/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.script.modules.helper;

import de.qfs.apps.qftest.shared.system.win32.User32;
import java.util.ArrayList;
import java.util.List;

public class Wnd {
    public static final int GW_HWNDNEXT = 2;
    public static final int GW_CHILD = 5;
    public static final int GWL_STYLE = -16;
    public static final int GWL_EXSTYLE = -20;
    public static final int HWND_TOPMOST = -1;
    public static final int HWND_NOTOPMOST = -2;
    public static final int SWP_NOSIZE = 1;
    public static final int SWP_NOMOVE = 2;
    public static final int SWP_NOZORDER = 4;
    public static final int WS_MAXIMIZE = 0x1000000;
    public static final int WS_MINIMIZE = 0x20000000;
    public static final int WS_EX_TOPMOST = 8;
    private int a;

    public Wnd(int n2) {
        this.a = n2;
    }

    public static List getAllWindows() {
        long[] lArray = de.qfs.apps.qftest.shared.system.win32.Wnd.GetAllWindows();
        ArrayList<Wnd> arrayList = new ArrayList<Wnd>();
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            arrayList.add(new Wnd((int)lArray[i2]));
        }
        return arrayList;
    }

    public String getWindowClassName() {
        return de.qfs.apps.qftest.shared.system.win32.Wnd.GetWindowClassName(this.a);
    }

    public String getWindowText() {
        return de.qfs.apps.qftest.shared.system.win32.Wnd.GetWindowText(this.a);
    }

    public void setWindowText(String string) {
        de.qfs.apps.qftest.shared.system.win32.Wnd.SetWindowText(this.a, string);
    }

    public int getProcessId() {
        return de.qfs.apps.qftest.shared.system.win32.Wnd.GetWindowProcessId(this.a);
    }

    public boolean isVisible() {
        return de.qfs.apps.qftest.shared.system.win32.Wnd.IsWindowVisible(this.a);
    }

    public boolean isMaximized() {
        return (this.getWindowStyle() & 0x1000000L) == 0x1000000L;
    }

    public boolean isMinimized() {
        return (this.getWindowStyle() & 0x20000000L) == 0x20000000L;
    }

    public boolean isTopmost() {
        return (this.getWindowExStyle() & 8L) == 8L;
    }

    public Rect getWindowRect() {
        return this.getBounds();
    }

    public Rect getBounds() {
        int[] nArray = de.qfs.apps.qftest.shared.system.win32.Wnd.GetWindowRect(this.a);
        return new Rect(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
    }

    public Point screenToClient(int n2, int n3) {
        Point point = new Point(n2, n3);
        int[] nArray = de.qfs.apps.qftest.shared.system.win32.Wnd.ScreenToClient(this.a, point.getX(), point.getY());
        return new Point(nArray[0], nArray[1]);
    }

    public long getWindowStyle() {
        long l2 = de.qfs.apps.qftest.shared.system.win32.Wnd.GetWindowLong(this.a, -16);
        return l2;
    }

    public long getWindowExStyle() {
        long l2 = de.qfs.apps.qftest.shared.system.win32.Wnd.GetWindowLong(this.a, -20);
        return l2;
    }

    public Wnd getWindow(int n2) {
        long l2 = de.qfs.apps.qftest.shared.system.win32.Wnd.GetWindow(this.a, n2);
        return new Wnd((int)l2);
    }

    public Wnd getParent() {
        long l2 = de.qfs.apps.qftest.shared.system.win32.Wnd.GetParent(this.a);
        return new Wnd((int)l2);
    }

    public List getChildren() {
        ArrayList<Wnd> arrayList = new ArrayList<Wnd>();
        Wnd wnd = this.getWindow(5);
        while (wnd.getValue() != 0L) {
            arrayList.add(wnd);
            wnd = wnd.getWindow(2);
        }
        return arrayList;
    }

    public List getChildWindows() {
        long[] lArray = de.qfs.apps.qftest.shared.system.win32.Wnd.GetChildWindows(this.a);
        ArrayList<Wnd> arrayList = new ArrayList<Wnd>();
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            arrayList.add(new Wnd((int)lArray[i2]));
        }
        return arrayList;
    }

    public long sendMessage(int n2, long l2, long l3) {
        return User32.SendMessage(this.a, n2, l2, l3);
    }

    public boolean postMessage(int n2, long l2, long l3) {
        return User32.PostMessage(this.a, n2, l2, l3);
    }

    public boolean setPosition(long l2, long l3, long l4, long l5, long l6, long l7) {
        return User32.SetWindowPos(this.a, l2, (int)l3, (int)l4, (int)l5, (int)l6, (int)l7);
    }

    public void setForeground() {
        de.qfs.apps.qftest.shared.system.win32.Wnd.SetForegroundWindow(this.a);
    }

    public void setTopmost(boolean bl) {
        if (bl) {
            this.setPosition(-1L, 0L, 0L, 0L, 0L, 3L);
        } else {
            this.setPosition(-2L, 0L, 0L, 0L, 0L, 3L);
        }
    }

    public long getValue() {
        return this.a;
    }

    public int hashCode() {
        return this.a;
    }

    public boolean equals(Object object) {
        return object instanceof Wnd && this.a == ((Wnd)object).a;
    }

    public String toString() {
        return "0x" + Integer.toHexString(this.a);
    }

    public static class Rect {
        public int x;
        public int y;
        public int width;
        public int height;

        public Rect(int n2, int n3, int n4, int n5) {
            this.x = n2;
            this.y = n3;
            this.width = n4;
            this.height = n5;
        }

        public int getLeft() {
            return this.x;
        }

        public int getTop() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getRight() {
            return this.x + this.width;
        }

        public int getBottom() {
            return this.y + this.height;
        }

        public String toString() {
            return "[" + this.x + "," + this.y + "," + this.width + "," + this.height + "]";
        }
    }

    public static class Point {
        public int x;
        public int y;

        public Point(int n2, int n3) {
            this.x = n2;
            this.y = n3;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String toString() {
            return "[" + this.x + "," + this.y + "]";
        }
    }
}

