/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.system;

import de.qfs.apps.qftest.shared.Globals;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.system.Native;
import de.qfs.apps.qftest.shared.system.UnixNative;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Stream;

public class LinuxNativeDirect
extends UnixNative {
    private static final QFLogger i = new QFLogger("de.qfs.apps.qftest.shared.system.LinuxNativeDirect");
    private static final int j = 1;
    private static final int k = 2;
    private static final int l = 4;
    private static final int m = 8;
    private static final int n = 16;
    private static final int o = 32;
    private static final int p = 64;
    private static final int q = 128;
    long a = 0L;
    int b = 0;

    protected LinuxNativeDirect() {
    }

    @Override
    public int getProcessID() {
        if (LinuxNativeDirect.i.level >= 7) {
            i.lvlBuild(7, "getProcessID()", 93).log();
        }
        return LinuxNativeDirect.GetPid();
    }

    @Override
    public void sendQuitSignal(int n2) {
        if (LinuxNativeDirect.i.level >= 7) {
            ((LevelAwareLogBuilder)i.lvlBuild(7, "sendQuitSignal(int)", 110).addDetail("processID", n2)).log();
        }
        LinuxNativeDirect.Kill(n2, 3);
    }

    @Override
    public boolean setTopmost(long l2, String string, boolean bl) {
        if (LinuxNativeDirect.i.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)i.lvlBuild(7, "setTopmost(long,String,boolean)", 128).addDetail("handle", l2)).addDetail("title", string)).addDetail("state", bl)).log();
        }
        if (l2 != 0L && l2 == this.a && this.b != 0) {
            if (LinuxNativeDirect.i.level >= 9) {
                ((LevelAwareLogBuilder)i.lvlBuild(9, "setTopmost(long,String,boolean)", 133).add("Cached handles match")).log();
            }
            LinuxNativeDirect.SetTopmost(this.b, bl);
            return true;
        }
        this.a = 0L;
        this.b = 0;
        if (l2 == 0L && string == null) {
            return false;
        }
        int[] nArray = LinuxNativeDirect.GetAllWindows();
        if (LinuxNativeDirect.i.level >= 9) {
            ((LevelAwareLogBuilder)i.lvlBuild(9, "setTopmost(long,String,boolean)", 147).add("handles", (Object)nArray)).log();
        }
        for (int n2 : nArray) {
            if (l2 != (long)n2) continue;
            if (LinuxNativeDirect.i.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)i.lvlBuild(9, "setTopmost(long,String,boolean)", 151).add("Handle ")).add(l2)).add(" is valid")).log();
            }
            this.a = l2;
            this.b = n2;
            break;
        }
        if (this.b == 0 && string != null) {
            for (int n2 : nArray) {
                String string2 = LinuxNativeDirect.GetWindowText(n2);
                if (LinuxNativeDirect.i.level >= 9) {
                    ((LevelAwareLogBuilder)i.lvlBuild(9, "setTopmost(long,String,boolean)", 162).add("winTitle", string2)).log();
                }
                if (!string.equals(string2)) continue;
                if (LinuxNativeDirect.i.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)i.lvlBuild(9, "setTopmost(long,String,boolean)", 164).add("Got title match for ")).add(string)).log();
                }
                this.a = l2;
                this.b = n2;
                break;
            }
        }
        if (this.b != 0) {
            LinuxNativeDirect.SetTopmost(this.b, bl);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isRunningInsideDocker() {
        if (LinuxNativeDirect.i.level >= 7) {
            i.lvlBuild(7, "isRunningInsideDocker()", 186).log();
        }
        try (Stream<String> stream = Files.lines(Paths.get("/proc/1/cgroup", new String[0]));){
            boolean bl2 = stream.anyMatch(string -> {
                boolean bl;
                boolean bl2 = bl = string.startsWith("0::/docker/") || string.startsWith("0::/kubepods") || string.trim().equals("0::/");
                if (LinuxNativeDirect.i.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)i.lvlBuild(9, "isRunningInsideDocker()", 192).add("line", string)).add("match", bl)).log();
                }
                return bl;
            });
            if (LinuxNativeDirect.i.level >= 9) {
                ((LevelAwareLogBuilder)i.lvlBuild(9, "isRunningInsideDocker()", 195).add("ret", bl2)).log();
            }
            boolean bl = bl2;
            return bl;
        }
        catch (IOException iOException) {
            if (LinuxNativeDirect.i.level < 5) return false;
            ((LevelAwareLogBuilder)i.lvlBuild(5, "isRunningInsideDocker()", 198).add("ex", (Object)iOException)).log();
            return false;
        }
    }

    @Override
    public void keybdEvent(int n2, int n3) {
        block3: {
            if (LinuxNativeDirect.i.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)i.lvlBuild(7, "keybdEvent(int,int)", 214).addDetail("keyCode", n2)).addDetail("flags", n3)).log();
            }
            try {
                LinuxNativeDirect.KeyboardEvent(n2, n3);
            }
            catch (Throwable throwable) {
                if (LinuxNativeDirect.i.level < 5) break block3;
                ((LevelAwareLogBuilder)i.lvlBuild(5, "keybdEvent(int,int)", 219).add("ex", (Object)throwable)).log();
            }
        }
    }

    @Override
    public void charInput(char c2, int n2, int n3) {
        block19: {
            if (LinuxNativeDirect.i.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)i.lvlBuild(7, "charInput(char,int,int)", 230).addDetail("c", c2)).addDetail("keyCode", n2)).addDetail("modifiers", n3)).log();
            }
            try {
                int n4;
                if (n2 != 0) {
                    c2 = this.a(n2);
                    if (LinuxNativeDirect.i.level >= 9) {
                        ((LevelAwareLogBuilder)i.lvlBuild(9, "charInput(char,int,int)", 235).add("c", c2)).log();
                    }
                }
                if (c2 != '\u0000') {
                    n4 = LinuxNativeDirect.GetKeyCodeAndModifiers(c2);
                    n2 = n4 & 0xFF;
                    if (n3 == 0) {
                        n3 = (n4 & 0xFF00) >> 8;
                    }
                }
                n4 = (n3 & 1) == 1 ? 1 : 0;
                boolean bl = (n3 & 2) == 2;
                boolean bl2 = (n3 & 8) == 8;
                boolean bl3 = (n3 & 4) == 4;
                boolean bl4 = (n3 & 0x80) == 128;
                boolean bl5 = Options.cached_OPT_NATIVE_SEND_INPUT;
                if (LinuxNativeDirect.i.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)i.lvlBuild(9, "charInput(char,int,int)", 250).add("keyCode", n2)).add("shift", n4 != 0)).add("ctrl", bl)).add("alt", bl2)).add("meta", bl3)).add("altgr", bl4)).add("send", bl5)).log();
                }
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                if (n4 & !bl5) {
                    n5 = LinuxNativeDirect.GetKeyCodeForModifier(1);
                    this.keybdEvent(n5, 0);
                }
                if (bl & !bl5) {
                    n6 = LinuxNativeDirect.GetKeyCodeForModifier(4);
                    this.keybdEvent(n6, 0);
                }
                if (bl2 & !bl5) {
                    n7 = LinuxNativeDirect.GetKeyCodeForModifier(8);
                    this.keybdEvent(n7, 0);
                }
                if (bl3 & !bl5) {
                    n8 = LinuxNativeDirect.GetKeyCodeForModifier(64);
                    this.keybdEvent(n8, 0);
                }
                if (bl4 & !bl5) {
                    n9 = LinuxNativeDirect.GetKeyCodeForModifier(128);
                    this.keybdEvent(n9, 0);
                }
                if (bl5) {
                    n2 = n2 & 0xFF | n3 << 8 & 0xFF00;
                }
                this.keybdEvent(n2, 0 | (bl5 ? Integer.MIN_VALUE : 0));
                this.keybdEvent(n2, 2 | (bl5 ? Integer.MIN_VALUE : 0));
                if (bl4 & !bl5) {
                    this.keybdEvent(n9, 2);
                }
                if (bl3 & !bl5) {
                    this.keybdEvent(n8, 2);
                }
                if (bl2 & !bl5) {
                    this.keybdEvent(n7, 2);
                }
                if (bl & !bl5) {
                    this.keybdEvent(n6, 2);
                }
                if (n4 & !bl5) {
                    this.keybdEvent(n5, 2);
                }
            }
            catch (Throwable throwable) {
                if (LinuxNativeDirect.i.level < 5) break block19;
                ((LevelAwareLogBuilder)i.lvlBuild(5, "charInput(char,int,int)", 294).add("ex", (Object)throwable)).log();
            }
        }
    }

    @Override
    public void textInput(String string) {
        if (LinuxNativeDirect.i.level >= 7) {
            ((LevelAwareLogBuilder)i.lvlBuild(7, "textInput(String)", 305).addDetail("text", string)).log();
        }
        for (char c2 : string.toCharArray()) {
            this.charInput(c2, 0, 0);
        }
    }

    private char a(int n2) {
        if (LinuxNativeDirect.i.level >= 7) {
            ((LevelAwareLogBuilder)i.lvlBuild(7, "mapVirtualKeyToXSymbol(int)", 315).addDetail("vk", n2)).log();
        }
        switch (n2) {
            case 32: {
                return ' ';
            }
            case 44: {
                return ',';
            }
            case 45: {
                return '-';
            }
            case 46: {
                return '.';
            }
            case 47: {
                return '/';
            }
            case 48: {
                return '0';
            }
            case 49: {
                return '1';
            }
            case 50: {
                return '2';
            }
            case 51: {
                return '3';
            }
            case 52: {
                return '4';
            }
            case 53: {
                return '5';
            }
            case 54: {
                return '6';
            }
            case 55: {
                return '7';
            }
            case 56: {
                return '8';
            }
            case 57: {
                return '9';
            }
            case 65: {
                return 'a';
            }
            case 66: {
                return 'b';
            }
            case 67: {
                return 'c';
            }
            case 68: {
                return 'd';
            }
            case 69: {
                return 'e';
            }
            case 70: {
                return 'f';
            }
            case 71: {
                return 'g';
            }
            case 72: {
                return 'h';
            }
            case 73: {
                return 'i';
            }
            case 74: {
                return 'j';
            }
            case 75: {
                return 'k';
            }
            case 76: {
                return 'l';
            }
            case 77: {
                return 'm';
            }
            case 78: {
                return 'n';
            }
            case 79: {
                return 'o';
            }
            case 80: {
                return 'p';
            }
            case 81: {
                return 'q';
            }
            case 82: {
                return 'r';
            }
            case 83: {
                return 's';
            }
            case 84: {
                return 't';
            }
            case 85: {
                return 'u';
            }
            case 86: {
                return 'v';
            }
            case 87: {
                return 'w';
            }
            case 88: {
                return 'x';
            }
            case 89: {
                return 'y';
            }
            case 90: {
                return 'z';
            }
            case 91: {
                return '[';
            }
            case 92: {
                return '\\';
            }
            case 93: {
                return ']';
            }
            case 150: {
                return '&';
            }
            case 151: {
                return '*';
            }
            case 152: {
                return '\"';
            }
            case 153: {
                return '<';
            }
            case 160: {
                return '>';
            }
            case 161: {
                return '{';
            }
            case 162: {
                return '}';
            }
            case 512: {
                return '@';
            }
            case 513: {
                return ':';
            }
            case 514: {
                return '^';
            }
            case 515: {
                return '$';
            }
            case 516: {
                return '\u20ac';
            }
            case 517: {
                return '!';
            }
            case 518: {
                return '\u00a1';
            }
            case 519: {
                return '(';
            }
            case 520: {
                return '#';
            }
            case 521: {
                return '+';
            }
            case 522: {
                return ')';
            }
            case 523: {
                return '_';
            }
            case 8: {
                return '\uff08';
            }
            case 9: {
                return '\uff09';
            }
            case 10: {
                return '\uff0d';
            }
            case 19: {
                return '\uff13';
            }
            case 27: {
                return '\uff1b';
            }
            case 36: {
                return '\uff50';
            }
            case 37: {
                return '\uff51';
            }
            case 38: {
                return '\uff52';
            }
            case 39: {
                return '\uff53';
            }
            case 40: {
                return '\uff54';
            }
            case 33: {
                return '\uff55';
            }
            case 34: {
                return '\uff56';
            }
            case 35: {
                return '\uff57';
            }
            case 154: {
                return '\uff61';
            }
            case 155: {
                return '\uff63';
            }
            case 112: {
                return '\uffbe';
            }
            case 113: {
                return '\uffbf';
            }
            case 114: {
                return '\uffc0';
            }
            case 115: {
                return '\uffc1';
            }
            case 116: {
                return '\uffc2';
            }
            case 117: {
                return '\uffc3';
            }
            case 118: {
                return '\uffc4';
            }
            case 119: {
                return '\uffc5';
            }
            case 120: {
                return '\uffc6';
            }
            case 121: {
                return '\uffc7';
            }
            case 122: {
                return '\uffc8';
            }
            case 123: {
                return '\uffc9';
            }
            case 127: {
                return '\uffff';
            }
        }
        return '\u0000';
    }

    @Override
    public int[] getMousePosition() {
        if (LinuxNativeDirect.i.level >= 7) {
            i.lvlBuild(7, "getMousePosition()", 421).log();
        }
        return LinuxNativeDirect.GetMousePosition();
    }

    static Native a() {
        LinuxNativeDirect linuxNativeDirect;
        block9: {
            if (LinuxNativeDirect.i.level >= 7) {
                i.lvlBuild(7, "createInstance()", 438).log();
            }
            linuxNativeDirect = null;
            try {
                if (LinuxNativeDirect.i.level >= 9) {
                    ((LevelAwareLogBuilder)i.lvlBuild(9, "createInstance()", 442).add("Globals loader", (Object)Globals.class.getClassLoader())).log();
                }
                if (LinuxNativeDirect.i.level >= 9) {
                    ((LevelAwareLogBuilder)i.lvlBuild(9, "createInstance()", 443).add("LinuxNativeDirect loader", (Object)LinuxNativeDirect.class.getClassLoader())).log();
                }
                String string = LinuxNativeDirect.getVersionDir();
                File file = Misc.JAVA_IS_64_BIT ? new File(string, "bin/libqfwrap.so") : new File(string, "bin/libqfwrap32.so");
                System.load(file.getPath());
                if (LinuxNativeDirect.i.level >= 9) {
                    ((LevelAwareLogBuilder)i.lvlBuild(9, "createInstance()", 448).add("Loaded library", (Object)file)).log();
                }
                linuxNativeDirect = new LinuxNativeDirect();
                if (LinuxNativeDirect.i.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)i.lvlBuild(9, "createInstance()", 450).add("res", (Object)linuxNativeDirect)).add("loader", (Object)linuxNativeDirect.getClass().getClassLoader())).log();
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (LinuxNativeDirect.i.level >= 3) {
                    ((LevelAwareLogBuilder)i.lvlBuild(3, "createInstance()", 452).add("ulex", (Object)unsatisfiedLinkError)).log();
                }
            }
            catch (Throwable throwable) {
                if (LinuxNativeDirect.i.level < 3) break block9;
                ((LevelAwareLogBuilder)i.lvlBuild(3, "createInstance()", 454).add("ex2", (Object)throwable)).log();
            }
        }
        return linuxNativeDirect;
    }

    @Override
    public int getParentProcessID() {
        if (LinuxNativeDirect.i.level >= 7) {
            i.lvlBuild(7, "getParentProcessID()", 474).log();
        }
        return LinuxNativeDirect.GetPPid();
    }

    public static native int GetPid();

    public static native int GetPPid();

    public static native void Kill(int var0, int var1);

    public static native void KeyboardEvent(int var0, int var1);

    public static native int GetKeyCodeAndModifiers(char var0);

    public static native int GetKeyCodeForModifier(int var0);

    public static native boolean DoEnter(int var0, int var1, int var2);

    public static native boolean DoMove(int var0, int var1, int var2);

    public static native boolean DoPress(int var0, int var1, int var2, int var3, int var4);

    public static native boolean DoRelease(int var0, int var1, int var2, int var3, int var4);

    public static native int[] GetAllWindows();

    public static native int[] GetWindowRect(int var0);

    public static native void SetWindowRect(int var0, int var1, int var2, int var3, int var4);

    public static native String GetWindowText(int var0);

    public static native int GetWindowProcessId(int var0);

    public static native int GetChildWindowAt(int var0, int var1, int var2);

    public static native int GetParent(int var0);

    public static native void CloseWindow(int var0);

    public static native void SetForeground(int var0);

    public static native void SetTopmost(int var0, boolean var1);

    public static native int[] GetMousePosition();
}

