/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.system;

import de.qfs.apps.qftest.shared.Globals;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.system.LinuxNative;
import de.qfs.apps.qftest.shared.system.LinuxNativeDirect;
import de.qfs.apps.qftest.shared.system.MacOSNative;
import de.qfs.apps.qftest.shared.system.NativeRobot;
import de.qfs.apps.qftest.shared.system.UnixNative;
import de.qfs.apps.qftest.shared.system.WindowsNative;
import de.qfs.lib.command.RuntimeCommandException;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Environment;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.ProcessManager;
import de.qfs.lib.util.Reflector;
import java.awt.Desktop;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;

public class Native {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.shared.system.Native");
    public static final int VK_SHIFT = 16;
    public static final int VK_CONTROL = 17;
    public static final int VK_ALT = 18;
    public static final int VK_META = 157;
    public static final int KEYDOWN = 0;
    public static final int KEYUP = 2;
    protected static final int c = 9;
    protected static final int d = 15;
    private static AtomicBoolean b = new AtomicBoolean(false);
    protected static Native e;
    public static final Object workingDirectoryLock;
    protected Robot f;

    protected Native() {
    }

    public static synchronized Native instance() {
        if (e == null) {
            e = Native.d();
        }
        return e;
    }

    public int getProcessID() {
        return 0;
    }

    public int getProcessID(@Nullable Process process) {
        return 0;
    }

    public int getProcessID(long l2) {
        return 0;
    }

    public void sendQuitSignal(int n2) {
    }

    public boolean setDoubleClickTime(int n2) {
        return true;
    }

    public boolean setWorkingDirectory(String string) {
        if (Native.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setWorkingDirectory(String)", 235).addDetail("dir", string)).log();
        }
        System.err.println("setWorkingDirectory not implemented");
        return false;
    }

    public File getApplicationSupportDirectory() {
        return null;
    }

    public File getSystemApplicationSupportDirectory(boolean bl) {
        return null;
    }

    public File getTopicApplicationSupportDirectory(String string) {
        File file = this.getApplicationSupportDirectory();
        if (file != null) {
            return new File(file, string);
        }
        return null;
    }

    public File getCacheDirectory() {
        return null;
    }

    @Nullable
    public File getAutosaveDirectory() {
        return new File(Util.getUserConfigDir());
    }

    @Nullable
    public File getWellKnownDirectory(String string) {
        if (Native.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getWellKnownDirectory(String)", 312).addDetail("directoryLabel", string)).log();
        }
        return null;
    }

    public boolean writeToQFTestDirAllowed() {
        return true;
    }

    public void deleteFile(File file) {
        block6: {
            if (file == null) {
                throw new IllegalArgumentException("file is marked non-null but is null");
            }
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException iOException) {
                if (Native.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "deleteFile(File)", 339).add("ex", (Object)iOException)).log();
                }
                try {
                    FileUtils.forceDeleteOnExit((File)file);
                }
                catch (IOException iOException2) {
                    if (Native.a.level < 3) break block6;
                    ((LevelAwareLogBuilder)a.lvlBuild(3, "deleteFile(File)", 343).add("ex2", (Object)iOException2)).log();
                }
            }
        }
    }

    public String getExecutable(String string) {
        if (Native.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getExecutable(String)", 359).addDetail("container", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("container is marked non-null but is null");
        }
        return string;
    }

    public boolean isCompliantInstallation() {
        if (Native.a.level >= 7) {
            a.lvlBuild(7, "isCompliantInstallation()", 369).log();
        }
        return false;
    }

    public boolean showFileInSystemExplorer(File file) {
        block7: {
            if (Native.a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "showFileInSystemExplorer(File)", 384).addDetail("file", (Object)file)).log();
            }
            this.checkFileExist(file);
            boolean bl = Util.isInteractiveAndDesktopActionSupported(Desktop.Action.OPEN);
            if (Native.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "showFileInSystemExplorer(File)", 388).add("desktopSupported", bl)).log();
            }
            if (!bl) {
                return false;
            }
            try {
                File file2;
                Desktop desktop = Desktop.getDesktop();
                File file3 = file2 = file.isDirectory() ? file : file.getParentFile();
                if (Native.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "showFileInSystemExplorer(File)", 394).add("dirToOpen", (Object)file2)).log();
                }
                if (file2 != null) {
                    desktop.open(file2);
                    return true;
                }
            }
            catch (IOException iOException) {
                if (Native.a.level < 9) break block7;
                ((LevelAwareLogBuilder)a.lvlBuild(9, "showFileInSystemExplorer(File)", 401).add("e", (Object)iOException)).log();
            }
        }
        return false;
    }

    public void checkFileExist(File file) {
        if (Native.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "checkFileExist(File)", 408).addDetail("file", (Object)file)).log();
        }
        if (file == null || !file.exists()) {
            throw new RuntimeCommandException(null, "File does not exist (anymore)", null, "fileNotFound", new Object[]{file});
        }
    }

    public boolean launchFileWithAssociatedApplication(File file) {
        if (Native.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "launchFileWithAssociatedApplication(File)", 423).addDetail("file", (Object)file)).log();
        }
        if (file == null || !file.exists() || file.isDirectory()) {
            return false;
        }
        boolean bl = Desktop.isDesktopSupported();
        if (Native.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "launchFileWithAssociatedApplication(File)", 427).add("desktopSupported", bl)).log();
        }
        if (!bl) {
            return false;
        }
        try {
            Desktop desktop = Desktop.getDesktop();
            if (Native.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "launchFileWithAssociatedApplication(File)", 432).add("file", (Object)file)).log();
            }
            desktop.open(file);
            return true;
        }
        catch (IOException iOException) {
            if (Native.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "launchFileWithAssociatedApplication(File)", 436).add("e", (Object)iOException)).log();
            }
            return false;
        }
    }

    public boolean openUrlInBrowser(URI uRI) {
        if (Native.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "openUrlInBrowser(URI)", 450).addDetail("url", (Object)uRI)).log();
        }
        if (uRI == null) {
            return false;
        }
        boolean bl = Desktop.isDesktopSupported();
        if (Native.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "openUrlInBrowser(URI)", 454).add("desktopSupported", bl)).log();
        }
        if (!bl) {
            return false;
        }
        try {
            Desktop desktop = Desktop.getDesktop();
            if (Native.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "openUrlInBrowser(URI)", 459).add("url", (Object)uRI)).log();
            }
            desktop.browse(uRI);
            return true;
        }
        catch (IOException iOException) {
            if (Native.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "openUrlInBrowser(URI)", 463).add("e", (Object)iOException)).log();
            }
            return false;
        }
    }

    public double getScreenScaleFactor() {
        return 1.0;
    }

    protected void a(long l2, int n2, long l3, long l4) {
    }

    protected void b(long l2, int n2, long l3, long l4) {
    }

    public boolean isRunningInsideDocker() {
        if (Native.a.level >= 7) {
            a.lvlBuild(7, "isRunningInsideDocker()", 524).log();
        }
        return false;
    }

    public long getWindowDC(long l2) {
        return 0L;
    }

    public void releaseWindowDC(long l2, long l3) {
    }

    public boolean printWindow(long l2, long l3, int n2) {
        return false;
    }

    public long[] findAllDialogs() {
        return new long[0];
    }

    public void setForegroundWindow(long l2, String string) {
        this.setForegroundWindow(l2, string, 100L);
    }

    public void setForegroundWindow(long l2, String string, long l3) {
    }

    public boolean setTopmost(long l2, String string, boolean bl) {
        return false;
    }

    public void setTopmost(long l2, boolean bl) {
    }

    public int[] getMousePosition() {
        return new int[]{-1, -1};
    }

    public boolean killProcessTree(int n2, int n3, long l2, int n4) {
        ArrayList arrayList = this.getProcessTreeList(n2);
        return this.killProcessTree(arrayList, n3, l2, n4);
    }

    public boolean killProcessTree(Collection collection, int n2, long l2, int n3) {
        if (Native.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "killProcessTree(Collection<Integer>,int,long,int)", 693).addDetail("pids", (Object)collection)).addDetail("signal1", n2)).addDetail("delay", l2)).addDetail("signal2", n3)).log();
        }
        if (collection == null) {
            return false;
        }
        this.killProcessTreeList(collection, n2);
        if (n3 != 0) {
            Misc.safeSleep((long)l2);
            this.killProcessTreeList(collection, n3);
        }
        return true;
    }

    @Nullable
    public ArrayList getProcessTreeList(int n2) {
        return null;
    }

    public ArrayList getProcessTreeList(int n2, String[] stringArray) {
        block30: {
            if (Native.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getProcessTreeList(int,String[])", 735).addDetail("pid", n2)).addDetail("cmd", (Object)stringArray)).log();
            }
            try {
                int n3;
                ProcessManager processManager = new ProcessManager("listtree", stringArray);
                processManager.setCollect(true, false);
                processManager.startProcess();
                if (!processManager.waitFor(10000L)) {
                    if (Native.a.level >= 3) {
                        ((LevelAwareLogBuilder)a.lvlBuild(3, "getProcessTreeList(int,String[])", 742).add("ps command did not terminate")).log();
                    }
                    return null;
                }
                int n4 = processManager.getExitCode();
                if (Native.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getProcessTreeList(int,String[])", 746).add("exitCode", n4)).log();
                }
                if (n4 != 0) {
                    if (Native.a.level >= 3) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "getProcessTreeList(int,String[])", 748).add("ps command terminated with exit code ")).add(n4)).log();
                    }
                    return null;
                }
                String string = processManager.getProcessOutputString();
                if (Native.a.level >= 5) {
                    ((LevelAwareLogBuilder)a.lvlBuild(5, "getProcessTreeList(int,String[])", 752).add("procs", string)).log();
                }
                if (Misc.emptyOrNull((String)string)) {
                    if (Native.a.level >= 3) {
                        ((LevelAwareLogBuilder)a.lvlBuild(3, "getProcessTreeList(int,String[])", 754).add("ps command did not return anything")).log();
                    }
                    return null;
                }
                String[] stringArray2 = string.split("\\s+");
                if (Native.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getProcessTreeList(int,String[])", 759).add("ids", (Object)stringArray2)).log();
                }
                HashMap hashMap = new HashMap();
                HashSet<Integer> hashSet = new HashSet<Integer>();
                for (n3 = 0; n3 < stringArray2.length; ++n3) {
                    try {
                        Integer.parseInt(stringArray2[n3]);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                }
                if (stringArray2.length - n3 <= 0 || (stringArray2.length - n3) % 2 != 0) {
                    if (Native.a.level >= 3) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "getProcessTreeList(int,String[])", 772).add("Bad number of remaining arguments - start", n3)).add("ids.length", stringArray2.length)).log();
                    }
                    return null;
                }
                for (int i2 = n3; i2 < stringArray2.length; i2 += 2) {
                    Integer n5 = Integer.parseInt(stringArray2[i2]);
                    Integer n6 = Integer.parseInt(stringArray2[i2 + 1]);
                    hashSet.add(n5);
                    if (n5 >= 0 && n6 >= 0) {
                        if (!hashMap.containsKey(n6)) {
                            hashMap.put(n6, new ArrayList());
                        }
                        ((ArrayList)hashMap.get(n6)).add(n5);
                        continue;
                    }
                    if (Native.a.level < 3) continue;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "getProcessTreeList(int,String[])", 785).add("Huh? - Negative process ID - ppid", (Object)n6)).add("cpid", (Object)n5)).log();
                }
                if (Native.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getProcessTreeList(int,String[])", 788).add("map", hashMap)).log();
                }
                ArrayList arrayList = new ArrayList();
                try {
                    this.a(n2, hashMap, arrayList);
                }
                catch (RuntimeException runtimeException) {
                    if (Native.a.level >= 3) {
                        ((LevelAwareLogBuilder)a.lvlBuild(3, "getProcessTreeList(int,String[])", 805).add("ex", (Object)runtimeException)).log();
                    }
                    if (Native.a.level >= 3) {
                        ((LevelAwareLogBuilder)a.lvlBuild(3, "getProcessTreeList(int,String[])", 807).add("Cycle in process hierarchy")).log();
                    }
                    return null;
                }
                if (Native.a.level >= 5) {
                    ((LevelAwareLogBuilder)a.lvlBuild(5, "getProcessTreeList(int,String[])", 810).add("toKill", arrayList)).log();
                }
                if (arrayList.size() == 0) {
                    if (Native.a.level >= 3) {
                        ((LevelAwareLogBuilder)a.lvlBuild(3, "getProcessTreeList(int,String[])", 814).add("nothing to kill")).log();
                    }
                    return null;
                }
                return arrayList;
            }
            catch (IOException iOException) {
                if (Native.a.level >= 1) {
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "getProcessTreeList(int,String[])", 820).add("ex", (Object)iOException)).log();
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (Native.a.level < 1) break block30;
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getProcessTreeList(int,String[])", 823).add("ex", (Object)numberFormatException)).log();
            }
        }
        return null;
    }

    public void killProcessTreeList(Collection collection, int n2) {
    }

    public void killProcessTreeList(Collection collection) {
        this.killProcessTreeList(collection, 15);
    }

    public void killProcesses(String string, boolean bl) {
    }

    public int getMemoryUsage(int n2) {
        return -1;
    }

    public int getMemoryUsage(int n2, boolean bl) {
        block19: {
            if (Native.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getMemoryUsage(int,boolean)", 903).addDetail("pid", n2)).addDetail("isWindowsNative", bl)).log();
            }
            String[] stringArray = null;
            stringArray = bl ? (Double.valueOf(System.getProperty("os.version")) < 6.0 ? new String[]{"cmd", "/c", "echo", "\"\"", "|", "wmic", "process", "where", "ProcessID=" + String.valueOf(n2), "get", "PageFileUsage"} : new String[]{"cmd", "/c", "wmic", "process", "where", "ProcessID=" + String.valueOf(n2), "get", "PageFileUsage"}) : new String[]{"ps", "p", String.valueOf(n2), "-o", "rss="};
            try {
                int n3;
                block18: {
                    ProcessManager processManager = new ProcessManager("memoryusage", stringArray);
                    processManager.setCollect(true, false);
                    processManager.startProcess();
                    if (!processManager.waitFor(10000L)) {
                        if (Native.a.level >= 3) {
                            ((LevelAwareLogBuilder)a.lvlBuild(3, "getMemoryUsage(int,boolean)", 926).add("command did not terminate")).log();
                        }
                        return -1;
                    }
                    int n4 = processManager.getExitCode();
                    if (Native.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getMemoryUsage(int,boolean)", 930).add("exitCode", n4)).log();
                    }
                    if (n4 != 0) {
                        if (Native.a.level >= 3) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "getMemoryUsage(int,boolean)", 932).add("command terminated with exit code ")).add(n4)).log();
                        }
                        return -1;
                    }
                    String string = processManager.getProcessOutputString();
                    if (Native.a.level >= 5) {
                        ((LevelAwareLogBuilder)a.lvlBuild(5, "getMemoryUsage(int,boolean)", 936).add("procs", string)).log();
                    }
                    if (Misc.emptyOrNull((String)string)) {
                        if (Native.a.level >= 3) {
                            ((LevelAwareLogBuilder)a.lvlBuild(3, "getMemoryUsage(int,boolean)", 938).add("command did not return anything")).log();
                        }
                        return -1;
                    }
                    n3 = -1;
                    try {
                        if (bl) {
                            n3 = Integer.parseInt(string.replaceAll("[^\\d]", ""));
                            if (Double.valueOf(System.getProperty("os.version")) < 6.0) {
                                n3 /= 1024;
                            }
                        } else {
                            n3 = Integer.parseInt(string.replaceAll("[^\\d]", ""));
                        }
                    }
                    catch (Exception exception) {
                        if (Native.a.level < 3) break block18;
                        ((LevelAwareLogBuilder)a.lvlBuild(3, "getMemoryUsage(int,boolean)", 956).add("cannot parse return value")).log();
                    }
                }
                return n3;
            }
            catch (IOException iOException) {
                if (Native.a.level >= 1) {
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "getMemoryUsage(int,boolean)", 961).add("ex", (Object)iOException)).log();
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (Native.a.level < 1) break block19;
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getMemoryUsage(int,boolean)", 964).add("ex", (Object)numberFormatException)).log();
            }
        }
        return -1;
    }

    public int getMemoryUsageOfProcessTree(int n2) {
        return -1;
    }

    public int getMemoryUsageOfProcessTree(int n2, boolean bl) {
        if (Native.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getMemoryUsageOfProcessTree(int,boolean)", 995).addDetail("pid", n2)).addDetail("isWindowsNative", bl)).log();
        }
        ArrayList arrayList = this.getProcessTreeList(n2);
        int n3 = 0;
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            n3 += this.getMemoryUsage((Integer)arrayList.get(i2), bl);
        }
        return n3;
    }

    public NativeRobot getNativeRobot() {
        if (Native.a.level >= 7) {
            a.lvlBuild(7, "getNativeRobot()", 1016).log();
        }
        return null;
    }

    protected synchronized void c() {
        block7: {
            if (Native.a.level >= 7) {
                a.lvlBuild(7, "updateRobot()", 1033).log();
            }
            if (this.f == null) {
                try {
                    this.f = new Robot();
                    if (Native.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "updateRobot()", 1038).add("awtRobot", (Object)this.f)).log();
                    }
                }
                catch (Throwable throwable) {
                    if (Native.a.level >= 3) {
                        ((LevelAwareLogBuilder)a.lvlBuild(3, "updateRobot()", 1040).add("ex", (Object)throwable)).log();
                    }
                    if (Native.a.level < 1) break block7;
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "updateRobot()", 1041).add("No AWT Robot available")).log();
                }
            }
        }
        if (Native.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "updateRobot()", 1044).add("awtRobot", (Object)this.f)).log();
        }
    }

    public void keybdEvent(int n2, int n3) {
        this.c();
        int n4 = Options.getInt(Options.OPT_PLAY_DND_DELAY, 200);
        if (Native.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "keybdEvent(int,int)", 1065).add("delay", n4)).log();
        }
        if (this.f != null) {
            this.f.setAutoDelay(n4);
            if (n3 == 0) {
                this.f.keyPress(n2);
            } else if (n3 == 2) {
                this.f.keyRelease(n2);
            } else if (Native.a.level >= 3) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "keybdEvent(int,int)", 1075).add("Flag not supported: ")).add(n3)).log();
            }
        }
    }

    public void charInput(char c2, int n2, int n3) {
        block13: {
            try {
                int n4;
                if (n2 != 0) {
                    n4 = n2;
                } else {
                    n4 = this.a(c2);
                    n2 = n4 & 0xFF;
                }
                boolean bl = n3 == 0 && (n4 & 0x100) == 256 || (n3 & 1) == 1;
                boolean bl2 = n3 == 0 && (n4 & 0x200) == 512 || (n3 & 2) == 2;
                boolean bl3 = n3 == 0 && (n4 & 0x400) == 1024 || (n3 & 8) == 8;
                boolean bl4 = n3 == 0 && (n4 & 0x800) == 2048 || (n3 & 4) == 4;
                int n5 = this.a(n2);
                if (Native.a.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "charInput(char,int,int)", 1117).add("keyCode", n2)).add("shift", bl)).add("ctrl", bl2)).add("alt", bl3)).add("meta", bl4)).add("extendedFlag", n5)).log();
                }
                if (bl) {
                    this.keybdEvent(16, 0);
                }
                if (bl2) {
                    this.keybdEvent(17, 0);
                }
                if (bl3) {
                    this.keybdEvent(18, 0);
                }
                if (bl4) {
                    this.keybdEvent(157, 0);
                }
                this.keybdEvent(n2, 0 | n5);
                this.keybdEvent(n2, 2 | n5);
                if (bl4) {
                    this.keybdEvent(157, 2);
                }
                if (bl3) {
                    this.keybdEvent(18, 2);
                }
                if (bl2) {
                    this.keybdEvent(17, 2);
                }
                if (bl) {
                    this.keybdEvent(16, 2);
                }
            }
            catch (Throwable throwable) {
                if (Native.a.level < 5) break block13;
                ((LevelAwareLogBuilder)a.lvlBuild(5, "charInput(char,int,int)", 1147).add("ex", (Object)throwable)).log();
            }
        }
    }

    public String stringForKeyCodes(int[] nArray, int n2) {
        if (Native.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "stringForKeyCodes(int[],int)", 1157).addDetail("keyCodes", (Object)nArray)).addDetail("modifiers", n2)).log();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int n3 : nArray) {
            boolean bl = n2 == 0 && (n3 & 0x100) == 256 || (n2 & 1) == 1;
            char c2 = (char)n3;
            if (bl) {
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(String.valueOf(c2).toLowerCase());
        }
        return stringBuilder.toString();
    }

    private int a(int n2) {
        if (Native.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getExtendedFlag(int)", 1187).addDetail("keyCode", n2)).log();
        }
        switch (n2) {
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 111: 
            case 127: 
            case 144: 
            case 154: 
            case 155: {
                return 1;
            }
        }
        return 0;
    }

    public void textInput(String string) {
        for (char c2 : string.toCharArray()) {
            this.charInput(c2, 0, 0);
        }
    }

    protected int a(char c2) {
        if (Native.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "charToKeycode(char)", 1238).addDetail("c", c2)).log();
        }
        try {
            int n2 = KeyEvent.getExtendedKeyCodeForChar(c2);
            if (Native.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "charToKeycode(char)", 1242).add("code", n2)).log();
            }
            if (Character.isUpperCase(c2)) {
                n2 |= 0x100;
            }
            return n2;
        }
        catch (Exception exception) {
            if (Native.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "charToKeycode(char)", 1250).add("ex", (Object)exception)).log();
            }
            return 0;
        }
    }

    static Native d() {
        Native native_;
        block9: {
            Native.enableNativeAccessToAllUnnamed();
            native_ = null;
            try {
                if (Misc.OS_IS_WINDOWS) {
                    native_ = WindowsNative.b();
                } else {
                    if (Misc.OS_IS_LINUX) {
                        String string = System.getProperty("qfs.native.linux.wrapped");
                        native_ = "true".equalsIgnoreCase(string) ? LinuxNative.createInstance() : LinuxNativeDirect.a();
                    } else if (Misc.OS_IS_MAC_OS_X) {
                        native_ = MacOSNative.a();
                    }
                    if (native_ == null) {
                        native_ = UnixNative.e();
                    }
                }
            }
            catch (Throwable throwable) {
                if (Native.a.level >= 3) {
                    ((LevelAwareLogBuilder)a.lvlBuild(3, "createInstance()", 1294).add("ex", (Object)throwable)).log();
                }
                if (throwable.getCause() == null || Native.a.level < 3) break block9;
                ((LevelAwareLogBuilder)a.lvlBuild(3, "createInstance()", 1296).add("ex.getCause()", (Object)throwable.getCause())).log();
            }
        }
        return native_ == null ? new Native() : native_;
    }

    public static void enableNativeAccessToAllUnnamed() {
        block4: {
            if (Native.a.level >= 7) {
                a.lvlBuild(7, "enableNativeAccessToAllUnnamed()", 1309).log();
            }
            if (Misc.IS_JAVA_VERSION_AT_LEAST_24) {
                try {
                    Class<?> clazz = Class.forName("java.lang.Module");
                    Reflector.call(clazz, (String)"implAddEnableNativeAccessToAllUnnamed", (boolean)true);
                }
                catch (Exception exception) {
                    if (Native.a.level < 1) break block4;
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "enableNativeAccessToAllUnnamed()", 1317).add("Could not enable native access to all unnamed", (Object)exception)).log();
                }
            }
        }
    }

    public static void setupLoader() {
        block13: {
            if (b.getAndSet(true)) {
                return;
            }
            String string = Native.getVersionDir();
            if (Native.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "setupLoader()", 1335).add("base", string)).log();
            }
            try {
                Class<?> clazz = Class.forName("com.jniwrapper.DefaultLibraryLoader");
                if (Native.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "setupLoader()", 1338).add("cl", clazz)).log();
                }
                Util.openModule(ClassLoader.class, clazz);
                Object object = Reflector.call(clazz, (String)"getInstance");
                Reflector.call((Object)object, (String)"addPath", File.class, (Object)new File(string, "bin"));
                if (System.getProperty("java.library.path") != null) {
                    Environment environment = (Environment)Globals.getGlobalValue("env", null);
                    if (environment == null) {
                        environment = new Environment();
                    }
                    if (Native.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "setupLoader()", 1349).add("env", (Object)environment)).log();
                    }
                    if (environment.isAvailable()) {
                        String string2 = environment.getEnv("PATH");
                        if (Native.a.level >= 9) {
                            ((LevelAwareLogBuilder)a.lvlBuild(9, "setupLoader()", 1352).add("path", string2)).log();
                        }
                        if (string2 != null) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
                            while (stringTokenizer.hasMoreTokens()) {
                                String string3 = stringTokenizer.nextToken();
                                if (Native.a.level >= 9) {
                                    ((LevelAwareLogBuilder)a.lvlBuild(9, "setupLoader()", 1357).add("dir", string3)).log();
                                }
                                Reflector.call((Object)object, (String)"addPath", File.class, (Object)new File(string3));
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                if (Native.a.level < 5) break block13;
                ((LevelAwareLogBuilder)a.lvlBuild(5, "setupLoader()", 1364).add("ex", (Object)throwable)).log();
            }
        }
    }

    protected void a(int n2, HashMap hashMap, ArrayList arrayList) {
        if (Native.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "flatten(int,HashMap<Integer, ArrayList<Integer>>,ArrayList<Integer>)", 1379).addDetail("pid", n2)).addDetail("map", (Object)hashMap)).addDetail("list", (Object)arrayList)).log();
        }
        arrayList.add(n2);
        ArrayList arrayList2 = (ArrayList)hashMap.get(n2);
        if (arrayList2 != null) {
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                if (!arrayList.contains(n3)) {
                    this.a(n3, hashMap, arrayList);
                    continue;
                }
                throw new RuntimeException("Cycle in process hierarchy!");
            }
        }
    }

    public static String getVersionDir() {
        String string;
        if (Native.a.level >= 7) {
            a.lvlBuild(7, "getVersionDir()", 1400).log();
        }
        if (Misc.emptyOrNull((String)(string = Globals.getGlobalString("qftestversiondir", "")))) {
            String string2;
            String string3 = System.getProperty("qftest.connector.home");
            if (Native.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getVersionDir()", 1409).add("baseDir", string3)).log();
            }
            if (string3 == null) {
                string3 = System.getProperty("qftest.versiondir");
                if (Native.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getVersionDir()", 1412).add("baseDir from versiondir", string3)).log();
                }
            }
            if (string3 == null && (string2 = Misc.getFilenameOfClass(Native.class)) != null && string2.toLowerCase().contains("qfshared.jar")) {
                string3 = new File(string2).getParentFile().getParent();
            }
            if (string3 == null && !Misc.emptyOrNull((String)(string2 = System.getenv("QFS_DEV")))) {
                string3 = new File(string2, "qftest" + File.separator + "qftest-master").getPath();
            }
            if (string3 != null) {
                string = Misc.getBestPath((String)string3);
            }
        }
        return string;
    }

    public int getParentProcessID() {
        return 0;
    }

    public String getShortPathName(String string) {
        return null;
    }

    public Set getRunningProcessIDs() {
        if (Native.a.level >= 7) {
            a.lvlBuild(7, "getRunningProcessIDs()", 1474).log();
        }
        return new HashSet();
    }

    public boolean isProcessRunning(int n2) {
        if (Native.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "isProcessRunning(int)", 1485).addDetail("pid", n2)).log();
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean canDetectSystemDarkMode() {
        if (Native.a.level >= 7) {
            a.lvlBuild(7, "canDetectSystemDarkMode()", 1492).log();
        }
        return false;
    }

    public boolean areAppsInDarkMode() {
        if (Native.a.level >= 7) {
            a.lvlBuild(7, "areAppsInDarkMode()", 1502).log();
        }
        return this.isSystemInDarkMode();
    }

    public boolean isSystemInDarkMode() {
        if (Native.a.level >= 7) {
            a.lvlBuild(7, "isSystemInDarkMode()", 1514).log();
        }
        return false;
    }

    public void listenForDarkModeSwitch() {
        if (Native.a.level >= 7) {
            a.lvlBuild(7, "listenForDarkModeSwitch()", 1522).log();
        }
    }

    public void setAppAppearance(boolean bl) {
        if (Native.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setAppAppearance(boolean)", 1532).addDetail("dark", bl)).log();
        }
    }

    public void setWindowAppearance(long l2, boolean bl) {
        if (Native.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "setWindowAppearance(long,boolean)", 1541).addDetail("handle", l2)).addDetail("dark", bl)).log();
        }
    }

    public Robot getAwtRobot() {
        if (Native.a.level >= 7) {
            a.lvlBuild(7, "getAwtRobot()", 95).log();
        }
        return this.f;
    }

    static {
        workingDirectoryLock = new Object();
    }
}

