/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.system;

import de.qfs.apps.qftest.shared.script.modules.UserNotifications;
import de.qfs.apps.qftest.shared.system.IniAccess;
import de.qfs.apps.qftest.shared.system.Native;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.DaemonThread;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.ProcessManager;
import de.qfs.lib.util.Reflector;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public class UnixNative
extends Native {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.shared.system.UnixNative");
    public static final int DARK_MODE_POLLING_DELAY = 2500;
    @Nullable
    private final AtomicReference b = new AtomicReference();
    @Nullable
    private final AtomicReference i = new AtomicReference();
    boolean g = true;
    final AtomicBoolean h = new AtomicBoolean();

    protected UnixNative() {
    }

    static Native e() {
        return new UnixNative();
    }

    @Override
    public int getProcessID(@Nullable Process process) {
        if (UnixNative.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getProcessID(Process)", 108).addDetail("process", (Object)process)).log();
        }
        if (process == null) {
            return 0;
        }
        Integer n2 = (Integer)Reflector.safeGet((Object)process, (String)"pid", (boolean)true);
        if (UnixNative.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getProcessID(Process)", 112).add("opid", (Object)n2)).log();
        }
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    @Override
    public void killProcessTreeList(Collection collection) {
        if (UnixNative.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "killProcessTreeList(Collection<Integer>)", 125).addDetail("pids", (Object)collection)).log();
        }
        this.killProcessTree(collection, 15, 1000L, 9);
    }

    @Override
    @Nullable
    public ArrayList getProcessTreeList(int n2) {
        if (UnixNative.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getProcessTreeList(int)", 142).addDetail("pid", n2)).log();
        }
        if (n2 == 0) {
            return null;
        }
        return this.getProcessTreeList(n2, new String[]{"ps", "-ax", "-o", "pid,ppid"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killProcessTreeList(Collection collection, int n2) {
        block16: {
            if (UnixNative.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "killProcessTreeList(Collection<Integer>,int)", 158).addDetail("pids", (Object)collection)).addDetail("signal", n2)).log();
            }
            try {
                ProcessManager processManager;
                Integer n32;
                LinkedList<String> linkedList = new LinkedList<String>();
                linkedList.add("kill");
                linkedList.add("-" + n2);
                for (Integer n32 : collection) {
                    if (n32 > 0) {
                        linkedList.add("" + n32);
                        continue;
                    }
                    if (UnixNative.a.level < 5) continue;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(5, "killProcessTreeList(Collection<Integer>,int)", 168).add("Cannot kill process ")).add((Object)n32)).log();
                }
                if (UnixNative.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "killProcessTreeList(Collection<Integer>,int)", 171).add("cmdList", linkedList)).log();
                }
                if (UnixNative.a.level >= 5) {
                    try {
                        processManager = new ProcessManager("ps", new String[]{"ps", "auxw"});
                        processManager.setCollect(true, true);
                        processManager.startProcess();
                        processManager.waitFor(10000L);
                        if (UnixNative.a.level >= 5) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(5, "killProcessTreeList(Collection<Integer>,int)", 178).add("pm returned", processManager.getExitCode())).add("output")).add("pm.getProcessOutputString()", processManager.getProcessOutputString())).log();
                        }
                    }
                    catch (Throwable throwable) {
                        if (UnixNative.a.level >= 1) {
                            ((LevelAwareLogBuilder)a.lvlBuild(1, "killProcessTreeList(Collection<Integer>,int)", 180).add("ex", (Object)throwable)).log();
                        }
                    }
                    finally {
                        Log.setQueueing((boolean)false);
                        Log.setQueueing((boolean)true);
                    }
                }
                processManager = linkedList.toArray(new String[linkedList.size()]);
                n32 = new ProcessManager("killtree", (String[])processManager);
                n32.setCollect(true, true);
                n32.startProcess();
                n32.waitFor(10000L);
                if (UnixNative.a.level >= 5) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(5, "killProcessTreeList(Collection<Integer>,int)", 192).add("pm returned", n32.getExitCode())).add("output")).add("pm.getProcessOutputString()", n32.getProcessOutputString())).log();
                }
            }
            catch (Exception exception) {
                if (UnixNative.a.level < 1) break block16;
                ((LevelAwareLogBuilder)a.lvlBuild(1, "killProcessTreeList(Collection<Integer>,int)", 195).add("ex", (Object)exception)).log();
            }
        }
    }

    @Override
    public int getMemoryUsage(int n2) {
        if (UnixNative.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getMemoryUsage(int)", 213).addDetail("pid", n2)).log();
        }
        return this.getMemoryUsage(n2, false);
    }

    @Override
    public int getMemoryUsageOfProcessTree(int n2) {
        if (UnixNative.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getMemoryUsageOfProcessTree(int)", 227).addDetail("pid", n2)).log();
        }
        return this.getMemoryUsageOfProcessTree(n2, false);
    }

    @Override
    public Set getRunningProcessIDs() {
        HashSet<Integer> hashSet;
        block7: {
            if (UnixNative.a.level >= 7) {
                a.lvlBuild(7, "getRunningProcessIDs()", 235).log();
            }
            hashSet = new HashSet<Integer>();
            try {
                String string = ProcessManager.runProcess((String[])new String[]{"ps", "axo", "pid"}, (int)10000);
                if (UnixNative.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getRunningProcessIDs()", 240).add("pids", string)).log();
                }
                for (String string2 : Misc.fastSplit((String)string, (char)'\n')) {
                    if ("PID".equals(string2 = string2.trim())) continue;
                    try {
                        hashSet.add(Integer.parseInt(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (UnixNative.a.level < 3) continue;
                        ((LevelAwareLogBuilder)a.lvlBuild(3, "getRunningProcessIDs()", 248).add("ex", (Object)numberFormatException)).log();
                    }
                }
            }
            catch (ProcessManager.RunProcessException runProcessException) {
                if (UnixNative.a.level < 5) break block7;
                ((LevelAwareLogBuilder)a.lvlBuild(5, "getRunningProcessIDs()", 252).add("e", (Object)runProcessException)).log();
            }
        }
        return hashSet;
    }

    @Override
    public boolean isProcessRunning(int n2) {
        if (UnixNative.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "isProcessRunning(int)", 262).addDetail("pid", n2)).log();
        }
        try {
            String string = ProcessManager.runProcess((String[])new String[]{"ps", "-p", "" + n2}, (int)10000);
            if (UnixNative.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "isProcessRunning(int)", 265).add("pidinfo", string)).log();
            }
            return true;
        }
        catch (ProcessManager.RunProcessException runProcessException) {
            if (UnixNative.a.level >= 5) {
                ((LevelAwareLogBuilder)a.lvlBuild(5, "isProcessRunning(int)", 268).add("e", (Object)runProcessException)).log();
            }
            if (runProcessException.getCause() != null) {
                throw runProcessException.getCause();
            }
            return false;
        }
    }

    @Override
    public void sendQuitSignal(int n2) {
        if (UnixNative.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "sendQuitSignal(int)", 281).addDetail("pid", n2)).log();
        }
        try {
            ProcessManager.runProcess((String[])new String[]{"kill", "-3", "" + n2}, (int)10000);
        }
        catch (ProcessManager.RunProcessException runProcessException) {
            if (UnixNative.a.level >= 5) {
                ((LevelAwareLogBuilder)a.lvlBuild(5, "sendQuitSignal(int)", 286).add("e", (Object)runProcessException)).log();
            }
            if (runProcessException.getCause() != null) {
                throw runProcessException.getCause();
            }
        }
    }

    @Override
    public File getCacheDirectory() {
        if (UnixNative.a.level >= 7) {
            a.lvlBuild(7, "getCacheDirectory()", 297).log();
        }
        return new File(System.getProperty("user.home"), ".cache/qftest");
    }

    @Override
    public boolean canDetectSystemDarkMode() {
        if (UnixNative.a.level >= 7) {
            a.lvlBuild(7, "canDetectSystemDarkMode()", 306).log();
        }
        if (this.getGtkSettingsIni() != null) {
            return true;
        }
        return this.getGSettingsApp() != null;
    }

    @Override
    public boolean isSystemInDarkMode() {
        String string;
        if (UnixNative.a.level >= 7) {
            a.lvlBuild(7, "isSystemInDarkMode()", 315).log();
        }
        if (!this.canDetectSystemDarkMode()) {
            return false;
        }
        File file = this.getGtkSettingsIni();
        if (UnixNative.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "isSystemInDarkMode()", 321).add("gtkSettingsIni", (Object)file)).log();
        }
        if (file != null) {
            return this.a(file);
        }
        if (this.g) {
            string = this.getGtkColorScheme();
            if (UnixNative.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "isSystemInDarkMode()", 329).add("colorScheme", string)).log();
            }
            if (string != null) {
                switch (string) {
                    case "prefer-dark": {
                        return true;
                    }
                    case "prefer-light": 
                    case "default": {
                        return false;
                    }
                }
            }
            this.g = false;
        }
        string = this.getGtkThemeName();
        if (UnixNative.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "isSystemInDarkMode()", 346).add("themeName", string)).log();
        }
        return string != null && string.toLowerCase().contains("-dark");
    }

    public String getGtkColorScheme() {
        if (UnixNative.a.level >= 7) {
            a.lvlBuild(7, "getGtkColorScheme()", 353).log();
        }
        return this.a("color-scheme");
    }

    public String getGtkThemeName() {
        if (UnixNative.a.level >= 7) {
            a.lvlBuild(7, "getGtkThemeName()", 361).log();
        }
        return this.a("gtk-theme");
    }

    @Nullable
    private String a(String string) {
        String string2;
        if (UnixNative.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getGtkSetting(String)", 370).addDetail("settingName", string)).log();
        }
        if ((string2 = this.getGSettingsApp()) == null) {
            return null;
        }
        try {
            int n2;
            String string3 = ProcessManager.runProcess((String[])new String[]{string2, "get", "org.gnome.desktop.interface", string}, (int)500);
            if (UnixNative.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getGtkSetting(String)", 376).add("value", string3)).log();
            }
            if (string3 != null && (n2 = string3.length() - 2) > 0) {
                return string3.substring(1, n2);
            }
            return string3;
        }
        catch (Exception exception) {
            if (UnixNative.a.level >= 5) {
                ((LevelAwareLogBuilder)a.lvlBuild(5, "getGtkSetting(String)", 385).add("ex", (Object)exception)).log();
            }
            return null;
        }
    }

    private File a() {
        File[] fileArray;
        if (UnixNative.a.level >= 7) {
            a.lvlBuild(7, "checkGSettingsIni()", 394).log();
        }
        for (File file : fileArray = new File[]{new File(System.getProperty("user.home"), ".config/gtk-4.0/settings.ini"), new File(System.getProperty("user.home"), ".config/gtk-3.0/settings.ini")}) {
            if (this.a(file) == null) continue;
            return file;
        }
        return null;
    }

    private Boolean a(File file) {
        if (UnixNative.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getPreferDarkThemeSetting(File)", 407).addDetail("settingsFile", (Object)file)).log();
        }
        if (!file.exists()) {
            return null;
        }
        Map map = IniAccess.instance().getIniData(file);
        Map map2 = (Map)map.get("Settings");
        if (map2 == null) {
            return null;
        }
        String string = (String)map2.get("gtk-application-prefer-dark-theme");
        if (UnixNative.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getPreferDarkThemeSetting(File)", 414).add("settingValue", string)).log();
        }
        if (string == null) {
            return null;
        }
        return "1".equals(string);
    }

    private String b() {
        String[] stringArray;
        if (UnixNative.a.level >= 7) {
            a.lvlBuild(7, "findGSettings()", 422).log();
        }
        String string = System.getenv("PATH");
        if (UnixNative.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "findGSettings()", 424).add("path_env", string)).log();
        }
        if (Misc.emptyOrNull((String)string)) {
            return null;
        }
        for (String string2 : stringArray = Misc.fastSplit((String)string, (char)File.pathSeparatorChar)) {
            File file = new File(string2.trim(), "gsettings");
            if (!file.exists()) continue;
            return file.getAbsolutePath();
        }
        return null;
    }

    @Override
    public void listenForDarkModeSwitch() {
        if (UnixNative.a.level >= 7) {
            a.lvlBuild(7, "listenForDarkModeSwitch()", 444).log();
        }
        if (!this.h.compareAndSet(false, true)) {
            return;
        }
        if (!this.canDetectSystemDarkMode()) {
            return;
        }
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(runnable -> new DaemonThread(runnable, "Gtk Theme Change Listener"));
        AtomicBoolean atomicBoolean = new AtomicBoolean(this.isSystemInDarkMode());
        scheduledExecutorService.scheduleWithFixedDelay(() -> {
            boolean bl = this.isSystemInDarkMode();
            if (atomicBoolean.compareAndSet(!bl, bl)) {
                UnixNative.a(bl);
            }
        }, 2500L, 2500L, TimeUnit.MILLISECONDS);
    }

    protected static void a(boolean bl) {
        if (UnixNative.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "notifySystemDarkModeChanged(boolean)", 464).addDetail("inDarkMode", bl)).log();
        }
        if (UserNotifications.NOTIFIER.level >= 1) {
            UserNotifications.NOTIFIER.postNotification(1, "user.theme.systemChanged", null, new Object[]{"didChangeAppsTheme", Boolean.TRUE, "appsAreInDarkMode", bl, "didChangeSystemTheme", Boolean.TRUE, "systemIsInDarkMode", bl});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public File getGtkSettingsIni() {
        Object object;
        if (UnixNative.a.level >= 7) {
            a.lvlBuild(7, "getGtkSettingsIni()", 66).log();
        }
        if ((object = this.b.get()) == null) {
            AtomicReference atomicReference = this.b;
            synchronized (atomicReference) {
                object = this.b.get();
                if (object == null) {
                    File file = this.a();
                    object = file == null ? this.b : file;
                    this.b.set(object);
                }
            }
        }
        return object == this.b ? null : object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getGSettingsApp() {
        Object object;
        if (UnixNative.a.level >= 7) {
            a.lvlBuild(7, "getGSettingsApp()", 67).log();
        }
        if ((object = this.i.get()) == null) {
            AtomicReference atomicReference = this.i;
            synchronized (atomicReference) {
                object = this.i.get();
                if (object == null) {
                    String string = this.b();
                    object = string == null ? this.i : string;
                    this.i.set(object);
                }
            }
        }
        return object == this.i ? null : object;
    }
}

