/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.system;

import de.qfs.apps.qftest.shared.system.NativeRobot;
import de.qfs.apps.qftest.shared.system.WindowsNative;
import de.qfs.apps.qftest.shared.system.win32.Kernel32;
import de.qfs.apps.qftest.shared.system.win32.User32;
import de.qfs.apps.qftest.shared.system.win32.WinMisc;
import de.qfs.apps.qftest.shared.system.win32.WindowDC;
import de.qfs.apps.qftest.shared.system.win32.Wnd;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WindowsNativeDirect
extends WindowsNative {
    private static final QFLogger b = new QFLogger("de.qfs.apps.qftest.shared.system.WindowsNativeDirect");
    private WindowsNativeDirectRobot g = new WindowsNativeDirectRobot();

    protected WindowsNativeDirect() {
        if (WindowsNativeDirect.b.level >= 7) {
            b.lvlBuild(7, "WindowsNativeDirect()", 58).log();
        }
    }

    @Override
    public int getProcessID() {
        if (WindowsNativeDirect.b.level >= 7) {
            b.lvlBuild(7, "getProcessID()", 75).log();
        }
        int n2 = Kernel32.GetCurrentProcessId();
        if (WindowsNativeDirect.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "getProcessID()", 78).add("pid", n2)).log();
        }
        return n2;
    }

    @Override
    public int getProcessID(long l2) {
        if (WindowsNativeDirect.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getProcessID(long)", 93).addDetail("handle", l2)).log();
        }
        int n2 = Kernel32.GetProcessId(l2);
        if (WindowsNativeDirect.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "getProcessID(long)", 96).add("pid", n2)).log();
        }
        return n2;
    }

    @Override
    public boolean setDoubleClickTime(int n2) {
        if (WindowsNativeDirect.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setDoubleClickTime(int)", 118).addDetail("interval", n2)).log();
        }
        boolean bl = User32.SetDoubleClickTime(n2);
        if (WindowsNativeDirect.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "setDoubleClickTime(int)", 121).add("ret", bl)).log();
        }
        return bl;
    }

    @Override
    public boolean setWorkingDirectory(String string) {
        if (WindowsNativeDirect.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setWorkingDirectory(String)", 134).addDetail("dir", string)).log();
        }
        string = string.replace('/', '\\');
        boolean bl = Kernel32.SetCurrentDirectory(string);
        if (WindowsNativeDirect.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "setWorkingDirectory(String)", 139).add("ret", bl)).log();
        }
        return bl;
    }

    @Override
    public double getScreenScaleFactor() {
        if (WindowsNativeDirect.b.level >= 7) {
            b.lvlBuild(7, "getScreenScaleFactor()", 147).log();
        }
        double d2 = WinMisc.getWindowsScaling();
        if (WindowsNativeDirect.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "getScreenScaleFactor()", 150).add("scaling", d2)).log();
        }
        return d2;
    }

    @Override
    protected void a(long l2, int n2, long l3, long l4) {
        block4: {
            if (WindowsNativeDirect.b.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "postMessage(long,int,long,long)", 161).addDetail("hwnd", l2)).addDetail("message", n2)).addDetail("wParam", l3)).addDetail("lParam", l4)).log();
            }
            try {
                if (WindowsNativeDirect.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "postMessage(long,int,long,long)", 164).add("message", n2)).log();
                }
                User32.PostMessage(l2, n2, l3, l4);
            }
            catch (Throwable throwable) {
                if (WindowsNativeDirect.b.level < 5) break block4;
                ((LevelAwareLogBuilder)b.lvlBuild(5, "postMessage(long,int,long,long)", 167).add("ex", (Object)throwable)).log();
            }
        }
    }

    @Override
    protected void b(long l2, int n2, long l3, long l4) {
        block3: {
            try {
                if (WindowsNativeDirect.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "sendMessage(long,int,long,long)", 181).add("message", n2)).log();
                }
                User32.SendMessage(l2, n2, l3, l4);
            }
            catch (Throwable throwable) {
                if (WindowsNativeDirect.b.level < 5) break block3;
                ((LevelAwareLogBuilder)b.lvlBuild(5, "sendMessage(long,int,long,long)", 184).add("ex", (Object)throwable)).log();
            }
        }
    }

    @Override
    public long getWindowDC(long l2) {
        if (WindowsNativeDirect.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getWindowDC(long)", 196).addDetail("hWnd", l2)).log();
        }
        Wnd wnd = new Wnd(l2);
        if (WindowsNativeDirect.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "getWindowDC(long)", 200).add("wnd", (Object)wnd)).log();
        }
        long l3 = WindowDC.getWindowDC(wnd).getValue();
        if (WindowsNativeDirect.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "getWindowDC(long)", 202).add("ret", l3)).log();
        }
        return l3;
    }

    @Override
    public void releaseWindowDC(long l2, long l3) {
        if (WindowsNativeDirect.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "releaseWindowDC(long,long)", 210).addDetail("hWnd", l2)).addDetail("hDC", l3)).log();
        }
        WindowDC.releaseWindowDC(l2, l3);
    }

    @Override
    public boolean printWindow(long l2, long l3, int n2) {
        if (WindowsNativeDirect.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "printWindow(long,long,int)", 219).addDetail("hWnd", l2)).addDetail("hDC", l3)).addDetail("flags", n2)).log();
        }
        boolean bl = User32.PrintWindow(l2, l3, n2);
        if (WindowsNativeDirect.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "printWindow(long,long,int)", 222).add("ret", bl)).log();
        }
        return bl;
    }

    @Override
    public long[] findAllDialogs() {
        if (WindowsNativeDirect.b.level >= 7) {
            b.lvlBuild(7, "findAllDialogs()", 230).log();
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        List list = Wnd.getAllWindows();
        if (WindowsNativeDirect.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "findAllDialogs()", 236).add("wnds", (Object)list)).log();
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Wnd wnd = (Wnd)list.get(i2);
            if (!wnd.getWindowClassName().equals("#32770")) continue;
            arrayList.add(wnd.getValue());
        }
        if (WindowsNativeDirect.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "findAllDialogs()", 244).add("dlgs", arrayList)).log();
        }
        long[] lArray = new long[arrayList.size()];
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            lArray[i3] = (Long)arrayList.get(i3);
        }
        return lArray;
    }

    @Override
    public NativeRobot getNativeRobot() {
        if (WindowsNativeDirect.b.level >= 7) {
            b.lvlBuild(7, "getNativeRobot()", 264).log();
        }
        return this.g;
    }

    @Override
    public void keybdEvent(int n2, int n3) {
        block4: {
            if (WindowsNativeDirect.b.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "keybdEvent(int,int)", 280).addDetail("keyCode", n2)).addDetail("flags", n3)).log();
            }
            n2 = this.awtKeyCodeToWinKeyCode(n2);
            try {
                int n4 = User32.MapVirtualKey(n2, 0);
                if (WindowsNativeDirect.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "keybdEvent(int,int)", 285).add("scan", n4)).log();
                }
                User32.keybd_event((byte)n2, (byte)n4, n3, 0L);
            }
            catch (Throwable throwable) {
                if (WindowsNativeDirect.b.level < 5) break block4;
                ((LevelAwareLogBuilder)b.lvlBuild(5, "keybdEvent(int,int)", 288).add("ex", (Object)throwable)).log();
            }
        }
    }

    @Override
    protected int a(char c2) {
        if (WindowsNativeDirect.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "charToKeycode(char)", 296).addDetail("c", c2)).log();
        }
        short s2 = User32.VkKeyScan(c2);
        return this.winKeyCodeToAwtKeyCode(s2);
    }

    @Override
    public int[] getMousePosition() {
        if (WindowsNativeDirect.b.level >= 7) {
            b.lvlBuild(7, "getMousePosition()", 310).log();
        }
        return WinMisc.GetMousePosition();
    }

    static WindowsNativeDirect i() {
        if (WindowsNativeDirect.b.level >= 7) {
            b.lvlBuild(7, "createInstance()", 327).log();
        }
        try {
            String string = WindowsNativeDirect.getVersionDir();
            File file = Misc.JAVA_IS_64_BIT ? new File(string, "bin/qfwrap.dll") : new File(string, "bin/qfwrap32.dll");
            System.load(file.getPath());
            if (WindowsNativeDirect.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "createInstance()", 335).add("Loaded library", (Object)file)).log();
            }
            return new WindowsNativeDirect();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (WindowsNativeDirect.b.level >= 5) {
                ((LevelAwareLogBuilder)b.lvlBuild(5, "createInstance()", 339).add("ulex", (Object)unsatisfiedLinkError)).log();
            }
            return null;
        }
        catch (Throwable throwable) {
            if (WindowsNativeDirect.b.level >= 5) {
                ((LevelAwareLogBuilder)b.lvlBuild(5, "createInstance()", 343).add("ex2", (Object)throwable)).log();
            }
            return null;
        }
    }

    @Override
    protected long e() {
        if (WindowsNativeDirect.b.level >= 7) {
            b.lvlBuild(7, "getForegroundWindow()", 355).log();
        }
        return Wnd.GetForegroundWindow();
    }

    @Override
    protected List f() {
        if (WindowsNativeDirect.b.level >= 7) {
            b.lvlBuild(7, "getAllWindows()", 363).log();
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (long l2 : Wnd.GetAllWindows()) {
            arrayList.add(l2);
        }
        return arrayList;
    }

    @Override
    protected Set g() {
        if (WindowsNativeDirect.b.level >= 7) {
            b.lvlBuild(7, "getAllVisibleWindows()", 375).log();
        }
        HashSet<Long> hashSet = new HashSet<Long>();
        for (long l2 : Wnd.GetAllVisibleWindows()) {
            hashSet.add(l2);
        }
        return hashSet;
    }

    @Override
    protected long a(long l2) {
        if (WindowsNativeDirect.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getParent(long)", 387).addDetail("hwnd", l2)).log();
        }
        return Wnd.GetParent(l2);
    }

    @Override
    protected boolean b(long l2) {
        if (WindowsNativeDirect.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setForegroundWindow(long)", 395).addDetail("hwnd", l2)).log();
        }
        return Wnd.SetForegroundWindow(l2);
    }

    @Override
    protected boolean c(long l2) {
        if (WindowsNativeDirect.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "bringWindowToTop(long)", 403).addDetail("hwnd", l2)).log();
        }
        return Wnd.BringWindowToTop(l2);
    }

    @Override
    protected String d(long l2) {
        if (WindowsNativeDirect.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getWindowText(long)", 411).addDetail("hwnd", l2)).log();
        }
        return Wnd.GetWindowText(l2);
    }

    @Override
    protected int b(int n2) {
        if (WindowsNativeDirect.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getAsyncKeyState(int)", 419).addDetail("key", n2)).log();
        }
        return User32.GetAsyncKeyState(n2);
    }

    @Override
    public String getShortPathName(String string) {
        if (WindowsNativeDirect.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getShortPathName(String)", 435).addDetail("path", string)).log();
        }
        string = string.replace('/', '\\');
        String string2 = Kernel32.GetShortPathName(string);
        if (WindowsNativeDirect.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "getShortPathName(String)", 439).add("ret", string2)).log();
        }
        return string2;
    }

    public static class WindowsNativeDirectRobot
    implements NativeRobot {
        public WindowsNativeDirectRobot() {
            if (b.level >= 7) {
                b.lvlBuild(7, "WindowsNativeDirectRobot.WindowsNativeDirectRobot()", 450).log();
            }
        }

        @Override
        public int getScreenCount() {
            if (b.level >= 7) {
                b.lvlBuild(7, "WindowsNativeDirectRobot.getScreenCount()", 461).log();
            }
            return WinMisc.getScreenCount();
        }

        @Override
        public double getScreenScaling(int n2) {
            if (b.level >= 7) {
                ((LevelAwareLogBuilder)b.lvlBuild(7, "WindowsNativeDirectRobot.getScreenScaling(int)", 477).addDetail("screen", n2)).log();
            }
            return WinMisc.getScreenScaling(n2);
        }

        @Override
        public boolean isPrimaryScreen(int n2) {
            if (b.level >= 7) {
                ((LevelAwareLogBuilder)b.lvlBuild(7, "WindowsNativeDirectRobot.isPrimaryScreen(int)", 492).addDetail("screen", n2)).log();
            }
            return WinMisc.isPrimaryScreen(n2);
        }

        @Override
        public int[] getScreenBounds(int n2) {
            if (b.level >= 7) {
                ((LevelAwareLogBuilder)b.lvlBuild(7, "WindowsNativeDirectRobot.getScreenBounds(int)", 507).addDetail("screen", n2)).log();
            }
            return WinMisc.getScreenBounds(n2);
        }

        @Override
        public int[] getVisualScreenBounds(int n2) {
            if (b.level >= 7) {
                ((LevelAwareLogBuilder)b.lvlBuild(7, "WindowsNativeDirectRobot.getVisualScreenBounds(int)", 523).addDetail("screen", n2)).log();
            }
            return WinMisc.getVisualScreenBounds(n2);
        }

        @Override
        public int[] grabScreenshot(int n2, int n3, int n4, int n5) {
            if (b.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "WindowsNativeDirectRobot.grabScreenshot(int,int,int,int)", 541).addDetail("x", n2)).addDetail("y", n3)).addDetail("width", n4)).addDetail("height", n5)).log();
            }
            return WinMisc.grabScreenshot(n2, n3, n4, n5);
        }

        @Override
        public int[] grabScreenshot(int n2, int n3, int n4, int n5, int n6) {
            if (b.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "WindowsNativeDirectRobot.grabScreenshot(int,int,int,int,int)", 560).addDetail("screen", n2)).addDetail("x", n3)).addDetail("y", n4)).addDetail("width", n5)).addDetail("height", n6)).log();
            }
            return WinMisc.grabScreenshot(n2, n3, n4, n5, n6);
        }

        @Override
        public void mouseMove(int n2, int n3) {
            if (b.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "WindowsNativeDirectRobot.mouseMove(int,int)", 575).addDetail("x", n2)).addDetail("y", n3)).log();
            }
            WinMisc.mouseMove(n2, n3);
        }

        @Override
        public void mousePress(int n2) {
            if (b.level >= 7) {
                ((LevelAwareLogBuilder)b.lvlBuild(7, "WindowsNativeDirectRobot.mousePress(int)", 589).addDetail("button", n2)).log();
            }
            WinMisc.mousePress(n2);
        }

        @Override
        public void mouseRelease(int n2) {
            if (b.level >= 7) {
                ((LevelAwareLogBuilder)b.lvlBuild(7, "WindowsNativeDirectRobot.mouseRelease(int)", 603).addDetail("button", n2)).log();
            }
            WinMisc.mouseRelease(n2);
        }

        @Override
        public int[] getMousePosition() {
            if (b.level >= 7) {
                b.lvlBuild(7, "WindowsNativeDirectRobot.getMousePosition()", 617).log();
            }
            return WinMisc.GetMousePosition();
        }
    }
}

