/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.system.mac;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import com.dd.plist.XMLPropertyListWriter;
import de.qfs.apps.qftest.shared.ExternalClassWrapperHelper;
import de.qfs.apps.qftest.shared.system.mac.PListAccessHelper;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

public class PListAccessHelperImpl
extends ExternalClassWrapperHelper
implements PListAccessHelper {
    private static final QFLogger c = new QFLogger("de.qfs.apps.qftest.shared.system.mac.PListAccessHelperImpl");

    public PListAccessHelperImpl() {
        if (PListAccessHelperImpl.c.level >= 7) {
            c.lvlBuild(7, "PListAccessHelperImpl.PListAccessHelperImpl()", 47).log();
        }
    }

    @Override
    @Nullable
    public File getExecutable(File file) {
        if (PListAccessHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "getExecutable(File)", 57).addDetail("containerFile", (Object)file)).log();
        }
        if (file == null) {
            throw new IllegalArgumentException("containerFile is marked non-null but is null");
        }
        File file2 = this.getInfoPlistFile(file);
        if (PListAccessHelperImpl.c.level >= 9) {
            ((LevelAwareLogBuilder)c.lvlBuild(9, "getExecutable(File)", 60).add("infoPlist", (Object)file2)).log();
        }
        if (file2 == null) {
            if (PListAccessHelperImpl.c.level >= 5) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(5, "getExecutable(File)", 62).add("No info.plist found in ")).add((Object)file)).log();
            }
            return null;
        }
        try {
            NSString nSString;
            NSDictionary nSDictionary = (NSDictionary)PropertyListParser.parse((File)file2);
            if (PListAccessHelperImpl.c.level >= 9) {
                ((LevelAwareLogBuilder)c.lvlBuild(9, "getExecutable(File)", 68).add("rootDict", (Object)nSDictionary)).log();
            }
            if ((nSString = (NSString)nSDictionary.objectForKey("CFBundleExecutable")) == null) {
                return null;
            }
            File file3 = new File(file2.getParentFile().getParentFile(), "Contents/MacOS/" + nSString.getContent());
            if (PListAccessHelperImpl.c.level >= 9) {
                ((LevelAwareLogBuilder)c.lvlBuild(9, "getExecutable(File)", 75).add("executableFile", (Object)file3)).log();
            }
            if (!file3.exists()) {
                if (PListAccessHelperImpl.c.level >= 3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(3, "getExecutable(File)", 77).add((Object)file3)).add(" does not exists")).log();
                }
                return null;
            }
            if (!file3.canExecute()) {
                if (PListAccessHelperImpl.c.level >= 3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(3, "getExecutable(File)", 81).add((Object)file3)).add(" is not executable")).log();
                }
                return null;
            }
            return file3;
        }
        catch (Exception exception) {
            if (PListAccessHelperImpl.c.level >= 1) {
                ((LevelAwareLogBuilder)c.lvlBuild(1, "getExecutable(File)", 87).add("ex", (Object)exception)).log();
            }
            return null;
        }
    }

    @Override
    @Nullable
    public String getBundleIdentifier(File file) {
        if (PListAccessHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "getBundleIdentifier(File)", 101).addDetail("containerFile", (Object)file)).log();
        }
        if (file == null) {
            throw new IllegalArgumentException("containerFile is marked non-null but is null");
        }
        File file2 = this.getInfoPlistFile(file);
        if (PListAccessHelperImpl.c.level >= 9) {
            ((LevelAwareLogBuilder)c.lvlBuild(9, "getBundleIdentifier(File)", 104).add("infoPlist", (Object)file2)).log();
        }
        if (file2 == null) {
            if (PListAccessHelperImpl.c.level >= 5) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(5, "getBundleIdentifier(File)", 106).add("No info.plist found in ")).add((Object)file)).log();
            }
            return null;
        }
        try {
            NSString nSString;
            NSDictionary nSDictionary = (NSDictionary)PropertyListParser.parse((File)file2);
            if (PListAccessHelperImpl.c.level >= 9) {
                ((LevelAwareLogBuilder)c.lvlBuild(9, "getBundleIdentifier(File)", 112).add("rootDict", (Object)nSDictionary)).log();
            }
            if ((nSString = (NSString)nSDictionary.objectForKey("CFBundleIdentifier")) == null) {
                return null;
            }
            if (PListAccessHelperImpl.c.level >= 9) {
                ((LevelAwareLogBuilder)c.lvlBuild(9, "getBundleIdentifier(File)", 116).add("bundleIdentifier", (Object)nSString)).log();
            }
            return nSString.toString();
        }
        catch (Exception exception) {
            if (PListAccessHelperImpl.c.level >= 1) {
                ((LevelAwareLogBuilder)c.lvlBuild(1, "getBundleIdentifier(File)", 120).add("ex", (Object)exception)).log();
            }
            return null;
        }
    }

    @Override
    @Nullable
    public File getInfoPlistFile(File file) {
        int n2;
        if (PListAccessHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "getInfoPlistFile(File)", 137).addDetail("containerFile", (Object)file)).log();
        }
        if (file == null) {
            throw new IllegalArgumentException("containerFile is marked non-null but is null");
        }
        if (!file.isDirectory()) {
            File file2;
            int n3;
            String string = file.getAbsolutePath();
            if (PListAccessHelperImpl.c.level >= 9) {
                ((LevelAwareLogBuilder)c.lvlBuild(9, "getInfoPlistFile(File)", 140).add("containerPath", string)).log();
            }
            if ((n3 = string.lastIndexOf(".app")) > -1) {
                if (!file.exists()) {
                    if (PListAccessHelperImpl.c.level >= 9) {
                        ((LevelAwareLogBuilder)c.lvlBuild(9, "getInfoPlistFile(File)", 145).add("Container path does not exists", string)).log();
                    }
                    return null;
                }
                string = string.substring(0, n3);
                if (PListAccessHelperImpl.c.level >= 9) {
                    ((LevelAwareLogBuilder)c.lvlBuild(9, "getInfoPlistFile(File)", 149).add("containerPath", string)).log();
                }
            }
            if ((file2 = new File(string + ".app")).isDirectory()) {
                file = file2;
            }
            if (PListAccessHelperImpl.c.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(9, "getInfoPlistFile(File)", 156).add("Adding .app to file")).add("containerFile", (Object)file)).log();
            }
        }
        if ((n2 = file.getAbsolutePath().lastIndexOf(".app")) > 0) {
            File file3 = new File(file.getAbsolutePath().substring(0, n2 + 4));
            if (PListAccessHelperImpl.c.level >= 9) {
                ((LevelAwareLogBuilder)c.lvlBuild(9, "getInfoPlistFile(File)", 162).add("containerFileCandidate", (Object)file3)).log();
            }
            if (new File(file3, "Contents").exists()) {
                if (PListAccessHelperImpl.c.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(9, "getInfoPlistFile(File)", 164).add("Truncating to app container")).add("containerFileCandidate", (Object)file3)).log();
                }
                file = file3;
            }
        }
        File file4 = new File(file, "Contents/Info.plist");
        if (PListAccessHelperImpl.c.level >= 9) {
            ((LevelAwareLogBuilder)c.lvlBuild(9, "getInfoPlistFile(File)", 170).add("infoPlist", (Object)file4)).log();
        }
        if (!file4.exists()) {
            if (PListAccessHelperImpl.c.level >= 5) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(5, "getInfoPlistFile(File)", 172).add("No info.plist found in ")).add((Object)file)).log();
            }
            return null;
        }
        return file4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map getContent(File file) {
        if (PListAccessHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "getContent(File)", 189).addDetail("plistFile", (Object)file)).log();
        }
        if (file == null) {
            throw new IllegalArgumentException("plistFile is marked non-null but is null");
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Map map = this.getContent(fileInputStream);
            return map;
        }
        catch (Exception exception) {
            if (PListAccessHelperImpl.c.level < 1) return Collections.emptyMap();
            ((LevelAwareLogBuilder)c.lvlBuild(1, "getContent(File)", 194).add("e", (Object)exception)).log();
            return Collections.emptyMap();
        }
    }

    @Override
    public Map getContent(InputStream inputStream) {
        if (PListAccessHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "getContent(InputStream)", 210).addDetail("stream", (Object)inputStream)).log();
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("stream is marked non-null but is null");
        }
        try {
            NSDictionary nSDictionary = (NSDictionary)PropertyListParser.parse((InputStream)inputStream);
            if (PListAccessHelperImpl.c.level >= 9) {
                ((LevelAwareLogBuilder)c.lvlBuild(9, "getContent(InputStream)", 214).add("rootDict", (Object)nSDictionary)).log();
            }
            return (Map)nSDictionary.toJavaObject();
        }
        catch (Exception exception) {
            if (PListAccessHelperImpl.c.level >= 1) {
                ((LevelAwareLogBuilder)c.lvlBuild(1, "getContent(InputStream)", 217).add("e", (Object)exception)).log();
            }
            return Collections.emptyMap();
        }
    }

    @Override
    public void setXmlContent(Map map, File file) throws IOException {
        if (PListAccessHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "setXmlContent(Map<String, Object>,File)", 228).addDetail("content", (Object)map)).addDetail("plistFile", (Object)file)).log();
        }
        if (map == null) {
            throw new IllegalArgumentException("content is marked non-null but is null");
        }
        if (file == null) {
            throw new IllegalArgumentException("plistFile is marked non-null but is null");
        }
        NSObject nSObject = NSObject.fromJavaObject((Object)map);
        XMLPropertyListWriter.write((NSObject)nSObject, (File)file);
    }

    @Override
    public void setXmlContent(Map map, OutputStream outputStream) throws IOException {
        if (PListAccessHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "setXmlContent(Map<String, Object>,OutputStream)", 240).addDetail("content", (Object)map)).addDetail("stream", (Object)outputStream)).log();
        }
        if (map == null) {
            throw new IllegalArgumentException("content is marked non-null but is null");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("stream is marked non-null but is null");
        }
        NSObject nSObject = NSObject.fromJavaObject((Object)map);
        XMLPropertyListWriter.write((NSObject)nSObject, (OutputStream)outputStream);
    }
}

