/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.ui;

import de.qfs.apps.qftest.shared.ui.UIHelpers;
import de.qfs.lib.log.QFLogger;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class FlatButtonBorder
extends AbstractBorder {
    private static final QFLogger b = new QFLogger("de.qfs.apps.qftest.shared.ui.FlatButtonBorder");
    protected static final Insets a = new Insets(2, 2, 2, 2);

    public FlatButtonBorder() {
        if (FlatButtonBorder.b.level >= 7) {
            b.lvlBuild(7, "FlatButtonBorder()", 42).log();
        }
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        AbstractButton abstractButton = (AbstractButton)component;
        ButtonModel buttonModel = abstractButton.getModel();
        if (!buttonModel.isEnabled()) {
            graphics.setColor(UIManager.getColor("Button.disabledBorder"));
            UIHelpers.drawRectScaled(component, graphics, 1, n2, n3, n4 - 1, n5 - 1);
            return;
        }
        boolean bl = buttonModel.isPressed() && buttonModel.isArmed();
        boolean bl2 = buttonModel.isSelected();
        boolean bl3 = abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton();
        boolean bl4 = abstractButton.hasFocus();
        if (bl) {
            graphics.setColor(UIManager.getColor("Button.selectedBorder"));
            UIHelpers.drawRectScaled(component, graphics, 2, n2, n3, n4 - 1, n5 - 1);
            component.setForeground(UIManager.getColor("Button.selectionForeground"));
        } else if (bl2) {
            graphics.setColor(UIManager.getColor("Button.defaultBorder"));
            UIHelpers.drawRectScaled(component, graphics, bl3 ? 2 : 1, n2, n3, n4 - 1, n5 - 1);
            component.setForeground(UIManager.getColor("Button.selectionForeground"));
        } else if (bl4) {
            graphics.setColor(UIManager.getColor("Button.focus"));
            UIHelpers.drawRectScaled(component, graphics, 2, n2, n3, n4 - 1, n5 - 1);
            component.setForeground(UIManager.getColor("Button.foreground"));
        } else {
            graphics.setColor(UIManager.getColor("Button.defaultBorder"));
            UIHelpers.drawRectScaled(component, graphics, bl3 ? 2 : 1, n2, n3, n4 - 1, n5 - 1);
            component.setForeground(UIManager.getColor("Button.foreground"));
        }
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return a;
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.top = FlatButtonBorder.a.top;
        insets.left = FlatButtonBorder.a.left;
        insets.bottom = FlatButtonBorder.a.bottom;
        insets.right = FlatButtonBorder.a.right;
        return insets;
    }
}

