/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.ui;

import de.qfs.apps.qftest.shared.ui.UIHelpers;
import de.qfs.lib.log.QFLogger;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class FlatComboBoxButtonBorder
extends AbstractBorder {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.shared.ui.FlatComboBoxButtonBorder");
    private static final long serialVersionUID = -666536336669873081L;
    private static final Insets b = new Insets(1, 1, 1, 1);

    public FlatComboBoxButtonBorder() {
        if (FlatComboBoxButtonBorder.a.level >= 7) {
            a.lvlBuild(7, "FlatComboBoxButtonBorder()", 49).log();
        }
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        boolean bl;
        AbstractButton abstractButton = (AbstractButton)component;
        ButtonModel buttonModel = abstractButton.getModel();
        if (!buttonModel.isEnabled()) {
            graphics.setColor(UIManager.getColor("ComboBox.disabledBorder"));
            UIHelpers.drawRectScaled(component, graphics, 1, n2, n3, n4 - 1, n5 - 1);
            return;
        }
        boolean bl2 = buttonModel.isPressed() && buttonModel.isArmed();
        boolean bl3 = bl = abstractButton.hasFocus() || abstractButton.getParent() != null && abstractButton.getParent().hasFocus();
        if (bl2) {
            graphics.setColor(UIManager.getColor("Button.selectedBorder"));
            UIHelpers.drawRectScaled(component, graphics, 1, n2, n3, n4 - 1, n5 - 1);
        } else if (bl) {
            graphics.setColor(UIManager.getColor("Button.focus"));
            UIHelpers.drawRectScaled(component, graphics, 2, n2, n3, n4 - 1, n5 - 1);
        } else {
            graphics.setColor(UIManager.getColor("ComboBox.borderColor"));
            UIHelpers.drawRectScaled(component, graphics, 1, n2, n3, n4 - 1, n5 - 1);
        }
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return b;
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.top = FlatComboBoxButtonBorder.b.top;
        insets.left = FlatComboBoxButtonBorder.b.left;
        insets.bottom = FlatComboBoxButtonBorder.b.bottom;
        insets.right = FlatComboBoxButtonBorder.b.right;
        return insets;
    }
}

