/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.ui;

import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.ui.UIHelpers;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.BooleanOption;
import de.qfs.lib.util.Observer;
import java.awt.Graphics;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTreeUI;

public class FlatTreeUI
extends MetalTreeUI {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.shared.ui.FlatTreeUI");
    static boolean treePaintLines = Options.cached_OPT_TREE_PAINT_LINES;
    private static Observer treeOptionObserver = (observable, object) -> {
        BooleanOption booleanOption;
        if (observable instanceof BooleanOption && Options.OPT_TREE_PAINT_LINES.equals((booleanOption = (BooleanOption)observable).getName())) {
            treePaintLines = (Boolean)booleanOption.getValue();
            for (Window window : Window.getWindows()) {
                window.repaint();
            }
        }
    };

    public FlatTreeUI() {
        if (FlatTreeUI.logger.level >= 7) {
            logger.lvlBuild(7, "FlatTreeUI.FlatTreeUI()", 33).log();
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        if (FlatTreeUI.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createUI(JComponent)", 60).addDetail("c", (Object)jComponent)).log();
        }
        return new FlatTreeUI();
    }

    @Override
    protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n2, int n3, int n4) {
        if (treePaintLines) {
            UIHelpers.drawLineScaled(jComponent, graphics, 1, n2, n3, n2, n4);
        }
    }

    @Override
    protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n2, int n3, int n4) {
        if (treePaintLines) {
            UIHelpers.drawLineScaled(jComponent, graphics, 1, n3, n2, n4, n2);
        }
    }

    static {
        Options.getOption(Options.OPT_TREE_PAINT_LINES).addObserver(treeOptionObserver);
    }
}

