/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.ui.plaf;

import com.jgoodies.looks.plastic.theme.SkyBlue;
import de.qfs.apps.qftest.shared.Globals;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.ui.Borders;
import de.qfs.apps.qftest.shared.ui.CssParser;
import de.qfs.apps.qftest.shared.ui.CssParserHelper;
import de.qfs.apps.qftest.shared.ui.Icons;
import de.qfs.lib.gui.SVGIcon;
import de.qfs.lib.json.Json;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.edit.OptionEdit;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import java.awt.Color;
import java.awt.Insets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;

public class SkyQfs
extends SkyBlue {
    private static final QFLogger f = new QFLogger("de.qfs.apps.qftest.shared.ui.plaf.SkyQfs");
    public static final String QFTEST_STYLES_RES_PACKAGE = "de.qfs.apps.qftest.resources.styles";
    public static final Pattern ICON_SCALING_SUFFIX_PATTERN = Pattern.compile("[\"']?(.+?)(@1\\.25x)?(@\\d+(?:\\.\\d+)?em)?(@\\d+(?:\\.\\d+)?x)?[\"']?");
    final String a;
    private static final AtomicReference g = new AtomicReference();
    private static final AtomicReference h = new AtomicReference();
    private static final AtomicReference i = new AtomicReference();
    private static final AtomicReference j = new AtomicReference();
    private static final AtomicReference k = new AtomicReference();
    @Nullable
    protected volatile HashMap b;
    @Nullable
    protected volatile Map c;
    @Nullable
    protected volatile Map d = new ConcurrentHashMap();
    @Nullable
    KeyStroke e;

    public SkyQfs(String string) {
        this.a = string;
    }

    public String getName() {
        this.g();
        return String.valueOf(this.c.get("Theme.name"));
    }

    public String getPropertySuffix() {
        this.g();
        return String.valueOf(this.c.get("Theme.propertySuffix"));
    }

    public boolean isDarkTheme() {
        this.g();
        return Boolean.TRUE.equals(this.c.get("Theme.isDark"));
    }

    private static Set a() {
        String string = Misc.getOsShortName();
        String string2 = Misc.getOsLongName().toLowerCase();
        String string3 = System.getProperty("user.language", "en");
        return Misc.setOf((Object[])new String[]{string, string2, string3, string + "-" + string3, string2 + "-" + string3});
    }

    private static List b() {
        LinkedList<String> linkedList = new LinkedList<String>();
        Util.getTopicDirs("styles", Util.LocationPreference.PREFER_USER_DIR).stream().map(string -> new File((String)string)).forEach(file -> linkedList.add((String)file));
        linkedList.add(QFTEST_STYLES_RES_PACKAGE);
        if (SkyQfs.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "defineCssSearchPath()", 197).add("cssSearchPath", linkedList)).log();
        }
        return linkedList;
    }

    private static Map c() {
        HashMap<String, CssParserHelper.CssFunctionTextMapping> hashMap = new HashMap<String, CssParserHelper.CssFunctionTextMapping>();
        hashMap.put("suffixedIcon", (string, string2, linkedList) -> {
            String string3 = (String)linkedList.pollFirst();
            if (string3 == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            switch (string3) {
                case "qflib": {
                    stringBuilder.append("qflibIcon");
                    break;
                }
                default: {
                    linkedList.addFirst(string3);
                    stringBuilder.append("icon");
                }
            }
            stringBuilder.append("(");
            string3 = (String)linkedList.pollFirst();
            if (string3 == null) {
                return "";
            }
            Object object = ICON_SCALING_SUFFIX_PATTERN.matcher(string3);
            if (((Matcher)object).matches()) {
                stringBuilder.append("join(");
                stringBuilder.append("'").append(((Matcher)object).group(1));
                stringBuilder.append("', var(--propertySuffix)");
                if (!Misc.emptyOrNull((String)((Matcher)object).group(3)) || !Misc.emptyOrNull((String)((Matcher)object).group(2))) {
                    try {
                        int n2 = Options.cached_OPT_UI_MINIMUM_FONT_SIZE;
                        stringBuilder.append(n2 >= 14 ? ", '@1.25x'" : "");
                    }
                    catch (NullPointerException nullPointerException) {
                        if (SkyQfs.f.level >= 9) {
                            ((LevelAwareLogBuilder)f.lvlBuild(9, "defineCssTextMapper()", 243).add("ex", (Object)nullPointerException)).log();
                        }
                    }
                } else if (!Misc.emptyOrNull((String)((Matcher)object).group(4))) {
                    stringBuilder.append(", '").append(((Matcher)object).group(4)).append("'");
                }
                stringBuilder.append(")");
            }
            for (String string4 : linkedList) {
                stringBuilder.append(", ").append(string4);
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        });
        hashMap.put("relativeIcon", (string, string2, linkedList, string3) -> {
            String string4 = (String)linkedList.pollFirst();
            if (string4 == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("icon");
            stringBuilder.append("(join(\"file:\",");
            File file = Misc.emptyOrNull((String)string3) ? new File(".") : new File(string3).getParentFile();
            stringBuilder.append(Json.value((String)file.getAbsolutePath()) + ",");
            stringBuilder.append("\"/\",");
            stringBuilder.append(string4);
            stringBuilder.append("))");
            return stringBuilder.toString();
        });
        hashMap.put("join", (string2, string3, linkedList) -> "'" + linkedList.stream().map(string -> Json.parse((String)string).asString()).collect(Collectors.joining()) + "'");
        hashMap.put("suffixedString", (string, string2, linkedList) -> {
            String string3 = (String)linkedList.pollFirst();
            if (string3 == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            linkedList.addFirst(string3);
            stringBuilder.append("join(");
            stringBuilder.append(string3);
            stringBuilder.append(", var(--stringSuffix)");
            stringBuilder.append(")");
            return stringBuilder.toString();
        });
        hashMap.put("suffixedIconString", (string, string2, linkedList) -> {
            String string3 = (String)linkedList.pollFirst();
            if (string3 == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            switch (string3) {
                case "qflib": {
                    stringBuilder.append("qflibIcon");
                    break;
                }
                default: {
                    linkedList.addFirst(string3);
                    stringBuilder.append("icon");
                }
            }
            stringBuilder.append("(");
            string3 = (String)linkedList.pollFirst();
            if (string3 == null) {
                return "";
            }
            Object object = ICON_SCALING_SUFFIX_PATTERN.matcher(string3);
            if (((Matcher)object).matches()) {
                stringBuilder.append("join(");
                stringBuilder.append("'").append(((Matcher)object).group(1)).append("'");
                if (!Misc.emptyOrNull((String)((Matcher)object).group(3)) || !Misc.emptyOrNull((String)((Matcher)object).group(2))) {
                    try {
                        int n2 = Options.cached_OPT_UI_TERMINAL_FONT_SIZE;
                        stringBuilder.append(n2 >= 14 ? ", '@1.25x'" : "");
                    }
                    catch (NullPointerException nullPointerException) {
                        if (SkyQfs.f.level >= 9) {
                            ((LevelAwareLogBuilder)f.lvlBuild(9, "defineCssTextMapper()", 328).add("ex", (Object)nullPointerException)).log();
                        }
                    }
                } else if (!Misc.emptyOrNull((String)((Matcher)object).group(4))) {
                    stringBuilder.append(", '").append(((Matcher)object).group(4)).append("'");
                }
                stringBuilder.append(", var(--iconStringSuffix)");
                stringBuilder.append(")");
            }
            for (String string4 : linkedList) {
                stringBuilder.append(", ").append(string4);
            }
            stringBuilder.append(", 'svg'");
            stringBuilder.append(")");
            return stringBuilder.toString();
        });
        hashMap.put("absoluteIconPath", (string, string2, linkedList) -> {
            String string3 = (String)linkedList.pollFirst();
            if (string3 == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            linkedList.addFirst(string3);
            stringBuilder.append("absoluteIconPath(");
            stringBuilder.append(string3);
            stringBuilder.append(")");
            return stringBuilder.toString();
        });
        hashMap.put("fontsize", (string, string2, linkedList) -> {
            double d2;
            Float f2;
            StringBuilder stringBuilder;
            block2: {
                stringBuilder = new StringBuilder();
                f2 = (Float)Globals.getGlobalValue("FontSize", Float.valueOf(14.0f));
                d2 = 1.0;
                try {
                    d2 = Float.parseFloat((String)linkedList.get(0));
                }
                catch (Exception exception) {
                    if (SkyQfs.f.level < 3) break block2;
                    ((LevelAwareLogBuilder)f.lvlBuild(3, "defineCssTextMapper()", 372).add("ex", (Object)exception)).log();
                }
            }
            stringBuilder.append((double)Math.round(d2 * (double)f2.floatValue() * 100.0) / 100.0);
            stringBuilder.append("px");
            return stringBuilder.toString();
        });
        return hashMap;
    }

    private static Map d() {
        Map map = Borders.getBorderFactories();
        map.putAll(Icons.getIconFactories());
        MapResourceBundle mapResourceBundle = Globals.getResources();
        map.put("icon", SkyQfs.a(mapResourceBundle));
        MapResourceBundle mapResourceBundle2 = new MapResourceBundle();
        mapResourceBundle2.fetchProperties("/de/qfs/lib/resources/properties/qflib", OptionEdit.class);
        map.put("qflibIcon", SkyQfs.a(mapResourceBundle2));
        map.put("absoluteIconPath", SkyQfs.f());
        map.put("long", (string, linkedList) -> ((Number)linkedList.get(0)).longValue());
        map.put("insets", (string, linkedList) -> new Insets((Integer)linkedList.get(0), (Integer)linkedList.get(1), (Integer)linkedList.get(2), (Integer)linkedList.get(3)));
        map.put("rgba", (string, linkedList) -> new Color((Integer)linkedList.get(0), (Integer)linkedList.get(1), (Integer)linkedList.get(2), (Integer)linkedList.get(3)));
        return map;
    }

    private static Icon e() {
        return UIManager.getIcon("OptionPane.errorIcon");
    }

    private static CssParserHelper.CssFunctionObjectMapping a(MapResourceBundle mapResourceBundle) {
        CssParserHelper.CssFunctionObjectMapping cssFunctionObjectMapping = (string, linkedList) -> {
            Object e2 = linkedList.get(0);
            try {
                Icon icon = null;
                if (linkedList.size() >= 2 && "svg".equals(linkedList.get(linkedList.size() - 1))) {
                    if (((String)e2).contains("@1.25x")) {
                        icon = mapResourceBundle.getIcon(((String)e2).replace("@1.25x", "_scaled") + ".svg", null);
                        if (icon == null) {
                            icon = mapResourceBundle.getIcon(((String)e2).replace("@1.25x", "") + ".svg", SkyQfs.getDefaultIcon());
                        }
                    } else if (((String)e2).contains("@0.875x")) {
                        double d2 = 0.875;
                        icon = mapResourceBundle.getIcon(((String)e2).replace("@0.875x", "") + ".svg", SkyQfs.getDefaultIcon());
                        icon = ((SVGIcon)icon).getScaledIcon(d2, d2);
                    } else {
                        icon = mapResourceBundle.getIcon((String)e2 + ".svg", SkyQfs.getDefaultIcon());
                    }
                } else {
                    icon = mapResourceBundle.getIcon((String)e2, SkyQfs.getDefaultIcon());
                }
                if ((linkedList.size() == 3 || linkedList.size() == 4) && icon != null && linkedList.get(1) instanceof Number && linkedList.get(2) instanceof Number) {
                    icon = ((SVGIcon)icon).getScaledIcon(((Number)linkedList.get(1)).doubleValue(), ((Number)linkedList.get(2)).doubleValue());
                }
                return icon;
            }
            catch (Exception exception) {
                if (SkyQfs.f.level >= 3) {
                    ((LevelAwareLogBuilder)f.lvlBuild(3, "getIconMappingFunction(MapResourceBundle)", 454).add("Could not icon: " + e2, (Object)exception)).log();
                }
                return SkyQfs.getDefaultIcon();
            }
        };
        return cssFunctionObjectMapping;
    }

    private static CssParserHelper.CssFunctionObjectMapping f() {
        CssParserHelper.CssFunctionObjectMapping cssFunctionObjectMapping = (string, linkedList) -> {
            SVGIcon sVGIcon;
            try {
                sVGIcon = new SVGIcon(new URL("file:/" + linkedList.get(0)));
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
            return sVGIcon;
        };
        return cssFunctionObjectMapping;
    }

    public void updateUI() {
        if (SkyQfs.f.level >= 7) {
            f.lvlBuild(7, "updateUI()", 488).log();
        }
        this.g();
        if (this.c != null) {
            this.c.entrySet().stream().forEach(entry -> {
                Object k2 = entry.getKey();
                Object v2 = entry.getValue();
                UIManager.put(k2, v2);
            });
            UIManager.put("css:factory", string -> this.getCss((String)string));
        }
    }

    private void g() {
        if (this.c == null) {
            this.updateStyleCacheFromCss();
        }
    }

    public void updateStyleCacheFromCss() {
        String string = this.getCssFileName();
        this.b = SkyQfs.a(string);
        this.d.clear();
        if (this.b != null) {
            HashMap<Object, Object> hashMap;
            block3: {
                hashMap = new HashMap<Object, Object>();
                try {
                    CssParser.instance().applyCssRules(this.b, hashMap, SkyQfs.getCssObjectMapper());
                }
                catch (Exception exception) {
                    if (SkyQfs.f.level < 1) break block3;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(1, "updateStyleCacheFromCss()", 528).add("Could not apply defaults from ")).add(string)).log();
                }
            }
            hashMap.replaceAll((object, object2) -> {
                if (object2 instanceof Color) {
                    return new ColorUIResource((Color)object2);
                }
                if (object2 instanceof Insets) {
                    return new InsetsUIResource(((Insets)object2).top, ((Insets)object2).left, ((Insets)object2).bottom, ((Insets)object2).right);
                }
                return object2;
            });
            this.c = hashMap;
        }
    }

    private static HashMap a(String string) {
        try {
            return CssParser.instance().readCssRules(string, SkyQfs.getCssSearchPath(), SkyQfs.getCssMedias(), SkyQfs.getCssTextMapper());
        }
        catch (Exception exception) {
            if (SkyQfs.f.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(1, "readCss(String)", 554).add("Could not read defaults from ")).add(string)).add("ex", (Object)exception)).log();
            }
            return null;
        }
    }

    private ColorUIResource a(String string, ColorUIResource colorUIResource) {
        return UIManager.getDefaults().getOrDefault(string, colorUIResource);
    }

    protected ColorUIResource getPrimary1() {
        return this.a("MetalTheme.primary1", super.getPrimary1());
    }

    protected ColorUIResource getPrimary2() {
        return this.a("MetalTheme.primary2", super.getPrimary2());
    }

    protected ColorUIResource getPrimary3() {
        return this.a("MetalTheme.primary3", super.getPrimary3());
    }

    protected ColorUIResource getSecondary1() {
        return this.a("MetalTheme.secondary1", super.getSecondary1());
    }

    protected ColorUIResource getSecondary2() {
        return this.a("MetalTheme.secondary2", super.getSecondary2());
    }

    protected ColorUIResource getSecondary3() {
        return this.a("MetalTheme.secondary3", super.getSecondary3());
    }

    protected ColorUIResource getWhite() {
        return this.a("MetalTheme.white", super.getWhite());
    }

    protected ColorUIResource getBlack() {
        return this.a("MetalTheme.black", super.getBlack());
    }

    public ColorUIResource getFocusColor() {
        return this.a("MetalTheme.focusColor", super.getFocusColor());
    }

    public ColorUIResource getDesktopColor() {
        return this.a("MetalTheme.desktopColor", super.getDesktopColor());
    }

    public ColorUIResource getControl() {
        return this.a("MetalTheme.control", super.getControl());
    }

    public ColorUIResource getControlShadow() {
        return this.a("MetalTheme.controlShadow", super.getControlShadow());
    }

    public ColorUIResource getControlDarkShadow() {
        return this.a("MetalTheme.controlDarkShadow", super.getControlDarkShadow());
    }

    public ColorUIResource getControlInfo() {
        return this.a("MetalTheme.controlInfo", super.getControlInfo());
    }

    public ColorUIResource getControlHighlight() {
        return this.a("MetalTheme.controlHighlight", super.getControlHighlight());
    }

    public ColorUIResource getControlDisabled() {
        return this.a("MetalTheme.controlDisabled", super.getControlDisabled());
    }

    public ColorUIResource getPrimaryControl() {
        return this.a("MetalTheme.primaryControl", super.getPrimaryControl());
    }

    public ColorUIResource getPrimaryControlShadow() {
        return this.a("MetalTheme.primaryControlShadow", super.getPrimaryControlShadow());
    }

    public ColorUIResource getPrimaryControlDarkShadow() {
        return this.a("MetalTheme.primaryControlDarkShadow", super.getPrimaryControlDarkShadow());
    }

    public ColorUIResource getPrimaryControlInfo() {
        return this.a("MetalTheme.primaryControlInfo", super.getPrimaryControlInfo());
    }

    public ColorUIResource getPrimaryControlHighlight() {
        return this.a("MetalTheme.primaryControlHighlight", super.getPrimaryControlHighlight());
    }

    public ColorUIResource getSystemTextColor() {
        return this.a("MetalTheme.systemTextColor", super.getSystemTextColor());
    }

    public ColorUIResource getControlTextColor() {
        return this.a("MetalTheme.controlTextColor", super.getControlTextColor());
    }

    public ColorUIResource getInactiveControlTextColor() {
        return this.a("MetalTheme.inactiveControlTextColor", super.getInactiveControlTextColor());
    }

    public ColorUIResource getInactiveSystemTextColor() {
        return this.a("MetalTheme.inactiveSystemTextColor", super.getInactiveSystemTextColor());
    }

    public ColorUIResource getUserTextColor() {
        return this.a("MetalTheme.userTextColor", super.getUserTextColor());
    }

    public ColorUIResource getTextHighlightColor() {
        return this.a("MetalTheme.textHighlightColor", super.getTextHighlightColor());
    }

    public ColorUIResource getHighlightedTextColor() {
        return this.a("MetalTheme.highlightedTextColor", super.getHighlightedTextColor());
    }

    public ColorUIResource getWindowBackground() {
        return this.a("MetalTheme.windowBackground", super.getWindowBackground());
    }

    public ColorUIResource getWindowTitleBackground() {
        return this.a("MetalTheme.windowTitleBackground", super.getWindowTitleBackground());
    }

    public ColorUIResource getWindowTitleForeground() {
        return this.a("MetalTheme.windowTitleForeground", super.getWindowTitleForeground());
    }

    public ColorUIResource getWindowTitleInactiveBackground() {
        return this.a("MetalTheme.windowTitleInactiveBackground", super.getWindowTitleInactiveBackground());
    }

    public ColorUIResource getWindowTitleInactiveForeground() {
        return this.a("MetalTheme.windowTitleInactiveForeground", super.getWindowTitleInactiveForeground());
    }

    public ColorUIResource getMenuBackground() {
        return this.a("MetalTheme.menuBackground", super.getMenuBackground());
    }

    public ColorUIResource getMenuForeground() {
        return this.a("MetalTheme.menuForeground", super.getMenuForeground());
    }

    public ColorUIResource getMenuSelectedBackground() {
        return this.a("MetalTheme.menuSelectedBackground", super.getMenuSelectedBackground());
    }

    public ColorUIResource getMenuSelectedForeground() {
        return this.a("MetalTheme.menuSelectedForeground", super.getMenuSelectedForeground());
    }

    public ColorUIResource getMenuDisabledForeground() {
        return this.a("MetalTheme.menuDisabledForeground", super.getMenuDisabledForeground());
    }

    public ColorUIResource getSeparatorBackground() {
        return this.a("MetalTheme.separatorBackground", super.getSeparatorBackground());
    }

    public ColorUIResource getSeparatorForeground() {
        return this.a("MetalTheme.separatorForeground", super.getSeparatorForeground());
    }

    public ColorUIResource getAcceleratorForeground() {
        return this.a("MetalTheme.acceleratorForeground", super.getAcceleratorForeground());
    }

    public ColorUIResource getAcceleratorSelectedForeground() {
        return this.a("MetalTheme.acceleratorSelectedForeground", super.getAcceleratorSelectedForeground());
    }

    public ColorUIResource getTitleTextColor() {
        return this.a("PlasticTheme.titleTextColor", super.getTitleTextColor());
    }

    public ColorUIResource getMenuItemBackground() {
        return this.a("PlasticTheme.menuItemBackground", super.getMenuItemBackground());
    }

    public ColorUIResource getMenuItemSelectedBackground() {
        return this.a("PlasticTheme.menuItemSelectedBackground", super.getMenuItemSelectedBackground());
    }

    public ColorUIResource getMenuItemSelectedForeground() {
        return this.a("PlasticTheme.menuItemSelectedForeground", super.getMenuItemSelectedForeground());
    }

    public ColorUIResource getSimpleInternalFrameForeground() {
        return this.a("PlasticTheme.simpleInternalFrameForeground", super.getSimpleInternalFrameForeground());
    }

    public ColorUIResource getSimpleInternalFrameBackground() {
        return this.a("PlasticTheme.simpleInternalFrameBackground", super.getSimpleInternalFrameBackground());
    }

    public ColorUIResource getToggleButtonCheckColor() {
        return this.a("PlasticTheme.toggleButtonCheckColor", super.getToggleButtonCheckColor());
    }

    public void addCustomEntriesToTable(UIDefaults uIDefaults) {
        super.addCustomEntriesToTable(uIDefaults);
        Object[] objectArray = new Object[]{"ScrollBar.maxBumpsWidth", 30, "RootPane.defaultButtonWindowKeyBindings", this.h()};
        uIDefaults.putDefaults(objectArray);
    }

    private Object[] h() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("ENTER");
        arrayList.add("press");
        arrayList.add("released ENTER");
        arrayList.add("release");
        arrayList.add("ENTER");
        arrayList.add("press");
        if (this.e != null) {
            arrayList.add(KeyStroke.getKeyStroke(this.e.getKeyCode(), this.e.getModifiers(), false));
            arrayList.add("press");
            arrayList.add(KeyStroke.getKeyStroke(this.e.getKeyCode(), this.e.getModifiers(), true));
            arrayList.add("release");
        }
        return arrayList.toArray();
    }

    public String getCss(String string) {
        String string2 = string == null ? "" : string;
        String string3 = (String)this.d.get(string2);
        if (string3 == null) {
            this.g();
            string3 = CssParser.instance().getFullStylesheet(this.b.entrySet().stream().filter(entry -> {
                String string2 = (String)entry.getKey();
                return string == null || string2.startsWith(string) || string2.startsWith("body" + string);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), true);
            this.d.put(string2, string3);
        }
        return string3;
    }

    public static void main(String[] stringArray) {
        SkyQfs skyQfs = stringArray.length > 0 ? new SkyQfs(stringArray[0]) : new SkyQfs("qfs-user-dark.css");
        skyQfs.g();
        System.out.println(CssParser.instance().getFullStylesheet(skyQfs.b, false));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SkyQfs)) {
            return false;
        }
        SkyQfs skyQfs = (SkyQfs)((Object)object);
        if (!skyQfs.a((Object)this)) {
            return false;
        }
        String string = this.getCssFileName();
        String string2 = skyQfs.getCssFileName();
        return !(string == null ? string2 != null : !string.equals(string2));
    }

    protected boolean a(Object object) {
        return object instanceof SkyQfs;
    }

    public int hashCode() {
        int n2 = 1;
        String string = this.getCssFileName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        return n2;
    }

    public String getCssFileName() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getCssMedias() {
        Object object = g.get();
        if (object == null) {
            AtomicReference atomicReference = g;
            synchronized (atomicReference) {
                object = g.get();
                if (object == null) {
                    Set set = SkyQfs.a();
                    object = set == null ? g : set;
                    g.set(object);
                }
            }
        }
        return object == g ? null : object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getCssSearchPath() {
        Object object = h.get();
        if (object == null) {
            AtomicReference atomicReference = h;
            synchronized (atomicReference) {
                object = h.get();
                if (object == null) {
                    List list = SkyQfs.b();
                    object = list == null ? h : list;
                    h.set(object);
                }
            }
        }
        return object == h ? null : object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getCssTextMapper() {
        Object object = i.get();
        if (object == null) {
            AtomicReference atomicReference = i;
            synchronized (atomicReference) {
                object = i.get();
                if (object == null) {
                    Map map = SkyQfs.c();
                    object = map == null ? i : map;
                    i.set(object);
                }
            }
        }
        return object == i ? null : object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getCssObjectMapper() {
        Object object = j.get();
        if (object == null) {
            AtomicReference atomicReference = j;
            synchronized (atomicReference) {
                object = j.get();
                if (object == null) {
                    Map map = SkyQfs.d();
                    object = map == null ? j : map;
                    j.set(object);
                }
            }
        }
        return object == j ? null : object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Icon getDefaultIcon() {
        Object object = k.get();
        if (object == null) {
            AtomicReference atomicReference = k;
            synchronized (atomicReference) {
                object = k.get();
                if (object == null) {
                    Icon icon = SkyQfs.e();
                    object = icon == null ? k : icon;
                    k.set(object);
                }
            }
        }
        return object == k ? null : object;
    }

    @Nullable
    public KeyStroke getDefaultButtonKeyStroke() {
        return this.e;
    }

    public SkyQfs setDefaultButtonKeyStroke(@Nullable KeyStroke keyStroke) {
        this.e = keyStroke;
        return this;
    }
}

