/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.variables;

import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.variables.VariableDataHelperRegistry;
import de.qfs.apps.qftest.shared.variables.VariableDataView;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class VariableData
implements Serializable {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.shared.variables.VariableData");
    public static long SERIALIZATION_LIMIT = 0x1900000L;
    public static final String DECRYPTED_PLACEHOLDER = "***";
    protected static final String OBJECT_NULL_DESCRIPTION = "(Object null)";
    public static final VariableData UNDEFINED = VariableData.from("UNDEFINED");
    static final long serialVersionUID = 3324713158058795674L;
    @Nullable
    Object object;
    @Nullable
    UUID objectUUID;
    @Nullable
    String objectAsString;
    @Nullable
    String description;
    @Nullable
    String descriptionPrefix;
    boolean isSerializable;
    boolean decryptedContent;
    Boolean autoExpandable;
    @Nullable
    WeakReference dataView;
    long dataViewRegistryAge;

    private VariableData(@Nullable Object object, @Nullable String string, @Nullable String string2) {
        this.setDefaultFieldValues();
        this.object = object;
        this.objectUUID = VariableData.createObjectUUID(object);
        this.objectAsString = string;
        this.description = string2;
    }

    private void setDefaultFieldValues() {
        this.isSerializable = true;
        this.decryptedContent = false;
        this.autoExpandable = null;
        this.dataViewRegistryAge = 0L;
    }

    public String toString() {
        String string;
        if (this.objectAsString != null) {
            return this.objectAsString;
        }
        if (this.object instanceof String) {
            return (String)this.object;
        }
        VariableDataView variableDataView = this.getDataView();
        if (variableDataView != null && (string = variableDataView.getToString(this)) != null) {
            return string;
        }
        if (this.object == null) {
            return "";
        }
        return VariableData.saveToString(this.object);
    }

    private boolean stringMightContainVariables() {
        String string = this.toString();
        return string.contains("$(") || string.contains("${") || string.contains("$[") || string.contains("$_(") || string.contains("$_{") || string.contains("$_[") || string.contains("$!(") || string.contains("$!{") || string.contains("$![");
    }

    public String stringify() {
        if (this.decryptedContent) {
            StringBuilder stringBuilder;
            block4: {
                stringBuilder = new StringBuilder("${decrypt:");
                String string = Options.cached_OPT_PLAY_PASSWORD_SALT;
                try {
                    stringBuilder.append(Util.encryptPassword(this.defaultStringify(), string));
                }
                catch (TestException testException) {
                    if (VariableData.logger.level >= 3) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "stringify()", 159).add("Could not encrypt value: ")).add((Object)testException)).log();
                    }
                    if (!this.decryptedContent) break block4;
                    return DECRYPTED_PLACEHOLDER;
                }
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
        return this.defaultStringify();
    }

    protected String defaultStringify() {
        String string;
        VariableDataView variableDataView = this.getDataView();
        if (variableDataView != null && (string = variableDataView.stringify(this)) != null) {
            return string;
        }
        return this.toString();
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    private String getDescription(@Nullable VariableDataView variableDataView) {
        String string;
        VariableDataView variableDataView2;
        if (this.decryptedContent && this.description != null) {
            return DECRYPTED_PLACEHOLDER;
        }
        String string2 = Misc.emptyOrNull((String)this.descriptionPrefix) ? "" : "[" + this.descriptionPrefix + "] ";
        if (this.description != null) {
            return string2 + this.description;
        }
        VariableDataView variableDataView3 = variableDataView2 = variableDataView == null ? this.getDataView() : variableDataView;
        if (variableDataView2 != null && (string = variableDataView2.getDescription(this)) != null) {
            return string2 + string;
        }
        if (this.decryptedContent) {
            return DECRYPTED_PLACEHOLDER;
        }
        if (this.object == null) {
            return string2 + OBJECT_NULL_DESCRIPTION;
        }
        if (this.object instanceof String) {
            return string2 + this;
        }
        return "(" + this.object.getClass().getSimpleName() + ") " + this;
    }

    VariableDataView getDataView() {
        long l2 = VariableDataHelperRegistry.instance.age.get();
        if (this.dataViewRegistryAge < l2) {
            this.dataViewRegistryAge = l2;
            this.dataView = new WeakReference<VariableDataView>(VariableDataHelperRegistry.instance.getView(this.object));
        }
        return this.dataView == null ? null : (VariableDataView)this.dataView.get();
    }

    public boolean isAutoExpandable() {
        if (this.autoExpandable != null) {
            return this.autoExpandable;
        }
        return this.object instanceof String;
    }

    public static VariableData from(@Nullable Object object) {
        if (object instanceof VariableData) {
            return (VariableData)object;
        }
        return VariableData.from(object, null, null);
    }

    public static VariableData from(@Nullable Object object, @Nullable String string) {
        return VariableData.from(object, string, null);
    }

    public static VariableData from(@Nullable Object object, @Nullable String string, @Nullable String string2) {
        if (object instanceof VariableData) {
            VariableData variableData = (VariableData)object;
            if (string == null && string2 == null) {
                return variableData;
            }
            return new VariableData(variableData.object, string == null ? variableData.objectAsString : string, string2 == null ? variableData.description : string2);
        }
        return new VariableData(object, string, string2);
    }

    public static VariableData fromDecrypted(String string) {
        VariableData variableData = VariableData.from(string);
        variableData.decryptedContent = true;
        return variableData;
    }

    public static VariableData fromDecrypted(VariableData variableData) {
        VariableData variableData2 = VariableData.from(variableData.getObject());
        VariableData.copyFlags(Misc.listOf((Object[])new VariableData[]{variableData}), variableData2);
        variableData2.decryptedContent = true;
        return variableData2;
    }

    public static VariableData fromNotAutoExpandable(String string) {
        VariableData variableData = VariableData.from(string);
        variableData.autoExpandable = false;
        return variableData;
    }

    public static VariableData fromExpanded(@Nullable Object object, @Nullable List list) {
        VariableData variableData = VariableData.from(object);
        VariableData.copyFlags(list, variableData);
        return variableData;
    }

    private static void copyFlags(@Nullable List list, VariableData variableData) {
        boolean bl = variableData.object instanceof String;
        if (list != null) {
            for (VariableData variableData2 : list) {
                if (variableData2 == null) continue;
                if (!bl && !variableData2.isSerializable) {
                    variableData.isSerializable = false;
                }
                if (variableData2.decryptedContent) {
                    variableData.decryptedContent = true;
                }
                if (Boolean.FALSE.equals(variableData2.autoExpandable)) {
                    variableData.autoExpandable = false;
                    continue;
                }
                if (!bl || variableData2.object instanceof String || variableData2.isAutoExpandable() || !variableData2.stringMightContainVariables()) continue;
                variableData.autoExpandable = false;
            }
        }
    }

    @Nullable
    public static VariableData nullOrFrom(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        return VariableData.from(object, null, null);
    }

    public static VariableData fromInlineScriptResult(@Nullable Object object, @Nullable String string) {
        if (object instanceof VariableData && ((VariableData)object).objectAsString != null) {
            return (VariableData)object;
        }
        if (string != null) {
            if (object == string) {
                string = null;
            }
        } else {
            string = object != null ? object.toString() : "";
        }
        return VariableData.from(object, string);
    }

    public static VariableData fromStringification(@Nullable String string) {
        Object object;
        boolean bl;
        block3: {
            bl = false;
            if (string != null && string.startsWith("${decrypt:") && string.endsWith("}")) {
                object = Options.cached_OPT_PLAY_PASSWORD_SALT;
                try {
                    string = Util.decryptPassword(string.substring(10, string.length() - 1), (String)object);
                    bl = true;
                }
                catch (TestException testException) {
                    if (VariableData.logger.level < 3) break block3;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "fromStringification(String)", 371).add("Could not decrypt data: ")).add((Object)testException)).log();
                }
            }
        }
        object = VariableData.defaultFromStringification(string);
        ((VariableData)object).decryptedContent = bl;
        return object;
    }

    protected static VariableData defaultFromStringification(@Nullable String string) {
        List list = VariableDataHelperRegistry.instance.getAllViews();
        if (list != null) {
            for (VariableDataView variableDataView : list) {
                VariableData variableData = variableDataView.fromStringification(string);
                if (variableData == null) continue;
                return variableData;
            }
        }
        return VariableData.from(string, null, null);
    }

    private static String saveToString(Object object) {
        try {
            return String.valueOf(object);
        }
        catch (Throwable throwable) {
            assert (object != null);
            String string = object.getClass() + "@" + Objects.hashCode(object);
            if (VariableData.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "saveToString(Object)", 403).add("Exception during stringify of object ")).add(string)).add("ex", (Object)throwable)).log();
            }
            return string;
        }
    }

    public static String descriptionOf(@Nullable Object object) {
        return VariableData.descriptionOf(object, null);
    }

    public static String descriptionOf(@Nullable Object object, @Nullable VariableDataView variableDataView) {
        if (object == null) {
            return "";
        }
        return VariableData.from(object).getDescription(variableDataView);
    }

    @Nullable
    private static UUID createObjectUUID(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return null;
        }
        if (object instanceof Boolean) {
            return null;
        }
        if (object instanceof Number) {
            return null;
        }
        if (object instanceof Pattern) {
            return null;
        }
        return UUID.randomUUID();
    }

    public static boolean emptyOrNull(VariableData variableData) {
        return variableData == null || Misc.emptyOrNull((Object)variableData.object) || Misc.emptyOrNull((String)variableData.toString());
    }

    public static boolean trimmedEmptyOrNull(VariableData variableData) {
        return variableData == null || Misc.emptyOrNull((Object)variableData.object) || Misc.emptyOrNull((String)variableData.toString().trim());
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        block30: {
            Object object2;
            this.setDefaultFieldValues();
            this.objectUUID = (UUID)objectInputStream.readObject();
            this.decryptedContent = objectInputStream.readBoolean();
            this.autoExpandable = (Boolean)objectInputStream.readObject();
            this.description = (String)objectInputStream.readObject();
            if (this.objectUUID != null) {
                this.descriptionPrefix = (String)objectInputStream.readObject();
            }
            this.objectAsString = (String)objectInputStream.readObject();
            if (this.objectAsString == null) {
                this.object = objectInputStream.readObject();
            }
            if ((object2 = objectInputStream.readObject()) instanceof byte[]) {
                try {
                    object = new ByteArrayInputStream((byte[])object2);
                    Throwable throwable = null;
                    try (ObjectInputStream objectInputStream2 = new ObjectInputStream((InputStream)object);){
                        this.object = objectInputStream2.readObject();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    ((ByteArrayInputStream)object).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((ByteArrayInputStream)object).close();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (VariableData.logger.level < 5) break block30;
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "readObject(ObjectInputStream)", 481).add("Error recreating the VariableData: ", (Object)throwable)).log();
                }
            }
        }
        if ((object = VariableDataHelperRegistry.instance().objectCache.getObject(this.objectUUID)) != null) {
            this.object = object;
            this.descriptionPrefix = null;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        block33: {
            Object object;
            objectOutputStream.writeObject(this.objectUUID);
            objectOutputStream.writeBoolean(this.decryptedContent);
            objectOutputStream.writeObject(this.autoExpandable);
            objectOutputStream.writeObject(this.description);
            if (this.objectUUID != null) {
                assert (this.object != null);
                object = VariableDataHelperRegistry.instance().objectCache;
                boolean bl = object.putObject(this.objectUUID, this.object);
                if (bl) {
                    objectOutputStream.writeObject(this.object.getClass().getSimpleName() + " in " + object.getReference());
                } else {
                    objectOutputStream.writeObject(this.descriptionPrefix);
                }
            }
            objectOutputStream.writeObject(this.objectAsString);
            if (this.objectAsString == null) {
                objectOutputStream.writeObject(this.toString());
            }
            try {
                if (!this.isSerializable || this.objectAsString == null && this.object instanceof String) {
                    objectOutputStream.writeObject(new a());
                    break block33;
                }
                object = new BoundedByteArrayOutputStream(SERIALIZATION_LIMIT);
                Throwable throwable = null;
                try {
                    try (ObjectOutputStream objectOutputStream2 = new ObjectOutputStream((OutputStream)object);){
                        objectOutputStream2.writeObject(this.object);
                    }
                    objectOutputStream.writeObject(((ByteArrayOutputStream)object).toByteArray());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((ByteArrayOutputStream)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((ByteArrayOutputStream)object).close();
                        }
                    }
                }
            }
            catch (BoundedByteArrayOutputStream.ByteBufferLimitException | NotSerializableException exception) {
                if (VariableData.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "writeObject(ObjectOutputStream)", 534).add("Could not serialize object: ")).add((Object)exception)).log();
                }
                objectOutputStream.writeObject(new a());
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VariableData)) {
            return false;
        }
        VariableData variableData = (VariableData)object;
        if (!variableData.canEqual(this)) {
            return false;
        }
        Object object2 = this.object;
        Object object3 = variableData.object;
        return !(object2 == null ? object3 != null : !object2.equals(object3));
    }

    protected boolean canEqual(Object object) {
        return object instanceof VariableData;
    }

    public int hashCode() {
        int n2 = 1;
        Object object = this.object;
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Nullable
    public Object getObject() {
        return this.object;
    }

    public boolean isSerializable() {
        return this.isSerializable;
    }

    public VariableData setSerializable(boolean bl) {
        this.isSerializable = bl;
        return this;
    }

    public boolean isDecryptedContent() {
        return this.decryptedContent;
    }

    public VariableData setAutoExpandable(Boolean bl) {
        this.autoExpandable = bl;
        return this;
    }

    static class BoundedByteArrayOutputStream
    extends ByteArrayOutputStream {
        final long a;
        long b;

        @Override
        public void write(int n2) {
            if (this.b >= this.a) {
                throw new ByteBufferLimitException(this.b, this.a);
            }
            super.write(n2);
            ++this.b;
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) {
            if (this.b + (long)n3 > this.a) {
                throw new ByteBufferLimitException(this.b + (long)n3, this.a);
            }
            super.write(byArray, n2, n3);
            this.b += (long)n3;
        }

        public BoundedByteArrayOutputStream(long l2) {
            this.a = l2;
        }

        static class ByteBufferLimitException
        extends RuntimeException {
            public ByteBufferLimitException(long l2, long l3) {
                super(l2 + " > " + l3);
            }
        }
    }

    private static class a
    implements Serializable {
    }
}

