/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.variables;

import de.qfs.apps.qftest.shared.extensions.Registry;
import de.qfs.apps.qftest.shared.variables.VariableDataObjectCache;
import de.qfs.apps.qftest.shared.variables.VariableDataView;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;

public class VariableDataHelperRegistry {
    private final Lock $lock = new ReentrantLock();
    static VariableDataHelperRegistry instance = new VariableDataHelperRegistry();
    Registry viewRegistry = new Registry("VariableDataViews");
    protected AtomicLong age = new AtomicLong();
    protected volatile VariableDataObjectCache objectCache = VariableDataObjectCache.NOOP;

    protected VariableDataHelperRegistry() {
    }

    public static VariableDataHelperRegistry instance() {
        return instance;
    }

    public void registerView(Class clazz, VariableDataView variableDataView) {
        this.$lock.lock();
        try {
            this.viewRegistry.registerHelper(clazz == null ? "" : clazz.getName(), (Object)variableDataView);
            this.age.incrementAndGet();
        }
        finally {
            this.$lock.unlock();
        }
    }

    public void unregisterView(Class clazz, VariableDataView variableDataView) {
        this.$lock.lock();
        try {
            this.viewRegistry.unregisterHelper(clazz == null ? "" : clazz.getName(), (Object)variableDataView);
            this.age.incrementAndGet();
        }
        finally {
            this.$lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VariableDataView getView(Object object) {
        this.$lock.lock();
        try {
            List list = object == null ? this.viewRegistry.getClassHelpers("") : this.viewRegistry.getClassHelpers(object.getClass());
            if (list == null || list.isEmpty()) {
                VariableDataView variableDataView = null;
                return variableDataView;
            }
            VariableDataView variableDataView = (VariableDataView)list.iterator().next();
            return variableDataView;
        }
        finally {
            this.$lock.unlock();
        }
    }

    public List getAllViews() {
        return this.viewRegistry.getAllHelpers(false);
    }

    public void setObjectCache(@Nullable VariableDataObjectCache variableDataObjectCache) {
        this.objectCache = variableDataObjectCache == null ? VariableDataObjectCache.NOOP : variableDataObjectCache;
    }

    public VariableDataObjectCache getObjectCache() {
        return this.objectCache;
    }
}

