/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.variables;

import de.qfs.apps.qftest.shared.variables.VariableData;
import de.qfs.apps.qftest.shared.variables.VariableMapBackedObjectMap;
import de.qfs.apps.qftest.shared.variables.VariableMapBackedProperties;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class VariableMap
extends ConcurrentHashMap
implements Cloneable {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.shared.variables.VariableMap");
    static final long serialVersionUID = 1736122483133009836L;

    public Properties toProperties() {
        return new VariableMapBackedProperties(this);
    }

    public Properties toClonedProperties() {
        Properties properties = new Properties();
        for (Map.Entry entry : this.entrySet()) {
            VariableData variableData = (VariableData)entry.getValue();
            if (variableData == null) continue;
            properties.put(entry.getKey(), variableData.toString());
        }
        return properties;
    }

    public VariableMapBackedObjectMap toObjectMap() {
        return new VariableMapBackedObjectMap(this);
    }

    public String[][] toStringArrays() {
        String[][] stringArray = new String[this.size()][2];
        int n2 = 0;
        for (Map.Entry entry : this.entrySet()) {
            stringArray[n2][0] = (String)entry.getKey();
            stringArray[n2][1] = Misc.toStringOrNull(entry.getValue());
            ++n2;
        }
        return stringArray;
    }

    public String[][] toDescriptionArrays() {
        String[][] stringArray = new String[this.size()][2];
        int n2 = 0;
        for (Map.Entry entry : this.entrySet()) {
            stringArray[n2][0] = (String)entry.getKey();
            stringArray[n2][1] = VariableData.descriptionOf(entry.getValue());
            ++n2;
        }
        return stringArray;
    }

    public Object[][] toObjectArraysWithVariableData() {
        Object[][] objectArray = new Object[this.size()][2];
        int n2 = 0;
        for (Map.Entry entry : this.entrySet()) {
            objectArray[n2][0] = entry.getKey();
            objectArray[n2][1] = entry.getValue();
            ++n2;
        }
        return objectArray;
    }

    public List toListWithVariableData() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.size() * 2);
        boolean bl = false;
        for (Map.Entry entry : this.entrySet()) {
            arrayList.add(entry.getKey());
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    public static VariableMap fromStringArrays(String[][] stringArray, String string) {
        VariableMap variableMap = new VariableMap();
        variableMap.putAllStrings(stringArray, string);
        return variableMap;
    }

    public static VariableMap fromObjectArrays(Object[][] objectArray, Object object) {
        VariableMap variableMap = new VariableMap();
        variableMap.putAllObjects(objectArray, object);
        return variableMap;
    }

    public static VariableMap fromCollection(Collection collection, Object object) {
        VariableMap variableMap = new VariableMap();
        variableMap.putAllFromCollection(collection, object);
        return variableMap;
    }

    public static VariableMap fromMap(Map map, Object object) {
        if (map instanceof VariableMap) {
            return (VariableMap)map;
        }
        if (map instanceof VariableMapBackedProperties) {
            return ((VariableMapBackedProperties)map).variableMap;
        }
        if (map instanceof VariableMapBackedObjectMap) {
            return ((VariableMapBackedObjectMap)map).variableMap;
        }
        VariableMap variableMap = new VariableMap();
        variableMap.putAllFromMap(map, object);
        return variableMap;
    }

    @Override
    public VariableMap clone() {
        VariableMap variableMap = new VariableMap();
        variableMap.entrySet().addAll(this.entrySet());
        return variableMap;
    }

    @Override
    public VariableData put(String string, VariableData variableData) {
        if (variableData == null) {
            throw new IllegalArgumentException("value is marked non-null but is null");
        }
        return super.put(VariableMap.trimKey(string), variableData);
    }

    @Override
    public VariableData remove(Object object) {
        return (VariableData)super.remove(VariableMap.trimKey(object));
    }

    @Override
    public boolean remove(Object object, Object object2) {
        return super.remove(VariableMap.trimKey(object), object2);
    }

    @Override
    public boolean replace(String string, VariableData variableData, VariableData variableData2) {
        return super.replace(VariableMap.trimKey(string), variableData, variableData2);
    }

    @Override
    public VariableData replace(String string, VariableData variableData) {
        return super.replace(VariableMap.trimKey(string), variableData);
    }

    private static String trimKey(Object object) {
        return object == null ? "null" : String.valueOf(object).trim();
    }

    public void putAllStrings(@Nullable String[][] stringArray, String string) {
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = (String)Misc.valueOrDefault((Object)stringArray[i2][1], (Object)string);
                if (string2 == null) continue;
                this.put(stringArray[i2][0], VariableData.from(string2));
            }
        }
    }

    public void putAllObjects(@Nullable Object[][] objectArray, Object object) {
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object object2;
                if (!(objectArray[i2][0] instanceof String) || (object2 = Misc.valueOrDefault((Object)objectArray[i2][1], (Object)object)) == null) continue;
                this.put((String)objectArray[i2][0], VariableData.from(object2));
            }
        }
    }

    public void putAllFromCollection(@Nullable Collection collection, Object object) {
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e2;
                Object object2;
                String string = String.valueOf(iterator.next());
                if (!iterator.hasNext() || (object2 = Misc.valueOrDefault(e2 = iterator.next(), (Object)object)) == null) continue;
                this.put(string, VariableData.from(object2));
            }
        }
    }

    public void putAllFromMap(@Nullable Map map, Object object) {
        if (map != null) {
            if (map instanceof VariableMap) {
                this.putAll((VariableMap)map);
            } else if (map instanceof VariableMapBackedProperties) {
                this.putAll(((VariableMapBackedProperties)map).variableMap);
            } else if (map instanceof VariableMapBackedObjectMap) {
                this.putAll(((VariableMapBackedObjectMap)map).variableMap);
            } else {
                for (Map.Entry entry : map.entrySet()) {
                    String string = String.valueOf(entry.getKey());
                    Object v2 = entry.getValue();
                    Object object2 = Misc.valueOrDefault(v2, (Object)object);
                    if (object2 == null) continue;
                    this.put(string, VariableData.from(object2));
                }
            }
        }
    }

    public void putAsData(String string, @Nullable Object object) {
        if (object == null) {
            this.remove(string);
        } else {
            this.put(string, VariableData.from(object));
        }
    }
}

