/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.web.chrome;

import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.extensions.TestOptionsProvider;
import de.qfs.apps.qftest.shared.web.BrowserReleaseChannel;
import de.qfs.apps.qftest.shared.web.ConnectionMode;
import de.qfs.apps.qftest.shared.web.WebBrowserInfo;
import de.qfs.apps.qftest.shared.web.chrome.c;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.notifications.DefaultNotificationCenter;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.VersionNumber;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ChromeBrowserInfo
extends WebBrowserInfo {
    private static final QFLogger r = new QFLogger("de.qfs.apps.qftest.shared.web.chrome.ChromeBrowserInfo");
    public static final String DEFAULT_DRIVER_PROPERTY = "webdriver.chrome.driver";
    final String a = "Chrome/Chromium";
    final String b = "chrome";
    final List c = Misc.listOf((Object[])new String[]{"Google Chrome", "chrome", "google-chrome", "Chromium", "chromium", "chromium-browser", "chrome.exe", "Chromium.exe", "Google Chrome for Testing", "Google Chrome Beta", "Google Chrome Dev", "Google Chrome Canary"});
    final List d = Misc.listOf((Object[])new String[]{"\\Google\\Chrome\\Application", "\\Google\\Chrome Beta\\Application", "\\Google\\Chrome Dev\\Application", "\\Google\\Chrome SxS\\Application", "\\Chromium\\Application"});
    final String e = "webdriver.chrome.driver";
    final String n = ChromeBrowserInfo.exeName("chromedriver");
    final String o = "https://chromedriver.chromium.org";
    private static final VersionNumber s = new VersionNumber(Integer.valueOf(2), Integer.valueOf(33));
    protected static final String p = "chromedrivers";
    private a t;
    private c u;
    private de.qfs.apps.qftest.shared.web.chrome.b v;

    public ChromeBrowserInfo() {
        if (ChromeBrowserInfo.r.level >= 7) {
            r.lvlBuild(7, "ChromeBrowserInfo.ChromeBrowserInfo()", 68).log();
        }
    }

    @Override
    protected void c(LinkedList linkedList) {
        if (ChromeBrowserInfo.r.level >= 7) {
            ((LevelAwareLogBuilder)r.lvlBuild(7, "addLinuxDefaultPaths(LinkedList<String>)", 108).addDetail("defaultPaths", (Object)linkedList)).log();
        }
        super.c(linkedList);
        linkedList.add("/opt/google/chrome");
        linkedList.add("/opt/google/chrome-beta");
        linkedList.add("/opt/google/chrome-unstable");
    }

    @Override
    @Nullable
    protected WebBrowserInfo b() {
        if (ChromeBrowserInfo.r.level >= 7) {
            r.lvlBuild(7, "detectExecutableVersion()", 127).log();
        }
        try {
            DefaultNotificationCenter.instance().postNotification("WebBrowserInfo.versiondetect.start", (Object)this, new Object[]{"executable", this.i});
            if (Misc.OS_IS_WINDOWS) {
                this.setExecutableVersion(this.c(this.i));
            } else if (this.e(this.i)) {
                this.setExecutableVersion(this.getVersionByRunningFile(this.i, "--version"));
            }
            this.detectExecutableChannel();
        }
        catch (Throwable throwable) {
            DefaultNotificationCenter.instance().postNotification("WebBrowserInfo.versiondetect.end", (Object)this, new Object[]{"executable", this.i});
            throw throwable;
        }
        DefaultNotificationCenter.instance().postNotification("WebBrowserInfo.versiondetect.end", (Object)this, new Object[]{"executable", this.i});
        return this;
    }

    @Override
    protected BrowserReleaseChannel b(@Nullable File file) {
        if (ChromeBrowserInfo.r.level >= 7) {
            ((LevelAwareLogBuilder)r.lvlBuild(7, "detectExecutableChannel(File)", 151).addDetail("executable", (Object)file)).log();
        }
        if (file != null) {
            String string = file.getAbsolutePath().toLowerCase();
            if (string.contains(" canary") || string.contains(" sxs")) {
                return BrowserReleaseChannel.CANARY;
            }
            if (string.contains(" dev") || string.contains("-unstable") || string.contains("-dev")) {
                return BrowserReleaseChannel.DEV;
            }
            if (string.contains(" beta") || string.contains("-beta")) {
                return BrowserReleaseChannel.BETA;
            }
            return BrowserReleaseChannel.STABLE;
        }
        return null;
    }

    @Override
    public WebBrowserInfo setExecutableChannel(BrowserReleaseChannel browserReleaseChannel) {
        if (ChromeBrowserInfo.r.level >= 7) {
            ((LevelAwareLogBuilder)r.lvlBuild(7, "setExecutableChannel(BrowserReleaseChannel)", 171).addDetail("executableChannel", (Object)browserReleaseChannel)).log();
        }
        if (browserReleaseChannel == BrowserReleaseChannel.ESR) {
            browserReleaseChannel = BrowserReleaseChannel.STABLE;
        }
        return super.setExecutableChannel(browserReleaseChannel);
    }

    protected boolean e(File file) {
        if (ChromeBrowserInfo.r.level >= 7) {
            ((LevelAwareLogBuilder)r.lvlBuild(7, "canGetVersionByRunningFile(File)", 192).addDetail("binary", (Object)file)).log();
        }
        if (file == null || !file.exists()) {
            return false;
        }
        String string = file.getName();
        boolean bl = this.c.contains(string);
        if (ChromeBrowserInfo.r.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)r.lvlBuild(9, "canGetVersionByRunningFile(File)", 198).add("browserFileName", string)).add("nameIsOk", bl)).log();
        }
        return bl;
    }

    @Override
    @Nullable
    public WebBrowserInfo detectDriverVersion() {
        if (ChromeBrowserInfo.r.level >= 7) {
            r.lvlBuild(7, "detectDriverVersion()", 207).log();
        }
        this.setDriverVersion(this.getVersionByRunningFile(this.k, "--version"));
        return this;
    }

    @Override
    protected List c() {
        if (ChromeBrowserInfo.r.level >= 7) {
            r.lvlBuild(7, "createListOfDefaultDriverPaths()", 217).log();
        }
        VersionNumber versionNumber = this.getExpectedDriverVersion();
        if (ChromeBrowserInfo.r.level >= 9) {
            ((LevelAwareLogBuilder)r.lvlBuild(9, "createListOfDefaultDriverPaths()", 220).add("expectedDriverVersion", (Object)versionNumber)).log();
        }
        if (versionNumber != null) {
            File file;
            List list;
            boolean bl = this.c(versionNumber);
            if (ChromeBrowserInfo.r.level >= 9) {
                ((LevelAwareLogBuilder)r.lvlBuild(9, "createListOfDefaultDriverPaths()", 226).add("expectedDriverIsBundled", bl)).log();
            }
            List list2 = list = bl ? super.c() : new LinkedList();
            if (ChromeBrowserInfo.r.level >= 9) {
                ((LevelAwareLogBuilder)r.lvlBuild(9, "createListOfDefaultDriverPaths()", 229).add("specificDriverDir", (Object)list)).log();
            }
            if ((file = this.getDriverDirForDriverVersion(versionNumber, false)) != null) {
                list.add(file);
            }
            return list;
        }
        return super.c();
    }

    @Nullable
    public VersionNumber getDriverVersionForExecutableVersion(VersionNumber versionNumber) {
        if (ChromeBrowserInfo.r.level >= 7) {
            ((LevelAwareLogBuilder)r.lvlBuild(7, "getDriverVersionForExecutableVersion(VersionNumber)", 249).addDetail("executableVersion", (Object)versionNumber)).log();
        }
        if (versionNumber == null) {
            throw new IllegalArgumentException("executableVersion is marked non-null but is null");
        }
        VersionNumber versionNumber2 = this.a(versionNumber);
        if (Misc.OS_IS_LINUX && !Misc.isSystemWith64Bit() && s.compareTo(versionNumber2) < 0) {
            if (ChromeBrowserInfo.r.level >= 9) {
                ((LevelAwareLogBuilder)r.lvlBuild(9, "getDriverVersionForExecutableVersion(VersionNumber)", 253).add("Reducing Browser version on Linux32 bit")).log();
            }
            return s;
        }
        return versionNumber2;
    }

    protected VersionNumber a(VersionNumber versionNumber) {
        if (ChromeBrowserInfo.r.level >= 7) {
            ((LevelAwareLogBuilder)r.lvlBuild(7, "mapExecutableVersionToDriverVersion(VersionNumber)", 266).addDetail("executableVersion", (Object)versionNumber)).log();
        }
        if (versionNumber == null) {
            throw new IllegalArgumentException("executableVersion is marked non-null but is null");
        }
        Integer n2 = versionNumber.getMajor();
        Integer n3 = versionNumber.getMedium();
        Integer n4 = versionNumber.getMinor();
        Integer n5 = versionNumber.getSub();
        assert (n2 != null) : "Major is @NonNull, due to definition of VersionNumber";
        switch (n2) {
            case 71: 
            case 72: 
            case 73: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(46));
            }
            case 70: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(45));
            }
            case 69: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(44));
            }
            case 68: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(42));
            }
            case 67: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(41));
            }
            case 66: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(40));
            }
            case 65: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(38));
            }
            case 64: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(37));
            }
            case 63: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(36));
            }
            case 62: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(35));
            }
            case 61: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(34));
            }
            case 60: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(33));
            }
            case 59: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(32));
            }
            case 58: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(31));
            }
            case 56: 
            case 57: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(29));
            }
            case 55: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(28));
            }
            case 54: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(27));
            }
            case 53: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(26));
            }
            case 52: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(24));
            }
            case 51: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(23));
            }
            case 49: 
            case 50: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(22));
            }
            case 46: 
            case 47: 
            case 48: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(21));
            }
            case 43: 
            case 44: 
            case 45: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(20));
            }
            case 42: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(16));
            }
            case 40: 
            case 41: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(15));
            }
            case 39: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(14));
            }
            case 38: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(13));
            }
            case 36: 
            case 37: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(12));
            }
            case 33: 
            case 34: 
            case 35: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(10));
            }
            case 31: 
            case 32: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(9));
            }
            case 30: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(8));
            }
            case 29: {
                return new VersionNumber(Integer.valueOf(2), Integer.valueOf(6));
            }
        }
        return new VersionNumber(n2, n3, n4);
    }

    @Nullable
    public VersionNumber getExpectedDriverVersion() {
        if (ChromeBrowserInfo.r.level >= 7) {
            r.lvlBuild(7, "getExpectedDriverVersion()", 332).log();
        }
        if (this.l != null) {
            if (ChromeBrowserInfo.r.level >= 9) {
                ((LevelAwareLogBuilder)r.lvlBuild(9, "getExpectedDriverVersion()", 334).add("driverVersion", (Object)this.l)).log();
            }
            return this.l;
        }
        if (this.i != null) {
            if (ChromeBrowserInfo.r.level >= 9) {
                ((LevelAwareLogBuilder)r.lvlBuild(9, "getExpectedDriverVersion()", 338).add("Executable was set: ", (Object)this.i)).log();
            }
            if (this.j == null) {
                if (ChromeBrowserInfo.r.level >= 9) {
                    ((LevelAwareLogBuilder)r.lvlBuild(9, "getExpectedDriverVersion()", 340).add("trying to detect executableVersion")).log();
                }
                this.b();
            }
            if (ChromeBrowserInfo.r.level >= 9) {
                ((LevelAwareLogBuilder)r.lvlBuild(9, "getExpectedDriverVersion()", 343).add("executableVersion", (Object)this.j)).log();
            }
        }
        if (this.j == null) {
            if (ChromeBrowserInfo.r.level >= 9) {
                ((LevelAwareLogBuilder)r.lvlBuild(9, "getExpectedDriverVersion()", 346).add("No executable version")).log();
            }
            return null;
        }
        VersionNumber versionNumber = this.getDriverVersionForExecutableVersion(this.j);
        if (ChromeBrowserInfo.r.level >= 9) {
            ((LevelAwareLogBuilder)r.lvlBuild(9, "getExpectedDriverVersion()", 350).add("expectedDriverVersion", (Object)versionNumber)).log();
        }
        return versionNumber;
    }

    @Nullable
    public File getDriverDirForDriverVersion(@Nullable VersionNumber versionNumber, boolean bl) {
        if (ChromeBrowserInfo.r.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)r.lvlBuild(7, "getDriverDirForDriverVersion(VersionNumber,boolean)", 364).addDetail("chromeDriverVersion", (Object)versionNumber)).addDetail("exact", bl)).log();
        }
        if (versionNumber == null) {
            return null;
        }
        Integer n2 = versionNumber.getMajor();
        Integer n3 = versionNumber.getMedium();
        Integer n4 = n2 <= 2 ? null : versionNumber.getMinor();
        String string = versionNumber.getOriginalVersionString();
        versionNumber = new VersionNumber(n2, n3, n4);
        versionNumber.setOriginalVersionString(string);
        String string2 = this.b(versionNumber);
        if (ChromeBrowserInfo.r.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)r.lvlBuild(9, "getDriverDirForDriverVersion(VersionNumber,boolean)", 375).add("chromeDriverVersion", (Object)versionNumber)).add("driverDirName", string2)).log();
        }
        String string3 = Util.getTopicDir(string2, true, Util.LocationPreference.PREFER_SYSTEM_DIR);
        if (ChromeBrowserInfo.r.level >= 9) {
            ((LevelAwareLogBuilder)r.lvlBuild(9, "getDriverDirForDriverVersion(VersionNumber,boolean)", 378).add("chromedriversPath", string3)).log();
        }
        if (string3 == null) {
            string3 = Util.getTopicDir(null, true, Util.LocationPreference.PREFER_SYSTEM_DIR) + File.separator + string2;
            if (ChromeBrowserInfo.r.level >= 9) {
                ((LevelAwareLogBuilder)r.lvlBuild(9, "getDriverDirForDriverVersion(VersionNumber,boolean)", 381).add("chromedriversPath", string3)).log();
            }
        }
        assert (string3 != null);
        File file = new File(string3);
        if (bl) {
            return this.a(versionNumber, file);
        }
        VersionNumber versionNumber2 = null;
        File file2 = null;
        String[] stringArray = file.list();
        if (ChromeBrowserInfo.r.level >= 9) {
            ((LevelAwareLogBuilder)r.lvlBuild(9, "getDriverDirForDriverVersion(VersionNumber,boolean)", 394).add("subdirs", (Object)stringArray)).log();
        }
        if (stringArray == null) {
            return null;
        }
        for (String string4 : stringArray) {
            File file3 = new File(file, string4);
            if (ChromeBrowserInfo.r.level >= 9) {
                ((LevelAwareLogBuilder)r.lvlBuild(9, "getDriverDirForDriverVersion(VersionNumber,boolean)", 401).add("subdir", (Object)file3)).log();
            }
            if (!file3.isDirectory()) {
                if (ChromeBrowserInfo.r.level < 9) continue;
                ((LevelAwareLogBuilder)r.lvlBuild(9, "getDriverDirForDriverVersion(VersionNumber,boolean)", 403).add("No directory, skipping")).log();
                continue;
            }
            VersionNumber versionNumber3 = VersionNumber.fromString((String)string4);
            assert (versionNumber3 != null);
            if (versionNumber3.compareTo(versionNumber2) <= 0 || versionNumber3.compareTo(versionNumber) > 0) continue;
            if (ChromeBrowserInfo.r.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)r.lvlBuild(9, "getDriverDirForDriverVersion(VersionNumber,boolean)", 413).add("New best match: ")).add((Object)versionNumber3)).log();
            }
            versionNumber2 = versionNumber3;
            file2 = file3;
        }
        if (ChromeBrowserInfo.r.level >= 9) {
            ((LevelAwareLogBuilder)r.lvlBuild(9, "getDriverDirForDriverVersion(VersionNumber,boolean)", 418).add("bestMatchedDir", file2)).log();
        }
        return file2;
    }

    protected File a(VersionNumber versionNumber, File file) {
        if (ChromeBrowserInfo.r.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)r.lvlBuild(7, "getExactChromeDriverPath(VersionNumber,File)", 427).addDetail("chromeDriverVersion", (Object)versionNumber)).addDetail("chromedriversVersionDir", (Object)file)).log();
        }
        File file2 = new File(file, versionNumber.toString());
        if (ChromeBrowserInfo.r.level >= 9) {
            ((LevelAwareLogBuilder)r.lvlBuild(9, "getExactChromeDriverPath(VersionNumber,File)", 431).add("exactDriverPath", (Object)file2)).log();
        }
        return file2;
    }

    protected String b(VersionNumber versionNumber) {
        if (ChromeBrowserInfo.r.level >= 7) {
            ((LevelAwareLogBuilder)r.lvlBuild(7, "getDriverDirName(VersionNumber)", 438).addDetail("driverVersion", (Object)versionNumber)).log();
        }
        if (versionNumber == null) {
            throw new IllegalArgumentException("driverVersion is marked non-null but is null");
        }
        return p;
    }

    @Nullable
    public File getExpectedDriverDir(boolean bl) {
        if (ChromeBrowserInfo.r.level >= 7) {
            ((LevelAwareLogBuilder)r.lvlBuild(7, "getExpectedDriverDir(boolean)", 447).addDetail("exact", bl)).log();
        }
        List list = super.c();
        if (ChromeBrowserInfo.r.level >= 9) {
            ((LevelAwareLogBuilder)r.lvlBuild(9, "getExpectedDriverDir(boolean)", 450).add("defaultDriverPaths", (Object)list)).log();
        }
        if (bl) {
            File file;
            VersionNumber versionNumber = this.getExpectedDriverVersion();
            if (ChromeBrowserInfo.r.level >= 9) {
                ((LevelAwareLogBuilder)r.lvlBuild(9, "getExpectedDriverDir(boolean)", 454).add("expectedDriverVersion", (Object)versionNumber)).log();
            }
            if (this.c(versionNumber)) {
                file = this.a(list);
                if (ChromeBrowserInfo.r.level >= 9) {
                    ((LevelAwareLogBuilder)r.lvlBuild(9, "getExpectedDriverDir(boolean)", 458).add("matchingDriver", (Object)file)).log();
                }
                if (file != null && file.exists()) {
                    return file.getParentFile();
                }
            }
            file = this.getDriverDirForDriverVersion(versionNumber, true);
            if (ChromeBrowserInfo.r.level >= 9) {
                ((LevelAwareLogBuilder)r.lvlBuild(9, "getExpectedDriverDir(boolean)", 466).add("exactNonBundledDriverPath", (Object)file)).log();
            }
            return file;
        }
        if (list.size() > 0) {
            return (File)list.get(0);
        }
        return null;
    }

    protected boolean c(VersionNumber versionNumber) {
        if (ChromeBrowserInfo.r.level >= 7) {
            ((LevelAwareLogBuilder)r.lvlBuild(7, "expectedDriverIsBundled(VersionNumber)", 480).addDetail("expectedDriverVersion", (Object)versionNumber)).log();
        }
        return false;
    }

    @Override
    public WebBrowserInfo findDefaultDriver() throws IOException {
        if (ChromeBrowserInfo.r.level >= 7) {
            r.lvlBuild(7, "findDefaultDriver()", 489).log();
        }
        try {
            this.downloadExpectedDriverIfRequired();
        }
        catch (IOException iOException) {
            StringBuilder stringBuilder;
            File file;
            block16: {
                if (ChromeBrowserInfo.r.level >= 3) {
                    ((LevelAwareLogBuilder)r.lvlBuild(3, "findDefaultDriver()", 494).add("ex", (Object)iOException)).log();
                }
                file = this.getExpectedDriverDir(true);
                stringBuilder = new StringBuilder();
                stringBuilder.append("Could not download the correct driver for " + this.getBrowserName() + " browser:\n\n");
                String string = iOException.getMessage();
                if (!Misc.emptyOrNull((String)string)) {
                    stringBuilder.append(string + "\n\n");
                }
                if (this.i != null) {
                    stringBuilder.append("Browser executable: " + this.i);
                    if (this.j != null) {
                        stringBuilder.append(" (version " + this.j + ")");
                    }
                    stringBuilder.append("\n");
                }
                VersionNumber versionNumber = this.getExpectedDriverVersion();
                if (ChromeBrowserInfo.r.level >= 9) {
                    ((LevelAwareLogBuilder)r.lvlBuild(9, "findDefaultDriver()", 513).add("expectedDriverVersion", (Object)versionNumber)).log();
                }
                if (versionNumber != null) {
                    stringBuilder.append("Expected driver version: " + versionNumber + "\n");
                    try {
                        URL uRL = this.getDriverDownloadUrlForVersion(this.j, versionNumber);
                        stringBuilder.append("Download URL: " + uRL + "\n");
                    }
                    catch (IOException iOException2) {
                        if (ChromeBrowserInfo.r.level < 9) break block16;
                        ((LevelAwareLogBuilder)r.lvlBuild(9, "findDefaultDriver()", 521).add("ex2", (Object)iOException2)).log();
                    }
                }
            }
            stringBuilder.append("Expected driver directory: " + file + "\n");
            stringBuilder.append("\nPlease provide the correct driver at the indicated location.");
            stringBuilder.append("\n\nTo download the driver, please visit " + this.getDriverDownloadHomepage());
            stringBuilder.append("\n\nIf your network requires a proxy to contact external websites,");
            stringBuilder.append("\nyou can instruct QF-Test to use the proxy during driver download");
            stringBuilder.append("\nby setting the \"http.proxyHost\" and \"http.proxyPort\" properties");
            stringBuilder.append("\nfor example in a SUT script before opening the browser window.");
            throw new IOException(stringBuilder.toString(), iOException);
        }
        finally {
            if (this.k == null) {
                super.findLocalDefaultDriver();
            }
        }
        return this;
    }

    @Nullable
    public URL getDriverDownloadUrlForVersion(VersionNumber versionNumber, VersionNumber versionNumber2) throws IOException {
        if (ChromeBrowserInfo.r.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)r.lvlBuild(7, "getDriverDownloadUrlForVersion(VersionNumber,VersionNumber)", 550).addDetail("executableVersion", (Object)versionNumber)).addDetail("driverVersion", (Object)versionNumber2)).log();
        }
        if (versionNumber == null) {
            throw new IllegalArgumentException("executableVersion is marked non-null but is null");
        }
        if (versionNumber2 == null) {
            throw new IllegalArgumentException("driverVersion is marked non-null but is null");
        }
        b b2 = this.a(versionNumber, versionNumber2);
        VersionNumber versionNumber3 = b2.a(versionNumber2);
        if (ChromeBrowserInfo.r.level >= 9) {
            ((LevelAwareLogBuilder)r.lvlBuild(9, "getDriverDownloadUrlForVersion(VersionNumber,VersionNumber)", 554).add("bestMatchingVersion", (Object)versionNumber3)).log();
        }
        URL uRL = b2.b(versionNumber3);
        if (ChromeBrowserInfo.r.level >= 9) {
            ((LevelAwareLogBuilder)r.lvlBuild(9, "getDriverDownloadUrlForVersion(VersionNumber,VersionNumber)", 556).add("url", (Object)uRL)).log();
        }
        return uRL;
    }

    public ChromeBrowserInfo downloadExpectedDriverIfRequired() throws IOException {
        if (ChromeBrowserInfo.r.level >= 7) {
            r.lvlBuild(7, "downloadExpectedDriverIfRequired()", 570).log();
        }
        File file = this.getExpectedDriverDir(true);
        if (ChromeBrowserInfo.r.level >= 9) {
            ((LevelAwareLogBuilder)r.lvlBuild(9, "downloadExpectedDriverIfRequired()", 575).add("expectedDriverDir", (Object)file)).log();
        }
        Object object = this.a(Misc.listOf((Object[])new File[]{file}));
        if (ChromeBrowserInfo.r.level >= 9) {
            ((LevelAwareLogBuilder)r.lvlBuild(9, "downloadExpectedDriverIfRequired()", 577).add("existingDriver", object)).log();
        }
        if (object != null) {
            if (ChromeBrowserInfo.r.level >= 5) {
                ((LevelAwareLogBuilder)r.lvlBuild(5, "downloadExpectedDriverIfRequired()", 580).add("Driver already exists, no download required", object)).log();
            }
            this.setDriver((File)object);
            return this;
        }
        file = this.getExpectedDriverVersion();
        if (ChromeBrowserInfo.r.level >= 9) {
            ((LevelAwareLogBuilder)r.lvlBuild(9, "downloadExpectedDriverIfRequired()", 587).add("expectedDriverVersion", (Object)file)).log();
        }
        if (file == null) {
            if (ChromeBrowserInfo.r.level >= 5) {
                ((LevelAwareLogBuilder)r.lvlBuild(5, "downloadExpectedDriverIfRequired()", 589).add("Cannot detect expected driver version")).log();
            }
            this.setDriver(null);
            return this;
        }
        object = this.a((VersionNumber)(this.j == null ? file : this.j), (VersionNumber)file);
        VersionNumber versionNumber = object.a((VersionNumber)file);
        if (ChromeBrowserInfo.r.level >= 9) {
            ((LevelAwareLogBuilder)r.lvlBuild(9, "downloadExpectedDriverIfRequired()", 596).add("bestMatchingVersion", (Object)versionNumber)).log();
        }
        File file2 = this.getDriverDirForDriverVersion(versionNumber, true);
        if (ChromeBrowserInfo.r.level >= 9) {
            ((LevelAwareLogBuilder)r.lvlBuild(9, "downloadExpectedDriverIfRequired()", 599).add("bestMatchingDriverDir", (Object)file2)).log();
        }
        File file3 = this.a(Misc.listOf((Object[])new File[]{file2}));
        if (ChromeBrowserInfo.r.level >= 9) {
            ((LevelAwareLogBuilder)r.lvlBuild(9, "downloadExpectedDriverIfRequired()", 603).add("existingBestMatchingDriver", (Object)file3)).log();
        }
        if (file3 != null) {
            if (ChromeBrowserInfo.r.level >= 5) {
                ((LevelAwareLogBuilder)r.lvlBuild(5, "downloadExpectedDriverIfRequired()", 606).add("Bast matching driver already exists, no download required", (Object)file3)).log();
            }
            this.setDriver(file3);
            return this;
        }
        if (versionNumber != null) {
            object.a(this, versionNumber, file2, this.getDriverExecutableName());
        }
        file2 = this.getDriverDirForDriverVersion(versionNumber, true);
        if (ChromeBrowserInfo.r.level >= 9) {
            ((LevelAwareLogBuilder)r.lvlBuild(9, "downloadExpectedDriverIfRequired()", 616).add("bestMatchingDriverDir", (Object)file2)).log();
        }
        this.setDriver(this.a(Misc.listOf((Object[])new File[]{file2})));
        if (ChromeBrowserInfo.r.level >= 9) {
            ((LevelAwareLogBuilder)r.lvlBuild(9, "downloadExpectedDriverIfRequired()", 618).add("driver", (Object)this.k)).log();
        }
        return this;
    }

    protected b a(VersionNumber versionNumber, VersionNumber versionNumber2) throws IOException {
        block17: {
            VersionNumber versionNumber3;
            b b2;
            block16: {
                if (ChromeBrowserInfo.r.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)r.lvlBuild(7, "getDriverDownloaderForVersion(VersionNumber,VersionNumber)", 626).addDetail("executableVersion", (Object)versionNumber)).addDetail("expectedDriverVersion", (Object)versionNumber2)).log();
                }
                if (versionNumber == null) {
                    throw new IllegalArgumentException("executableVersion is marked non-null but is null");
                }
                if (versionNumber2 == null) {
                    throw new IllegalArgumentException("expectedDriverVersion is marked non-null but is null");
                }
                if (versionNumber2.getMajor() > 114) {
                    try {
                        b2 = this.e(versionNumber);
                        if (b2 != null) {
                            versionNumber3 = b2.a(versionNumber2);
                            if (ChromeBrowserInfo.r.level >= 9) {
                                ((LevelAwareLogBuilder)r.lvlBuild(9, "getDriverDownloaderForVersion(VersionNumber,VersionNumber)", 634).add("bestMatchingVersion", (Object)versionNumber3)).log();
                            }
                            if (versionNumber2.compareTo(versionNumber3, 1) == 0) {
                                if (ChromeBrowserInfo.r.level >= 9) {
                                    ((LevelAwareLogBuilder)r.lvlBuild(9, "getDriverDownloaderForVersion(VersionNumber,VersionNumber)", 636).add("Chrome driver downloader returns matching result, use it")).log();
                                }
                                return b2;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        if (ChromeBrowserInfo.r.level < 3) break block16;
                        ((LevelAwareLogBuilder)r.lvlBuild(3, "getDriverDownloaderForVersion(VersionNumber,VersionNumber)", 641).add("Exception downloading with chrome after 114 version downloader", (Object)iOException)).log();
                    }
                }
            }
            try {
                b2 = this.e();
                if (b2 != null) {
                    versionNumber3 = b2.a(versionNumber2);
                    if (ChromeBrowserInfo.r.level >= 9) {
                        ((LevelAwareLogBuilder)r.lvlBuild(9, "getDriverDownloaderForVersion(VersionNumber,VersionNumber)", 648).add("bestMatchingVersion", (Object)versionNumber3)).log();
                    }
                    if (versionNumber2.compareTo(versionNumber3, 1) == 0) {
                        if (ChromeBrowserInfo.r.level >= 9) {
                            ((LevelAwareLogBuilder)r.lvlBuild(9, "getDriverDownloaderForVersion(VersionNumber,VersionNumber)", 650).add("Chrome driver downloader returns matching result, use it")).log();
                        }
                        return b2;
                    }
                }
            }
            catch (IOException iOException) {
                if (ChromeBrowserInfo.r.level < 3) break block17;
                ((LevelAwareLogBuilder)r.lvlBuild(3, "getDriverDownloaderForVersion(VersionNumber,VersionNumber)", 655).add("Exception downloading with chrome before 115 version downloader", (Object)iOException)).log();
            }
        }
        return this.d(versionNumber);
    }

    protected synchronized a e() throws IOException {
        if (ChromeBrowserInfo.r.level >= 7) {
            r.lvlBuild(7, "getChromeDriverDownloader()", 664).log();
        }
        if (this.t != null) {
            return this.t;
        }
        this.t = new a();
        return this.t;
    }

    protected synchronized c d(VersionNumber versionNumber) throws IOException {
        if (ChromeBrowserInfo.r.level >= 7) {
            ((LevelAwareLogBuilder)r.lvlBuild(7, "getNightlyDriverDownloaderForVersion(VersionNumber)", 674).addDetail("executableVersion", (Object)versionNumber)).log();
        }
        if (versionNumber == null) {
            throw new IllegalArgumentException("executableVersion is marked non-null but is null");
        }
        if (this.u != null) {
            return this.u;
        }
        this.u = new c(versionNumber);
        return this.u;
    }

    protected synchronized de.qfs.apps.qftest.shared.web.chrome.b e(VersionNumber versionNumber) throws IOException {
        if (ChromeBrowserInfo.r.level >= 7) {
            ((LevelAwareLogBuilder)r.lvlBuild(7, "getAbove114DriverDownloaderForVersion(VersionNumber)", 686).addDetail("executableVersion", (Object)versionNumber)).log();
        }
        if (versionNumber == null) {
            throw new IllegalArgumentException("executableVersion is marked non-null but is null");
        }
        if (this.v != null) {
            return this.v;
        }
        this.v = new de.qfs.apps.qftest.shared.web.chrome.b(versionNumber);
        return this.v;
    }

    protected static String f() {
        if (ChromeBrowserInfo.r.level >= 7) {
            r.lvlBuild(7, "getCurrentOSSuffix()", 1147).log();
        }
        String string = (Misc.OS_IS_MAC_OS_X ? "mac" : (Misc.OS_IS_LINUX ? "linux" : "win")) + (Misc.isSystemWith64Bit() ? "64" : "32");
        return string;
    }

    protected static File f(File file) {
        if (ChromeBrowserInfo.r.level >= 7) {
            ((LevelAwareLogBuilder)r.lvlBuild(7, "appendOSSuffixSubdir(File)", 1157).addDetail("dir", (Object)file)).log();
        }
        String string = ChromeBrowserInfo.f();
        if (ChromeBrowserInfo.r.level >= 9) {
            ((LevelAwareLogBuilder)r.lvlBuild(9, "appendOSSuffixSubdir(File)", 1160).add("osSuffix", string)).log();
        }
        if (!Misc.emptyOrNull((String)string)) {
            return new File(file, string);
        }
        return file;
    }

    @Override
    public boolean supportsConnectionMode(ConnectionMode connectionMode) {
        if (ChromeBrowserInfo.r.level >= 7) {
            ((LevelAwareLogBuilder)r.lvlBuild(7, "supportsConnectionMode(ConnectionMode)", 1172).addDetail("connectionMode", (Object)connectionMode)).log();
        }
        return Misc.OS_IS_WINDOWS || connectionMode != ConnectionMode.QFDRIVER;
    }

    public static void main(String[] stringArray) {
        if (ChromeBrowserInfo.r.level >= 7) {
            ((LevelAwareLogBuilder)r.lvlBuild(7, "main(String[])", 1182).addDetail("args", (Object)stringArray)).log();
        }
        Options.setOptionsProvider(new TestOptionsProvider());
        ChromeBrowserInfo chromeBrowserInfo = new ChromeBrowserInfo();
        chromeBrowserInfo.setBrowserFileName("");
        chromeBrowserInfo.findExecutable();
        try {
            chromeBrowserInfo.setupDriver();
        }
        catch (IOException iOException) {
            if (ChromeBrowserInfo.r.level >= 3) {
                ((LevelAwareLogBuilder)r.lvlBuild(3, "main(String[])", 1201).add("e", (Object)iOException)).log();
            }
            System.out.println(iOException.getMessage());
        }
        System.out.println(chromeBrowserInfo.asJsonValue());
    }

    @Override
    public String toString() {
        if (ChromeBrowserInfo.r.level >= 7) {
            r.lvlBuild(7, "toString()", 66).log();
        }
        return "ChromeBrowserInfo(super=" + super.toString() + ", browserName=" + this.getBrowserName() + ", simpleBrowserName=" + this.getSimpleBrowserName() + ", binaryNames=" + this.getBinaryNames() + ", windowsProgramFilesSubdirs=" + this.getWindowsProgramFilesSubdirs() + ", driverProperty=" + this.getDriverProperty() + ", driverExecutableName=" + this.getDriverExecutableName() + ", driverDownloadHomepage=" + this.getDriverDownloadHomepage() + ", chromeStableDriverDownloader=" + this.t + ", chromeNightlyDriverDownloader=" + this.u + ", chromeAbove114DriverDownloader=" + this.v + ")";
    }

    @Override
    public String getBrowserName() {
        if (ChromeBrowserInfo.r.level >= 7) {
            r.lvlBuild(7, "getBrowserName()", 75).log();
        }
        return this.a;
    }

    @Override
    public String getSimpleBrowserName() {
        if (ChromeBrowserInfo.r.level >= 7) {
            r.lvlBuild(7, "getSimpleBrowserName()", 76).log();
        }
        return this.b;
    }

    @Override
    public List getBinaryNames() {
        if (ChromeBrowserInfo.r.level >= 7) {
            r.lvlBuild(7, "getBinaryNames()", 77).log();
        }
        return this.c;
    }

    @Override
    public List getWindowsProgramFilesSubdirs() {
        if (ChromeBrowserInfo.r.level >= 7) {
            r.lvlBuild(7, "getWindowsProgramFilesSubdirs()", 82).log();
        }
        return this.d;
    }

    @Override
    public String getDriverProperty() {
        if (ChromeBrowserInfo.r.level >= 7) {
            r.lvlBuild(7, "getDriverProperty()", 89).log();
        }
        return this.e;
    }

    @Override
    public String getDriverExecutableName() {
        if (ChromeBrowserInfo.r.level >= 7) {
            r.lvlBuild(7, "getDriverExecutableName()", 90).log();
        }
        return this.n;
    }

    public String getDriverDownloadHomepage() {
        if (ChromeBrowserInfo.r.level >= 7) {
            r.lvlBuild(7, "getDriverDownloadHomepage()", 91).log();
        }
        return this.o;
    }

    protected static class a
    extends DefaultHandler
    implements b {
        static final String a = "https://chromedriver.storage.googleapis.com/";
        static final String b = "%s/chromedriver_%s%s.zip";
        static final String c = "LATEST_RELEASE";
        static final String d = de.qfs.apps.qftest.shared.web.chrome.ChromeBrowserInfo$a.c();
        StringBuilder e = null;
        private NavigableSet j = null;
        private NavigableSet k = null;
        String f = null;
        String g = "NextMarker";
        final String h;

        public a() {
            if (r.level >= 7) {
                r.lvlBuild(7, "ChromeDriverDownloader.ChromeDriverDownloader()", 758).log();
            }
            this.h = this.a();
        }

        protected String a() {
            if (r.level >= 7) {
                r.lvlBuild(7, "ChromeDriverDownloader.getKeyName()", 765).log();
            }
            return "Key";
        }

        protected void c(VersionNumber versionNumber) throws MalformedURLException, IOException {
            if (r.level >= 7) {
                ((LevelAwareLogBuilder)r.lvlBuild(7, "ChromeDriverDownloader.init(VersionNumber)", 778).addDetail("preferredVersion", (Object)versionNumber)).log();
            }
            this.k = new TreeSet();
            this.j = new TreeSet();
            URL uRL = this.b();
            int n2 = de.qfs.apps.qftest.shared.web.chrome.a.d * 1000;
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            int n3 = 0;
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            while (bl || bl3 || bl2) {
                int n4;
                URL uRL2 = uRL;
                if (!Misc.emptyOrNull((String)this.f)) {
                    uRL2 = new URL(uRL2 + (uRL2.getQuery() == null ? "?" : "&") + "marker=" + this.f);
                }
                if (versionNumber != null && bl3 && (n4 = versionNumber.getMajor() - n3) > 0) {
                    uRL2 = new URL(uRL2 + (uRL2.getQuery() == null ? "?" : "&") + "prefix=" + n4 + ".");
                }
                if (r.level >= 9) {
                    ((LevelAwareLogBuilder)r.lvlBuild(9, "ChromeDriverDownloader.init(VersionNumber)", 811).add("url", (Object)uRL2)).log();
                }
                InputStream inputStream = this.a(uRL2, n2 / 4, n2 / 4);
                Throwable throwable = null;
                try {
                    try {
                        SAXParser sAXParser = sAXParserFactory.newSAXParser();
                        this.f = null;
                        sAXParser.parse(inputStream, (DefaultHandler)this);
                        bl2 = this.j.isEmpty();
                        bl = !Misc.emptyOrNull((String)this.f);
                        bl3 = ++n3 <= 1;
                    }
                    catch (ParserConfigurationException | SAXException exception) {
                        if (r.level >= 1) {
                            ((LevelAwareLogBuilder)r.lvlBuild(1, "ChromeDriverDownloader.init(VersionNumber)", 824).add("e", (Object)exception)).log();
                        }
                        throw new IOException(exception);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }

        @Override
        public InputStream a(URL uRL, int n2, int n3) throws IOException {
            if (r.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)r.lvlBuild(7, "ChromeDriverDownloader.openStreamWithTimeout(URL,int,int)", 834).addDetail("url", (Object)uRL)).addDetail("connectionTimeout", n2)).addDetail("readTimeout", n3)).log();
            }
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(n2);
            uRLConnection.setReadTimeout(n3);
            InputStream inputStream = uRLConnection.getInputStream();
            return inputStream;
        }

        protected URL b() throws MalformedURLException {
            if (r.level >= 7) {
                r.lvlBuild(7, "ChromeDriverDownloader.getIndexXmlUrl()", 847).log();
            }
            return new URL(a);
        }

        public NavigableSet d(@Nullable VersionNumber versionNumber) throws IOException {
            if (r.level >= 7) {
                ((LevelAwareLogBuilder)r.lvlBuild(7, "ChromeDriverDownloader.getFiles(VersionNumber)", 858).addDetail("preferredVersion", (Object)versionNumber)).log();
            }
            if (this.j == null) {
                this.c(versionNumber);
            }
            return this.j;
        }

        public NavigableSet e(@Nullable VersionNumber versionNumber) throws IOException {
            if (r.level >= 7) {
                ((LevelAwareLogBuilder)r.lvlBuild(7, "ChromeDriverDownloader.getVersions(VersionNumber)", 872).addDetail("preferredVersion", (Object)versionNumber)).log();
            }
            if (this.k == null) {
                this.c(versionNumber);
            }
            return this.k;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (r.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)r.lvlBuild(7, "ChromeDriverDownloader.startElement(String,String,String,Attributes)", 887).addDetail("uri", string)).addDetail("localName", string2)).addDetail("qName", string3)).addDetail("attributes", (Object)attributes)).log();
            }
            this.e = this.h.equals(string3) || this.g.equals(string3) ? new StringBuilder() : null;
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (r.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)r.lvlBuild(7, "ChromeDriverDownloader.endElement(String,String,String)", 898).addDetail("uri", string)).addDetail("localName", string2)).addDetail("qName", string3)).log();
            }
            if (this.h.equals(string3)) {
                String string4 = this.e.toString();
                if (r.level >= 9) {
                    ((LevelAwareLogBuilder)r.lvlBuild(9, "ChromeDriverDownloader.endElement(String,String,String)", 902).add("key", string4)).log();
                }
                if (string4.contains(d)) {
                    if (this.j != null) {
                        this.j.add(string4);
                    }
                    this.b(string4);
                }
                this.e = null;
            } else if (this.g.equals(string3)) {
                String string5 = this.e.toString();
                if (r.level >= 9) {
                    ((LevelAwareLogBuilder)r.lvlBuild(9, "ChromeDriverDownloader.endElement(String,String,String)", 912).add("marker", string5)).log();
                }
                this.f = string5;
                this.e = null;
            }
        }

        @Override
        public void characters(char[] cArray, int n2, int n3) throws SAXException {
            if (r.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)r.lvlBuild(7, "ChromeDriverDownloader.characters(char[],int,int)", 919).addDetail("ch", (Object)cArray)).addDetail("start", n2)).addDetail("length", n3)).log();
            }
            if (this.e != null) {
                this.e.append(cArray, n2, n3);
            }
        }

        private void b(String string) {
            if (r.level >= 7) {
                ((LevelAwareLogBuilder)r.lvlBuild(7, "ChromeDriverDownloader.addVersionFromKey(String)", 929).addDetail("key", string)).log();
            }
            if (string == null) {
                throw new IllegalArgumentException("key is marked non-null but is null");
            }
            int n2 = string.indexOf(47);
            if (r.level >= 9) {
                ((LevelAwareLogBuilder)r.lvlBuild(9, "ChromeDriverDownloader.addVersionFromKey(String)", 932).add("slashIndex", n2)).log();
            }
            if (n2 == -1) {
                return;
            }
            VersionNumber versionNumber = VersionNumber.fromString((String)string.substring(0, n2));
            if (this.k != null) {
                this.k.add(versionNumber);
            }
        }

        @Override
        @Nullable
        public VersionNumber a(VersionNumber versionNumber) throws IOException {
            if (r.level >= 7) {
                ((LevelAwareLogBuilder)r.lvlBuild(7, "ChromeDriverDownloader.getBestMatchingVersion(VersionNumber)", 945).addDetail("targetVersion", (Object)versionNumber)).log();
            }
            if (versionNumber == null) {
                throw new IllegalArgumentException("targetVersion is marked non-null but is null");
            }
            int n2 = versionNumber.getSignificantDigits();
            Iterator iterator = this.e(versionNumber).descendingIterator();
            while (iterator.hasNext()) {
                VersionNumber versionNumber2 = (VersionNumber)iterator.next();
                int n3 = versionNumber.compareTo(versionNumber2, n2);
                if (r.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)r.lvlBuild(9, "ChromeDriverDownloader.getBestMatchingVersion(VersionNumber)", 952).add("versionNumber", (Object)versionNumber2)).add("comparison", n3)).log();
                }
                if (n3 < 0) continue;
                return versionNumber2;
            }
            return null;
        }

        @Override
        @Nullable
        public URL b(@Nullable VersionNumber versionNumber) throws IOException {
            if (r.level >= 7) {
                ((LevelAwareLogBuilder)r.lvlBuild(7, "ChromeDriverDownloader.getURLForVersion(VersionNumber)", 965).addDetail("version", (Object)versionNumber)).log();
            }
            if (versionNumber == null) {
                return null;
            }
            for (String string : WebBrowserInfo.BITNESS_SUFFIXES) {
                String string2 = this.a(versionNumber, d, string);
                if (r.level >= 9) {
                    ((LevelAwareLogBuilder)r.lvlBuild(9, "ChromeDriverDownloader.getURLForVersion(VersionNumber)", 971).add("filename", string2)).log();
                }
                if (!this.d(versionNumber).contains(string2)) continue;
                String string3 = this.a(string2);
                if (r.level >= 9) {
                    ((LevelAwareLogBuilder)r.lvlBuild(9, "ChromeDriverDownloader.getURLForVersion(VersionNumber)", 974).add("urlString", string3)).log();
                }
                try {
                    return new URL(string3);
                }
                catch (MalformedURLException malformedURLException) {
                    if (r.level < 3) break;
                    ((LevelAwareLogBuilder)r.lvlBuild(3, "ChromeDriverDownloader.getURLForVersion(VersionNumber)", 978).add("e", (Object)malformedURLException)).log();
                    break;
                }
            }
            return null;
        }

        protected static String c() {
            if (r.level >= 7) {
                r.lvlBuild(7, "ChromeDriverDownloader.getOsString()", 989).log();
            }
            String string = Misc.OS_IS_MAC_OS_X ? "mac" : (Misc.OS_IS_LINUX ? "linux" : "win");
            return string;
        }

        protected String a(VersionNumber versionNumber, String string, String string2) {
            if (r.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)r.lvlBuild(7, "ChromeDriverDownloader.getFilename(VersionNumber,String,String)", 998).addDetail("version", (Object)versionNumber)).addDetail("osString", string)).addDetail("suffix", string2)).log();
            }
            return String.format(b, versionNumber.toString(), string, string2);
        }

        protected String a(String string) {
            if (r.level >= 7) {
                ((LevelAwareLogBuilder)r.lvlBuild(7, "ChromeDriverDownloader.getUrlForFilename(String)", 1006).addDetail("filename", string)).log();
            }
            return a + string;
        }

        @Override
        public void a(WebBrowserInfo webBrowserInfo, VersionNumber versionNumber, File file, @Nullable String string) throws IOException {
            if (r.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)r.lvlBuild(7, "ChromeDriverDownloader.downloadVersionToDir(WebBrowserInfo,VersionNumber,File,String)", 1015).addDetail("info", (Object)webBrowserInfo)).addDetail("version", (Object)versionNumber)).addDetail("targetDir", (Object)file)).addDetail("driverFileName", string)).log();
            }
            if (versionNumber == null) {
                throw new IllegalArgumentException("version is marked non-null but is null");
            }
            if (file == null) {
                throw new IllegalArgumentException("targetDir is marked non-null but is null");
            }
            URL uRL = this.b(versionNumber);
            if (r.level >= 9) {
                ((LevelAwareLogBuilder)r.lvlBuild(9, "ChromeDriverDownloader.downloadVersionToDir(WebBrowserInfo,VersionNumber,File,String)", 1018).add("url", (Object)uRL)).log();
            }
            if (uRL == null) {
                throw new IOException("Could not get driver download url for version " + versionNumber);
            }
            String string2 = de.qfs.apps.qftest.shared.web.chrome.ChromeBrowserInfo$a.a(uRL, '_');
            if (r.level >= 9) {
                ((LevelAwareLogBuilder)r.lvlBuild(9, "ChromeDriverDownloader.downloadVersionToDir(WebBrowserInfo,VersionNumber,File,String)", 1024).add("osSuffix", string2)).log();
            }
            if (!Misc.emptyOrNull((String)string2)) {
                file = new File(file, string2);
                if (r.level >= 9) {
                    ((LevelAwareLogBuilder)r.lvlBuild(9, "ChromeDriverDownloader.downloadVersionToDir(WebBrowserInfo,VersionNumber,File,String)", 1028).add("targetDir", (Object)file)).log();
                }
            }
            de.qfs.apps.qftest.shared.web.chrome.ChromeBrowserInfo$a.a(webBrowserInfo, file, string, uRL, this.b(uRL), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void a(WebBrowserInfo webBrowserInfo, File file, String string, URL uRL, String string2, boolean bl) throws IOException {
            if (r.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)r.lvlBuild(7, "ChromeDriverDownloader.downloadToDirAndSetExecutable(WebBrowserInfo,File,String,URL,String,boolean)", 1037).addDetail("info", (Object)webBrowserInfo)).addDetail("targetDir", (Object)file)).addDetail("driverFileName", string)).addDetail("url", (Object)uRL)).addDetail("fileName", string2)).addDetail("flatExtract", bl)).log();
            }
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new IOException("Cannot create directory " + file);
            }
            assert (file.isDirectory());
            boolean bl2 = false;
            try {
                DefaultNotificationCenter.instance().postNotification("WebBrowserInfo.download.start", (Object)webBrowserInfo, new Object[]{"url", uRL, "targetDir", file, "driverFileName", string});
                URLConnection uRLConnection = uRL.openConnection();
                int n2 = de.qfs.apps.qftest.shared.web.chrome.a.d;
                int n3 = Math.max(n2 / 4, 1000);
                uRLConnection.setConnectTimeout(n3);
                uRLConnection.setReadTimeout(Math.max(5000, n2 - n3 - 15000));
                uRLConnection.connect();
                int n4 = uRLConnection.getContentLength();
                if (r.level >= 9) {
                    ((LevelAwareLogBuilder)r.lvlBuild(9, "ChromeDriverDownloader.downloadToDirAndSetExecutable(WebBrowserInfo,File,String,URL,String,boolean)", 1066).add("contentLength", n4)).log();
                }
                File file2 = new File(file, string2);
                Files.deleteIfExists(file2.toPath());
                int n5 = 0;
                try (Object object = uRLConnection.getInputStream();
                     FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                    byte[] byArray = new byte[16384];
                    while (true) {
                        int n6;
                        if ((n6 = ((InputStream)object).read(byArray)) <= 0) {
                            if (r.level >= 9) {
                                ((LevelAwareLogBuilder)r.lvlBuild(9, "ChromeDriverDownloader.downloadToDirAndSetExecutable(WebBrowserInfo,File,String,URL,String,boolean)", 1078).add("Download done")).log();
                            }
                            break;
                        }
                        fileOutputStream.write(byArray, 0, n6);
                        n5 += n6;
                    }
                }
                if (n4 >= 0 && n5 != n4) {
                    if (r.level >= 3) {
                        ((LevelAwareLogBuilder)r.lvlBuild(3, "ChromeDriverDownloader.downloadToDirAndSetExecutable(WebBrowserInfo,File,String,URL,String,boolean)", 1089).add("nread", n5)).log();
                    }
                    Files.deleteIfExists(file2.toPath());
                    throw new IOException("Error: Download not completed");
                }
                if (string2.endsWith(".zip")) {
                    if (r.level >= 9) {
                        ((LevelAwareLogBuilder)r.lvlBuild(9, "ChromeDriverDownloader.downloadToDirAndSetExecutable(WebBrowserInfo,File,String,URL,String,boolean)", 1095).add("Extracting")).log();
                    }
                    object = new FileInputStream(file2);
                    var14_14 = null;
                    try {
                        Util.extractZipToFolder((InputStream)object, file, bl);
                    }
                    catch (Throwable throwable) {
                        var14_14 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object != null) {
                            if (var14_14 != null) {
                                try {
                                    ((InputStream)object).close();
                                }
                                catch (Throwable throwable) {
                                    var14_14.addSuppressed(throwable);
                                }
                            } else {
                                ((InputStream)object).close();
                            }
                        }
                    }
                    Files.deleteIfExists(file2.toPath());
                }
                if (string != null && !Misc.OS_IS_WINDOWS && !((File)(object = new File(file, string))).setExecutable(true)) {
                    throw new IOException("Could not set file executable: " + object);
                }
                bl2 = true;
            }
            catch (Throwable throwable) {
                DefaultNotificationCenter.instance().postNotification("WebBrowserInfo.download.end", (Object)webBrowserInfo, new Object[]{"url", uRL, "targetDir", file, "driverFileName", string, "success", bl2});
                throw throwable;
            }
            DefaultNotificationCenter.instance().postNotification("WebBrowserInfo.download.end", (Object)webBrowserInfo, new Object[]{"url", uRL, "targetDir", file, "driverFileName", string, "success", bl2});
        }

        @Nullable
        protected static String a(URL uRL, char c2) {
            if (r.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)r.lvlBuild(7, "ChromeDriverDownloader.getOsSuffixFromUrl(URL,char)", 1124).addDetail("url", (Object)uRL)).addDetail("separatorChar", c2)).log();
            }
            String string = uRL.getFile();
            int n2 = string.lastIndexOf(46);
            int n3 = string.lastIndexOf(c2);
            if (r.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)r.lvlBuild(9, "ChromeDriverDownloader.getOsSuffixFromUrl(URL,char)", 1129).add("filename", string)).add("dotIndex", n2)).add("underscoreIndex", n3)).log();
            }
            if (n2 == -1) {
                n2 = string.length();
                if (r.level >= 9) {
                    ((LevelAwareLogBuilder)r.lvlBuild(9, "ChromeDriverDownloader.getOsSuffixFromUrl(URL,char)", 1133).add("dotIndex", n2)).log();
                }
            }
            if (n3 > -1 && n3 < n2 - 1) {
                return string.substring(n3 + 1, n2);
            }
            return null;
        }

        public String d() {
            if (r.level >= 7) {
                r.lvlBuild(7, "ChromeDriverDownloader.getNextPageMarker()", 748).log();
            }
            return this.f;
        }

        public String e() {
            if (r.level >= 7) {
                r.lvlBuild(7, "ChromeDriverDownloader.getNextPageMarkerKeyName()", 749).log();
            }
            return this.g;
        }
    }

    public static interface b {
        @Nullable
        public VersionNumber a(VersionNumber var1) throws IOException;

        @Nullable
        public URL b(@Nullable VersionNumber var1) throws IOException;

        public void a(WebBrowserInfo var1, VersionNumber var2, File var3, @Nullable String var4) throws IOException;

        default public String b(URL uRL) {
            if (r.level >= 7) {
                ((LevelAwareLogBuilder)r.lvlBuild(7, "DriverDownloader.getDownloadedFileName(URL)", 713).addDetail("url", (Object)uRL)).log();
            }
            String[] stringArray = uRL.toString().split("/|=");
            return stringArray[stringArray.length - 1];
        }

        default public InputStream a(URL uRL, int n2, int n3) throws IOException {
            if (r.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)r.lvlBuild(7, "DriverDownloader.openStreamWithTimeout(URL,int,int)", 718).addDetail("url", (Object)uRL)).addDetail("connectionTimeout", n2)).addDetail("readTimeout", n3)).log();
            }
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(n2);
            uRLConnection.setReadTimeout(n3);
            InputStream inputStream = uRLConnection.getInputStream();
            return inputStream;
        }
    }
}

