/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.web.electron;

import de.qfs.apps.qftest.shared.Globals;
import de.qfs.apps.qftest.shared.web.ConnectionMode;
import de.qfs.apps.qftest.shared.web.WebBrowserInfo;
import de.qfs.apps.qftest.shared.web.chrome.ChromeBrowserInfo;
import de.qfs.lib.json.Json;
import de.qfs.lib.json.JsonObject;
import de.qfs.lib.json.JsonValue;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.notifications.DefaultNotificationCenter;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.StringOption;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.ProcessManager;
import de.qfs.lib.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ElectronBrowserInfo
extends ChromeBrowserInfo {
    private static final QFLogger B = new QFLogger("de.qfs.apps.qftest.shared.web.electron.ElectronBrowserInfo");
    final String r = "Electron";
    final String s = "electron";
    final List t = Collections.emptyList();
    final File u = null;
    public static final VersionNumber LAST_COMMON_DRIVER_VERSION = new VersionNumber(Integer.valueOf(2));
    private static final String C = "electron-chromedrivers";
    final String v = "https://github.com/electron/electron/releases/";
    static final String w = "v%s";
    static final String x = "v%s-beta.%d";
    VersionNumber y;
    b z;
    a A;

    public ElectronBrowserInfo() {
        if (ElectronBrowserInfo.B.level >= 7) {
            B.lvlBuild(7, "ElectronBrowserInfo.ElectronBrowserInfo()", 59).log();
        }
    }

    @Override
    public JsonValue asJsonValue() {
        if (ElectronBrowserInfo.B.level >= 7) {
            B.lvlBuild(7, "asJsonValue()", 192).log();
        }
        JsonObject jsonObject = (JsonObject)super.asJsonValue();
        if (this.y != null) {
            jsonObject.add("nodeVersion", this.y.asJsonValue());
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ElectronBrowserInfo detectElectronVersion() {
        block36: {
            if (ElectronBrowserInfo.B.level >= 7) {
                B.lvlBuild(7, "detectElectronVersion()", 207).log();
            }
            if (this.i == null || !this.i.exists()) {
                return null;
            }
            String string = System.getProperty("qftest.web.electron.version", null);
            if (!Misc.emptyOrNull((String)string)) {
                try {
                    this.z = b.a(string);
                    this.j = this.z.e;
                    return this;
                }
                catch (Exception exception) {
                    if (ElectronBrowserInfo.B.level < 5) break block36;
                    ((LevelAwareLogBuilder)B.lvlBuild(5, "detectElectronVersion()", 219).add("ex", (Object)exception)).log();
                }
            }
        }
        File file = null;
        try {
            Object object;
            block37: {
                file = File.createTempFile("electronversion-", ".txt");
                if (ElectronBrowserInfo.B.level >= 9) {
                    ((LevelAwareLogBuilder)B.lvlBuild(9, "detectElectronVersion()", 226).add("tempFile", (Object)file)).log();
                }
                file.setWritable(true);
                try {
                    object = Json.value((String)file.getAbsolutePath()).toString().replaceAll("\"", "'");
                    if (ElectronBrowserInfo.B.level >= 9) {
                        ((LevelAwareLogBuilder)B.lvlBuild(9, "detectElectronVersion()", 231).add("jsonPath", (String)object)).log();
                    }
                    ProcessManager.runProcess((String[])new String[]{"ELECTRON_RUN_AS_NODE=1", this.i.getAbsolutePath(), "-p", "require('fs').writeFileSync(" + (String)object + ", JSON.stringify(process.versions))"}, (int)30000);
                }
                catch (ProcessManager.RunProcessException runProcessException) {
                    if (ElectronBrowserInfo.B.level < 9) break block37;
                    ((LevelAwareLogBuilder)B.lvlBuild(9, "detectElectronVersion()", 235).add("e", (Object)runProcessException)).log();
                }
            }
            object = Files.lines(file.toPath());
            Throwable throwable = null;
            try {
                JsonValue jsonValue;
                String string = object.collect(Collectors.joining("")).replaceAll("\n", "");
                if (ElectronBrowserInfo.B.level >= 9) {
                    ((LevelAwareLogBuilder)B.lvlBuild(9, "detectElectronVersion()", 239).add("content", string)).log();
                }
                if (!"".equals(string) && (jsonValue = Json.parse((String)string)) instanceof JsonObject) {
                    JsonObject jsonObject = (JsonObject)jsonValue;
                    JsonValue jsonValue2 = jsonObject.get("electron");
                    JsonValue jsonValue3 = jsonObject.get("node");
                    this.y = VersionNumber.fromString((String)jsonValue3.asString());
                    if (jsonValue2 != null) {
                        this.z = b.a(jsonValue2.asString());
                    } else if (jsonValue3 != null) {
                        this.z = b.a(this.getElectronVersionForNodeVersion(this.y).toString());
                    }
                    this.j = this.z.e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        object.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            if (ElectronBrowserInfo.B.level >= 3) {
                ((LevelAwareLogBuilder)B.lvlBuild(3, "detectElectronVersion()", 258).add("e", (Object)exception)).log();
            }
        }
        finally {
            if (file != null) {
                if (ElectronBrowserInfo.B.level >= 10) {
                    if (ElectronBrowserInfo.B.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)B.lvlBuild(9, "detectElectronVersion()", 262).add("Keep temp file for debugging purposes")).add("tempFile", (Object)file)).log();
                    }
                } else {
                    file.delete();
                }
            }
        }
        return this;
    }

    @Override
    @Nullable
    protected WebBrowserInfo b() {
        block5: {
            if (ElectronBrowserInfo.B.level >= 7) {
                B.lvlBuild(7, "detectExecutableVersion()", 276).log();
            }
            if (ElectronBrowserInfo.B.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)B.lvlBuild(9, "detectExecutableVersion()", 278).add("nodeVersion", (Object)this.y)).add("electronVersion", (Object)this.z)).add("executableVersion", (Object)this.j)).log();
            }
            try {
                DefaultNotificationCenter.instance().postNotification("WebBrowserInfo.versiondetect.start", (Object)this, new Object[]{"executable", this.i});
                if (this.y != null && this.z != null && this.j != null) break block5;
                this.detectElectronVersion();
                if (ElectronBrowserInfo.B.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)B.lvlBuild(9, "detectExecutableVersion()", 284).add("nodeVersion", (Object)this.y)).add("executableVersion", (Object)this.j)).add("electronVersion", (Object)this.z)).log();
                }
            }
            catch (Throwable throwable) {
                DefaultNotificationCenter.instance().postNotification("WebBrowserInfo.versiondetect.end", (Object)this, new Object[]{"executable", this.i});
                throw throwable;
            }
        }
        DefaultNotificationCenter.instance().postNotification("WebBrowserInfo.versiondetect.end", (Object)this, new Object[]{"executable", this.i});
        return this;
    }

    @Override
    public WebBrowserInfo findDefaultDriver() throws IOException {
        if (ElectronBrowserInfo.B.level >= 7) {
            B.lvlBuild(7, "findDefaultDriver()", 296).log();
        }
        this.detectElectronVersion();
        if (this.z != null) {
            this.setDriverVersion(this.z.e());
        }
        super.findDefaultDriver();
        return this;
    }

    @Override
    protected File a(VersionNumber versionNumber, File file) {
        if (ElectronBrowserInfo.B.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)B.lvlBuild(7, "getExactChromeDriverPath(VersionNumber,File)", 311).addDetail("chromeDriverVersion", (Object)versionNumber)).addDetail("chromedriversVersionDir", (Object)file)).log();
        }
        File file2 = new File(file, versionNumber.getOriginalVersionString());
        if (ElectronBrowserInfo.B.level >= 9) {
            ((LevelAwareLogBuilder)B.lvlBuild(9, "getExactChromeDriverPath(VersionNumber,File)", 315).add("exactDriverPath", (Object)file2)).log();
        }
        return file2;
    }

    @Nullable
    public VersionNumber getElectronVersionForNodeVersion(VersionNumber versionNumber) {
        if (ElectronBrowserInfo.B.level >= 7) {
            ((LevelAwareLogBuilder)B.lvlBuild(7, "getElectronVersionForNodeVersion(VersionNumber)", 323).addDetail("nodeVersion", (Object)versionNumber)).log();
        }
        if (versionNumber == null) {
            throw new IllegalArgumentException("nodeVersion is marked non-null but is null");
        }
        for (b b2 : b.h) {
            if (versionNumber.compareTo(b2.c()) < 0) continue;
            return b2.b();
        }
        return null;
    }

    @Override
    protected boolean c(VersionNumber versionNumber) {
        if (ElectronBrowserInfo.B.level >= 7) {
            ((LevelAwareLogBuilder)B.lvlBuild(7, "expectedDriverIsBundled(VersionNumber)", 337).addDetail("expectedDriverVersion", (Object)versionNumber)).log();
        }
        return false;
    }

    @Override
    @Nullable
    protected VersionNumber a(VersionNumber versionNumber) {
        if (ElectronBrowserInfo.B.level >= 7) {
            ((LevelAwareLogBuilder)B.lvlBuild(7, "mapExecutableVersionToDriverVersion(VersionNumber)", 350).addDetail("executableVersion", (Object)versionNumber)).log();
        }
        if (versionNumber == null) {
            throw new IllegalArgumentException("executableVersion is marked non-null but is null");
        }
        for (b b2 : b.h) {
            int n2 = versionNumber.compareTo(b2.b());
            if (ElectronBrowserInfo.B.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)B.lvlBuild(9, "mapExecutableVersionToDriverVersion(VersionNumber)", 354).add("executableVersion", (Object)versionNumber)).add("version", (Object)b2)).add("compare", n2)).log();
            }
            if (n2 < 0) continue;
            VersionNumber versionNumber2 = b2.e();
            if (ElectronBrowserInfo.B.level >= 9) {
                ((LevelAwareLogBuilder)B.lvlBuild(9, "mapExecutableVersionToDriverVersion(VersionNumber)", 358).add("chromeDriverVersion", (Object)versionNumber2)).log();
            }
            if (versionNumber2 == null) {
                return versionNumber;
            }
            return versionNumber2;
        }
        return versionNumber;
    }

    @Override
    protected String b(VersionNumber versionNumber) {
        if (ElectronBrowserInfo.B.level >= 7) {
            ((LevelAwareLogBuilder)B.lvlBuild(7, "getDriverDirName(VersionNumber)", 373).addDetail("driverVersion", (Object)versionNumber)).log();
        }
        if (versionNumber == null) {
            throw new IllegalArgumentException("driverVersion is marked non-null but is null");
        }
        if (versionNumber.compareTo(LAST_COMMON_DRIVER_VERSION, LAST_COMMON_DRIVER_VERSION.getSignificantDigits()) <= 0) {
            return super.b(versionNumber);
        }
        return C;
    }

    @Override
    protected ChromeBrowserInfo.b a(VersionNumber versionNumber, VersionNumber versionNumber2) throws IOException {
        if (ElectronBrowserInfo.B.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)B.lvlBuild(7, "getDriverDownloaderForVersion(VersionNumber,VersionNumber)", 386).addDetail("executableVersion", (Object)versionNumber)).addDetail("expectedDriverVersion", (Object)versionNumber2)).log();
        }
        if (versionNumber == null) {
            throw new IllegalArgumentException("executableVersion is marked non-null but is null");
        }
        if (versionNumber2 == null) {
            throw new IllegalArgumentException("expectedDriverVersion is marked non-null but is null");
        }
        if (versionNumber2.compareTo(LAST_COMMON_DRIVER_VERSION, LAST_COMMON_DRIVER_VERSION.getSignificantDigits()) <= 0) {
            return super.a(versionNumber, versionNumber2);
        }
        return this.h();
    }

    protected synchronized a h() throws IOException {
        if (ElectronBrowserInfo.B.level >= 7) {
            B.lvlBuild(7, "getElectronChromeDriverDownloader()", 398).log();
        }
        if (this.A != null) {
            return this.A;
        }
        this.A = new a();
        return this.A;
    }

    public static void main(String[] stringArray) {
        if (ElectronBrowserInfo.B.level >= 7) {
            ((LevelAwareLogBuilder)B.lvlBuild(7, "main(String[])", 522).addDetail("args", (Object)stringArray)).log();
        }
        Globals.addGlobal((Option)new StringOption("qftestversiondir", "/Users/pascal/qfs_drives/H/prj/install/qftest/qftest-master"));
        ElectronBrowserInfo electronBrowserInfo = new ElectronBrowserInfo();
        electronBrowserInfo.setBrowserDir("/data/common/electron/CarConfig 5.0.0-beta.2.app");
        electronBrowserInfo.findExecutable().assureExecutableVersion();
        try {
            electronBrowserInfo.setupDriver();
        }
        catch (IOException iOException) {
            if (ElectronBrowserInfo.B.level >= 3) {
                ((LevelAwareLogBuilder)B.lvlBuild(3, "main(String[])", 537).add("e", (Object)iOException)).log();
            }
            System.out.println(iOException.getMessage());
        }
        System.out.println(electronBrowserInfo.asJsonValue());
    }

    @Override
    public boolean supportsConnectionMode(ConnectionMode connectionMode) {
        VersionNumber versionNumber;
        if (ElectronBrowserInfo.B.level >= 7) {
            ((LevelAwareLogBuilder)B.lvlBuild(7, "supportsConnectionMode(ConnectionMode)", 547).addDetail("connectionMode", (Object)connectionMode)).log();
        }
        if (connectionMode == ConnectionMode.QFDRIVER) {
            return false;
        }
        return connectionMode != ConnectionMode.CDPDRIVER || (versionNumber = this.getExecutableVersion()) == null || versionNumber.getMajor() >= 76;
    }

    @Override
    public String toString() {
        if (ElectronBrowserInfo.B.level >= 7) {
            B.lvlBuild(7, "toString()", 58).log();
        }
        return "ElectronBrowserInfo(super=" + super.toString() + ", browserName=" + this.getBrowserName() + ", simpleBrowserName=" + this.getSimpleBrowserName() + ", binaryNames=" + this.getBinaryNames() + ", binaryFromDefaultPaths=" + this.getBinaryFromDefaultPaths() + ", driverDownloadHomepage=" + this.getDriverDownloadHomepage() + ", nodeVersion=" + this.getNodeVersion() + ", electronVersion=" + this.getElectronVersion() + ", electronDownloader=" + this.A + ")";
    }

    @Override
    public String getBrowserName() {
        if (ElectronBrowserInfo.B.level >= 7) {
            B.lvlBuild(7, "getBrowserName()", 64).log();
        }
        return this.r;
    }

    @Override
    public String getSimpleBrowserName() {
        if (ElectronBrowserInfo.B.level >= 7) {
            B.lvlBuild(7, "getSimpleBrowserName()", 65).log();
        }
        return this.s;
    }

    @Override
    public List getBinaryNames() {
        if (ElectronBrowserInfo.B.level >= 7) {
            B.lvlBuild(7, "getBinaryNames()", 66).log();
        }
        return this.t;
    }

    @Override
    public File getBinaryFromDefaultPaths() {
        if (ElectronBrowserInfo.B.level >= 7) {
            B.lvlBuild(7, "getBinaryFromDefaultPaths()", 67).log();
        }
        return this.u;
    }

    @Override
    public String getDriverDownloadHomepage() {
        if (ElectronBrowserInfo.B.level >= 7) {
            B.lvlBuild(7, "getDriverDownloadHomepage()", 72).log();
        }
        return this.v;
    }

    public VersionNumber getNodeVersion() {
        if (ElectronBrowserInfo.B.level >= 7) {
            B.lvlBuild(7, "getNodeVersion()", 182).log();
        }
        return this.y;
    }

    public ElectronBrowserInfo setNodeVersion(VersionNumber versionNumber) {
        if (ElectronBrowserInfo.B.level >= 7) {
            ((LevelAwareLogBuilder)B.lvlBuild(7, "setNodeVersion(VersionNumber)", 182).addDetail("nodeVersion", (Object)versionNumber)).log();
        }
        this.y = versionNumber;
        return this;
    }

    public b getElectronVersion() {
        if (ElectronBrowserInfo.B.level >= 7) {
            B.lvlBuild(7, "getElectronVersion()", 183).log();
        }
        return this.z;
    }

    public ElectronBrowserInfo setElectronVersion(b b2) {
        if (ElectronBrowserInfo.B.level >= 7) {
            ((LevelAwareLogBuilder)B.lvlBuild(7, "setElectronVersion(ElectronVersion)", 183).addDetail("electronVersion", (Object)b2)).log();
        }
        this.z = b2;
        return this;
    }

    protected static class a
    implements ChromeBrowserInfo.b {
        static final String a = "https://github.com/electron/electron/releases/download/%1$s/chromedriver-%1$s-%2$s-%3$s.zip";

        public a() throws IOException {
            if (B.level >= 7) {
                B.lvlBuild(7, "ElectronChromeDriverDownloader.ElectronChromeDriverDownloader()", 419).log();
            }
        }

        @Override
        public VersionNumber a(VersionNumber versionNumber) {
            if (B.level >= 7) {
                ((LevelAwareLogBuilder)B.lvlBuild(7, "ElectronChromeDriverDownloader.getBestMatchingVersion(VersionNumber)", 450).addDetail("driverVersion", (Object)versionNumber)).log();
            }
            if (versionNumber == null) {
                throw new IllegalArgumentException("driverVersion is marked non-null but is null");
            }
            return versionNumber;
        }

        public String c(VersionNumber versionNumber) {
            if (B.level >= 7) {
                ((LevelAwareLogBuilder)B.lvlBuild(7, "ElectronChromeDriverDownloader.getTagNameForVersionNumber(VersionNumber)", 458).addDetail("driverVersion", (Object)versionNumber)).log();
            }
            if (versionNumber == null) {
                throw new IllegalArgumentException("driverVersion is marked non-null but is null");
            }
            String string = String.format(ElectronBrowserInfo.w, versionNumber.getOriginalVersionString());
            if (B.level >= 9) {
                ((LevelAwareLogBuilder)B.lvlBuild(9, "ElectronChromeDriverDownloader.getTagNameForVersionNumber(VersionNumber)", 461).add("tagName", string)).log();
            }
            return string;
        }

        public URL a(String string) {
            String string2;
            if (B.level >= 7) {
                ((LevelAwareLogBuilder)B.lvlBuild(7, "ElectronChromeDriverDownloader.getURLForTagName(String)", 469).addDetail("tag", string)).log();
            }
            if (string == null) {
                throw new IllegalArgumentException("tag is marked non-null but is null");
            }
            String string3 = Misc.OS_IS_MAC_OS_X ? "darwin" : (Misc.OS_IS_LINUX ? "linux" : "win32");
            String string4 = string2 = Misc.isSystemWith64Bit() ? "x64" : "ia32";
            if (B.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)B.lvlBuild(9, "ElectronChromeDriverDownloader.getURLForTagName(String)", 473).add("tag", string)).add("osString", string3)).add("bitnessSuffix", string2)).log();
            }
            String string5 = String.format(a, string, string3, string2);
            if (B.level >= 9) {
                ((LevelAwareLogBuilder)B.lvlBuild(9, "ElectronChromeDriverDownloader.getURLForTagName(String)", 476).add("urlString", string5)).log();
            }
            try {
                return new URL(string5);
            }
            catch (MalformedURLException malformedURLException) {
                if (B.level >= 3) {
                    ((LevelAwareLogBuilder)B.lvlBuild(3, "ElectronChromeDriverDownloader.getURLForTagName(String)", 481).add("e", (Object)malformedURLException)).log();
                }
                return null;
            }
        }

        @Override
        public URL b(@Nullable VersionNumber versionNumber) {
            if (B.level >= 7) {
                ((LevelAwareLogBuilder)B.lvlBuild(7, "ElectronChromeDriverDownloader.getURLForVersion(VersionNumber)", 490).addDetail("version", (Object)versionNumber)).log();
            }
            if (versionNumber == null) {
                return null;
            }
            String string = this.c(versionNumber);
            return this.a(string);
        }

        @Override
        public void a(WebBrowserInfo webBrowserInfo, VersionNumber versionNumber, File file, String string) throws IOException {
            if (B.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)B.lvlBuild(7, "ElectronChromeDriverDownloader.downloadVersionToDir(WebBrowserInfo,VersionNumber,File,String)", 502).addDetail("info", (Object)webBrowserInfo)).addDetail("version", (Object)versionNumber)).addDetail("targetDir", (Object)file)).addDetail("driverFileName", string)).log();
            }
            URL uRL = this.b(versionNumber);
            if (B.level >= 9) {
                ((LevelAwareLogBuilder)B.lvlBuild(9, "ElectronChromeDriverDownloader.downloadVersionToDir(WebBrowserInfo,VersionNumber,File,String)", 506).add("url", (Object)uRL)).log();
            }
            file = ElectronBrowserInfo.f(file);
            if (B.level >= 9) {
                ((LevelAwareLogBuilder)B.lvlBuild(9, "ElectronChromeDriverDownloader.downloadVersionToDir(WebBrowserInfo,VersionNumber,File,String)", 509).add("targetDir", (Object)file)).log();
            }
            ChromeBrowserInfo.a.a(webBrowserInfo, file, string, uRL, this.b(uRL), false);
        }
    }

    public static class b {
        static final b[] a = new b[]{new b("1.7.x", "7.9.0", "58", "2.31"), new b("1.8.x", "8.2.1", "59", "2.32"), new b("2.x", "8.9.3", "61", Misc.OS_IS_LINUX && !Misc.JAVA_IS_64_BIT ? "2.30" : "2.33"), new b("3.x", "10.2.0", "66", "2.37"), new b("4.x", "10.11.0", "69", "2.37"), new b("5.x", "12.0.0", "73", "5.0.0"), new b("6.x", "999", "2147483647", null)};
        public static final String b = "autodetect";
        final VersionNumber c;
        final VersionNumber d;
        final VersionNumber e;
        @Nullable
        final VersionNumber f;
        @Nullable
        String g;
        static final b[] h = de.qfs.apps.qftest.shared.web.electron.ElectronBrowserInfo$b.h();

        public b(String string, String string2, String string3, String string4) {
            if (B.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)B.lvlBuild(7, "ElectronVersion.ElectronVersion(String,String,String,String)", 112).addDetail("versionString", string)).addDetail("nodeVersionString", string2)).addDetail("chromeVersionString", string3)).addDetail("chromeDriverVersionString", string4)).log();
            }
            this.c = VersionNumber.fromString((String)string);
            this.d = VersionNumber.fromString((String)string2);
            this.e = VersionNumber.fromString((String)string3);
            this.f = string4 == null ? null : VersionNumber.fromString((String)string4);
        }

        private static b[] h() {
            if (B.level >= 7) {
                B.lvlBuild(7, "ElectronVersion.createReverseValues()", 130).log();
            }
            b[] bArray = (b[])a.clone();
            for (int i2 = 0; i2 < bArray.length / 2; ++i2) {
                b b2 = bArray[i2];
                bArray[i2] = bArray[bArray.length - i2 - 1];
                bArray[bArray.length - i2 - 1] = b2;
            }
            return bArray;
        }

        public static b a(String string) {
            if (B.level >= 7) {
                ((LevelAwareLogBuilder)B.lvlBuild(7, "ElectronVersion.createVersion(String)", 142).addDetail("electronVersionString", string)).log();
            }
            VersionNumber versionNumber = VersionNumber.fromString((String)string);
            for (b b2 : h) {
                String string2;
                if (versionNumber.compareTo(b2.c) < 0) continue;
                String string3 = de.qfs.apps.qftest.shared.web.electron.ElectronBrowserInfo$b.a(string, b2);
                String string4 = string2 = b2.b().compareTo(new VersionNumber(Integer.valueOf(6))) >= 0 ? string : b2.b().getOriginalVersionString();
                if ("6.x".equals(string2)) {
                    string2 = "6.0.0";
                }
                b b3 = new b(string2, b2.c().toString(), b2.d().toString(), string3);
                return b3;
            }
            return new b(string, null, null, string);
        }

        protected static String a(String string, b b2) {
            if (B.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)B.lvlBuild(7, "ElectronVersion.getCorrectChromeDriver(String,ElectronVersion)", 167).addDetail("electronVersionString", string)).addDetail("defaultVersion", (Object)b2)).log();
            }
            if (b2.e() == null) {
                return string;
            }
            return b2.e().getOriginalVersionString();
        }

        public String toString() {
            if (B.level >= 7) {
                B.lvlBuild(7, "ElectronVersion.toString()", 80).log();
            }
            return "ElectronBrowserInfo.ElectronVersion(number=" + this.b() + ", nodeVersion=" + this.c() + ", chromeVersion=" + this.d() + ", chromeDriverVersion=" + this.e() + ", parsedVersion=" + this.f() + ")";
        }

        public static b[] a() {
            if (B.level >= 7) {
                B.lvlBuild(7, "ElectronVersion.getValues()", 86).log();
            }
            return a;
        }

        public VersionNumber b() {
            if (B.level >= 7) {
                B.lvlBuild(7, "ElectronVersion.getNumber()", 97).log();
            }
            return this.c;
        }

        public VersionNumber c() {
            if (B.level >= 7) {
                B.lvlBuild(7, "ElectronVersion.getNodeVersion()", 100).log();
            }
            return this.d;
        }

        public VersionNumber d() {
            if (B.level >= 7) {
                B.lvlBuild(7, "ElectronVersion.getChromeVersion()", 103).log();
            }
            return this.e;
        }

        @Nullable
        public VersionNumber e() {
            if (B.level >= 7) {
                B.lvlBuild(7, "ElectronVersion.getChromeDriverVersion()", 106).log();
            }
            return this.f;
        }

        @Nullable
        public String f() {
            if (B.level >= 7) {
                B.lvlBuild(7, "ElectronVersion.getParsedVersion()", 109).log();
            }
            return this.g;
        }

        public b b(@Nullable String string) {
            if (B.level >= 7) {
                ((LevelAwareLogBuilder)B.lvlBuild(7, "ElectronVersion.setParsedVersion(String)", 109).addDetail("parsedVersion", string)).log();
            }
            this.g = string;
            return this;
        }

        public static b[] g() {
            if (B.level >= 7) {
                B.lvlBuild(7, "ElectronVersion.getReverseValues()", 127).log();
            }
            return h;
        }
    }
}

