/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.web.electron;

import de.qfs.apps.qftest.shared.Globals;
import de.qfs.apps.qftest.shared.web.electron.ElectronBrowserInfo;
import de.qfs.lib.gui.Message;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.VersionNumber;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.annotation.Nullable;

public class ElectronChecker {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.shared.web.electron.ElectronChecker");

    public ElectronChecker() {
        if (ElectronChecker.a.level >= 7) {
            a.lvlBuild(7, "ElectronChecker.ElectronChecker()", 37).log();
        }
    }

    @Nullable
    public static String getChromeDriverVersion(String string) {
        if (ElectronChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getChromeDriverVersion(String)", 42).addDetail("electronVersionString", string)).log();
        }
        VersionNumber versionNumber = VersionNumber.fromString((String)string);
        ElectronBrowserInfo electronBrowserInfo = new ElectronBrowserInfo();
        electronBrowserInfo.setExecutableVersion(versionNumber);
        VersionNumber versionNumber2 = electronBrowserInfo.getDriverVersionForExecutableVersion(versionNumber);
        return versionNumber2 == null ? "" : versionNumber2.toString();
    }

    @Nullable
    public static ElectronBrowserInfo.b detectElectronVersion(String string) {
        if (ElectronChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "detectElectronVersion(String)", 64).addDetail("appPath", string)).log();
        }
        ElectronBrowserInfo electronBrowserInfo = new ElectronBrowserInfo();
        electronBrowserInfo.setExecutable(new File(string));
        electronBrowserInfo.detectElectronVersion();
        ElectronBrowserInfo.b b2 = electronBrowserInfo.getElectronVersion();
        if (ElectronChecker.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "detectElectronVersion(String)", 70).add("detectedElectronVersion", (Object)b2)).log();
        }
        return b2;
    }

    @Nullable
    public static File getChromeDriverPath(String string, boolean bl) throws IllegalArgumentException {
        if (ElectronChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getChromeDriverPath(String,boolean)", 78).addDetail("chromeDriverVersion", string)).addDetail("download", bl)).log();
        }
        return ElectronChecker.getChromeDriverPath(string, bl, null);
    }

    @Nullable
    public static File getChromeDriverPath(String string, boolean bl, Component component) {
        if (ElectronChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getChromeDriverPath(String,boolean,Component)", 89).addDetail("chromeDriverVersionString", string)).addDetail("download", bl)).addDetail("dialog", (Object)component)).log();
        }
        if ("0".equals(string)) {
            return null;
        }
        VersionNumber versionNumber = VersionNumber.fromString((String)string);
        ElectronBrowserInfo electronBrowserInfo = new ElectronBrowserInfo();
        electronBrowserInfo.setDriverVersion(versionNumber);
        try {
            if (bl) {
                electronBrowserInfo.findDefaultDriver();
            }
            if (ElectronChecker.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getChromeDriverPath(String,boolean,Component)", 104).add("info", (Object)electronBrowserInfo)).log();
            }
            return electronBrowserInfo.getExpectedDriverDir(true);
        }
        catch (Exception exception) {
            if (Globals.getGlobalBoolean("interactive", false)) {
                URL uRL;
                try {
                    uRL = electronBrowserInfo.getDriverDownloadUrlForVersion(versionNumber, versionNumber);
                }
                catch (IOException iOException) {
                    if (ElectronChecker.a.level >= 5) {
                        ((LevelAwareLogBuilder)a.lvlBuild(5, "getChromeDriverPath(String,boolean,Component)", 112).add("e", (Object)iOException)).log();
                    }
                    uRL = null;
                }
                if (component != null) {
                    Message.showMessage((Component)component, (String)"electron.downloaddriver.failed", (Object[])new String[]{string, uRL == null ? "?" : uRL.toString()});
                }
            } else if (ElectronChecker.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "getChromeDriverPath(String,boolean,Component)", 120).add("Failed to download Chromedriver")).log();
            }
            return null;
        }
    }
}

