/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.web.firefox;

import de.qfs.apps.qftest.shared.Globals;
import de.qfs.apps.qftest.shared.system.IniAccess;
import de.qfs.apps.qftest.shared.system.win32.WinApiAccess;
import de.qfs.apps.qftest.shared.web.BrowserReleaseChannel;
import de.qfs.apps.qftest.shared.web.ConnectionMode;
import de.qfs.apps.qftest.shared.web.WebBrowserInfo;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.notifications.DefaultNotificationCenter;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.StringOption;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public class FirefoxBrowserInfo
extends WebBrowserInfo {
    private static final QFLogger o = new QFLogger("de.qfs.apps.qftest.shared.web.firefox.FirefoxBrowserInfo");
    final String a = "Firefox";
    final String b = "firefox";
    final List c = Misc.listOf((Object[])new String[]{"Firefox", "firefox", "firefox-bin", "Firefox.exe", "Firefox Nightly", "Firefox ESR", "Firefox Beta"});
    final List d = Misc.listOf((Object[])new String[]{"\\Mozilla Firefox", "\\Firefox Nightly", "\\Firefox ESR", "\\Firefox Beta"});
    final String e = "webdriver.gecko.driver";
    final String n = FirefoxBrowserInfo.exeName("geckodriver");
    private final AtomicReference p = new AtomicReference();

    public FirefoxBrowserInfo() {
        if (FirefoxBrowserInfo.o.level >= 7) {
            o.lvlBuild(7, "FirefoxBrowserInfo.FirefoxBrowserInfo()", 53).log();
        }
    }

    @Override
    @Nullable
    protected WebBrowserInfo b() {
        if (FirefoxBrowserInfo.o.level >= 7) {
            o.lvlBuild(7, "detectExecutableVersion()", 76).log();
        }
        if (FirefoxBrowserInfo.o.level >= 9) {
            ((LevelAwareLogBuilder)o.lvlBuild(9, "detectExecutableVersion()", 78).add("executable", (Object)this.i)).log();
        }
        if (this.i == null) {
            return this;
        }
        try {
            DefaultNotificationCenter.instance().postNotification("WebBrowserInfo.versiondetect.start", (Object)this, new Object[]{"executable", this.i});
            VersionNumber versionNumber = this.e(this.i);
            this.setExecutableVersion(versionNumber);
            this.setExecutableChannel(this.a(versionNumber));
        }
        catch (Throwable throwable) {
            DefaultNotificationCenter.instance().postNotification("WebBrowserInfo.versiondetect.end", (Object)this, new Object[]{"executable", this.i});
            throw throwable;
        }
        DefaultNotificationCenter.instance().postNotification("WebBrowserInfo.versiondetect.end", (Object)this, new Object[]{"executable", this.i});
        return this;
    }

    protected VersionNumber e(File file) {
        Object object;
        if (FirefoxBrowserInfo.o.level >= 7) {
            ((LevelAwareLogBuilder)o.lvlBuild(7, "getFirefoxVersion(File)", 100).addDetail("executableFile", (Object)file)).log();
        }
        File file2 = file.getParentFile();
        Object object2 = null;
        File file3 = new File(file2, "application.ini");
        if (file3.exists()) {
            object2 = this.getFirefoxVersionFromIni(file3);
        }
        if (FirefoxBrowserInfo.o.level >= 9) {
            ((LevelAwareLogBuilder)o.lvlBuild(9, "getFirefoxVersion(File)", 110).add("versionNumberString", (String)object2)).log();
        }
        if (object2 == null && (file3 = new File(file2.getParentFile(), "Resources/application.ini")).exists()) {
            object2 = this.getFirefoxVersionFromIni(file3);
        }
        if (FirefoxBrowserInfo.o.level >= 9) {
            ((LevelAwareLogBuilder)o.lvlBuild(9, "getFirefoxVersion(File)", 117).add("versionNumberString", (String)object2)).log();
        }
        if (object2 == null && file.exists()) {
            object = this.a(file, "-version");
            if (FirefoxBrowserInfo.o.level >= 9) {
                ((LevelAwareLogBuilder)o.lvlBuild(9, "getFirefoxVersion(File)", 121).add("output", (String)object)).log();
            }
            if (object != null) {
                object = ((String)object).trim();
                int n2 = ((String)object).lastIndexOf(32);
                if (FirefoxBrowserInfo.o.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)o.lvlBuild(9, "getFirefoxVersion(File)", 125).add("output", (String)object)).add("spaceIndex", n2)).log();
                }
                if (n2 > -1 && n2 < ((String)object).length() - 1) {
                    object = ((String)object).substring(n2 + 1);
                    if (FirefoxBrowserInfo.o.level >= 9) {
                        ((LevelAwareLogBuilder)o.lvlBuild(9, "getFirefoxVersion(File)", 128).add("output", (String)object)).log();
                    }
                }
                object2 = object;
            }
        }
        object = this.c((String)object2);
        return object;
    }

    @Nullable
    public String getFirefoxVersionFromIni(File file) {
        block6: {
            if (FirefoxBrowserInfo.o.level >= 7) {
                ((LevelAwareLogBuilder)o.lvlBuild(7, "getFirefoxVersionFromIni(File)", 142).addDetail("applicationIni", (Object)file)).log();
            }
            if (file == null) {
                throw new IllegalArgumentException("applicationIni is marked non-null but is null");
            }
            try {
                Map map = IniAccess.instance().getIniData(file);
                if (map != null) {
                    String string = (String)((Map)map.get("App")).get("Version");
                    if (FirefoxBrowserInfo.o.level >= 9) {
                        ((LevelAwareLogBuilder)o.lvlBuild(9, "getFirefoxVersionFromIni(File)", 148).add("version", string)).log();
                    }
                    return string;
                }
            }
            catch (Exception exception) {
                if (FirefoxBrowserInfo.o.level < 1) break block6;
                ((LevelAwareLogBuilder)o.lvlBuild(1, "getFirefoxVersionFromIni(File)", 152).add("e", (Object)exception)).log();
            }
        }
        return null;
    }

    @Nullable
    protected VersionNumber c(String string) {
        if (FirefoxBrowserInfo.o.level >= 7) {
            ((LevelAwareLogBuilder)o.lvlBuild(7, "parseVersionNumber(String)", 161).addDetail("versionNumberString", string)).log();
        }
        if (string == null) {
            return null;
        }
        return VersionNumber.fromString((String)string, (String)"[.ab]");
    }

    @Override
    protected BrowserReleaseChannel b(@Nullable File file) {
        if (FirefoxBrowserInfo.o.level >= 7) {
            ((LevelAwareLogBuilder)o.lvlBuild(7, "detectExecutableChannel(File)", 171).addDetail("executable", (Object)file)).log();
        }
        if (file == null) {
            return null;
        }
        VersionNumber versionNumber = this.e(file);
        return this.a(versionNumber);
    }

    protected BrowserReleaseChannel a(@Nullable VersionNumber versionNumber) {
        if (FirefoxBrowserInfo.o.level >= 7) {
            ((LevelAwareLogBuilder)o.lvlBuild(7, "detectExecutableChannel(VersionNumber)", 181).addDetail("versionNumber", (Object)versionNumber)).log();
        }
        if (versionNumber == null) {
            return null;
        }
        String string = versionNumber.getOriginalVersionString();
        if (!Misc.emptyOrNull((String)string)) {
            if (string.contains("esr")) {
                return BrowserReleaseChannel.ESR;
            }
            if (string.contains("a")) {
                return BrowserReleaseChannel.DEV;
            }
            if (string.contains("b")) {
                return BrowserReleaseChannel.BETA;
            }
        }
        return BrowserReleaseChannel.STABLE;
    }

    @Override
    public WebBrowserInfo setExecutableChannel(BrowserReleaseChannel browserReleaseChannel) {
        if (FirefoxBrowserInfo.o.level >= 7) {
            ((LevelAwareLogBuilder)o.lvlBuild(7, "setExecutableChannel(BrowserReleaseChannel)", 201).addDetail("executableChannel", (Object)browserReleaseChannel)).log();
        }
        if (browserReleaseChannel == BrowserReleaseChannel.CANARY) {
            browserReleaseChannel = BrowserReleaseChannel.DEV;
        }
        return super.setExecutableChannel(browserReleaseChannel);
    }

    @Override
    protected void b(LinkedList linkedList) {
        if (FirefoxBrowserInfo.o.level >= 7) {
            ((LevelAwareLogBuilder)o.lvlBuild(7, "addWindowsExecutableDefaultPaths(LinkedList<String>)", 213).addDetail("defaultPaths", (Object)linkedList)).log();
        }
        linkedList.addAll(this.getWindowsInstallDirs());
        super.b(linkedList);
    }

    @Nullable
    private List e() {
        LinkedList<String> linkedList;
        block17: {
            if (FirefoxBrowserInfo.o.level >= 7) {
                o.lvlBuild(7, "determineWindowsInstallDirs()", 223).log();
            }
            linkedList = new LinkedList<String>();
            try {
                for (String string : new String[]{"HKEY_LOCAL_MACHINE\\SOFTWARE", "HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node"}) {
                    Object object;
                    String string2 = null;
                    String string3 = string + "\\mozilla.org\\Mozilla";
                    if (FirefoxBrowserInfo.o.level >= 9) {
                        ((LevelAwareLogBuilder)o.lvlBuild(9, "determineWindowsInstallDirs()", 231).add("subTree", string3)).log();
                    }
                    if (WinApiAccess.instance().registryKeyExists(string3) && (object = WinApiAccess.instance().registryGetValue(string3, "CurrentVersion")) instanceof String) {
                        string2 = (String)object;
                    }
                    if (FirefoxBrowserInfo.o.level >= 9) {
                        ((LevelAwareLogBuilder)o.lvlBuild(9, "determineWindowsInstallDirs()", 238).add("currentVersion", string2)).log();
                    }
                    object = string + "\\Mozilla";
                    if (FirefoxBrowserInfo.o.level >= 9) {
                        ((LevelAwareLogBuilder)o.lvlBuild(9, "determineWindowsInstallDirs()", 241).add("mozKey", (String)object)).log();
                    }
                    if (!WinApiAccess.instance().registryKeyExists((String)object)) continue;
                    List list = WinApiAccess.instance().registryGetKeys((String)object);
                    Collections.sort(list);
                    Collections.reverse(list);
                    if (FirefoxBrowserInfo.o.level >= 9) {
                        ((LevelAwareLogBuilder)o.lvlBuild(9, "determineWindowsInstallDirs()", 247).add("ffKeys", (Object)list)).log();
                    }
                    for (String string4 : list) {
                        Object object2;
                        boolean bl;
                        boolean bl2 = bl = string4.contains("Firefox") || string4.contains("Nightly");
                        if (FirefoxBrowserInfo.o.level >= 9) {
                            ((LevelAwareLogBuilder)o.lvlBuild(9, "determineWindowsInstallDirs()", 250).add("isFirefox", bl)).log();
                        }
                        if (!bl) continue;
                        boolean bl3 = WinApiAccess.instance().registryKeyExists((String)object + "\\" + string4 + "\\bin");
                        if (FirefoxBrowserInfo.o.level >= 9) {
                            ((LevelAwareLogBuilder)o.lvlBuild(9, "determineWindowsInstallDirs()", 254).add("binDirExists", bl3)).log();
                        }
                        if (!bl3) continue;
                        if (string2 != null) {
                            object2 = WinApiAccess.instance().registryGetValue((String)object + "\\" + string4, "GeckoVer");
                            if (FirefoxBrowserInfo.o.level >= 9) {
                                ((LevelAwareLogBuilder)o.lvlBuild(9, "determineWindowsInstallDirs()", 259).add("thisVersion", object2)).log();
                            }
                            if (!string2.equals(object2)) continue;
                        }
                        object2 = WinApiAccess.instance().registryGetValue((String)object + "\\" + string4 + "\\bin", "PathToExe");
                        if (FirefoxBrowserInfo.o.level >= 9) {
                            ((LevelAwareLogBuilder)o.lvlBuild(9, "determineWindowsInstallDirs()", 266).add("pathToExe", object2)).log();
                        }
                        if (!(object2 instanceof String)) continue;
                        File file = new File((String)object2);
                        boolean bl4 = file.isFile();
                        if (FirefoxBrowserInfo.o.level >= 9) {
                            ((LevelAwareLogBuilder)o.lvlBuild(9, "determineWindowsInstallDirs()", 271).add("isFile", bl4)).log();
                        }
                        if (!bl4) continue;
                        linkedList.add(file.getParent());
                    }
                }
            }
            catch (Exception exception) {
                if (FirefoxBrowserInfo.o.level < 3) break block17;
                ((LevelAwareLogBuilder)o.lvlBuild(3, "determineWindowsInstallDirs()", 280).add("ex", (Object)exception)).log();
            }
        }
        if (FirefoxBrowserInfo.o.level >= 9) {
            ((LevelAwareLogBuilder)o.lvlBuild(9, "determineWindowsInstallDirs()", 282).add("result", linkedList)).log();
        }
        return linkedList;
    }

    @Override
    @Nullable
    public WebBrowserInfo detectDriverVersion() {
        if (FirefoxBrowserInfo.o.level >= 7) {
            o.lvlBuild(7, "detectDriverVersion()", 291).log();
        }
        this.setDriverVersion(this.getVersionByRunningFile(this.k, "--version"));
        return this;
    }

    public static void main(String[] stringArray) {
        if (FirefoxBrowserInfo.o.level >= 7) {
            ((LevelAwareLogBuilder)o.lvlBuild(7, "main(String[])", 302).addDetail("args", (Object)stringArray)).log();
        }
        Globals.addGlobal((Option)new StringOption("qftestversiondir", "/Users/pascal/qfs_drives/H/prj/install/qftest/qftest-build"));
        FirefoxBrowserInfo firefoxBrowserInfo = new FirefoxBrowserInfo();
        firefoxBrowserInfo.setExecutableChannel(BrowserReleaseChannel.CANARY);
        firefoxBrowserInfo.findExecutable();
        try {
            firefoxBrowserInfo.setupDriver();
        }
        catch (IOException iOException) {
            if (FirefoxBrowserInfo.o.level >= 3) {
                ((LevelAwareLogBuilder)o.lvlBuild(3, "main(String[])", 315).add("e", (Object)iOException)).log();
            }
            System.out.println(iOException.getMessage());
        }
        System.out.println(firefoxBrowserInfo.asJsonValue());
    }

    @Override
    public boolean supportsConnectionMode(ConnectionMode connectionMode) {
        if (FirefoxBrowserInfo.o.level >= 7) {
            ((LevelAwareLogBuilder)o.lvlBuild(7, "supportsConnectionMode(ConnectionMode)", 325).addDetail("connectionMode", (Object)connectionMode)).log();
        }
        if (connectionMode == ConnectionMode.CDPDRIVER) {
            return false;
        }
        if (connectionMode == ConnectionMode.QFDRIVER) {
            if (Misc.OS_IS_MAC_OS_X) {
                return false;
            }
            VersionNumber versionNumber = this.getExecutableVersion();
            if (versionNumber != null && versionNumber.getMajor() > 43) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getBrowserName() {
        if (FirefoxBrowserInfo.o.level >= 7) {
            o.lvlBuild(7, "getBrowserName()", 57).log();
        }
        return this.a;
    }

    @Override
    public String getSimpleBrowserName() {
        if (FirefoxBrowserInfo.o.level >= 7) {
            o.lvlBuild(7, "getSimpleBrowserName()", 58).log();
        }
        return this.b;
    }

    @Override
    public List getBinaryNames() {
        if (FirefoxBrowserInfo.o.level >= 7) {
            o.lvlBuild(7, "getBinaryNames()", 59).log();
        }
        return this.c;
    }

    @Override
    public List getWindowsProgramFilesSubdirs() {
        if (FirefoxBrowserInfo.o.level >= 7) {
            o.lvlBuild(7, "getWindowsProgramFilesSubdirs()", 61).log();
        }
        return this.d;
    }

    @Override
    public String getDriverProperty() {
        if (FirefoxBrowserInfo.o.level >= 7) {
            o.lvlBuild(7, "getDriverProperty()", 63).log();
        }
        return this.e;
    }

    @Override
    public String getDriverExecutableName() {
        if (FirefoxBrowserInfo.o.level >= 7) {
            o.lvlBuild(7, "getDriverExecutableName()", 64).log();
        }
        return this.n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getWindowsInstallDirs() {
        Object object;
        if (FirefoxBrowserInfo.o.level >= 7) {
            o.lvlBuild(7, "getWindowsInstallDirs()", 66).log();
        }
        if ((object = this.p.get()) == null) {
            AtomicReference atomicReference = this.p;
            synchronized (atomicReference) {
                object = this.p.get();
                if (object == null) {
                    List list = this.e();
                    object = list == null ? this.p : list;
                    this.p.set(object);
                }
            }
        }
        return object == this.p ? null : object;
    }
}

