/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.sdk.metrics.internal.view.DefaultAggregation;
import io.opentelemetry.sdk.metrics.internal.view.DropAggregation;
import io.opentelemetry.sdk.metrics.internal.view.ExplicitBucketHistogramAggregation;
import io.opentelemetry.sdk.metrics.internal.view.LastValueAggregation;
import io.opentelemetry.sdk.metrics.internal.view.SumAggregation;
import java.util.List;

public interface Aggregation {
    public static Aggregation drop() {
        return DropAggregation.getInstance();
    }

    public static Aggregation defaultAggregation() {
        return DefaultAggregation.getInstance();
    }

    public static Aggregation sum() {
        return SumAggregation.getInstance();
    }

    public static Aggregation lastValue() {
        return LastValueAggregation.getInstance();
    }

    public static Aggregation explicitBucketHistogram() {
        return ExplicitBucketHistogramAggregation.getDefault();
    }

    public static Aggregation explicitBucketHistogram(List<Double> bucketBoundaries) {
        return ExplicitBucketHistogramAggregation.create(bucketBoundaries);
    }
}

