/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerBuilder;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.common.InstrumentationScopeInfoBuilder;
import io.opentelemetry.sdk.internal.ComponentRegistry;
import io.opentelemetry.sdk.trace.SdkTracer;

class SdkTracerBuilder
implements TracerBuilder {
    private final ComponentRegistry<SdkTracer> registry;
    private final InstrumentationScopeInfoBuilder scopeBuilder;

    SdkTracerBuilder(ComponentRegistry<SdkTracer> registry, String instrumentationScopeName) {
        this.registry = registry;
        this.scopeBuilder = InstrumentationScopeInfo.builder(instrumentationScopeName);
    }

    public TracerBuilder setSchemaUrl(String schemaUrl) {
        this.scopeBuilder.setSchemaUrl(schemaUrl);
        return this;
    }

    public TracerBuilder setInstrumentationVersion(String instrumentationScopeVersion) {
        this.scopeBuilder.setVersion(instrumentationScopeVersion);
        return this;
    }

    public Tracer build() {
        return this.registry.get(this.scopeBuilder.build());
    }
}

