/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.ExtensionFileFilter;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Pair;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import lombok.Generated;

public class FileChooser
extends JFileChooser {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qflog.FileChooser");

    public FileChooser() {
        super((File)null, (FileSystemView)null);
        if (FileChooser.logger.level >= 7) {
            logger.lvlBuild(7, "FileChooser()", 73).log();
        }
    }

    public FileChooser(String string) {
        super(string, (FileSystemView)null);
        if (FileChooser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "FileChooser(String)", 92).addDetail("currentDirectoryPath", string)).log();
        }
    }

    public FileChooser(File file) {
        super(file, (FileSystemView)null);
        if (FileChooser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "FileChooser(File)", 111).addDetail("currentDirectory", file)).log();
        }
    }

    public FileChooser(File file, FileSystemView fileSystemView) {
        super(file, fileSystemView);
        if (FileChooser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "FileChooser(File,FileSystemView)", 126).addDetail("currentDirectory", file)).addDetail("fsv", fileSystemView)).log();
        }
    }

    public FileChooser(FileSystemView fileSystemView) {
        super((File)null, fileSystemView);
        if (FileChooser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "FileChooser(FileSystemView)", 138).addDetail("fsv", fileSystemView)).log();
        }
    }

    public FileChooser(String string, FileSystemView fileSystemView) {
        super(string, fileSystemView);
        if (FileChooser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "FileChooser(String,FileSystemView)", 153).addDetail("currentDirectoryPath", string)).addDetail("fsv", fileSystemView)).log();
        }
    }

    public static FileChooser createFileChooser(String string, File file, FileSystemView fileSystemView) {
        if (FileChooser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createFileChooser(String,File,FileSystemView)", 178).addDetail("currentDirectoryPath", string)).addDetail("currentDirectory", file)).addDetail("fsv", fileSystemView)).log();
        }
        if (fileSystemView == null) {
            if (string == null) {
                return file == null ? new FileChooser() : new FileChooser(file);
            }
            return new FileChooser(string);
        }
        if (string == null) {
            return file == null ? new FileChooser(fileSystemView) : new FileChooser(file, fileSystemView);
        }
        return new FileChooser(string, fileSystemView);
    }

    @Override
    public int showOpenDialog(Component component) {
        if (FileChooser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "showOpenDialog(Component)", 223).addDetail("parent", component)).log();
        }
        super.setDialogType(0);
        if (this.displayMacOSNativeFileChooser()) {
            return this.showMacOSNativeOpenDialog(component);
        }
        assert (SwingUtilities.isEventDispatchThread());
        Integer n = Misc.tryThreeTimes(() -> super.showOpenDialog(component));
        return n == null ? -1 : n;
    }

    @Override
    public int showSaveDialog(Component component) {
        Comparable<File> comparable;
        if (FileChooser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "showSaveDialog(Component)", 258).addDetail("parent", component)).log();
        }
        super.setDialogType(1);
        int n = -1;
        if (this.displayMacOSNativeFileChooser()) {
            n = this.showMacOSNativeSaveDialog(component);
        } else {
            assert (SwingUtilities.isEventDispatchThread());
            comparable = Misc.tryThreeTimes(() -> super.showSaveDialog(component));
            n = comparable == null ? -1 : (Integer)comparable;
        }
        comparable = this.getSelectedFile();
        if (comparable != null) {
            File file = new File(this.getCheckedAndValidFilePath(((File)comparable).getAbsolutePath()));
            this.setSelectedFile(file);
        }
        return n;
    }

    @Override
    public void setSelectedFile(File file) {
        if (FileChooser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setSelectedFile(File)", 285).addDetail("file", file)).log();
        }
        Misc.tryThreeTimes(() -> super.setSelectedFile(file));
    }

    @Override
    public void setSelectedFiles(File[] fileArray) {
        if (FileChooser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setSelectedFiles(File[])", 294).addDetail("selectedFiles", fileArray)).log();
        }
        Misc.tryThreeTimes(() -> super.setSelectedFiles(fileArray));
    }

    @Override
    public void setCurrentDirectory(File file) {
        if (FileChooser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setCurrentDirectory(File)", 303).addDetail("dir", file)).log();
        }
        Misc.tryThreeTimes(() -> super.setCurrentDirectory(file));
    }

    @Override
    public void addChoosableFileFilter(FileFilter fileFilter) {
        if (FileChooser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addChoosableFileFilter(FileFilter)", 313).addDetail("filter", fileFilter)).log();
        }
        Misc.tryThreeTimes(() -> super.addChoosableFileFilter(fileFilter));
    }

    @Override
    public boolean removeChoosableFileFilter(FileFilter fileFilter) {
        Boolean bl;
        if (FileChooser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeChoosableFileFilter(FileFilter)", 322).addDetail("filter", fileFilter)).log();
        }
        return (bl = Misc.tryThreeTimes(() -> super.removeChoosableFileFilter(fileFilter))) == null ? false : bl;
    }

    @Override
    public void resetChoosableFileFilters() {
        if (FileChooser.logger.level >= 7) {
            logger.lvlBuild(7, "resetChoosableFileFilters()", 332).log();
        }
        Misc.tryThreeTimes(() -> super.resetChoosableFileFilters());
    }

    @Override
    public void setAcceptAllFileFilterUsed(boolean bl) {
        if (FileChooser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setAcceptAllFileFilterUsed(boolean)", 341).addDetail("b", bl)).log();
        }
        Misc.tryThreeTimes(() -> super.setAcceptAllFileFilterUsed(bl));
    }

    @Override
    public void setFileFilter(FileFilter fileFilter) {
        if (FileChooser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setFileFilter(FileFilter)", 350).addDetail("filter", fileFilter)).log();
        }
        Misc.tryThreeTimes(() -> super.setFileFilter(fileFilter));
    }

    protected boolean displayMacOSNativeFileChooser() {
        if (FileChooser.logger.level >= 7) {
            logger.lvlBuild(7, "displayMacOSNativeFileChooser()", 362).log();
        }
        return Misc.OS_IS_MAC_OS_X;
    }

    private boolean dirsOnly() {
        if (FileChooser.logger.level >= 7) {
            logger.lvlBuild(7, "dirsOnly()", 370).log();
        }
        boolean bl = this.getFileSelectionMode() == 2 || this.getFileSelectionMode() == 1;
        return bl;
    }

    private Pair<String[], String[]> getExtensionFilters() {
        if (FileChooser.logger.level >= 7) {
            logger.lvlBuild(7, "getExtensionFilters()", 380).log();
        }
        FileFilter[] fileFilterArray = this.getChoosableFileFilters();
        String[] stringArray = new String[fileFilterArray.length];
        String[] stringArray2 = new String[fileFilterArray.length];
        for (int i = 0; i < fileFilterArray.length; ++i) {
            if (fileFilterArray[i].getClass() == this.getAcceptAllFileFilter().getClass()) {
                stringArray[i] = "*.*";
                stringArray2[i] = this.getAcceptAllFileFilter().getDescription();
                continue;
            }
            if (fileFilterArray[i] instanceof ExtensionFileFilter) {
                StringBuilder stringBuilder = new StringBuilder();
                ExtensionFileFilter extensionFileFilter = (ExtensionFileFilter)fileFilterArray[i];
                for (String string : extensionFileFilter.getExtensions()) {
                    stringBuilder.append("*" + string + ";");
                }
                stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
                stringArray[i] = stringBuilder.toString();
                stringArray2[i] = extensionFileFilter.getDescription();
                continue;
            }
            if (FileChooser.logger.level >= 1) {
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "getExtensionFilters()", 399).add("Unsupported filter", fileFilterArray[i])).log();
            }
            stringArray[i] = "*.*";
            stringArray2[i] = "Unsupported filter";
        }
        return new Pair<String[], String[]>(stringArray2, stringArray);
    }

    protected int getSelectedFilterIndex() {
        if (FileChooser.logger.level >= 7) {
            logger.lvlBuild(7, "getSelectedFilterIndex()", 410).log();
        }
        FileFilter[] fileFilterArray = this.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            if (fileFilterArray[i] != this.getFileFilter()) continue;
            return i;
        }
        return -1;
    }

    protected int showMacOSNativeOpenDialog(Component component) {
        boolean bl;
        if (FileChooser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "showMacOSNativeOpenDialog(Component)", 430).addDetail("parent", component)).log();
        }
        boolean bl2 = bl = this.getFileSelectionMode() == 2 || this.getFileSelectionMode() == 1;
        if (bl) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
        }
        int n = this.showAwtDialog(component, 0);
        System.setProperty("apple.awt.fileDialogForDirectories", "false");
        return n;
    }

    protected int showAwtDialog(Component component, int n) {
        Object object;
        FileFilter[] fileFilterArray;
        File file;
        if (FileChooser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "showAwtDialog(Component,int)", 455).addDetail("parent", component)).addDetail("dialogMode", n)).log();
        }
        FileDialog fileDialog = null;
        for (Component component2 = component; component2 != null && fileDialog == null; component2 = component2.getParent()) {
            if (FileChooser.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "showAwtDialog(Component,int)", 459).add("win", component2)).log();
            }
            if (component2 instanceof Frame) {
                fileDialog = new FileDialog((Frame)component2, this.getDialogTitle(), n);
                if (FileChooser.logger.level < 9) continue;
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "showAwtDialog(Component,int)", 462).add("fd", fileDialog)).log();
                continue;
            }
            if (!(component2 instanceof Dialog)) continue;
            fileDialog = new FileDialog((Dialog)component2, this.getDialogTitle(), n);
            if (FileChooser.logger.level < 9) continue;
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "showAwtDialog(Component,int)", 465).add("fd", fileDialog)).log();
        }
        if (fileDialog == null) {
            fileDialog = new FileDialog((Frame)null, this.getDialogTitle(), n);
            if (FileChooser.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "showAwtDialog(Component,int)", 472).add("fd", fileDialog)).log();
            }
        }
        this.setFileDialogMultipleMode(fileDialog, this.isMultiSelectionEnabled());
        File file2 = this.getCurrentDirectory();
        if (file2 != null) {
            fileDialog.setDirectory(this.getCurrentDirectory().getAbsolutePath());
        }
        if ((file = this.getSelectedFile()) != null) {
            fileDialog.setFile(file.getName());
        }
        if ((fileFilterArray = this.getChoosableFileFilters()).length > 0) {
            object = new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    for (FileFilter fileFilter : fileFilterArray) {
                        if (!fileFilter.accept(new File(file, string))) continue;
                        return true;
                    }
                    return false;
                }
            };
            fileDialog.setFilenameFilter((FilenameFilter)object);
        }
        fileDialog.setVisible(true);
        object = fileDialog.getDirectory();
        File[] fileArray = this.getFileDialogFiles(fileDialog);
        if (fileArray.length == 0) {
            return -1;
        }
        this.setCurrentDirectory(new File((String)object));
        this.setSelectedFile(fileArray[0]);
        this.setSelectedFiles(fileArray);
        return 0;
    }

    protected void setFileDialogMultipleMode(FileDialog fileDialog, boolean bl) {
        block3: {
            try {
                Method method = fileDialog.getClass().getMethod("setMultipleMode", Boolean.TYPE);
                method.invoke((Object)fileDialog, bl);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception exception) {
                if (FileChooser.logger.level < 1) break block3;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "setFileDialogMultipleMode(FileDialog,boolean)", 539).add("e", exception)).log();
            }
        }
    }

    protected File[] getFileDialogFiles(FileDialog fileDialog) {
        block5: {
            assert (fileDialog != null);
            try {
                Method method = fileDialog.getClass().getMethod("getFiles", new Class[0]);
                return (File[])method.invoke((Object)fileDialog, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception exception) {
                if (FileChooser.logger.level < 1) break block5;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "getFileDialogFiles(FileDialog)", 564).add("e", exception)).log();
            }
        }
        String string = fileDialog.getFile();
        if (string == null) {
            return new File[0];
        }
        String string2 = fileDialog.getDirectory();
        return new File[]{new File(string2, string)};
    }

    protected int showMacOSNativeSaveDialog(Component component) {
        if (FileChooser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "showMacOSNativeSaveDialog(Component)", 586).addDetail("parent", component)).log();
        }
        return this.showAwtDialog(component, 1);
    }

    private String getCheckedAndValidFilePath(String object) {
        String string;
        if (FileChooser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getCheckedAndValidFilePath(String)", 601).addDetail("fileName", (String)object)).log();
        }
        int n = ((String)object).lastIndexOf(".");
        FileFilter[] fileFilterArray = this.getChoosableFileFilters();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            Object object2 = null;
            if (fileFilterArray[i] instanceof ExtensionFileFilter) {
                object2 = (ExtensionFileFilter)fileFilterArray[i];
            }
            if (object2 == null) continue;
            for (String string2 : ((ExtensionFileFilter)object2).getExtensions()) {
                string2 = string2.startsWith(".") ? string2.substring(1, string2.length()) : string2;
                hashMap.put(string2, string2.toUpperCase());
                arrayList.add(string2);
            }
        }
        if (FileChooser.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getCheckedAndValidFilePath(String)", 620).add("fileFilters", fileFilterArray)).log();
        }
        String string3 = string = n < 0 ? "" : ((String)object).substring(n + 1);
        if (FileChooser.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getCheckedAndValidFilePath(String)", 622).add("extToCheck", string)).log();
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            if (((String)entry.getKey()).equals(string)) {
                return object;
            }
            if (!((String)entry.getValue()).equals(string)) continue;
            object = ((String)object).substring(0, n) + "." + (String)entry.getKey();
            return object;
        }
        if (arrayList.size() > 0) {
            object = (String)object + "." + (String)arrayList.get(0);
        }
        if (FileChooser.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getCheckedAndValidFilePath(String)", 636).add("fileName", (String)object)).log();
        }
        return object;
    }
}

