/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog;

import de.qfs.lib.gui.Grid;
import de.qfs.lib.log.Logger;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.option.group.RadioOptionGroup;
import de.qfs.lib.util.MapResourceBundle;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;

public class LookAndFeelGroup
extends RadioOptionGroup {
    private static final Logger logger = new Logger("de.qfs.apps.qflog.LookAndFeelGroup");
    private UIManager.LookAndFeelInfo[] lnfs;

    public LookAndFeelGroup() {
    }

    public LookAndFeelGroup(String string, OptionSet optionSet) {
        super(string, optionSet);
        if (LookAndFeelGroup.logger.level >= 7) {
            logger.log(7, "Log(String,OptionSet)", (String)(LookAndFeelGroup.logger.level < 8 ? "" : "name: " + string));
        }
    }

    @Override
    public boolean checkValues() {
        if (LookAndFeelGroup.logger.level >= 7) {
            logger.log(7, "checkValues()", "");
        }
        ButtonModel buttonModel = this.buttonGroup.getSelection();
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (((JRadioButton)this.buttons.get(i)).getModel() != buttonModel) continue;
            if (this.option.checkValue(this.grid, this.lnfs[i].getClassName())) break;
            ((JRadioButton)this.buttons.get(i)).requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public void readValues() {
        if (LookAndFeelGroup.logger.level >= 7) {
            logger.log(7, "readValues()", "");
        }
        ButtonModel buttonModel = this.buttonGroup.getSelection();
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (((JRadioButton)this.buttons.get(i)).getModel() != buttonModel) continue;
            this.option.setValue(this.lnfs[i].getClassName());
            return;
        }
        this.option.setValue(null);
    }

    @Override
    public void update(OptionSet optionSet) {
        if (LookAndFeelGroup.logger.level >= 7) {
            logger.log(7, "update(OptionSet)", (String)(LookAndFeelGroup.logger.level < 8 ? "" : "options: " + String.valueOf(optionSet) + " this: " + String.valueOf(this)));
        }
        this.options = optionSet;
        this.option = optionSet.getOption(this.option.getName());
        if (this.option == null) {
            throw new NullPointerException();
        }
        String string = (String)this.option.getValue();
        for (int i = 0; i < this.lnfs.length; ++i) {
            if (!this.lnfs[i].getClassName().equals(string)) continue;
            ((JRadioButton)this.buttons.get(i)).setSelected(true);
        }
    }

    @Override
    protected void getChoices() {
        if (LookAndFeelGroup.logger.level >= 7) {
            logger.log(7, "getChoices()", "");
        }
        MapResourceBundle mapResourceBundle = Option.getResources();
        this.choices = new ArrayList();
        String string = mapResourceBundle.getString("option.group." + this.name + ".option", null);
        if (string == null && LookAndFeelGroup.logger.level >= 1) {
            logger.log(1, "getChoices()", "No option for RadioOptionGroup " + this.name);
            return;
        }
        this.option = this.options.getOption(string);
        if (this.option == null && LookAndFeelGroup.logger.level >= 1) {
            logger.log(1, "getChoices()", "No option for RadioOptionGroup " + this.name);
            return;
        }
        this.lnfs = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < this.lnfs.length; ++i) {
            this.choices.add(this.lnfs[i].getName());
        }
    }

    @Override
    protected void makeGrid() {
        if (LookAndFeelGroup.logger.level >= 7) {
            logger.log(7, "makeGrid()", "");
        }
        MapResourceBundle mapResourceBundle = Option.getResources();
        this.grid = new Grid();
        this.grid.setName("OptionGroup-" + this.name + "-" + this.options.getConfigurableName());
        this.buttonGroup = new ButtonGroup();
        this.buttons = new ArrayList();
        for (int i = 0; i < this.choices.size(); ++i) {
            JRadioButton jRadioButton = new JRadioButton((String)this.choices.get(i));
            jRadioButton.setName("Choice" + (i + 1) + "-" + this.option.getName());
            this.buttonGroup.add(jRadioButton);
            this.buttons.add(jRadioButton);
            this.grid.add((Component)jRadioButton, 0.0);
        }
        this.grid.addGlue();
        String string = (String)this.option.getValue();
        for (int i = 0; i < this.lnfs.length; ++i) {
            if (!this.lnfs[i].getClassName().equals(string)) continue;
            ((JRadioButton)this.buttons.get(i)).setSelected(true);
        }
    }
}

