/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog;

import de.qfs.apps.qflog.App;
import de.qfs.apps.qflog.Model;
import de.qfs.apps.qflog.ViewTable;
import de.qfs.apps.qflog.command.CommandEditOptions;
import de.qfs.apps.qflog.command.CommandEditRemove;
import de.qfs.apps.qflog.command.CommandFileExit;
import de.qfs.apps.qflog.command.CommandFileOpen;
import de.qfs.apps.qflog.command.CommandFileSaveAs;
import de.qfs.apps.qflog.command.CommandHelpAbout;
import de.qfs.apps.qflog.command.CommandOpenLogView;
import de.qfs.lib.config.ConfigWrapper;
import de.qfs.lib.config.Configurator;
import de.qfs.lib.gui.DefaultTableModelSorter;
import de.qfs.lib.gui.NotifyingJFrame;
import de.qfs.lib.gui.SortedTableHelper;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.Logger;
import de.qfs.lib.option.KeyOption;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.option.edit.KeyOptionEdit;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Observable;
import de.qfs.lib.util.Observer;
import de.qfs.lib.util.Reflector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.StringReader;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;

public class MainFrame
extends NotifyingJFrame
implements Observer {
    private static final Logger logger = new Logger("de.qfs.apps.qflog.MainFrame");
    private Configurator cfg = new Configurator("LogFrame");
    private JTable table;
    private SortedTableHelper helper;
    protected ActionListener actionFileExit = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            App.getCommandDistributor().assignCommand(new CommandFileExit(MainFrame.this));
        }
    };
    protected ActionListener actionFileOpen = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            App.getCommandDistributor().assignCommand(new CommandFileOpen(MainFrame.this, MainFrame.this));
        }
    };
    protected ActionListener actionPaste = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                try {
                    Transferable transferable = SwingUtil.safeGetClipboard(null);
                    if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        App.getCommandDistributor().assignCommand(new CommandFileOpen(MainFrame.this, MainFrame.this, new StringReader(string), string.length()));
                    }
                }
                catch (Throwable throwable) {
                    if (MainFrame.logger.level < 1) break block3;
                    logger.log(1, "actionPerformed(ActionEvent)", throwable);
                }
            }
        }
    };
    protected ActionListener actionFileSaveAs = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            App.getCommandDistributor().assignCommand(new CommandFileSaveAs(MainFrame.this, MainFrame.this, MainFrame.this.table));
        }
    };
    protected ActionListener actionEditRemove = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            App.getCommandDistributor().assignCommand(new CommandEditRemove(MainFrame.this, MainFrame.this, MainFrame.this.table));
        }
    };
    protected ActionListener actionEditOptions = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            App.getCommandDistributor().assignCommand(new CommandEditOptions(MainFrame.this, MainFrame.this));
        }
    };
    protected ActionListener actionOpenLogView = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            App.getCommandDistributor().assignCommand(new CommandOpenLogView(MainFrame.this, MainFrame.this.table));
        }
    };
    protected ActionListener actionHelpAbout = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            App.getCommandDistributor().assignCommand(new CommandHelpAbout(MainFrame.this, MainFrame.this));
        }
    };

    public MainFrame() {
        if (MainFrame.logger.level >= 7) {
            logger.log(7, "MainFrame()", "");
        }
        App.getOptions().addObserver(this);
    }

    public void init() {
        if (MainFrame.logger.level >= 7) {
            logger.log(7, "init()", "");
        }
        this.setTitle("qflog");
        this.setName("MainFrame");
        ImageIcon imageIcon = (ImageIcon)App.getResources().getIcon("logServer.icon", null);
        if (imageIcon != null) {
            this.setIconImage(imageIcon.getImage());
        }
        this.initMenu();
        this.initTable();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                App.getCommandDistributor().assignCommand(new CommandFileExit(windowEvent.getSource()));
            }
        });
        this.cfg.add(ConfigWrapper.makeWrapper(this, "MainFrame"));
    }

    protected void initMenu() {
        if (MainFrame.logger.level >= 7) {
            logger.log(7, "initMenu()", "");
        }
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = this.makeMenu("file");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = this.makeMenuItem("fileOpen", this.actionFileOpen);
        jMenuItem.setAccelerator(KeyOptionEdit.getKeyStrokeForData(KeyOption.DEFVAL_KEYSTROKE_OPEN_FILE_SYSTEM));
        jMenu.add(jMenuItem);
        jMenuItem = this.makeMenuItem("paste", this.actionPaste);
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(KeyOptionEdit.getKeyStrokeForData(KeyOption.DEFVAL_KEYSTROKE_PASTE_SYSTEM));
        jMenuItem = this.makeMenuItem("fileSaveAs", this.actionFileSaveAs);
        if (KeyOption.DEFVAL_KEYSTROKE_SAVE_FILE_AS_SYSTEM != null) {
            jMenuItem.setAccelerator(KeyOptionEdit.getKeyStrokeForData(KeyOption.DEFVAL_KEYSTROKE_SAVE_FILE_AS_SYSTEM));
        }
        jMenu.add(jMenuItem);
        jMenuItem = this.makeMenuItem("fileExit", this.actionFileExit);
        jMenu.add(jMenuItem);
        JMenu jMenu2 = this.makeMenu("edit");
        jMenuBar.add(jMenu2);
        jMenuItem = this.makeMenuItem("editShow", this.actionOpenLogView);
        jMenu2.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(10, 0));
        jMenuItem = this.makeMenuItem("editRemove", this.actionEditRemove);
        jMenu2.add(jMenuItem);
        jMenuItem.setAccelerator(KeyOptionEdit.getKeyStrokeForData(KeyOption.DEFVAL_KEYSTROKE_DELETE_SYSTEM));
        jMenuItem = this.makeMenuItem("editOptions", this.actionEditOptions);
        jMenu2.add(jMenuItem);
        JMenu jMenu3 = this.makeMenu("help");
        jMenuBar.add(jMenu3);
        jMenuItem = this.makeMenuItem("helpAbout", this.actionHelpAbout);
        jMenu3.add(jMenuItem);
    }

    protected JMenu makeMenu(String string) {
        if (MainFrame.logger.level >= 7) {
            logger.log(7, "makeMenu(String)", (String)(MainFrame.logger.level < 8 ? "" : "resource: " + string));
        }
        MapResourceBundle mapResourceBundle = App.getResources();
        JMenu jMenu = new JMenu(mapResourceBundle.getString("menu." + string + ".name", "MISSING: " + string));
        String string2 = mapResourceBundle.getString("menu." + string + ".mnemonic", null);
        if (string2 != null) {
            jMenu.setMnemonic(string2.charAt(0));
        }
        return jMenu;
    }

    protected JMenuItem makeMenuItem(String string, ActionListener actionListener) {
        if (MainFrame.logger.level >= 7) {
            logger.log(7, "makeMenuItem(String,ActionListener)", (String)(MainFrame.logger.level < 8 ? "" : "resource: " + string + ", action: " + String.valueOf(actionListener)));
        }
        MapResourceBundle mapResourceBundle = App.getResources();
        JMenuItem jMenuItem = new JMenuItem(mapResourceBundle.getString("action." + string + ".name", "MISSING NAME: " + string));
        String string2 = mapResourceBundle.getString("action." + string + ".mnemonic", null);
        if (string2 != null) {
            jMenuItem.setMnemonic(string2.charAt(0));
        }
        jMenuItem.setActionCommand(mapResourceBundle.getString("action." + string + ".command", "MISSING COMMAND: " + string));
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    private void initTable() {
        if (MainFrame.logger.level >= 7) {
            logger.log(7, "initTable()", "");
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.table = new ViewTable(Model.instance());
        this.table.setName("ClientTable");
        JTableHeader jTableHeader = new JTableHeader(this.table.getColumnModel()){

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        jTableHeader.setRequestFocusEnabled(false);
        this.table.setTableHeader(jTableHeader);
        this.helper = new SortedTableHelper(this.table);
        this.helper.prepareTable();
        this.helper.saveSelection(true);
        this.cfg.add(ConfigWrapper.makeWrapper(this.table, "Table"));
        DefaultTableModelSorter defaultTableModelSorter = (DefaultTableModelSorter)this.helper.getTableModelSorter();
        defaultTableModelSorter.setConfigurableName("sorter");
        this.cfg.add(defaultTableModelSorter);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBackground(this.table.getBackground());
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setName("ClientScrollPane");
        jPanel.add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel, "Center");
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        Object object = Reflector.safeCall((Object)this.table, "getInputMap", Integer.TYPE, (Object)1);
        if (object != null) {
            Reflector.safeCall(object, "put", new Class[]{KeyStroke.class, Object.class}, new Object[]{KeyStroke.getKeyStroke(10, 0), "dummy"});
            Reflector.safeCall(object, "put", new Class[]{KeyStroke.class, Object.class}, new Object[]{KeyStroke.getKeyStroke(86, 2), "dummy"});
        }
        this.table.registerKeyboardAction(this.actionOpenLogView, "open", KeyStroke.getKeyStroke(10, 0), 2);
        this.table.registerKeyboardAction(this.actionPaste, "paste", KeyStroke.getKeyStroke(86, 2), 2);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() > 1 && (n = MainFrame.this.table.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()))) >= 0) {
                    App.getCommandDistributor().assignCommand(new CommandOpenLogView(mouseEvent.getSource(), MainFrame.this.table, n));
                }
            }
        });
    }

    public final JTable getTable() {
        return this.table;
    }

    public final Configurator getConfigurator() {
        if (MainFrame.logger.level >= 7) {
            logger.log(7, "getConfigurator()", "");
        }
        return this.cfg;
    }

    @Override
    public void update(Observable observable, Object object) {
        String string;
        if (MainFrame.logger.level >= 7) {
            logger.log(7, "update(Observable,Object)", (String)(MainFrame.logger.level < 8 ? "" : "obs: " + String.valueOf(observable) + ", arg: " + String.valueOf(object)));
        }
        if (observable instanceof OptionSet && (string = ((OptionSet)observable).getString("lookAndFeel", null)) != null && !string.equals(UIManager.getLookAndFeel().getClass().getName())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String string2 = System.getProperty("os.name");
                    try {
                        System.getProperties().put("os.name", "Windows");
                        UIManager.setLookAndFeel(string);
                    }
                    catch (Exception exception) {
                        if (MainFrame.logger.level >= 1) {
                            logger.log("main(String[])", exception);
                        }
                    }
                    finally {
                        System.getProperties().put("os.name", string2);
                    }
                    SwingUtilities.updateComponentTreeUI(MainFrame.this);
                    MainFrame.this.helper.updateUI();
                    MainFrame.this.table.revalidate();
                    CommandEditOptions.updateDialogUI();
                    MainFrame.this.table.registerKeyboardAction(MainFrame.this.actionOpenLogView, "open", KeyStroke.getKeyStroke(10, 0), 2);
                }
            });
        }
    }
}

