/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog;

import de.qfs.apps.qflog.LogListenerImpl;
import de.qfs.apps.qflog.Model;
import de.qfs.apps.qflog.RemoteLogLevelCallbackAdapter;
import de.qfs.apps.qflog.Start;
import de.qfs.apps.qflog.logview.LogLevelTreeModel;
import de.qfs.apps.qflog.logview.LogParser;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.Logger;
import de.qfs.lib.logrmi.LogListener;
import de.qfs.lib.logrmi.RemoteLogLevelCallback;
import de.qfs.lib.logrmi.RemoteLogLevelListener;
import de.qfs.lib.util.Reflector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.RemoteException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SocketListener
extends Thread {
    private static final Logger logger = new Logger("de.qfs.apps.qflog.SocketListener");
    private static final String LINESEP = System.getProperty("line.separator");
    private static int threadId;
    private static Object classLock;
    ServerSocket serverSocket;
    boolean lowLevelLoggingInitialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketListener(int n) {
        block8: {
            if (SocketListener.logger.level >= 7) {
                Logger.Builder builder = logger.build("SocketListener(int)");
                (SocketListener.logger.level < 8 ? builder : builder.add("port: ").add(n)).log(7);
            }
            try {
                int n2;
                this.serverSocket = new ServerSocket(n);
                this.setDaemon(true);
                Object object = classLock;
                synchronized (object) {
                    n2 = threadId++;
                }
                this.setName("SocketListener-" + n2);
                this.start();
            }
            catch (BindException bindException) {
                if (SocketListener.logger.level >= 5) {
                    logger.log(5, "setupServer(int)", bindException);
                }
            }
            catch (IOException iOException) {
                if (SocketListener.logger.level < 1) break block8;
                logger.log(1, "setupServer(int)", iOException);
            }
        }
    }

    @Override
    public void run() {
        if (SocketListener.logger.level >= 7) {
            logger.log(7, "run()", "");
        }
        boolean bl = false;
        while (!bl) {
            try {
                Socket socket = this.serverSocket.accept();
                new StreamListener(socket);
            }
            catch (SocketException socketException) {
                bl = true;
            }
            catch (IOException iOException) {
                if (SocketListener.logger.level >= 1) {
                    logger.log(1, "run()", iOException);
                }
                bl = true;
            }
        }
    }

    static {
        classLock = new Object();
    }

    private class StreamListener
    extends Thread {
        private Socket socket;
        private StreamConsumer consumer;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StreamListener(Socket socket) {
            int n;
            if (SocketListener.logger.level >= 7) {
                Logger.Builder builder = logger.build("StreamListener(Socket)");
                (SocketListener.logger.level < 8 ? builder : builder.add("socket: ").add(socket)).log(7);
            }
            this.socket = socket;
            this.consumer = new StreamConsumer();
            this.setDaemon(true);
            Object object = classLock;
            synchronized (object) {
                n = threadId++;
            }
            this.setName("StreamListener-" + n);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block38: {
                if (SocketListener.logger.level >= 7) {
                    logger.log(7, "run()", "");
                }
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                    try {
                        String string = bufferedReader.readLine();
                        if (SocketListener.logger.level >= 9) {
                            logger.build("run()").add("first line: ").add(string).log(9);
                        }
                        if (string == null) break block38;
                        Matcher matcher = Pattern.compile("initiate IPC for (.*):([0-9]+),([0-9]+),([0-9]+)").matcher(string.trim());
                        if (matcher.matches()) {
                            String string2 = matcher.group(1);
                            String string3 = matcher.group(2);
                            String string4 = matcher.group(3);
                            String string5 = matcher.group(4);
                            if (SocketListener.logger.level >= 9) {
                                logger.build("run()").add("client: ").add(string2).add(", queue1: ").add(string3).add(", queue2: ").add(string4).add(", cbHandle: ").add(string5).log(9);
                            }
                            try {
                                Class<?> clazz;
                                long l;
                                int n;
                                int n2;
                                block39: {
                                    n2 = Integer.parseInt(string3);
                                    n = Integer.parseInt(string4);
                                    l = Long.parseLong(string5);
                                    clazz = Class.forName("de.qfs.clib.ipc.ShmLogListener");
                                    if (!SocketListener.this.lowLevelLoggingInitialized) {
                                        try {
                                            Reflector.call(clazz, "setupLogging", new String[0].getClass(), (Object)Start.args);
                                            SocketListener.this.lowLevelLoggingInitialized = true;
                                        }
                                        catch (Throwable throwable) {
                                            if (SocketListener.logger.level >= 9) {
                                                logger.log(9, "run()", throwable);
                                            }
                                            break block39;
                                        }
                                    }
                                    try {
                                        Reflector.call(clazz, "setThreadName");
                                    }
                                    catch (Throwable throwable) {
                                        if (SocketListener.logger.level < 9) break block39;
                                        logger.log(9, "run()", throwable);
                                    }
                                }
                                Object obj = clazz.newInstance();
                                int n3 = Model.instance().getNewId(string2);
                                LogListenerImpl logListenerImpl = new LogListenerImpl(n3);
                                Model.instance().setListener(n3, logListenerImpl);
                                LogLevelTreeModel logLevelTreeModel = new LogLevelTreeModel();
                                RemoteLogLevelCallbackAdapter remoteLogLevelCallbackAdapter = new RemoteLogLevelCallbackAdapter(logLevelTreeModel);
                                Reflector.call(obj, "connect", new Class[]{Integer.TYPE, Integer.TYPE, Long.TYPE, LogListener.class, RemoteLogLevelListener.class}, new Object[]{n2, n, l, logListenerImpl, remoteLogLevelCallbackAdapter});
                                remoteLogLevelCallbackAdapter.setLogLevelCallback((RemoteLogLevelCallback)obj);
                                Model.instance().setLogLevelListener(n3, remoteLogLevelCallbackAdapter);
                                PrintWriter printWriter = new PrintWriter(this.socket.getOutputStream());
                                try {
                                    printWriter.write("OK");
                                }
                                finally {
                                    try {
                                        printWriter.close();
                                    }
                                    catch (Throwable throwable) {}
                                }
                                this.socket.close();
                                return;
                            }
                            catch (Throwable throwable) {
                                if (SocketListener.logger.level >= 1) {
                                    logger.log(1, "run()", throwable);
                                }
                                this.socket.getOutputStream().write("IPC not supported".getBytes());
                                this.socket.close();
                                try {
                                    bufferedReader.close();
                                }
                                catch (Throwable throwable2) {
                                    // empty catch block
                                }
                                return;
                            }
                        }
                        if (SocketListener.logger.level >= 9) {
                            logger.log(9, "run()", "Doesn't match IPC regexp");
                        }
                        this.consumer.start();
                        while (string != null) {
                            if (SocketListener.logger.level >= 10) {
                                logger.build("run()").add("line: ").add(string).log(10);
                            }
                            this.consumer.setLine(string);
                            string = bufferedReader.readLine();
                            if (SocketListener.logger.level < 9) continue;
                            logger.build("run()").add("line: ").add(string).log(9);
                        }
                        {
                            break block38;
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (IOException iOException) {
                    if (SocketListener.logger.level < 5) break block38;
                    logger.log(5, "run()", iOException);
                }
            }
            this.consumer.finish();
        }
    }

    private class StreamConsumer
    extends Thread {
        private String line;
        private boolean done;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StreamConsumer() {
            int n;
            this.setDaemon(true);
            Object object = classLock;
            synchronized (object) {
                n = threadId++;
            }
            this.setName("StreamConsumer-" + n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (SocketListener.logger.level >= 7) {
                logger.log(7, "run()", "");
            }
            String string = "client";
            this.getLine(true);
            if (SocketListener.logger.level >= 9) {
                logger.build("run()").add("line: ").add(this.line).log(9);
            }
            if (this.done) {
                if (SocketListener.logger.level >= 5) {
                    logger.log(5, "run()", "done");
                }
                return;
            }
            if (this.line.startsWith("client name: ")) {
                string = this.line.substring(13).trim();
                if (SocketListener.logger.level >= 9) {
                    logger.build("run()").add("client: ").add(string).log(9);
                }
                StreamConsumer streamConsumer = this;
                synchronized (streamConsumer) {
                    this.line = null;
                    this.notifyAll();
                    this.getLine(true);
                }
                if (this.done) {
                    return;
                }
            }
            try {
                int n = Model.instance().getNewId(string);
                if (SocketListener.logger.level >= 9) {
                    logger.build("run()").add("id: ").add(n).log(9);
                }
                LogListenerImpl logListenerImpl = new LogListenerImpl(n);
                if (SocketListener.logger.level >= 9) {
                    logger.build("run()").add("listener: ").add(logListenerImpl).log(9);
                }
                Model.instance().setListener(n, logListenerImpl);
                LogParser logParser = new LogParser();
                LogEntry logEntry = null;
                boolean bl = false;
                StringBuffer stringBuffer = new StringBuffer();
                while (!this.done) {
                    LogEntry logEntry2 = logParser.parse(this.line);
                    if (SocketListener.logger.level >= 9) {
                        logger.build("run()").add("tmp: ").add(logEntry2).log(9);
                    }
                    if (logEntry2 != null) {
                        if (logEntry != null) {
                            if (bl) {
                                logEntry.setMessage(stringBuffer.toString());
                            }
                            logListenerImpl.log(logEntry);
                        }
                        logEntry = logEntry2;
                        bl = false;
                    } else if (logEntry != null) {
                        if (!bl) {
                            stringBuffer.setLength(0);
                            stringBuffer.append(logEntry.getMessage());
                            bl = true;
                        }
                        stringBuffer.append(LINESEP);
                        stringBuffer.append(this.line);
                    }
                    StreamConsumer streamConsumer = this;
                    synchronized (streamConsumer) {
                        this.line = null;
                        this.notifyAll();
                        this.getLine(logEntry == null);
                        if (!this.done && this.line == null && logEntry != null) {
                            if (bl) {
                                logEntry.setMessage(stringBuffer.toString());
                            }
                            logListenerImpl.log(logEntry);
                            logEntry = null;
                            bl = false;
                            this.getLine(true);
                        }
                    }
                }
                if (logEntry != null) {
                    if (bl) {
                        logEntry.setMessage(stringBuffer.toString());
                    }
                    logListenerImpl.log(logEntry);
                }
                logListenerImpl.disconnect();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }

        public synchronized void setLine(String string) {
            if (SocketListener.logger.level >= 7) {
                Logger.Builder builder = logger.build("setLine(String)");
                (SocketListener.logger.level < 8 ? builder : builder.add("line: ").add(string)).log(7);
            }
            while (!this.done && this.line != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.line = string;
            this.notifyAll();
        }

        public synchronized void finish() {
            if (SocketListener.logger.level >= 7) {
                logger.log(7, "finish()", "");
            }
            this.done = true;
            this.notifyAll();
        }

        private synchronized void getLine(boolean bl) {
            if (SocketListener.logger.level >= 7) {
                Logger.Builder builder = logger.build("getLine(boolean)");
                (SocketListener.logger.level < 8 ? builder : builder.add("block: ").add(bl)).log(7);
            }
            while (!this.done && this.line == null) {
                try {
                    if (bl) {
                        this.wait();
                        continue;
                    }
                    this.wait(1000L);
                    return;
                }
                catch (InterruptedException interruptedException) {
                }
            }
            if (SocketListener.logger.level >= 9) {
                logger.build("getLine(boolean)").add("line: ").add(this.line).log(9);
            }
        }
    }
}

