/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog;

import de.qfs.apps.qflog.logview.LogView;
import de.qfs.lib.config.ConfigWrapper;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.Logger;
import de.qfs.lib.log.StreamFilter;
import de.qfs.lib.logrmi.RemoteLogWriter;
import de.qfs.lib.util.ArgsParser;
import de.qfs.lib.util.MalformedArgumentListException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JFrame;

public class TestClient {
    private static final Logger logger = new Logger("de.qfs.apps.qflog.TestClient");
    private static final String CLIENT_NAME = "testclient";
    private static Hashtable options;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        int n;
        String string;
        block32: {
            block31: {
                TestClient.getOpts(stringArray);
                Logger.setLogLevels(options);
                int n2 = 2;
                if (options.containsKey("outputlevel")) {
                    try {
                        n2 = Integer.parseInt((String)options.get("outputlevel"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                Log.setOutputLevel(n2);
                string = CLIENT_NAME;
                if (options.containsKey("clientname")) {
                    string = (String)options.get("clientname");
                }
                String string2 = (String)options.get("logserver");
                boolean bl = options.containsKey("waitforserver");
                try {
                    if (bl) {
                        int n3 = -1;
                        if (options.containsKey("port")) {
                            try {
                                n3 = Integer.parseInt((String)options.get("port"));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        boolean bl2 = !options.containsKey("allownonlocal");
                        n = options.containsKey("createregistry");
                        if (string2 != null) {
                            RemoteLogWriter.logRemote(string2, string, n3, n != 0, bl2);
                        } else {
                            RemoteLogWriter.logRemote(string, n3, n != 0, bl2);
                        }
                        break block31;
                    }
                    if (string2 != null) {
                        RemoteLogWriter.logRemote(string2, string);
                    }
                }
                catch (Exception exception) {
                    if (TestClient.logger.level < 1) break block31;
                    logger.log("main(String[])", exception);
                }
            }
            if (options.containsKey("logfile")) {
                try {
                    StreamFilter.logToFile(string, new File((String)options.get("logfile")), 0);
                }
                catch (IOException iOException) {
                    if (TestClient.logger.level < 1) break block32;
                    logger.log("main(String[])", iOException);
                }
            }
        }
        if (options.containsKey("configfile")) {
            try {
                FileInputStream fileInputStream = new FileInputStream((String)options.get("configfile"));
                try {
                    Configuration.instance().restore(fileInputStream);
                }
                finally {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        JFrame jFrame = new JFrame("TestClient");
        jFrame.setName("TestClient.frame");
        Configuration.instance().register(ConfigWrapper.makeWrapper(jFrame, "TestClient.frame"));
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TestClient.exit();
            }
        });
        JButton jButton = new JButton("quit");
        jButton.setName("quit");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestClient.exit();
            }
        });
        jFrame.getContentPane().add(jButton);
        jFrame.pack();
        jFrame.show();
        if (options.containsKey("internal")) {
            final String string3 = string;
            SwingUtil.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    LogView logView = LogView.logToView(string3);
                    logView.setLoggingEnabled(true);
                    logView.getFrame().show();
                }
            });
        }
        n = 3;
        if (options.containsKey("numloggers")) {
            try {
                n = Integer.parseInt((String)options.get("numloggers"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (int i = 1; i <= n; ++i) {
            int n4 = i / 2 + 1;
            int n5 = (i - 1) % 3 + 1;
            new LoggerThread("pkg_" + n4 + ".Logger" + (char)(65 + n4 - 1) + "_" + n5, i * 1000).start();
        }
    }

    private static void exit() {
        Log.setQueueing(false);
        RemoteLogWriter.stopLogging();
        StreamFilter.stopLogging();
        if (options.containsKey("configfile")) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream((String)options.get("configfile"));
                try {
                    Configuration.instance().save(fileOutputStream);
                }
                finally {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.exit(0);
    }

    private static void getOpts(String[] stringArray) {
        if (TestClient.logger.level >= 7) {
            logger.log(7, "getOpts(String[])", (String)(TestClient.logger.level < 8 ? "" : "args: " + String.valueOf(stringArray)));
        }
        ArgsParser argsParser = new ArgsParser(new String[]{"-allownonlocal", "+clientname", "+configfile", "-createregistry", "-internal", "+log-*", "+logfile", "+logserver", "+numloggers", "+outputlevel", "+port", "-waitforserver"});
        try {
            argsParser.parse(stringArray);
            options = argsParser.getOptions();
        }
        catch (MalformedArgumentListException malformedArgumentListException) {
            if (TestClient.logger.level >= 1) {
                logger.log("getOpts(String[])", malformedArgumentListException);
            }
            options = new Hashtable();
        }
    }

    private static class LoggerThread
    extends Thread {
        private Logger logger;
        private int delay;

        public LoggerThread(String string, int n) {
            super("LoggerThread-" + string);
            this.setDaemon(true);
            this.logger = new Logger(string);
            this.delay = n;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    LoggerThread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                int n = (int)Math.floor(Math.random() * 10.0) + 1;
                int n2 = (int)Math.floor(Math.random() * 5.0) + 1;
                int n3 = (int)Math.floor(Math.random() * 8.0) + 1;
                if (this.logger.level < n) continue;
                this.logger.log(n, "method_" + n2, "message-" + n3);
            }
        }
    }
}

