/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog.logview;

import de.qfs.lib.gui.Borders;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.Logger;
import de.qfs.lib.log.ProguardMap;
import de.qfs.lib.log.ProguardMapPossessor;
import de.qfs.lib.option.edit.IncrementalSearch;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import lombok.Generated;

public class LogDetailView
extends JPanel
implements ProguardMapPossessor {
    private static final Logger logger = new Logger("de.qfs.apps.qflog.logview.LogDetailView");
    private static SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final String[] iconNames = new String[]{"logTableView.icon.err", "logTableView.icon.errDetail", "logTableView.icon.wrn", "logTableView.icon.wrnDetail", "logTableView.icon.msg", "logTableView.icon.msgDetail", "logTableView.icon.mtd", "logTableView.icon.mtdDetail", "logTableView.icon.dbg", "logTableView.icon.dbgDetail"};
    private static final Icon[] icons = new Icon[iconNames.length];
    JLabel level;
    JLabel time;
    JLabel thread;
    JLabel clazz;
    JLabel method;
    MessageView detail;
    private boolean logging;
    private transient MapResourceBundle resources;
    private LogEntry currentEntry;
    private ProguardMap proguardMap;
    private static final Logger mvLogger = new Logger("de.qfs.apps.qflog.logview.MessageView");

    public final void setLoggingEnabled(boolean bl) {
        this.logging = bl;
    }

    protected void init() {
        if (this.logging && LogDetailView.logger.level >= 7) {
            logger.log(7, "init()", "");
        }
        this.initIcons();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(null);
        String string = this.resources.getString("logTableView.detail.title", "Detail");
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(UIManager.getColor("textText"));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jLabel, "North");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.level = new JLabel(" ");
        this.level.setForeground(UIManager.getColor("textText"));
        this.level.setName("LevelLabel");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.level, gridBagConstraints);
        jPanel2.add(this.level);
        this.time = new JLabel(" ");
        this.time.setForeground(UIManager.getColor("textText"));
        this.level.setName("TimeLabel");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.time, gridBagConstraints);
        jPanel2.add(this.time);
        this.thread = new JLabel(" ");
        this.thread.setForeground(UIManager.getColor("textText"));
        this.level.setName("ThreadLabel");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.thread, gridBagConstraints);
        jPanel2.add(this.thread);
        this.clazz = new JLabel(" ");
        this.clazz.setForeground(UIManager.getColor("textText"));
        this.level.setName("ClassLabel");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.clazz, gridBagConstraints);
        jPanel2.add(this.clazz);
        this.method = new JLabel(" ");
        this.method.setForeground(UIManager.getColor("textText"));
        this.level.setName("MethodLabel");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.method, gridBagConstraints);
        jPanel2.add(this.method);
        this.detail = new MessageView("");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.detail, gridBagConstraints);
        jPanel2.add(this.detail);
        this.add((Component)jPanel2, "Center");
    }

    public void cleanup() {
        if (this.logging && LogDetailView.logger.level >= 7) {
            logger.log(7, "cleanup()", "");
        }
        SwingUtil.cleanup(this);
        this.detail.cleanup();
        this.detail = null;
        this.resources = null;
    }

    public void setResources(MapResourceBundle mapResourceBundle) {
        this.resources = mapResourceBundle;
    }

    public void setEntry(LogEntry logEntry) {
        this.currentEntry = logEntry;
        if (logEntry != null) {
            Icon icon = null;
            if (icons[0] != null && logEntry.getLevel() >= 0 && logEntry.getLevel() < icons.length) {
                icon = icons[logEntry.getLevel() - 1];
            }
            this.level.setIcon(icon);
            this.level.setText(icon == null ? "" + logEntry.getLevel() : null);
            this.time.setText(df.format(new Date(logEntry.getTimestamp())));
            this.thread.setText(logEntry.getThread());
            this.method.setText(logEntry.getMethod());
            this.clazz.setText(logEntry.getClazz());
            String string = logEntry.getMessage();
            if (this.proguardMap != null && ProguardMap.isStackTrace(string)) {
                string = this.proguardMap.retrace(string);
            }
            this.detail.getTextArea().setText(string);
            this.detail.getTextArea().setCaretPosition(0);
        } else {
            this.level.setIcon(null);
            this.level.setText(" ");
            this.time.setText(" ");
            this.thread.setText(" ");
            this.method.setText(" ");
            this.clazz.setText(" ");
            this.detail.getTextArea().setText(" ");
        }
    }

    @Override
    public final void setProguardMap(ProguardMap proguardMap) {
        boolean bl;
        this.proguardMap = proguardMap;
        boolean bl2 = bl = this.level != null;
        if (bl) {
            this.setEntry(this.currentEntry);
        }
    }

    private void initIcons() {
        if (icons[0] == null && this.resources != null) {
            for (int i = 0; i < icons.length; ++i) {
                LogDetailView.icons[i] = this.resources.getIcon(iconNames[i], null);
            }
        }
    }

    @Override
    @Generated
    public ProguardMap getProguardMap() {
        return this.proguardMap;
    }

    private class MessageView
    extends JScrollPane
    implements FocusListener {
        private Border defaultBorder;
        private Border focusBorder;
        private JTextArea textArea;
        private KeyAdapter scrollListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 38 && keyEvent.getModifiers() == 0) {
                    SwingUtil.scrollDownLine(MessageView.this);
                    keyEvent.consume();
                } else if (keyEvent.getKeyCode() == 40 && keyEvent.getModifiers() == 0) {
                    SwingUtil.scrollUpLine(MessageView.this);
                    keyEvent.consume();
                }
            }
        };

        public MessageView(String string) {
            this.textArea = new JTextArea(string){

                @Override
                public boolean isManagingFocus() {
                    return false;
                }

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    String string;
                    String string2 = this.getSelectedText();
                    String string3 = string2 == null ? null : string2.trim();
                    String string4 = string = string2 == null ? null : string2.trim();
                    if (Misc.emptyOrNull(string2)) {
                        string3 = this.getNumberFromCursor(mouseEvent, string2, false);
                        string = this.getNumberFromCursor(mouseEvent, string2, true);
                    }
                    if (!Misc.emptyOrNull(string3) || !Misc.emptyOrNull(string)) {
                        Long l = null;
                        try {
                            l = Long.valueOf(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        Long l2 = null;
                        if (string != null) {
                            try {
                                if (string.startsWith("0x")) {
                                    string = string.substring(2);
                                }
                                l2 = Long.valueOf(string, 16);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        StringBuilder stringBuilder = new StringBuilder("<html>");
                        if (l != null) {
                            stringBuilder.append(l).append(" &rarr; ").append("0x").append(Long.toHexString(l));
                            if (l2 != null) {
                                stringBuilder.append("<br>");
                            }
                        }
                        if (l2 != null) {
                            stringBuilder.append("0x").append(Long.toHexString(l2)).append(" &rarr; ").append(l2);
                        }
                        stringBuilder.append("</html>");
                        return stringBuilder.toString();
                    }
                    return "";
                }

                private String getNumberFromCursor(MouseEvent mouseEvent, String string, boolean bl) {
                    String string2;
                    int n = this.viewToModel(mouseEvent.getPoint());
                    if (n < (string2 = this.getText()).length()) {
                        int n2 = n;
                        int n3 = n;
                        while (n >= 0 && this.isNumber(string2.charAt(n), bl)) {
                            n2 = n--;
                        }
                        while (n3 < string2.length() && this.isNumber(string2.charAt(n3), bl)) {
                            ++n3;
                        }
                        if (n3 != n2) {
                            string = string2.substring(n2, n3);
                        }
                    }
                    return string;
                }

                private boolean isNumber(char c, boolean bl) {
                    return c >= '0' && c <= '9' || bl && c >= 'a' && c <= 'f';
                }
            };
            this.textArea.setToolTipText("");
            this.textArea.setName("MessageText");
            this.textArea.setLineWrap(true);
            this.textArea.setEditable(false);
            this.textArea.addFocusListener(this);
            new IncrementalSearch(this.textArea);
            this.setViewportView(this.textArea);
            this.defaultBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createLoweredBevelBorder());
            this.focusBorder = BorderFactory.createCompoundBorder(Borders.STIPPLE, BorderFactory.createLoweredBevelBorder());
            this.setBorder(this.defaultBorder);
            this.textArea.addKeyListener(this.scrollListener);
            this.setName("MessageDetail");
        }

        public JTextArea getTextArea() {
            return this.textArea;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.setBorder(this.focusBorder);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.setBorder(this.defaultBorder);
        }

        public void cleanup() {
            if (LogDetailView.this.logging && LogDetailView.mvLogger.level >= 7) {
                mvLogger.log(7, "cleanup()", "");
            }
            this.setViewportView(null);
            this.setBorder(null);
            this.defaultBorder = null;
            this.focusBorder = null;
            this.textArea.removeKeyListener(this.scrollListener);
            this.scrollListener = null;
            this.textArea.removeFocusListener(this);
            this.textArea = null;
            LogDetailView.this.resources = null;
        }
    }
}

