/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog.logview;

import de.qfs.apps.qflog.logview.FilterNode;
import de.qfs.apps.qflog.logview.FilterRootNode;
import de.qfs.apps.qflog.logview.LogTableModel;
import de.qfs.apps.qflog.logview.NodeData;
import de.qfs.lib.config.Configurable;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.gui.TableModelFilter;
import de.qfs.lib.gui.TableModelFilterEvent;
import de.qfs.lib.gui.TableModelFilterListener;
import de.qfs.lib.gui.TreeNotification;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.Logger;
import de.qfs.lib.log.TreeFilter;
import de.qfs.lib.util.DelayedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class LogFilterTreeModel
extends TreeFilter
implements TreeModel,
Configurable,
TableModelFilter {
    static final Logger logger = new Logger("de.qfs.apps.qflog.logview.LogFilterTreeModel");
    private static int DEFAULT_LEVEL = 2;
    protected FilterNode root = new FilterRootNode("default", null, this);
    private Set filterPackages = new HashSet();
    private boolean packageFiltering;
    private Set listeners = new HashSet();
    private Set filterListeners = new HashSet();
    private DelayedAction delayedFilterChanged = new DelayedAction(30);
    private String configurableName;
    private String rootName = "default";
    private boolean logging;

    public LogFilterTreeModel() {
        this.root.setLevel(DEFAULT_LEVEL);
    }

    public void cleanup() {
        if (this.logging && LogFilterTreeModel.logger.level >= 7) {
            logger.log(7, "cleanup()", "");
        }
        this.root = null;
        this.filterPackages = null;
        this.listeners = null;
        this.filterListeners = null;
        this.delayedFilterChanged = null;
    }

    public final String getRootName() {
        return this.rootName;
    }

    public final void setRootName(String string) {
        this.rootName = string;
        this.root.getData().setClazz(string);
    }

    public final void setLoggingEnabled(boolean bl) {
        this.logging = bl;
    }

    public Object[] getPath(String string, String string2) {
        ArrayList<FilterNode> arrayList = new ArrayList<FilterNode>();
        arrayList.add(this.root);
        FilterNode filterNode = null;
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            String string3 = string.substring(0, n + 1);
            filterNode = this.root.findChild(string3, null);
            if (filterNode == null) {
                return null;
            }
            arrayList.add(filterNode);
            if (string.endsWith(".")) {
                return arrayList.toArray();
            }
        } else {
            filterNode = this.root;
        }
        if ((filterNode = filterNode.findChild(string, null)) == null) {
            return null;
        }
        arrayList.add(filterNode);
        if (string2 == null) {
            return arrayList.toArray();
        }
        if ((filterNode = filterNode.findChild(string, string2)) == null) {
            return null;
        }
        arrayList.add(filterNode);
        return arrayList.toArray();
    }

    @Override
    public void setDefault(int n) {
        if (this.root.getData().getLevel() == null || this.root.getData().getLevel() != n) {
            this.root.setLevel(n);
            super.setDefault(n);
            this.fireNodesChanged(new Object[]{this.root});
            this.fireFilterChanged();
        }
    }

    @Override
    public void setLevel(String string, String string2, int n, boolean bl) {
        super.setLevel(string, string2, n, bl);
        FilterNode filterNode = this.findNode(string, string2);
        if (filterNode != null) {
            if (filterNode.getData().getLevel() == null || filterNode.getData().getLevel() != n) {
                filterNode.setLevel(n);
                filterNode.notify(new TreeNotification(0, 0));
                this.fireFilterChanged();
            }
        } else {
            System.err.println("couldn't find node: " + string + "-" + string2);
        }
    }

    public void setLevel(TreePath treePath, int n) {
        FilterNode filterNode = (FilterNode)treePath.getLastPathComponent();
        if (filterNode == this.root) {
            this.setDefault(n);
            return;
        }
        NodeData nodeData = filterNode.getData();
        if (nodeData.getLevel() == null || nodeData.getLevel() != n) {
            super.setLevel(nodeData.getClazz(), nodeData.getMethod(), n, false);
            filterNode.setLevel(n);
            filterNode.notify(new TreeNotification(0, 0));
            this.fireFilterChanged();
        }
    }

    public void removeLevel(TreePath treePath, boolean bl) {
        boolean bl2 = false;
        FilterNode filterNode = (FilterNode)treePath.getLastPathComponent();
        if (filterNode == this.root) {
            if (this.root.getData().getLevel() == null || this.root.getData().getLevel() != DEFAULT_LEVEL) {
                this.setDefault(DEFAULT_LEVEL);
                bl2 = true;
            }
            if (bl) {
                for (FilterNode filterNode2 : filterNode.getChildren()) {
                    NodeData nodeData = filterNode2.getData();
                    super.removeLevel(nodeData.getClazz(), nodeData.getMethod(), bl);
                    bl2 = this.clearNodes(filterNode2, bl) || bl2;
                }
            }
        } else {
            NodeData nodeData = filterNode.getData();
            super.removeLevel(nodeData.getClazz(), nodeData.getMethod(), bl);
            bl2 = this.clearNodes(filterNode, bl);
        }
        if (bl2) {
            this.fireFilterChanged();
        }
    }

    private boolean clearNodes(FilterNode filterNode, boolean bl) {
        boolean bl2 = false;
        if (filterNode.getData().getLevel() != null) {
            filterNode.getData().setLevel(null);
            filterNode.notify(new TreeNotification(0, 0));
            bl2 = true;
        }
        if (bl) {
            Iterator iterator = filterNode.getChildren().iterator();
            while (iterator.hasNext()) {
                bl2 = this.clearNodes((FilterNode)iterator.next(), bl) || bl2;
            }
        }
        return bl2;
    }

    @Override
    protected void methodAdded(final String string, final String string2) {
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                boolean bl;
                boolean bl2 = bl = !LogFilterTreeModel.this.logging;
                if (bl) {
                    Log.excludeThread();
                }
                try {
                    LogFilterTreeModel.this._methodAdded(string, string2);
                }
                finally {
                    if (bl) {
                        Log.includeThread();
                    }
                }
            }
        });
    }

    private void _methodAdded(String string, String string2) {
        FilterNode filterNode = null;
        FilterNode filterNode2 = this.root;
        FilterNode filterNode3 = null;
        String string3 = string;
        String string4 = string2;
        boolean bl = false;
        boolean bl2 = false;
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            String string5 = string.substring(0, n + 1);
            filterNode = this.root.findChild(string5, null);
            if (filterNode == null) {
                filterNode3 = filterNode = this._addChild(this.root, string5, null);
            }
            filterNode2 = filterNode;
        }
        if (!string.endsWith(".") && (filterNode = filterNode2.findChild(string, null)) == null) {
            filterNode = this._addChild(filterNode2, string, null);
            if (filterNode3 == null) {
                filterNode3 = filterNode;
            }
        }
        if (string2 != null && (filterNode = (filterNode2 = filterNode).findChild(string, string2)) == null) {
            filterNode = this._addChild(filterNode2, string, string2);
            if (filterNode3 == null) {
                filterNode3 = filterNode;
            }
        }
        if (filterNode3 != null) {
            filterNode3.getParent().notify(new TreeNotification(1, filterNode3.getParent().getChildren().indexOf(filterNode3)));
        }
    }

    private FilterNode _addChild(FilterNode filterNode, String string, String string2) {
        FilterNode filterNode2 = new FilterNode(string, string2);
        int n = Collections.binarySearch(filterNode.getChildren(), filterNode2);
        if (n < 0) {
            n = -(n + 1);
        }
        filterNode.getChildren().add(n, filterNode2);
        filterNode2.setParent(filterNode);
        return filterNode2;
    }

    @Override
    public String getConfigurableName() {
        return this.configurableName;
    }

    @Override
    public void setConfigurableName(String string) {
        this.configurableName = string;
    }

    @Override
    public Properties getConfigurableState() {
        boolean bl;
        Properties properties = new Properties();
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            this.makeState(properties, this.root);
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
        return properties;
    }

    @Override
    public void setConfigurableState(final Properties properties) {
        SwingUtil.invokeAndWait(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean bl;
                boolean bl2 = bl = !LogFilterTreeModel.this.logging;
                if (bl) {
                    Log.excludeThread();
                }
                try {
                    Enumeration<Object> enumeration = properties.keys();
                    while (enumeration.hasMoreElements()) {
                        String string;
                        String string2 = string = (String)enumeration.nextElement();
                        String string3 = null;
                        int n = string2.indexOf(45);
                        if (n >= 0) {
                            string2 = string2.substring(0, n);
                            string3 = n == string.length() - 1 ? null : string.substring(n + 1);
                        }
                        try {
                            Integer n2 = Integer.valueOf(properties.getProperty(string));
                            NodeData nodeData = new NodeData(string2, string3, n2);
                            if ("*default*".equals(nodeData.getClazz())) {
                                LogFilterTreeModel.this.setDefault(nodeData.getLevel());
                                continue;
                            }
                            LogFilterTreeModel.this.setLevel(nodeData.getClazz(), nodeData.getMethod(), nodeData.getLevel(), false);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                finally {
                    if (bl) {
                        Log.includeThread();
                    }
                }
            }
        });
    }

    @Override
    public void registrationChanged(Configuration configuration, String string, boolean bl, boolean bl2) {
        if (LogFilterTreeModel.logger.level >= 7) {
            logger.log(7, "registrationChanged(Configuration,String,boolean,boolean)", (String)(LogFilterTreeModel.logger.level < 8 ? "" : "name: " + string + ", registered: " + bl));
        }
    }

    @Override
    public synchronized void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(treeModelListener);
    }

    @Override
    public synchronized void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(treeModelListener);
    }

    @Override
    public Object getChild(Object object, int n) {
        return ((FilterNode)object).getChildren().get(n);
    }

    @Override
    public int getChildCount(Object object) {
        return ((FilterNode)object).getChildren().size();
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return ((FilterNode)object).getChildren().indexOf(object2);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        return ((FilterNode)object).getData().getMethod() != null;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public void notify(TreeNotification treeNotification) {
        switch (treeNotification.getOperation()) {
            case 0: {
                this.fireNodesChanged(treeNotification.getPath());
                break;
            }
            case 1: {
                this.fireNodesInserted(treeNotification.getPath(), treeNotification.getIndex());
                break;
            }
            case 3: {
                this.fireNodeStructureChanged(treeNotification.getPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodesInserted(Object[] objectArray, int n) {
        boolean bl;
        TreeModelListener[] treeModelListenerArray;
        Object e = ((FilterNode)objectArray[objectArray.length - 1]).getChildren().get(n);
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, objectArray, new int[]{n}, new Object[]{e});
        LogFilterTreeModel logFilterTreeModel = this;
        synchronized (logFilterTreeModel) {
            treeModelListenerArray = this.listeners.toArray(new TreeModelListener[0]);
        }
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            for (int i = 0; i < treeModelListenerArray.length; ++i) {
                treeModelListenerArray[i].treeNodesInserted(treeModelEvent);
            }
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodesChanged(Object[] objectArray) {
        boolean bl;
        TreeModelListener[] treeModelListenerArray;
        Object object = this;
        synchronized (object) {
            treeModelListenerArray = this.listeners.toArray(new TreeModelListener[0]);
        }
        object = new TreeModelEvent((Object)this, objectArray);
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            for (int i = 0; i < treeModelListenerArray.length; ++i) {
                treeModelListenerArray[i].treeNodesChanged((TreeModelEvent)object);
            }
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeStructureChanged(Object[] objectArray) {
        boolean bl;
        TreeModelListener[] treeModelListenerArray;
        Object object = this;
        synchronized (object) {
            treeModelListenerArray = this.listeners.toArray(new TreeModelListener[0]);
        }
        object = new TreeModelEvent((Object)this, objectArray);
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            for (int i = 0; i < treeModelListenerArray.length; ++i) {
                treeModelListenerArray[i].treeStructureChanged((TreeModelEvent)object);
            }
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    public Integer getLevel(Object object) {
        return ((FilterNode)object).getData().getLevel();
    }

    @Override
    public boolean filter(TableModel tableModel, int n) {
        LogEntry logEntry = ((LogTableModel)tableModel).getEntry(n);
        return this.filter(logEntry);
    }

    @Override
    public void addTableModelFilterListener(TableModelFilterListener tableModelFilterListener) {
        this.filterListeners.add(tableModelFilterListener);
    }

    @Override
    public void removeTableModelFilterListener(TableModelFilterListener tableModelFilterListener) {
        this.filterListeners.remove(tableModelFilterListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFilterChanged() {
        boolean bl;
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            final TableModelFilterListener[] tableModelFilterListenerArray = this.filterListeners.toArray(new TableModelFilterListener[0]);
            final TableModelFilterEvent tableModelFilterEvent = new TableModelFilterEvent(this);
            this.delayedFilterChanged.perform(new Runnable(){

                @Override
                public void run() {
                    boolean bl;
                    boolean bl2 = bl = !LogFilterTreeModel.this.logging;
                    if (bl) {
                        Log.excludeThread();
                    }
                    try {
                        for (int i = 0; i < tableModelFilterListenerArray.length; ++i) {
                            tableModelFilterListenerArray[i].filterChanged(tableModelFilterEvent);
                        }
                    }
                    finally {
                        if (bl) {
                            Log.includeThread();
                        }
                    }
                }
            });
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    @Override
    public boolean filter(LogEntry logEntry) {
        if (!super.filter(logEntry)) {
            return false;
        }
        if (this.packageFiltering) {
            boolean bl = false;
            for (FilterNode filterNode : this.filterPackages) {
                if (filterNode == this.root) {
                    bl = true;
                    break;
                }
                String string = filterNode.getData().getClazz();
                String string2 = logEntry.getClazz();
                if (!string2.startsWith(string) || string2.length() != string.length() && string2.substring(string.length() + 1).indexOf(46) >= 0 || filterNode.getData().getMethod() != null && !filterNode.getData().getMethod().equals(logEntry.getMethod())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
        }
        return true;
    }

    public void togglePackageFiltering() {
        if (this.logging && LogFilterTreeModel.logger.level >= 7) {
            logger.log(7, "togglePackageFiltering()", "");
        }
        this.packageFiltering = !this.packageFiltering;
        for (FilterNode filterNode : this.filterPackages) {
            filterNode.setExtra(this.packageFiltering);
            filterNode.notify(new TreeNotification(0, 0));
        }
        this.fireFilterChanged();
    }

    public void addFilterPackage(FilterNode filterNode) {
        if (this.logging && LogFilterTreeModel.logger.level >= 7) {
            logger.log(7, "addFilterPackage(FilterNode)", (String)(LogFilterTreeModel.logger.level < 8 ? "" : "node: " + String.valueOf(filterNode)));
        }
        if (this.filterPackages.add(filterNode) && this.packageFiltering) {
            filterNode.setExtra(true);
            filterNode.notify(new TreeNotification(0, 0));
            this.fireFilterChanged();
        }
    }

    public void removeFilterPackage(FilterNode filterNode) {
        if (this.logging && LogFilterTreeModel.logger.level >= 7) {
            logger.log(7, "removeFilterPackage(FilterNode)", (String)(LogFilterTreeModel.logger.level < 8 ? "" : "node: " + String.valueOf(filterNode)));
        }
        if (this.filterPackages.remove(filterNode) && this.packageFiltering) {
            filterNode.setExtra(false);
            filterNode.notify(new TreeNotification(0, 0));
            this.fireFilterChanged();
        }
    }

    public void clearFilterPackages() {
        if (this.logging && LogFilterTreeModel.logger.level >= 7) {
            logger.log(7, "clearFilterPackages()", "");
        }
        if (!this.filterPackages.isEmpty()) {
            for (FilterNode filterNode : this.filterPackages) {
                filterNode.setExtra(false);
                filterNode.notify(new TreeNotification(0, 0));
            }
            this.filterPackages.clear();
            this.fireFilterChanged();
        }
    }

    public boolean isPackageFilteringEnabled() {
        return this.packageFiltering;
    }

    public FilterNode findNode(String string, String string2) {
        FilterNode filterNode = null;
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            String string3 = string.substring(0, n + 1);
            filterNode = this.root.findChild(string3, null);
            if (filterNode == null || string.endsWith(".")) {
                return filterNode;
            }
        } else {
            filterNode = this.root;
        }
        filterNode = filterNode.findChild(string, null);
        if (string2 == null) {
            return filterNode;
        }
        filterNode = filterNode.findChild(string, string2);
        return filterNode;
    }

    private void makeState(Properties properties, FilterNode filterNode) {
        Object object;
        NodeData nodeData = filterNode.getData();
        if (nodeData.getLevel() != null) {
            object = nodeData.getClazz();
            if (filterNode == this.root) {
                object = "*default*";
            }
            if (nodeData.getMethod() != null) {
                object = (String)object + "-" + nodeData.getMethod();
            }
            properties.put(object, nodeData.getLevel().toString());
        }
        object = filterNode.getChildren().toArray(new FilterNode[0]);
        for (int i = 0; i < ((FilterNode[])object).length; ++i) {
            this.makeState(properties, object[i]);
        }
    }
}

