/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog.logview;

import de.qfs.apps.qflog.logview.LogLevelTreeModel;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.gui.WindowsTreeCellRenderer;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.Logger;
import de.qfs.lib.option.OptionDialog;
import de.qfs.lib.util.MapResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.TreePath;

public class LogLevelView
extends JPanel {
    private static final Logger logger = new Logger("de.qfs.apps.qflog.logview.LogLevelView");
    private transient LogLevelTreeModel model;
    private transient boolean initialized;
    private transient JTree tree;
    private transient MapResourceBundle resources;
    private transient JPopupMenu popup;
    private transient PopupListener popupListener;
    private OptionDialog optionDialog;
    private boolean logging;
    private Action removeAction;
    private Action removeRecursiveAction;
    private Action setERRAction;
    private Action setERRDETAILAction;
    private Action setWRNAction;
    private Action setWRNDETAILAction;
    private Action setMSGAction;
    private Action setMSGDETAILAction;
    private Action setMTDAction;
    private Action setMTDDETAILAction;
    private Action setDBGAction;
    private Action setDBGDETAILAction;
    private Action expandAllAction;
    private Action collapseAllAction;
    private Action showSetLevelsAction;
    private Action editOptionsAction;
    private static final int CLASS = 10;
    private static final int PACKAGE = 11;
    private static final int PACKAGE_OPEN = 12;
    private static final String[] iconNames = new String[]{"logLevelView.icon.err", "logLevelView.icon.errDetail", "logLevelView.icon.wrn", "logLevelView.icon.wrnDetail", "logLevelView.icon.msg", "logLevelView.icon.msgDetail", "logLevelView.icon.mtd", "logLevelView.icon.mtdDetail", "logLevelView.icon.dbg", "logLevelView.icon.dbgDetail", "logLevelView.icon.class", "logLevelView.icon.package", "logLevelView.icon.packageOpen"};
    private static final Icon[] icons = new Icon[iconNames.length];

    public LogLevelView(LogLevelTreeModel logLevelTreeModel) {
        boolean bl;
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            this.model = logLevelTreeModel;
            this.resources = new MapResourceBundle();
            this.resources.setResolvingClass(this.getClass());
            this.resources.fetchProperties("/de/qfs/apps/qflog/logview/resources/properties/loglevelview", this.getClass());
            logLevelTreeModel.setRootName(this.resources.getString("logLevelView.root.name", "default"));
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    public final void setLoggingEnabled(boolean bl) {
        this.logging = bl;
        this.model.setLoggingEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        boolean bl;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            this.setLayout(new BorderLayout());
            this.setBorder(null);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.setBorder(null);
            String string = this.resources.getString("logLevelView.title", "Log levels");
            JLabel jLabel = new JLabel(string);
            jLabel.setForeground(UIManager.getColor("textText"));
            jLabel.setBorder(BorderFactory.createEtchedBorder());
            jPanel.add((Component)jLabel, "North");
            this.tree = new JTree(this.model){

                @Override
                public boolean hasBeenExpanded(TreePath treePath) {
                    return false;
                }
            };
            this.tree.setName("LevelTree");
            this.tree.setBorder(null);
            this.tree.setCellRenderer(new Renderer());
            JScrollPane jScrollPane = new JScrollPane(this.tree);
            jScrollPane.setName("TreeScrollPane");
            jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
            jPanel.add((Component)jScrollPane, "Center");
            this.add((Component)jPanel, "Center");
            this.tree.setSelectionRow(0);
            this.setupActions();
            this.tree.registerKeyboardAction(this.removeAction, "remove", KeyStroke.getKeyStroke(127, 0), 0);
            this.tree.registerKeyboardAction(this.removeRecursiveAction, "removeRecursive", KeyStroke.getKeyStroke(127, 2), 0);
            this.tree.registerKeyboardAction(this.setERRAction, "setERR", KeyStroke.getKeyStroke(49, 0), 0);
            this.tree.registerKeyboardAction(this.setERRDETAILAction, "setERRDETAIL", KeyStroke.getKeyStroke(50, 0), 0);
            this.tree.registerKeyboardAction(this.setWRNAction, "setWRN", KeyStroke.getKeyStroke(51, 0), 0);
            this.tree.registerKeyboardAction(this.setWRNDETAILAction, "setWRNDETAIL", KeyStroke.getKeyStroke(52, 0), 0);
            this.tree.registerKeyboardAction(this.setMSGAction, "MSGERR", KeyStroke.getKeyStroke(53, 0), 0);
            this.tree.registerKeyboardAction(this.setMSGDETAILAction, "setMSGDETAIL", KeyStroke.getKeyStroke(54, 0), 0);
            this.tree.registerKeyboardAction(this.setMTDAction, "setMTD", KeyStroke.getKeyStroke(55, 0), 0);
            this.tree.registerKeyboardAction(this.setMTDDETAILAction, "setMTDDETAIL", KeyStroke.getKeyStroke(56, 0), 0);
            this.tree.registerKeyboardAction(this.setDBGAction, "setDBG", KeyStroke.getKeyStroke(57, 0), 0);
            this.tree.registerKeyboardAction(this.setDBGDETAILAction, "setDBGDETAIL", KeyStroke.getKeyStroke(48, 0), 0);
            this.tree.registerKeyboardAction(this.expandAllAction, "expandAll", KeyStroke.getKeyStroke(39, 8), 0);
            this.tree.registerKeyboardAction(this.collapseAllAction, "collapseAll", KeyStroke.getKeyStroke(37, 8), 0);
            this.popup = new JPopupMenu();
            this.fillMenu(this.popup);
            this.popupListener = new PopupListener();
            this.tree.addMouseListener(this.popupListener);
            this.showSetLevels();
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    public void cleanup() {
        if (this.logging && LogLevelView.logger.level >= 7) {
            logger.log(7, "cleanup()", "");
        }
        SwingUtil.cleanup(this);
        this.tree.removeMouseListener(this.popupListener);
        this.popupListener = null;
        SwingUtil.cleanup(this.popup);
        this.popup = null;
        this.tree.resetKeyboardActions();
        this.tree = null;
        this.resources = null;
        this.model.cleanup();
        this.model = null;
    }

    public final LogLevelTreeModel getModel() {
        return this.model;
    }

    public final JTree getTree() {
        return this.tree;
    }

    public void fillMenu(JMenu jMenu) {
        jMenu.add(this.removeAction);
        jMenu.add(this.removeRecursiveAction);
        jMenu.addSeparator();
        jMenu.add(this.setERRAction);
        jMenu.add(this.setERRDETAILAction);
        jMenu.add(this.setWRNAction);
        jMenu.add(this.setWRNDETAILAction);
        jMenu.add(this.setMSGAction);
        jMenu.add(this.setMSGDETAILAction);
        jMenu.add(this.setMTDAction);
        jMenu.add(this.setMTDDETAILAction);
        jMenu.add(this.setDBGAction);
        jMenu.add(this.setDBGDETAILAction);
        jMenu.addSeparator();
        JMenuItem jMenuItem = jMenu.add(this.showSetLevelsAction);
        String string = this.resources.getString("logLevelView.action.showSetLevels.mnemonic", null);
        if (string != null) {
            jMenuItem.setMnemonic(string.charAt(0));
        }
        jMenu.addSeparator();
        jMenuItem = jMenu.add(this.editOptionsAction);
        string = this.resources.getString("logLevelView.action.editOptions.mnemonic", null);
        if (string != null) {
            jMenuItem.setMnemonic(string.charAt(0));
        }
    }

    public void fillMenu(JPopupMenu jPopupMenu) {
        jPopupMenu.add(this.removeAction);
        jPopupMenu.add(this.removeRecursiveAction);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.setERRAction);
        jPopupMenu.add(this.setERRDETAILAction);
        jPopupMenu.add(this.setWRNAction);
        jPopupMenu.add(this.setWRNDETAILAction);
        jPopupMenu.add(this.setMSGAction);
        jPopupMenu.add(this.setMSGDETAILAction);
        jPopupMenu.add(this.setMTDAction);
        jPopupMenu.add(this.setMTDDETAILAction);
        jPopupMenu.add(this.setDBGAction);
        jPopupMenu.add(this.setDBGDETAILAction);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.showSetLevelsAction);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.editOptionsAction);
    }

    public void setResources(ResourceBundle resourceBundle) {
        this.resources.addResources(resourceBundle);
    }

    public void showSetLevels() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogLevelView.this.showSetLevelsAction.actionPerformed(null);
            }
        });
    }

    private void setupActions() {
        if (this.removeAction == null) {
            this.removeAction = new RemoveLevelAction(false);
            this.setActionProperties(this.removeAction, "removeLevel");
            this.removeRecursiveAction = new RemoveLevelAction(true);
            this.setActionProperties(this.removeRecursiveAction, "removeLevelRecursive");
            this.setERRAction = new ChangeLevelAction(1);
            this.setActionProperties(this.setERRAction, "setLevelERR");
            this.setERRDETAILAction = new ChangeLevelAction(2);
            this.setActionProperties(this.setERRDETAILAction, "setLevelERRDETAIL");
            this.setWRNAction = new ChangeLevelAction(3);
            this.setActionProperties(this.setWRNAction, "setLevelWRN");
            this.setWRNDETAILAction = new ChangeLevelAction(4);
            this.setActionProperties(this.setWRNDETAILAction, "setLevelWRNDETAIL");
            this.setMSGAction = new ChangeLevelAction(5);
            this.setActionProperties(this.setMSGAction, "setLevelMSG");
            this.setMSGDETAILAction = new ChangeLevelAction(6);
            this.setActionProperties(this.setMSGDETAILAction, "setLevelMSGDETAIL");
            this.setMTDAction = new ChangeLevelAction(7);
            this.setActionProperties(this.setMTDAction, "setLevelMTD");
            this.setMTDDETAILAction = new ChangeLevelAction(8);
            this.setActionProperties(this.setMTDDETAILAction, "setLevelMTDDETAIL");
            this.setDBGAction = new ChangeLevelAction(9);
            this.setActionProperties(this.setDBGAction, "setLevelDBG");
            this.setDBGDETAILAction = new ChangeLevelAction(10);
            this.setActionProperties(this.setDBGDETAILAction, "setLevelDBGDETAIL");
            this.expandAllAction = new AbstractAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TreePath treePath = LogLevelView.this.tree.getSelectionPath();
                    if (treePath != null) {
                        boolean bl;
                        boolean bl2 = bl = !LogLevelView.this.logging;
                        if (bl) {
                            Log.excludeThread();
                        }
                        try {
                            SwingUtil.expandAll(LogLevelView.this.tree, treePath, 1000);
                        }
                        finally {
                            if (bl) {
                                Log.includeThread();
                            }
                        }
                    }
                }
            };
            this.collapseAllAction = new AbstractAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TreePath treePath = LogLevelView.this.tree.getSelectionPath();
                    if (treePath != null) {
                        boolean bl;
                        boolean bl2 = bl = !LogLevelView.this.logging;
                        if (bl) {
                            Log.excludeThread();
                        }
                        try {
                            SwingUtil.collapseAll(LogLevelView.this.tree, treePath, 1000);
                        }
                        finally {
                            if (bl) {
                                Log.includeThread();
                            }
                        }
                    }
                }
            };
            this.showSetLevelsAction = new ShowSetLevelsAction();
            this.setActionProperties(this.showSetLevelsAction, "showSetLevels");
            this.editOptionsAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LogLevelView.this.editOptions();
                }
            };
            this.setActionProperties(this.editOptionsAction, "editOptions");
        }
    }

    private void setActionProperties(Action action, String string) {
        Icon icon;
        String string2;
        String string3 = this.resources.getString("logLevelView.action." + string + ".name", null);
        if (string3 != null) {
            action.putValue("Name", string3);
        }
        if ((string2 = this.resources.getString("logLevelView.action." + string + ".icon", null)) != null && (icon = this.resources.getIcon(string2, null)) != null) {
            action.putValue("SmallIcon", icon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editOptions() {
        boolean bl;
        if (this.logging && LogLevelView.logger.level >= 7) {
            logger.log(7, "editOptions()", "");
        }
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            Window window = SwingUtilities.windowForComponent(this);
            Frame frame = window instanceof Frame ? (Frame)window : new Frame();
            if (this.optionDialog == null) {
                this.optionDialog = new OptionDialog("logLevelView", frame, this.model.getOptions(), "levelview");
                this.optionDialog.setReusable(true);
                SwingUtil.closeOnEscape(this.optionDialog);
            } else {
                this.optionDialog.update(this.model.getOptions());
            }
            this.optionDialog.doModal(this, true);
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    private class Renderer
    extends WindowsTreeCellRenderer {
        public Renderer() {
            this.initIcons();
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            int n2;
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Integer n3 = LogLevelView.this.model.getLevel(object);
            int n4 = bl3 ? 10 : (n2 = bl2 ? 12 : 11);
            if (n3 == null) {
                jLabel.setIcon(icons[n2]);
                return jLabel;
            }
            int n5 = n3;
            if (n5 < 1 || n5 > 10) {
                jLabel.setIcon(icons[n2]);
            } else {
                jLabel.setIcon(icons[n3 - 1]);
            }
            return jLabel;
        }

        private void initIcons() {
            if (icons[0] == null) {
                for (int i = 0; i < icons.length; ++i) {
                    LogLevelView.icons[i] = LogLevelView.this.resources.getIcon(iconNames[i], null);
                }
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybePopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybePopup(mouseEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybePopup(MouseEvent mouseEvent) {
            boolean bl;
            boolean bl2 = bl = !LogLevelView.this.logging;
            if (bl) {
                Log.excludeThread();
            }
            try {
                if (mouseEvent.isPopupTrigger()) {
                    int n = LogLevelView.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (n >= 0) {
                        if (!LogLevelView.this.tree.isRowSelected(n)) {
                            LogLevelView.this.tree.setSelectionRow(n);
                        }
                    } else if (LogLevelView.this.tree.isSelectionEmpty()) {
                        return;
                    }
                    SwingUtil.showPopup(LogLevelView.this.popup, LogLevelView.this.tree, mouseEvent.getX(), mouseEvent.getY(), false);
                }
            }
            finally {
                if (bl) {
                    Log.includeThread();
                }
            }
        }
    }

    private class RemoveLevelAction
    extends AbstractAction {
        private boolean recurse;

        public RemoveLevelAction(boolean bl) {
            this.recurse = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath[] treePathArray = LogLevelView.this.tree.getSelectionPaths();
            if (treePathArray != null) {
                for (int i = 0; i < treePathArray.length; ++i) {
                    LogLevelView.this.model.removeLogLevel(treePathArray[i], this.recurse);
                }
            }
        }
    }

    private class ChangeLevelAction
    extends AbstractAction {
        private int level;

        public ChangeLevelAction(int n) {
            this.level = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath[] treePathArray = LogLevelView.this.tree.getSelectionPaths();
            if (treePathArray != null) {
                for (int i = 0; i < treePathArray.length; ++i) {
                    LogLevelView.this.model.setLogLevel(treePathArray[i], this.level);
                }
            }
        }
    }

    private class ShowSetLevelsAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            boolean bl2 = bl = !LogLevelView.this.logging;
            if (bl) {
                Log.excludeThread();
            }
            try {
                this.maybeExpandPath(new TreePath(new Object[]{LogLevelView.this.model.getRoot()}));
            }
            finally {
                if (bl) {
                    Log.includeThread();
                }
            }
        }

        private boolean maybeExpandPath(TreePath treePath) {
            Object object;
            if (LogLevelView.this.logging && LogLevelView.logger.level >= 7) {
                logger.log(7, "maybeExpandPath(TreePath)", (String)(LogLevelView.logger.level < 8 ? "" : "path: " + String.valueOf(treePath)));
            }
            boolean bl = LogLevelView.this.model.getLevel(object = treePath.getLastPathComponent()) != null;
            boolean bl2 = false;
            if (LogLevelView.this.model.isLeaf(object)) {
                return bl;
            }
            int n = LogLevelView.this.model.getChildCount(object);
            for (int i = 0; i < n; ++i) {
                Object object2 = LogLevelView.this.model.getChild(object, i);
                if (!this.maybeExpandPath(treePath.pathByAddingChild(object2))) continue;
                bl2 = true;
            }
            if (object == LogLevelView.this.model.getRoot()) {
                bl2 = true;
            }
            if (LogLevelView.logger.level >= 9) {
                logger.log(9, "maybeExpandPath(TreePath)", "expand: " + bl2);
            }
            if (bl2) {
                LogLevelView.this.tree.expandPath(treePath);
            } else {
                LogLevelView.this.tree.collapsePath(treePath);
            }
            return bl2 || bl;
        }
    }
}

