/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog.logview;

import de.qfs.lib.log.LogEntry;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.GregorianCalendar;

public class LogParser {
    private MillisCalendar cal = new MillisCalendar();
    private static final String LINESEP = System.getProperty("line.separator");
    protected ProgressCallback callback;
    public boolean debug;

    public void setProgressCallback(ProgressCallback progressCallback) {
        this.callback = progressCallback;
    }

    public LogEntry[] parse(BufferedReader bufferedReader) throws IOException {
        ArrayList<LogEntry> arrayList = new ArrayList<LogEntry>();
        LogEntry logEntry = null;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        String string = bufferedReader.readLine();
        while (string != null) {
            ++n;
            n2 += string.length() + 1;
            LogEntry logEntry2 = this.parse(string);
            if (this.debug) {
                System.err.println("entry: " + String.valueOf(logEntry2));
                System.err.println("last: " + String.valueOf(logEntry));
            }
            if (logEntry2 == null) {
                if (logEntry != null) {
                    if (!bl) {
                        stringBuffer.setLength(0);
                        stringBuffer.append(logEntry.getMessage());
                        bl = true;
                    }
                    stringBuffer.append(LINESEP);
                    stringBuffer.append(string);
                }
            } else {
                if (logEntry != null) {
                    if (bl) {
                        logEntry.setMessage(stringBuffer.toString());
                    }
                    arrayList.add(logEntry);
                }
                logEntry = logEntry2;
                bl = false;
            }
            if (this.callback != null && !this.callback.progress(n, n2)) {
                string = null;
                continue;
            }
            string = bufferedReader.readLine();
        }
        if (logEntry != null) {
            if (bl) {
                logEntry.setMessage(stringBuffer.toString());
            }
            arrayList.add(logEntry);
        }
        return arrayList.toArray(new LogEntry[0]);
    }

    public LogEntry parse(String string) {
        try {
            int n;
            char c = string.charAt(0);
            int n2 = 3;
            if (c < '1' || c > '9') {
                if (this.debug) {
                    System.err.println("bad c: " + c);
                }
                return null;
            }
            if (c == '1' && string.charAt(1) == '0') {
                n = 10;
                n2 = 4;
            } else {
                n = c - 48;
            }
            if (string.charAt(n2 - 2) != ' ' || string.charAt(n2 - 1) != '(') {
                if (this.debug) {
                    System.err.println("no (");
                }
                return null;
            }
            int n3 = string.indexOf(")");
            if (n3 < 0) {
                if (this.debug) {
                    System.err.println("no )");
                }
                return null;
            }
            if (string.charAt(n3 + 1) != ' ') {
                if (this.debug) {
                    System.err.println("no blank after )");
                }
                return null;
            }
            String string2 = string.substring(n2, n3);
            if (!this.parseTime(string2)) {
                if (this.debug) {
                    System.err.println("bad parseTime: " + string2);
                }
                return null;
            }
            int n4 = (string = string.substring(n3 + 2)).indexOf("): ");
            if (n4 < 0) {
                if (this.debug) {
                    System.err.println("no ):");
                }
                return null;
            }
            int n5 = string.lastIndexOf("(", n4);
            if (n5 < 0) {
                if (this.debug) {
                    System.err.println("no (");
                }
                return null;
            }
            String string3 = string.substring(n4 + 3);
            int n6 = string.lastIndexOf(".", n5);
            if (n6 < 0) {
                if (this.debug) {
                    System.err.println("no .");
                }
                return null;
            }
            String string4 = string.substring(n6 + 1, n4 + 1);
            int n7 = string.lastIndexOf(" ", n6);
            if (n7 < 0) {
                if (this.debug) {
                    System.err.println("no blank after thread");
                }
                return null;
            }
            String string5 = string.substring(0, n7);
            String string6 = string.substring(n7 + 1, n6);
            return new LogEntry(n, this.cal.getMillis(), string5, string6, string4, string3);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private boolean parseTime(String string) throws NumberFormatException, IllegalArgumentException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        if (string.length() == 12) {
            n4 = Integer.parseInt(string.substring(0, 2));
            n3 = Integer.parseInt(string.substring(3, 5));
            n2 = Integer.parseInt(string.substring(6, 8));
            n = Integer.parseInt(string.substring(9));
        } else if (string.length() == 21) {
            n5 = Integer.parseInt(string.substring(0, 2));
            n6 = Integer.parseInt(string.substring(3, 5));
            n7 += (n7 = Integer.parseInt(string.substring(6, 8))) < 70 ? 2000 : 1900;
            if (string.charAt(8) != ' ') {
                return false;
            }
            n4 = Integer.parseInt(string.substring(9, 11));
            n3 = Integer.parseInt(string.substring(12, 14));
            n2 = Integer.parseInt(string.substring(15, 17));
            n = Integer.parseInt(string.substring(18));
            bl = true;
        } else if (string.length() == 23) {
            n7 = Integer.parseInt(string.substring(0, 4));
            n6 = Integer.parseInt(string.substring(5, 7));
            n5 = Integer.parseInt(string.substring(8, 10));
            if (string.charAt(10) != ' ') {
                return false;
            }
            n4 = Integer.parseInt(string.substring(11, 13));
            n3 = Integer.parseInt(string.substring(14, 16));
            n2 = Integer.parseInt(string.substring(17, 19));
            n = Integer.parseInt(string.substring(20));
            bl = true;
        } else {
            return false;
        }
        if (bl) {
            this.cal.set(1, n7);
            this.cal.set(2, n6 - 1);
            this.cal.set(5, n5);
        }
        this.cal.set(11, n4);
        this.cal.set(12, n3);
        this.cal.set(13, n2);
        this.cal.set(14, n);
        return true;
    }

    private class MillisCalendar
    extends GregorianCalendar {
        public MillisCalendar() {
            this.setLenient(false);
        }

        public long getMillis() throws IllegalArgumentException {
            return this.getTimeInMillis();
        }
    }

    public static interface ProgressCallback {
        public boolean progress(int var1, int var2);
    }
}

