/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog.logview;

import de.qfs.apps.qflog.logview.FilterNode;
import de.qfs.apps.qflog.logview.InternalLogLevelCallback;
import de.qfs.apps.qflog.logview.LogFilterTreeModel;
import de.qfs.apps.qflog.logview.LogFilterView;
import de.qfs.apps.qflog.logview.LogFrame;
import de.qfs.apps.qflog.logview.LogLevelTreeModel;
import de.qfs.apps.qflog.logview.LogLevelView;
import de.qfs.apps.qflog.logview.LogTableModel;
import de.qfs.apps.qflog.logview.LogTableView;
import de.qfs.lib.config.Configurator;
import de.qfs.lib.gui.Message;
import de.qfs.lib.gui.MultiPane;
import de.qfs.lib.gui.MultiPaneEvent;
import de.qfs.lib.gui.MultiPaneListener;
import de.qfs.lib.gui.StatusLine;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.LogSource;
import de.qfs.lib.log.Logger;
import de.qfs.lib.log.ProguardMap;
import de.qfs.lib.log.ProguardMapPossessor;
import de.qfs.lib.option.BooleanOption;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.option.StringOption;
import de.qfs.lib.util.DelayedAction;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Observable;
import de.qfs.lib.util.Observer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.tree.TreePath;
import lombok.Generated;

public class LogView
extends JPanel
implements Observer,
ProguardMapPossessor {
    private static final Logger logger = new Logger("de.qfs.apps.qflog.logview.LogView");
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_INTERNAL = 1;
    public static final int STATE_FILE = 2;
    public static final int STATE_CONNECTED = 3;
    public static final int STATE_DISCONNECTED = 4;
    private transient int state = 0;
    private transient String clientName;
    private File file;
    private transient LogFrame frame;
    private transient LogFilterTreeModel filterModel;
    private transient LogFilterView filterView;
    private transient ButtonModel filterButtonModel;
    private transient LogLevelTreeModel levelModel;
    private transient LogLevelView levelView;
    private transient ButtonModel levelButtonModel;
    private transient LogTableModel tableModel;
    private transient LogTableView tableView;
    private transient ButtonModel detailButtonModel;
    private transient MultiPane multiPane;
    private transient MultiPane innerMulti;
    private transient MultiListener multiListener = new MultiListener();
    private transient Status status;
    private transient ButtonModel statusButtonModel;
    private transient MapResourceBundle resources;
    private transient Configurator cfg;
    private transient Configurator outerCfg;
    private transient File cfgSaveDir = new File(System.getProperties().getProperty("user.home") + File.separator + ".qflog");
    protected transient OptionSet options;
    private transient boolean initialized;
    private boolean logging = false;
    private ProguardMap proguardMap;
    private transient Action toggleFilterViewAction;
    private transient Action toggleLevelViewAction;
    private transient Action toggleDetailViewAction;
    private transient Action toggleStatusLineAction;
    private transient Action jumpTableFilterAction;
    private transient Action jumpTableLevelsAction;
    private transient Action jumpFilterLevelsAction;
    private transient Action jumpLevelsFilterAction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogView() {
        boolean bl;
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "LogView()", "");
        }
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            this.cfg = new Configurator("LogView");
            this.options = new OptionSet("Options");
            this.resources = new MapResourceBundle();
            this.resources.setResolvingClass(this.getClass());
            this.resources.fetchProperties("/de/qfs/apps/qflog/logview/resources/properties/logview", this.getClass());
            String string = System.getProperty("qflog.modelclass");
            if (string != null) {
                try {
                    this.tableModel = (LogTableModel)Class.forName(string).newInstance();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            if (this.tableModel == null) {
                this.tableModel = new LogTableModel();
            }
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    public static LogView logToView(String string) {
        LogView logView = new LogView();
        logView.startLogging();
        LogLevelTreeModel logLevelTreeModel = new LogLevelTreeModel();
        Logger.addLogLevelListener(logLevelTreeModel);
        logLevelTreeModel.setLogLevelCallback(new InternalLogLevelCallback(logLevelTreeModel));
        logView.setLogLevels(logLevelTreeModel);
        logView.setClientName(string);
        MapResourceBundle mapResourceBundle = new MapResourceBundle();
        mapResourceBundle.fetchProperties("/de/qfs/apps/qflog/logview/resources/properties/logview", LogView.class);
        mapResourceBundle.fetchProperties("/de/qfs/apps/qflog/logview/resources/properties/logfilterview", LogView.class);
        mapResourceBundle.fetchProperties("/de/qfs/apps/qflog/logview/resources/properties/loglevelview", LogView.class);
        mapResourceBundle.fetchProperties("/de/qfs/apps/qflog/logview/resources/properties/logtableview", LogView.class);
        Option.addResources(mapResourceBundle);
        Message.addResources(mapResourceBundle);
        return logView;
    }

    public void init() {
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "init()", "");
        }
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.setLayout(new BorderLayout());
        this.filterModel = new LogFilterTreeModel();
        this.filterModel.setConfigurableName("TreeFilter");
        this.filterView = new LogFilterView(this.filterModel);
        this.filterView.setLoggingEnabled(this.logging);
        this.filterView.init();
        this.tableView = new LogTableView(this.tableModel);
        this.tableView.setLoggingEnabled(this.logging);
        this.tableView.init();
        this.tableView.setFilter(this.filterModel);
        this.tableView.setProguardMap(this.proguardMap);
        this.tableView.getMultiPane().addMultiPaneListener(this.multiListener);
        this.options.addAll(this.tableView.getOptions());
        this.multiPane = new MultiPane("HorPane", 1, this.filterView, this.tableView, 0.25, 0, false);
        this.add((Component)this.multiPane, "Center");
        this.multiPane.addMultiPaneListener(this.multiListener);
        this.cfg.add(this.multiPane);
        if (this.levelModel != null) {
            this.addLogLevelView();
        }
        this.status = new Status();
        this.tableModel.addTableModelListener(this.status);
        this.tableModel.addChangeListener(this.status);
        this.tableView.getTable().getModel().addTableModelListener(this.status);
        this.tableView.setStatusLine(this.status);
        this.add((Component)this.status, "South");
        this.setPreferredSize(new Dimension(500, 300));
        this.cfg.add(this.filterModel);
        this.cfg.add(this.tableView.getConfigurator());
        OptionSet optionSet = new OptionSet("Options");
        Option option = new BooleanOption("ShowFilterView", true);
        option.addObserver(this);
        this.options.add(option);
        optionSet.add(option);
        option = new BooleanOption("ShowLevelView", true);
        option.addObserver(this);
        this.options.add(option);
        optionSet.add(option);
        option = new BooleanOption("ShowDetailView", true);
        option.addObserver(this);
        this.options.add(option);
        optionSet.add(option);
        option = new BooleanOption("ShowStatusLine", true);
        option.addObserver(this);
        this.options.add(option);
        optionSet.add(option);
        option = new StringOption("ProguardMapFile", null);
        option.addObserver(this);
        this.options.add(option);
        optionSet.add(option);
        this.cfg.add(optionSet);
        this.setupActions();
        this.tableView.getTable().registerKeyboardAction(this.jumpTableFilterAction, "jumpFilter", KeyStroke.getKeyStroke(74, 2), 0);
        this.tableView.getTable().registerKeyboardAction(this.jumpTableLevelsAction, "jumpLevels", KeyStroke.getKeyStroke(71, 2), 0);
        this.filterView.getTree().registerKeyboardAction(this.jumpFilterLevelsAction, "jumpLevels", KeyStroke.getKeyStroke(71, 2), 0);
        this.tableView.getTable().requestFocus();
    }

    public JMenu makeViewMenu() {
        JMenu jMenu = new JMenu(this.resources.getString("logView.menu.view.name", "View"));
        String string = this.resources.getString("logView.menu.view.mnemonic", null);
        if (string != null) {
            jMenu.setMnemonic(string.charAt(0));
        }
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.resources.getString("logView.action.view.showFilter.name", "Show filter view"));
        string = this.resources.getString("logView.action.view.showFilter.mnemonic", null);
        if (string != null) {
            jCheckBoxMenuItem.setMnemonic(string.charAt(0));
        }
        if (this.filterButtonModel == null) {
            this.filterButtonModel = jCheckBoxMenuItem.getModel();
            this.filterButtonModel.setSelected(this.options.getBoolean("ShowFilterView", true));
        } else {
            jCheckBoxMenuItem.setModel(this.filterButtonModel);
        }
        jCheckBoxMenuItem.addActionListener(this.toggleFilterViewAction);
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem = new JCheckBoxMenuItem(this.resources.getString("logView.action.view.showLevels.name", "Show log level view"));
        string = this.resources.getString("logView.action.view.showLevels.mnemonic", null);
        if (string != null) {
            jCheckBoxMenuItem.setMnemonic(string.charAt(0));
        }
        if (this.levelButtonModel == null) {
            this.levelButtonModel = jCheckBoxMenuItem.getModel();
            this.levelButtonModel.setSelected(this.options.getBoolean("ShowLevelView", true));
            this.levelButtonModel.setEnabled(this.levelModel != null);
        } else {
            jCheckBoxMenuItem.setModel(this.levelButtonModel);
        }
        jCheckBoxMenuItem.addActionListener(this.toggleLevelViewAction);
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem = new JCheckBoxMenuItem(this.resources.getString("logView.action.view.showDetail.name", "Show filter view"));
        string = this.resources.getString("logView.action.view.showDetail.mnemonic", null);
        if (string != null) {
            jCheckBoxMenuItem.setMnemonic(string.charAt(0));
        }
        if (this.detailButtonModel == null) {
            this.detailButtonModel = jCheckBoxMenuItem.getModel();
            this.detailButtonModel.setSelected(this.options.getBoolean("ShowDetailView", true));
        } else {
            jCheckBoxMenuItem.setModel(this.detailButtonModel);
        }
        jCheckBoxMenuItem.addActionListener(this.toggleDetailViewAction);
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem = new JCheckBoxMenuItem(this.resources.getString("logView.action.view.showStatus.name", "Show status line"));
        string = this.resources.getString("logView.action.view.showStatus.mnemonic", null);
        if (string != null) {
            jCheckBoxMenuItem.setMnemonic(string.charAt(0));
        }
        if (this.statusButtonModel == null) {
            this.statusButtonModel = jCheckBoxMenuItem.getModel();
            this.statusButtonModel.setSelected(this.options.getBoolean("ShowStatusLine", true));
        } else {
            jCheckBoxMenuItem.setModel(this.statusButtonModel);
        }
        jCheckBoxMenuItem.addActionListener(this.toggleStatusLineAction);
        jMenu.add(jCheckBoxMenuItem);
        return jMenu;
    }

    public void cleanup() {
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "cleanup()", "");
        }
        if (this.outerCfg != null) {
            if (this.outerCfg.isRegistered()) {
                this.outerCfg.unregister(true);
            }
            this.outerCfg = null;
        } else if (this.cfg != null && this.cfg.isRegistered()) {
            this.cfg.unregister(true);
        }
        this.cfg = null;
        if (this.frame != null) {
            this.frame.setReusable(false);
            this.frame = null;
        }
        if (this.initialized) {
            this.multiPane.removeMultiPaneListener(this.multiListener);
            this.multiPane.setFirstComponent(null);
            this.multiPane.setSecondComponent(null);
            this.multiPane = null;
            if (this.innerMulti != null) {
                this.innerMulti.removeMultiPaneListener(this.multiListener);
                this.innerMulti.setFirstComponent(null);
                this.innerMulti.setSecondComponent(null);
                this.innerMulti = null;
            }
            this.tableView.getMultiPane().removeMultiPaneListener(this.multiListener);
            this.multiListener = null;
            this.tableView.getTable().getModel().removeTableModelListener(this.status);
            this.tableView.cleanup();
            this.filterView.cleanup();
            if (this.levelView != null) {
                this.levelView.cleanup();
            }
            SwingUtil.cleanup(this);
            this.tableModel = null;
            this.tableView = null;
            this.filterModel = null;
            this.filterView = null;
            this.levelModel = null;
            this.levelView = null;
            this.status = null;
            Option[] optionArray = this.options.getOptions();
            for (int i = 0; i < optionArray.length; ++i) {
                optionArray[i].deleteObservers();
            }
            this.options = null;
            this.initialized = false;
        } else if (this.tableModel != null) {
            this.tableModel.cleanup();
        }
    }

    public final int getState() {
        return this.state;
    }

    public final void setState(int n) {
        this.state = n;
        this.setFrameTitle();
    }

    public final String getClientName() {
        return this.clientName;
    }

    public final void setClientName(String string) {
        int n;
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "setClientName(String)", (String)(LogView.logger.level < 8 ? "" : "clientName: " + string));
        }
        if (string == null && this.file != null && (n = (string = this.file.getName()).lastIndexOf(46)) > 0) {
            string = string.substring(0, n);
        }
        this.clientName = string;
        if (this.outerCfg != null) {
            this.outerCfg.remove(this.cfg, true);
        }
        if (this.cfg.isRegistered()) {
            this.cfg.unregister(true);
        }
        if (string != null) {
            this.outerCfg = new Configurator("Logs for " + string);
            this.outerCfg.add(this.cfg);
            this.outerCfg.register();
        } else {
            this.outerCfg = null;
            this.cfg.register();
        }
        this.setFrameTitle();
    }

    public final File getFile() {
        return this.file;
    }

    public final void setFile(File file) {
        this.file = file;
        this.setFrameTitle();
    }

    public boolean isLoggingEnabled() {
        return this.logging;
    }

    public final void setLoggingEnabled(boolean bl) {
        this.logging = bl;
        if (this.frame != null) {
            this.frame.setLoggingEnabled(this.logging);
        }
        if (this.filterView != null) {
            this.filterView.setLoggingEnabled(this.logging);
        }
        if (this.levelView != null) {
            this.levelView.setLoggingEnabled(this.logging);
        }
        if (this.tableView != null) {
            this.tableView.setLoggingEnabled(this.logging);
        }
    }

    public final MapResourceBundle getResources() {
        return this.resources;
    }

    public void setResources(ResourceBundle resourceBundle) {
        this.resources.addResources(resourceBundle);
    }

    public Configurator getConfigurator() {
        return this.cfg;
    }

    public final File getConfigurationDirectory() {
        return this.cfgSaveDir;
    }

    public final void setConfigurationDirectory(File file) {
        this.cfgSaveDir = file;
    }

    public final LogTableModel getTableModel() {
        return this.tableModel;
    }

    public int getLogCount() {
        return this.tableModel.getRowCount() + this.tableModel.getDeleted() + this.tableModel.getPending();
    }

    public final OptionSet getOptions() {
        return this.options;
    }

    public LogFrame getFrame() {
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "getFrame()", "");
        }
        if (this.frame == null) {
            this.frame = new LogFrame(this);
            this.frame.setReusable(true);
            this.frame.setLoggingEnabled(this.logging);
            if (this.outerCfg != null) {
                this.outerCfg.add(this.frame.getConfigurator());
            } else {
                this.frame.getConfigurator().register();
            }
            this.setFrameTitle();
            if (this.filterView != null) {
                this.filterView.showSetLevels();
            }
            if (this.levelView != null) {
                this.levelView.showSetLevels();
            }
        }
        return this.frame;
    }

    private void setFrameTitle() {
        if (this.frame == null) {
            return;
        }
        String string = "";
        ImageIcon imageIcon = null;
        switch (this.state) {
            case 2: {
                string = Message.format("logFrame.file.title", new String[]{this.file == null ? "" : this.file.getPath()});
                imageIcon = (ImageIcon)this.resources.getIcon("logFrame.icon.file", null);
                break;
            }
            case 3: {
                string = this.resources.getString("logFrame.connected.title", "connected");
                imageIcon = (ImageIcon)this.resources.getIcon("logFrame.icon.connected", null);
                break;
            }
            case 4: {
                string = this.resources.getString("logFrame.disconnected.title", "disconnected");
                imageIcon = (ImageIcon)this.resources.getIcon("logFrame.icon.disconnected", null);
                break;
            }
            default: {
                imageIcon = (ImageIcon)this.resources.getIcon("logFrame.icon", null);
            }
        }
        String string2 = Message.format("logFrame.title", new String[]{this.clientName == null ? this.resources.getString("logView.name.unknown", "unknown") : this.clientName, string});
        this.frame.setTitle(string2);
        if (imageIcon != null) {
            this.frame.setIconImage(imageIcon.getImage());
        }
    }

    public final LogTableView getTableView() {
        return this.tableView;
    }

    public final LogFilterView getFilterView() {
        return this.filterView;
    }

    public final LogLevelView getLevelView() {
        return this.levelView;
    }

    public StatusLine getStatusLine() {
        return this.status;
    }

    @Override
    public final void setProguardMap(ProguardMap proguardMap) {
        String string;
        Serializable serializable;
        this.proguardMap = proguardMap;
        if (this.tableView != null) {
            this.tableView.setProguardMap(proguardMap);
        }
        if (this.frame != null && (serializable = this.frame.getUnloadProguardMapMenuItem()) != null) {
            ((JMenuItem)serializable).setEnabled(proguardMap != null);
        }
        serializable = this.options.getOption("ProguardMapFile");
        String string2 = string = proguardMap != null ? proguardMap.getMapFile().getAbsolutePath() : null;
        if (!Misc.equalOrNull(((Option)serializable).getValue(), string)) {
            ((Option)serializable).setValue(string);
        }
    }

    public void setLogLevels(LogLevelTreeModel logLevelTreeModel) {
        boolean bl;
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        logLevelTreeModel.setLoggingEnabled(this.logging);
        try {
            if (this.levelModel != null) {
                this.cfg.remove(this.levelModel, true);
            }
            if (this.levelModel == null && this.initialized) {
                this.levelModel = logLevelTreeModel;
                this.addLogLevelView();
            } else if (this.initialized) {
                this.levelModel = logLevelTreeModel;
                this.levelView.getTree().setModel(this.levelModel);
            } else {
                this.levelModel = logLevelTreeModel;
            }
            if (this.levelButtonModel != null) {
                this.levelButtonModel.setEnabled(this.levelModel != null);
            }
            if (this.levelModel != null) {
                this.cfg.add(this.levelModel);
                this.options.addAll(this.levelModel.getOptions());
            }
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    private void addLogLevelView() {
        boolean bl;
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "addLogLevelView()", "");
        }
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            this.levelView = new LogLevelView(this.levelModel);
            this.levelView.setLoggingEnabled(this.logging);
            this.levelView.init();
            this.levelView.getTree().registerKeyboardAction(this.jumpLevelsFilterAction, "jumpFilter", KeyStroke.getKeyStroke(74, 2), 0);
            this.innerMulti = new MultiPane("LogLevelPane", 0, this.filterView, this.levelView, 0.5, 0, false);
            this.multiPane.setFirstComponent(this.innerMulti);
            this.innerMulti.addMultiPaneListener(this.multiListener);
            this.cfg.add(this.innerMulti);
            this.revalidate();
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    public void showFilterView(boolean bl) {
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "showFilterView(boolean)", (String)(LogView.logger.level < 8 ? "" : "show: " + bl));
        }
        Option option = this.options.getOption("ShowFilterView");
        if (!Boolean.valueOf(bl).equals(option.getValue())) {
            option.setValue(bl);
        }
        if (bl) {
            if (this.levelModel != null) {
                this.innerMulti.setShowing(this.options.getBoolean("ShowLevelView", true) ? 0 : 1);
            }
            this.multiPane.setShowing(0);
        } else if (this.levelModel != null && this.options.getBoolean("ShowLevelView", true)) {
            this.innerMulti.setShowing(2);
        } else {
            this.multiPane.setShowing(2);
        }
        if (this.filterButtonModel != null) {
            this.filterButtonModel.setSelected(bl);
        }
    }

    private void toggleFilterView() {
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "toggleFilterView()", "");
        }
        this.showFilterView(!this.options.getBoolean("ShowFilterView", true));
    }

    public void showLevelView(boolean bl) {
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "showLevelView(boolean)", (String)(LogView.logger.level < 8 ? "" : "show: " + bl));
        }
        Option option = this.options.getOption("ShowLevelView");
        Boolean bl2 = bl;
        if (!Misc.equalOrNull(option.getValue(), bl2)) {
            option.setValue(bl2);
        }
        if (bl) {
            if (this.innerMulti != null) {
                this.innerMulti.setShowing(this.options.getBoolean("ShowFilterView", true) ? 0 : 2);
            }
            this.multiPane.setShowing(0);
        } else if (this.options.getBoolean("ShowFilterView", true)) {
            this.innerMulti.setShowing(1);
        } else {
            this.multiPane.setShowing(2);
        }
        if (this.levelButtonModel != null) {
            this.levelButtonModel.setSelected(bl);
        }
    }

    private void toggleLevelView() {
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "toggleLevelView()", "");
        }
        this.showLevelView(!this.options.getBoolean("ShowLevelView", true));
    }

    public void showDetailView(boolean bl) {
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "showDetailView(boolean)", (String)(LogView.logger.level < 8 ? "" : "show: " + bl));
        }
        Option option = this.options.getOption("ShowDetailView");
        if (!Boolean.valueOf(bl).equals(option.getValue())) {
            option.setValue(bl);
        }
        this.tableView.showDetail(bl);
        if (this.detailButtonModel != null) {
            this.detailButtonModel.setSelected(bl);
        }
    }

    private void toggleDetailView() {
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "toggleDetailView()", "");
        }
        this.showDetailView(!this.options.getBoolean("ShowDetailView", true));
    }

    public void showStatusLine(boolean bl) {
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "showStatusLine(boolean)", (String)(LogView.logger.level < 8 ? "" : "show: " + bl));
        }
        Option option = this.options.getOption("ShowStatusLine");
        if (!Boolean.valueOf(bl).equals(option.getValue())) {
            option.setValue(bl);
        }
        if (bl) {
            if (this.status.getParent() != this) {
                this.add((Component)this.status, "South");
                this.revalidate();
            }
            this.tableView.setStatusLine(this.status);
        } else {
            this.status.getMessageLabel().setIcon(null);
            this.status.getMessageLabel().setHorizontalTextPosition(11);
            this.status.clearMessages();
            if (this.status.getParent() == this) {
                this.remove(this.status);
                this.revalidate();
            }
            this.tableView.setStatusLine(null);
        }
    }

    private void toggleStatusLine() {
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "toggleStatusLine()", "");
        }
        this.showStatusLine(!this.options.getBoolean("ShowStatusLine", true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jumpTableFilter() {
        boolean bl;
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "jumpTableFilter()", "");
        }
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            if (!this.options.getBoolean("ShowFilterView", false)) {
                return;
            }
            int n = this.tableView.getTable().getSelectionModel().getAnchorSelectionIndex();
            if (n < 0) {
                return;
            }
            LogEntry logEntry = (LogEntry)this.tableView.getTable().getValueAt(n, -1);
            Object[] objectArray = this.filterModel.getPath(logEntry.getClazz(), logEntry.getMethod());
            if (objectArray != null) {
                TreePath treePath = new TreePath(objectArray);
                this.filterView.getTree().setSelectionPath(treePath);
                this.filterView.getTree().scrollPathToVisible(treePath);
                this.filterView.getTree().requestFocus();
            }
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jumpLevelsFilter() {
        boolean bl;
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "jumpLevelsFilter()", "");
        }
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            Object[] objectArray;
            if (!this.options.getBoolean("ShowLevelView", false)) {
                return;
            }
            TreePath treePath = this.levelView.getTree().getSelectionPath();
            if (treePath == null) {
                return;
            }
            String string = this.levelModel.getClazz(treePath.getLastPathComponent());
            if (this.logging && LogView.logger.level >= 9) {
                logger.log(9, "jumpLevelsFilter()", "clazz: " + string);
            }
            if ((objectArray = this.filterModel.getPath(string, null)) != null) {
                treePath = new TreePath(objectArray);
                this.filterView.getTree().setSelectionPath(treePath);
                this.filterView.getTree().scrollPathToVisible(treePath);
                this.filterView.getTree().requestFocus();
            }
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jumpTableLevels() {
        boolean bl;
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "jumpTableLevels()", "");
        }
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            if (!this.options.getBoolean("ShowLevelView", false)) {
                return;
            }
            int n = this.tableView.getTable().getSelectionModel().getAnchorSelectionIndex();
            if (n < 0) {
                return;
            }
            LogEntry logEntry = (LogEntry)this.tableView.getTable().getValueAt(n, -1);
            Object[] objectArray = this.levelModel.getPath(logEntry.getClazz());
            if (objectArray != null) {
                TreePath treePath = new TreePath(objectArray);
                this.levelView.getTree().setSelectionPath(treePath);
                this.levelView.getTree().scrollPathToVisible(treePath);
                this.levelView.getTree().requestFocus();
            }
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jumpFilterLevels() {
        boolean bl;
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "jumpFilterLevels()", "");
        }
        boolean bl2 = bl = !this.logging;
        if (bl) {
            Log.excludeThread();
        }
        try {
            if (!this.options.getBoolean("ShowLevelView", false)) {
                return;
            }
            TreePath treePath = this.filterView.getTree().getSelectionPath();
            if (treePath == null) {
                return;
            }
            String string = ((FilterNode)treePath.getLastPathComponent()).getData().getClazz();
            Object[] objectArray = this.levelModel.getPath(string);
            if (objectArray != null) {
                treePath = new TreePath(objectArray);
                this.levelView.getTree().setSelectionPath(treePath);
                this.levelView.getTree().scrollPathToVisible(treePath);
                this.levelView.getTree().requestFocus();
            }
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable observable, Object object) {
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "update(Observable,Object)", (String)(LogView.logger.level < 8 ? "" : "obj: " + String.valueOf(observable) + ", arg: " + String.valueOf(object)));
        }
        if (observable instanceof Option && object != this) {
            boolean bl;
            boolean bl2 = bl = !this.logging;
            if (bl) {
                Log.excludeThread();
            }
            try {
                Option option = (Option)observable;
                if (option.getName().equals("ShowFilterView")) {
                    this.showFilterView(this.options.getBoolean("ShowFilterView", true));
                } else if (option.getName().equals("ShowLevelView")) {
                    if (this.levelModel != null) {
                        this.showLevelView(this.options.getBoolean("ShowLevelView", true));
                    }
                } else if (option.getName().equals("ShowDetailView")) {
                    this.showDetailView(this.options.getBoolean("ShowDetailView", true));
                } else if (option.getName().equals("ShowStatusLine")) {
                    this.showStatusLine(this.options.getBoolean("ShowStatusLine", true));
                } else if (option.getName().equals("ProguardMapFile")) {
                    String string = this.options.getString("ProguardMapFile", "");
                    if (string != null && !"".equals(string)) {
                        this.setProguardMap(new ProguardMap(new File(string)));
                    } else {
                        this.setProguardMap(null);
                    }
                }
            }
            finally {
                if (bl) {
                    Log.includeThread();
                }
            }
        }
    }

    public void startLogging() {
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "startLogging()", "");
        }
        Log.addFilter(this.tableModel);
    }

    public void stopLogging() {
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "stopLogging()", "");
        }
        Log.removeFilter(this.tableModel);
    }

    public void startLogging(LogSource logSource) {
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "startLogging(LogSource)", (String)(LogView.logger.level < 8 ? "" : "source: " + String.valueOf(logSource)));
        }
        logSource.addFilter(this.tableModel);
    }

    public void stopLogging(LogSource logSource) {
        if (this.logging && LogView.logger.level >= 7) {
            logger.log(7, "stopLogging(LogSource)", (String)(LogView.logger.level < 8 ? "" : "source: " + String.valueOf(logSource)));
        }
        logSource.removeFilter(this.tableModel);
    }

    private void setupActions() {
        this.toggleFilterViewAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogView.this.toggleFilterView();
            }
        };
        this.toggleLevelViewAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogView.this.toggleLevelView();
            }
        };
        this.toggleDetailViewAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogView.this.toggleDetailView();
            }
        };
        this.toggleStatusLineAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogView.this.toggleStatusLine();
            }
        };
        this.jumpTableFilterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogView.this.jumpTableFilter();
            }
        };
        this.jumpTableLevelsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogView.this.jumpTableLevels();
            }
        };
        this.jumpFilterLevelsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogView.this.jumpFilterLevels();
            }
        };
        this.jumpLevelsFilterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogView.this.jumpLevelsFilter();
            }
        };
    }

    @Override
    @Generated
    public ProguardMap getProguardMap() {
        return this.proguardMap;
    }

    private class MultiListener
    implements MultiPaneListener {
        private MultiListener() {
        }

        @Override
        public void showingChanged(MultiPaneEvent multiPaneEvent) {
            if (LogView.this.logging && LogView.logger.level >= 7) {
                logger.log(7, "showingChanged(MultiPaneEvent)", (String)(LogView.logger.level < 8 ? "" : "source: MultiPane " + (multiPaneEvent.getSource() == null ? "null" : ((MultiPane)multiPaneEvent.getSource()).getConfigurableName())));
            }
            boolean bl = LogView.this.options.getBoolean("ShowFilterView", true);
            boolean bl2 = LogView.this.levelModel != null && LogView.this.options.getBoolean("ShowLevelView", true);
            boolean bl3 = LogView.this.options.getBoolean("ShowDetailView", true);
            if (multiPaneEvent.getSource() == LogView.this.innerMulti && (bl || bl2)) {
                int n;
                int n2 = bl ? (bl2 ? 0 : 1) : (n = 2);
                if (n != LogView.this.innerMulti.getShowing()) {
                    LogView.this.innerMulti.setShowing(n);
                }
                return;
            }
            if (multiPaneEvent.getSource() == LogView.this.multiPane) {
                int n;
                int n3 = n = bl || bl2 ? 0 : 2;
                if (n != LogView.this.multiPane.getShowing()) {
                    LogView.this.multiPane.setShowing(n);
                }
                return;
            }
            if (multiPaneEvent.getSource() == LogView.this.tableView.getMultiPane()) {
                int n;
                int n4 = n = bl3 ? 0 : 1;
                if (n != LogView.this.tableView.getMultiPane().getShowing()) {
                    LogView.this.tableView.getMultiPane().setShowing(n);
                }
                return;
            }
        }
    }

    private class Status
    extends StatusLine
    implements TableModelListener,
    ChangeListener,
    Runnable {
        private JLabel count = new JLabel();
        private DelayedAction delayed = new DelayedAction(500);

        public Status() {
            this.getMessageLabel().setForeground(UIManager.getColor("textText"));
            this.count.setForeground(UIManager.getColor("textText"));
            this.count.setBorder(BorderFactory.createLoweredBevelBorder());
            this.updateCount();
            this.add((Component)this.count, "East");
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getSource() == LogView.this.tableModel) {
                this.delayed.perform(this);
            } else {
                this.delayed.cancel();
                this.updateCount();
            }
        }

        public void updateCount() {
            int n = LogView.this.tableView.getTable().getRowCount();
            int n2 = LogView.this.tableModel.getRowCount();
            int n3 = LogView.this.tableModel.getDeleted();
            int n4 = LogView.this.tableModel.getPending();
            this.count.setText(n + "/" + (n2 + n4) + "/" + (n2 + n3 + n4));
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == LogView.this.tableModel) {
                this.delayed.cancel();
                this.updateCount();
            }
        }

        @Override
        public void run() {
            this.updateCount();
        }
    }
}

