/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog.logview.command;

import de.qfs.apps.qflog.FileChooser;
import de.qfs.apps.qflog.logview.LogFileFilter;
import de.qfs.apps.qflog.logview.LogFrame;
import de.qfs.apps.qflog.logview.LogView;
import de.qfs.lib.command.CancelCommandException;
import de.qfs.lib.command.Command;
import de.qfs.lib.command.CommandException;
import de.qfs.lib.command.Invokable;
import de.qfs.lib.command.MessageCommandException;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.ProguardMap;
import de.qfs.lib.log.ProguardMapPossessor;
import de.qfs.lib.log.QFLogger;
import java.awt.Frame;
import java.io.File;
import lombok.Generated;
import lombok.NonNull;

public class CommandLoadProguardMap
extends Command
implements Invokable {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qflog.logview.command.CommandLoadProguardMap");
    private LogView view;
    private Frame parent;
    private File file;
    private static FileChooser fileChooser;
    private final ProguardMapPossessor delegate;

    public CommandLoadProguardMap(@NonNull Object object, @NonNull LogFrame logFrame, @NonNull ProguardMapPossessor proguardMapPossessor) {
        super(object);
        if (CommandLoadProguardMap.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "CommandLoadProguardMap(Object,LogFrame,ProguardMapPossessor)", 106).addDetail("source", object)).addDetail("frame", logFrame)).addDetail("delegate", proguardMapPossessor)).log();
        }
        if (object == null) {
            throw new IllegalArgumentException("source is marked non-null but is null");
        }
        if (logFrame == null) {
            throw new IllegalArgumentException("frame is marked non-null but is null");
        }
        if (proguardMapPossessor == null) {
            throw new IllegalArgumentException("delegate is marked non-null but is null");
        }
        this.parent = logFrame;
        this.view = logFrame.getView();
        this.delegate = proguardMapPossessor;
    }

    @Override
    public Object invoke() throws CommandException {
        boolean bl;
        if (CommandLoadProguardMap.logger.level >= 7) {
            logger.lvlBuild(7, "invoke()", 120).log();
        }
        boolean bl2 = bl = !this.view.isLoggingEnabled();
        if (bl) {
            Log.excludeThread();
        }
        try {
            this.readPGFile();
            Object var2_2 = null;
            return var2_2;
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    private void readPGFile() throws CommandException {
        block11: {
            if (CommandLoadProguardMap.logger.level >= 7) {
                logger.lvlBuild(7, "readPGFile()", 140).log();
            }
            this.setupFileChooser();
            if (this.file == null) {
                fileChooser.setSelectedFile(null);
                fileChooser.rescanCurrentDirectory();
                if (fileChooser.showOpenDialog(this.parent) != 0) {
                    throw new CancelCommandException();
                }
                this.file = fileChooser.getSelectedFile();
            }
            if (this.file == null) {
                throw new CancelCommandException();
            }
            if (!this.file.exists()) {
                throw new MessageCommandException("No such file: " + this.file.getPath(), this.parent, "logView.noSuchFile", new String[]{this.file.getPath()});
            }
            String string = this.view.getResources().getString("logView.status.loadingMap", "Loading map file...");
            boolean bl = true;
            if (this.view.getStatusLine() != null) {
                this.view.getStatusLine().pushMessage(string);
            }
            try {
                ProguardMap proguardMap = new ProguardMap(this.file);
                if (!proguardMap.checkLibs()) break block11;
                this.delegate.setProguardMap(proguardMap);
                bl = false;
                if (this.view.getStatusLine() != null) {
                    this.view.getStatusLine().popMessage(string);
                    this.view.getStatusLine().setTemporaryMessage(this.view.getResources().getString(bl ? "logView.status.loadingMap.failed" : "logView.status.loadingMap.done", "Loading map file..." + (bl ? "failed" : "done")));
                }
                return;
            }
            catch (Throwable throwable) {
                if (this.view.getStatusLine() != null) {
                    this.view.getStatusLine().popMessage(string);
                    this.view.getStatusLine().setTemporaryMessage(this.view.getResources().getString(bl ? "logView.status.loadingMap.failed" : "logView.status.loadingMap.done", "Loading map file..." + (bl ? "failed" : "done")));
                }
                throw throwable;
            }
        }
        throw new MessageCommandException("cannot load file " + this.file.getPath() + " - libraries not found.", this.parent, "logView.loadError", new String[]{this.file.getPath()});
    }

    private void setupFileChooser() {
        if (CommandLoadProguardMap.logger.level >= 7) {
            logger.lvlBuild(7, "setupFileChooser()", 201).log();
        }
        if (fileChooser != null) {
            return;
        }
        File file = ProguardMap.getMapFileChooserStartDir(this.delegate.getProguardMap());
        fileChooser = new FileChooser(file);
        LogFileFilter logFileFilter = new LogFileFilter(this.view.getResources().getString("logView.fileFilter.map", "map file"), ".map");
        fileChooser.setFileFilter(logFileFilter);
    }
}

