/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog.logview.command;

import de.qfs.apps.qflog.FileChooser;
import de.qfs.apps.qflog.logview.LogFileFilter;
import de.qfs.apps.qflog.logview.LogFrame;
import de.qfs.apps.qflog.logview.LogParser;
import de.qfs.apps.qflog.logview.LogView;
import de.qfs.lib.command.CancelCommandException;
import de.qfs.lib.command.Command;
import de.qfs.lib.command.CommandException;
import de.qfs.lib.command.Invokable;
import de.qfs.lib.command.MessageCommandException;
import de.qfs.lib.gui.Message;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.LogFilter;
import de.qfs.lib.log.LogSource;
import de.qfs.lib.log.Logger;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import javax.swing.JTable;
import javax.swing.ProgressMonitor;
import javax.swing.filechooser.FileFilter;

public class CommandSaveLog
extends Command
implements Invokable {
    private static final Logger logger = new Logger("de.qfs.apps.qflog.logview.command.CommandSaveLog");
    private boolean save;
    private boolean all;
    private LogView view;
    private Frame parent;
    private File file;
    private Reader reader;
    private int size;
    private static FileChooser fileChooser;
    private static LogFileFilter logFilter;

    public CommandSaveLog(Object object, LogFrame logFrame, File file, boolean bl, boolean bl2) {
        super(object);
        this.parent = logFrame;
        this.view = logFrame.getView();
        this.file = file;
        this.save = bl;
        this.all = bl2;
    }

    public CommandSaveLog(Object object, Frame frame, LogView logView, File file, boolean bl, boolean bl2) {
        super(object);
        this.parent = frame;
        this.view = logView;
        this.file = file;
        this.save = bl;
        this.all = bl2;
    }

    public CommandSaveLog(Object object, Frame frame, LogView logView, Reader reader, int n) {
        super(object);
        this.parent = frame;
        this.view = logView;
        this.reader = reader;
        this.size = n;
    }

    @Override
    public Object invoke() throws CommandException {
        boolean bl;
        boolean bl2 = bl = !this.view.isLoggingEnabled();
        if (bl) {
            Log.excludeThread();
        }
        try {
            if (this.save) {
                this.save();
            } else {
                this.restore();
            }
            Object var2_2 = null;
            return var2_2;
        }
        finally {
            if (bl) {
                Log.includeThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() throws CommandException {
        this.setupFileChooser();
        if (this.file == null) {
            fileChooser.setSelectedFile(null);
            fileChooser.rescanCurrentDirectory();
            if (fileChooser.showSaveDialog(this.parent) != 0) {
                throw new CancelCommandException();
            }
            this.file = fileChooser.getSelectedFile();
            FileFilter fileFilter = fileChooser.getFileFilter();
            if (this.file.getName().indexOf(".") < 0 && fileFilter instanceof LogFileFilter) {
                this.file = ((LogFileFilter)fileFilter).forceExtension(this.file);
            }
            if (this.file.exists() && Message.showMessage(this.parent, "logView.askOverwrite", new String[]{this.file.getName()}) != 0) {
                throw new CancelCommandException();
            }
        }
        boolean bl = true;
        String string = this.view.getResources().getString("logView.status.savingLog", "Saving log file...");
        if (this.view.getStatusLine() != null) {
            this.view.getStatusLine().pushMessage(string);
        }
        try {
            Object object;
            LogEntry[] logEntryArray;
            if (this.all) {
                logEntryArray = this.view.getTableModel().getData();
            } else {
                object = this.view.getTableView().getTable();
                int n = ((JTable)object).getRowCount();
                logEntryArray = new LogEntry[n];
                for (int i = 0; i < n; ++i) {
                    logEntryArray[i] = (LogEntry)((JTable)object).getValueAt(i, -1);
                }
            }
            object = new PrintWriter(new FileWriter(this.file));
            try {
                if (this.view.getClientName() != null) {
                    ((PrintWriter)object).println("client name: " + this.view.getClientName());
                }
                for (LogEntry logEntry : logEntryArray) {
                    ((PrintWriter)object).println(logEntry.toString());
                }
            }
            finally {
                try {
                    ((PrintWriter)object).close();
                }
                catch (Throwable throwable) {}
            }
            bl = false;
            if (this.view.getStatusLine() != null) {
                this.view.getStatusLine().popMessage(string);
                this.view.getStatusLine().setTemporaryMessage(this.view.getResources().getString(bl ? "logView.status.savingLog.failed" : "logView.status.savingLog.done", "Saving log file..." + (bl ? "failed" : "done")));
            }
        }
        catch (IOException iOException) {
            try {
                if (CommandSaveLog.logger.level >= 1) {
                    logger.log("save()", iOException);
                }
                throw new MessageCommandException(iOException.getMessage(), this.parent, "logView.saveError", new String[]{this.file.getPath()});
            }
            catch (Throwable throwable) {
                if (this.view.getStatusLine() != null) {
                    this.view.getStatusLine().popMessage(string);
                    this.view.getStatusLine().setTemporaryMessage(this.view.getResources().getString(bl ? "logView.status.savingLog.failed" : "logView.status.savingLog.done", "Saving log file..." + (bl ? "failed" : "done")));
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void restore() throws CommandException {
        if (this.reader == null) {
            if (this.file == null) {
                this.setupFileChooser();
                fileChooser.setSelectedFile(null);
                fileChooser.rescanCurrentDirectory();
                if (fileChooser.showOpenDialog(this.parent) != 0) {
                    throw new CancelCommandException();
                }
                this.file = fileChooser.getSelectedFile();
            }
            if (this.file == null) {
                throw new CancelCommandException();
            }
            if (!this.file.exists()) {
                throw new MessageCommandException("No such file: " + this.file.getPath(), this.parent, "logView.noSuchFile", new String[]{this.file.getPath()});
            }
            this.size = (int)this.file.length();
        }
        boolean bl = true;
        String string = this.view.getResources().getString("logView.status.loadingLog", "Loading log file...");
        if (this.view.getStatusLine() != null) {
            this.view.getStatusLine().pushMessage(string);
        }
        try {
            this.view.setState(2);
            this.view.setFile(this.file);
            if (!this.readText(this.reader == null ? new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF8") : this.reader, this.size)) throw new MessageCommandException("cannot load file " + this.file.getPath(), this.parent, "logView.loadError", new String[]{this.file.getPath()});
            bl = false;
            if (this.all) {
                Follower follower = new Follower(this.file);
                this.view.startLogging(follower);
                follower.start();
            }
            if (this.view.getStatusLine() == null) return;
            this.view.getStatusLine().popMessage(string);
            this.view.getStatusLine().setTemporaryMessage(this.view.getResources().getString(bl ? "logView.status.loadingLog.failed" : "logView.status.loadingLog.done", "Loading log file..." + (bl ? "failed" : "done")));
            return;
        }
        catch (IOException iOException) {
            if (CommandSaveLog.logger.level < 5) throw new MessageCommandException("cannot load file " + this.file.getPath(), this.parent, "logView.loadError", new String[]{this.file.getPath()});
            logger.log(5, "restore()", iOException);
            throw new MessageCommandException("cannot load file " + this.file.getPath(), this.parent, "logView.loadError", new String[]{this.file.getPath()});
        }
        catch (Throwable throwable) {
            if (this.view.getStatusLine() == null) throw throwable;
            this.view.getStatusLine().popMessage(string);
            this.view.getStatusLine().setTemporaryMessage(this.view.getResources().getString(bl ? "logView.status.loadingLog.failed" : "logView.status.loadingLog.done", "Loading log file..." + (bl ? "failed" : "done")));
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readText(Reader reader, int n) {
        try (final ProgressMonitor progressMonitor = new ProgressMonitor(this.parent, "parsing...", null, 0, n);){
            final BufferedReader bufferedReader = new BufferedReader(reader);
            bufferedReader.mark(4090);
            String string = bufferedReader.readLine();
            if (string == null) {
                boolean bl = false;
                return bl;
            }
            String string2 = null;
            if (string.startsWith("client name: ")) {
                string2 = string.substring("client name: ".length());
            } else {
                bufferedReader.reset();
            }
            final LogParser logParser = new LogParser();
            logParser.setProgressCallback(new LogParser.ProgressCallback(){
                private int count = 0;

                @Override
                public boolean progress(int n, int n2) {
                    if (this.count++ % 50 == 0) {
                        progressMonitor.setProgress(n2);
                        Thread.yield();
                        return !progressMonitor.isCanceled();
                    }
                    return true;
                }
            });
            LogEntry[] logEntryArray = (LogEntry[])SwingUtil.withEvents(new SwingUtil.UnsafeRunnable(){

                @Override
                public Object run() throws IOException {
                    return logParser.parse(bufferedReader);
                }
            }, 0, 0);
            bufferedReader.close();
            this.view.setClientName(string2);
            this.view.getTableModel().setMaxRows(0);
            this.view.getTableModel().setData(logEntryArray);
        }
        return true;
    }

    private void setupFileChooser() {
        if (fileChooser != null) {
            return;
        }
        fileChooser = new FileChooser(new File(new File(".").getAbsolutePath()));
        logFilter = new LogFileFilter(this.view.getResources().getString("logView.fileFilter.log", "qflog text log file"), ".log");
        fileChooser.setFileFilter(logFilter);
    }

    class Follower
    extends Thread
    implements LogSource {
        private File file;
        private RandomAccessFile raf;
        private long lastSize;
        private byte[] buffer = new byte[8192];
        private byte[] pending;
        private LogParser parser = new LogParser();
        private LogFilter filter;

        public Follower(File file) {
            this.file = file;
            this.lastSize = file.length();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: while (true) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.file.length() == this.lastSize) continue;
                RandomAccessFile randomAccessFile = null;
                try {
                    randomAccessFile = new RandomAccessFile(this.file, "r");
                    randomAccessFile.seek(this.lastSize);
                    int n = randomAccessFile.read(this.buffer);
                    while (true) {
                        int n2;
                        int n3;
                        if (n <= 0) continue block15;
                        if (this.buffer[0] == 0) {
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue block15;
                        }
                        this.lastSize += (long)n;
                        for (n3 = n - 1; n3 >= 0 && this.buffer[n3] != 10 && this.buffer[n3] != 13; --n3) {
                        }
                        if (n3 > 0) {
                            ByteArrayInputStream byteArrayInputStream;
                            Object object;
                            if (this.pending != null) {
                                object = new byte[this.pending.length + n3 + 1];
                                System.arraycopy(this.pending, 0, object, 0, this.pending.length);
                                System.arraycopy(this.buffer, 0, object, this.pending.length, n3 + 1);
                                this.pending = null;
                                byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                            } else {
                                byteArrayInputStream = new ByteArrayInputStream(this.buffer, 0, n3 + 1);
                            }
                            object = new BufferedReader(new InputStreamReader((InputStream)byteArrayInputStream, "UTF-8"));
                            LogEntry[] logEntryArray = this.parser.parse((BufferedReader)object);
                            if (this.filter != null && logEntryArray.length > 0) {
                                this.filter.filter(logEntryArray);
                            }
                        }
                        if ((n2 = n - (n3 + 1)) > 0) {
                            this.pending = new byte[n2];
                            System.arraycopy(this.buffer, n3 + 1, this.pending, 0, n2);
                        }
                        n = randomAccessFile.read(this.buffer);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    continue;
                }
                finally {
                    if (randomAccessFile == null) continue;
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    continue;
                }
                break;
            }
        }

        @Override
        public void addFilter(LogFilter logFilter) {
            this.filter = logFilter;
        }

        @Override
        public void removeFilter(LogFilter logFilter) {
            if (this.filter == logFilter) {
                logFilter = null;
            }
        }
    }
}

