/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j;

import com.cdp4j.Browser;
import com.cdp4j.Constant;
import com.cdp4j.JsObjectReleaseMode;
import com.cdp4j.JsonLibrary;
import com.cdp4j.ProtocolVersion;
import com.cdp4j.SelectorEngine;
import com.cdp4j.SessionIdFilter;
import com.cdp4j.exception.CdpException;
import com.cdp4j.exception.CdpReadTimeoutExceptionHandler;
import com.cdp4j.logger.CdpLoggerType;
import com.cdp4j.logger.CdpLogggerLevel;
import com.cdp4j.process.AdaptiveProcessManager;
import com.cdp4j.process.ProcessManager;
import com.cdp4j.session.WaitingStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class Options {
    private static final int DEFAULT_READ_TIMEOUT = 10000;
    private CdpLoggerType loggerType;
    private String loggerNamePrefix;
    private Executor workerThreadPool;
    private Executor eventHandlerThreadPool;
    private Integer readTimeout;
    private CdpReadTimeoutExceptionHandler readTimeoutExceptionHandler;
    private List<String> arguments;
    private Path userDataDir;
    private boolean useDefaultUserDataDir;
    private int userProfileCleanerMaxSleepTime = 30000;
    private boolean createNewUserDataDir;
    private boolean headless;
    private Integer screenWidth;
    private Integer screenHeight;
    private CdpLogggerLevel consoleLoggerLevel;
    private Boolean shutdownThreadPoolOnClose;
    private WaitingStrategy waitingStrategy;
    private String browserExecutablePath;
    private Browser browser;
    private ProcessManager processManager;
    private SelectorEngine selectorEngine;
    private int remoteDebuggingPort;
    private JsonLibrary jsonLibrary;
    private ProtocolVersion protocolVersion;
    private JsObjectReleaseMode jsObjectReleaseMode;
    private SessionIdFilter sessionIdFilter;
    private String safeProcessPath;
    private static final String SAFE_PROCESS_PATH;

    private Options() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public CdpLoggerType loggerType() {
        return this.loggerType;
    }

    public String loggerNamePrefix() {
        return this.loggerNamePrefix;
    }

    public Executor workerThreadPool() {
        return this.workerThreadPool;
    }

    public Executor eventHandlerThreadPool() {
        return this.eventHandlerThreadPool;
    }

    public List<String> arguments() {
        return this.arguments;
    }

    public Path userDataDir() {
        return this.userDataDir;
    }

    public Integer readTimeout() {
        return this.readTimeout;
    }

    public CdpReadTimeoutExceptionHandler readTimeoutExceptionHandler() {
        return this.readTimeoutExceptionHandler;
    }

    public boolean headless() {
        return this.headless;
    }

    public Integer screenWidth() {
        return this.screenWidth;
    }

    public Integer screenHeight() {
        return this.screenHeight;
    }

    public CdpLogggerLevel consoleLoggerLevel() {
        return this.consoleLoggerLevel;
    }

    public boolean shutdownThreadPoolOnClose() {
        return this.shutdownThreadPoolOnClose;
    }

    public WaitingStrategy waitingStrategy() {
        return this.waitingStrategy;
    }

    public String browserExecutablePath() {
        return this.browserExecutablePath;
    }

    public Browser browser() {
        return this.browser;
    }

    public ProcessManager processManager() {
        return this.processManager;
    }

    public SelectorEngine selectorEngine() {
        return this.selectorEngine;
    }

    public boolean useDefaultUserDataDir() {
        return this.useDefaultUserDataDir;
    }

    public int remoteDebuggingPort() {
        return this.remoteDebuggingPort;
    }

    public boolean createNewUserDataDir() {
        return this.createNewUserDataDir;
    }

    public int userProfileCleanerMaxSleepTime() {
        return this.userProfileCleanerMaxSleepTime;
    }

    public JsonLibrary jsonLibrary() {
        return this.jsonLibrary;
    }

    public ProtocolVersion protocolVersion() {
        return this.protocolVersion;
    }

    public JsObjectReleaseMode jsObjectReleaseMode() {
        return this.jsObjectReleaseMode;
    }

    public SessionIdFilter jsonIdFilter() {
        return this.sessionIdFilter;
    }

    public String safeProcessPath() {
        return this.safeProcessPath;
    }

    static {
        Path tmpdir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).toAbsolutePath();
        String executable = Constant.WINDOWS ? "safe-process.exe" : (Constant.MACOS ? "safe-process-mac" : "safe-process");
        Path safeProcess = tmpdir.resolve("cdp4j").resolve(executable);
        String safeProcessPathCandidate = null;
        if (!Files.exists(safeProcess, new LinkOption[0]) || !safeProcess.toFile().canExecute()) {
            try (InputStream is = Options.class.getResourceAsStream("/META-INF/" + executable);){
                if (is != null) {
                    if (!Files.exists(safeProcess.getParent(), new LinkOption[0])) {
                        Files.createDirectory(safeProcess.getParent(), new FileAttribute[0]);
                    }
                    if (!Files.exists(safeProcess, new LinkOption[0])) {
                        Files.createFile(safeProcess, new FileAttribute[0]);
                    }
                    Files.copy(is, safeProcess, StandardCopyOption.REPLACE_EXISTING);
                    safeProcess.toFile().setExecutable(true);
                    safeProcessPathCandidate = safeProcess.toAbsolutePath().toString();
                }
            }
            catch (Exception e) {
                System.err.println("Could not setup safe-process execution: " + e.toString());
            }
        } else {
            safeProcessPathCandidate = safeProcess.toAbsolutePath().toString();
        }
        SAFE_PROCESS_PATH = safeProcessPathCandidate;
    }

    public static class Builder {
        private Options options = new Options();

        private Builder() {
        }

        public Builder loggerType(CdpLoggerType loggerType) {
            this.options.loggerType = loggerType;
            return this;
        }

        public Builder loggerNamePrefix(String loggerNamePrefix) {
            this.options.loggerNamePrefix = loggerNamePrefix;
            return this;
        }

        public Builder workerThreadPool(Executor workerThreadPool) {
            this.options.workerThreadPool = workerThreadPool;
            return this;
        }

        public Builder eventHandlerThreadPool(Executor eventHandlerThreadPool) {
            this.options.eventHandlerThreadPool = eventHandlerThreadPool;
            return this;
        }

        public Builder arguments(List<String> arguments) {
            this.options.arguments = arguments;
            return this;
        }

        public Builder userDataDir(Path userDataDir) {
            this.options.userDataDir = userDataDir;
            return this;
        }

        public Builder headless(boolean headless) {
            this.options.headless = headless;
            return this;
        }

        public Builder consoleLoggerLevel(CdpLogggerLevel consoleLoggerLevel) {
            this.options.consoleLoggerLevel = consoleLoggerLevel;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.options.readTimeout = readTimeout;
            return this;
        }

        public Builder readTimeoutExceptionHandler(CdpReadTimeoutExceptionHandler readTimeoutExceptionHandler) {
            this.options.readTimeoutExceptionHandler = readTimeoutExceptionHandler;
            return this;
        }

        public Builder browserExecutablePath(String browserExecutablePath) {
            if (browserExecutablePath == null || browserExecutablePath.trim().isEmpty()) {
                throw new IllegalArgumentException();
            }
            this.options.browserExecutablePath = browserExecutablePath;
            return this;
        }

        public Builder shutdownThreadPoolOnClose(boolean shutdownThreadPoolOnClose) {
            this.options.shutdownThreadPoolOnClose = shutdownThreadPoolOnClose;
            return this;
        }

        public Builder browser(Browser browser) {
            this.options.browser = browser;
            return this;
        }

        public Builder selectorEngine(SelectorEngine selectorEngine) {
            this.options.selectorEngine = selectorEngine;
            return this;
        }

        public Builder useDefaultUserDataDir(boolean useDefaultUserDataDir) {
            this.options.useDefaultUserDataDir = useDefaultUserDataDir;
            return this;
        }

        public Builder waitingStrategy(WaitingStrategy waitingStrategy) {
            this.options.waitingStrategy = waitingStrategy;
            return this;
        }

        public Builder processManager(ProcessManager processManager) {
            this.options.processManager = processManager;
            return this;
        }

        public Builder remoteDebuggingPort(int remoteDebuggingPort) {
            this.options.remoteDebuggingPort = remoteDebuggingPort;
            return this;
        }

        public Builder createNewUserDataDir(boolean createNewUserDataDir) {
            this.options.createNewUserDataDir = createNewUserDataDir;
            return this;
        }

        public Builder safeProcessPath(String safeProcessPath) {
            this.options.safeProcessPath = safeProcessPath;
            return this;
        }

        public Builder userProfileCleanerMaxSleepTime(int userProfileCleanerMaxSleepTime) {
            if (userProfileCleanerMaxSleepTime < 1000) {
                throw new IllegalArgumentException();
            }
            this.options.userProfileCleanerMaxSleepTime = userProfileCleanerMaxSleepTime;
            return this;
        }

        public Builder jsonLibrary(JsonLibrary jsonLibrary) {
            this.options.jsonLibrary = jsonLibrary;
            return this;
        }

        public Builder protocolVersion(ProtocolVersion protocolVersion) {
            this.options.protocolVersion = protocolVersion;
            return this;
        }

        public Builder jsObjectReleaseMode(JsObjectReleaseMode jsObjectReleaseMode) {
            this.options.jsObjectReleaseMode = jsObjectReleaseMode;
            return this;
        }

        public Builder sessionIdFilter(SessionIdFilter sessionIdFilter) {
            this.options.sessionIdFilter = sessionIdFilter;
            return this;
        }

        public Options build() {
            if (this.options.loggerType == null) {
                this.options.loggerType = CdpLoggerType.Null;
            }
            if (this.options.consoleLoggerLevel == null) {
                this.options.consoleLoggerLevel = CdpLogggerLevel.Info;
            }
            if (this.options.workerThreadPool == null) {
                this.options.workerThreadPool = Executors.newSingleThreadExecutor(new CdpThreadFactory("CdpWorkerThread"));
            }
            if (this.options.eventHandlerThreadPool == null) {
                this.options.eventHandlerThreadPool = Executors.newSingleThreadExecutor(new CdpThreadFactory("CdpEventHandlerThread"));
            }
            if (this.options.arguments == null) {
                this.options.arguments = Collections.emptyList();
            }
            if (this.options.readTimeout == null) {
                this.options.readTimeout = 10000;
            }
            if (this.options.shutdownThreadPoolOnClose == null) {
                this.options.shutdownThreadPoolOnClose = Boolean.TRUE;
            }
            if (this.options.waitingStrategy == null) {
                this.options.waitingStrategy = WaitingStrategy.Semaphore;
            }
            if (this.options.browser == null) {
                this.options.browser = Browser.Any;
            }
            if (this.options.processManager == null) {
                this.options.processManager = new AdaptiveProcessManager();
            }
            if (this.options.protocolVersion == null) {
                this.options.protocolVersion = ProtocolVersion.ToT;
            }
            if (this.options.selectorEngine == null) {
                this.options.selectorEngine = SelectorEngine.Native;
            }
            if (this.options.jsonLibrary == null) {
                this.options.jsonLibrary = JsonLibrary.Gson;
            }
            if (this.options.jsObjectReleaseMode == null) {
                this.options.jsObjectReleaseMode = JsObjectReleaseMode.async;
            }
            if (this.options.sessionIdFilter == null) {
                this.options.sessionIdFilter = SessionIdFilter.SimpleParser;
            }
            if (this.options.safeProcessPath == null) {
                this.options.safeProcessPath = SAFE_PROCESS_PATH;
            }
            if (this.options.createNewUserDataDir) {
                if (this.options.useDefaultUserDataDir || this.options.userDataDir != null) {
                    throw new IllegalStateException();
                }
                try {
                    this.options.userDataDir = Files.createTempDirectory("cdp4j-user-profile", new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new CdpException(e);
                }
            }
            return this.options;
        }
    }

    static class CdpThreadFactory
    implements ThreadFactory {
        private final String name;

        CdpThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, this.name);
            thread.setDaemon(true);
            return thread;
        }
    }
}

