/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.channel;

import com.cdp4j.channel.Channel;
import com.cdp4j.channel.ChannelFactory;
import com.cdp4j.channel.Connection;
import com.cdp4j.channel.JettyWebSocketChannel;
import com.cdp4j.channel.JettyWebSocketListener;
import com.cdp4j.exception.CdpException;
import com.cdp4j.session.MessageHandler;
import com.cdp4j.session.SessionFactory;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class JettyWebSocketFactory
implements ChannelFactory,
AutoCloseable {
    private final WebSocketClient client;

    public JettyWebSocketFactory() {
        this.client = new WebSocketClient();
        try {
            this.client.start();
        }
        catch (Exception e) {
            throw new CdpException(e);
        }
    }

    public JettyWebSocketFactory(WebSocketClient client) {
        this.client = client;
    }

    @Override
    public Channel createChannel(Connection connection, SessionFactory factory, MessageHandler handler) {
        String url = connection.getUrl();
        CompletableFuture future = null;
        try {
            future = this.client.connect((Object)new JettyWebSocketListener(factory, handler), URI.create(url));
        }
        catch (IOException e) {
            throw new CdpException(e);
        }
        return new JettyWebSocketChannel(future);
    }

    @Override
    public void close() {
        if (this.client != null && !this.client.isStopped()) {
            try {
                this.client.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

