/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.channel;

import com.cdp4j.session.MessageHandler;
import com.cdp4j.session.SessionFactory;
import java.net.http.WebSocket;
import java.util.concurrent.CompletionStage;

public class JreWebSocketListener
implements WebSocket.Listener {
    private final SessionFactory factory;
    private final MessageHandler handler;
    private final StringBuilder buffer = new StringBuilder(0);

    public JreWebSocketListener(SessionFactory factory, MessageHandler handler) {
        this.factory = factory;
        this.handler = handler;
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        if (last) {
            if (this.buffer.length() == 0) {
                this.handler.process(data.toString());
            } else {
                this.buffer.append(data);
                String message = this.buffer.toString();
                this.buffer.setLength(0);
                this.handler.process(message);
            }
        } else {
            this.buffer.append(data);
        }
        webSocket.request(1L);
        return null;
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        this.factory.close();
        this.buffer.setLength(0);
        return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
    }
}

