/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.channel;

import com.cdp4j.channel.Channel;
import com.cdp4j.exception.CdpException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.framing.Framedata;
import org.java_websocket.framing.TextFrame;

public class TooTallNateWebSocketChannel
implements Channel {
    private final WebSocketClient webSocket;

    public TooTallNateWebSocketChannel(WebSocketClient webSocket) {
        this.webSocket = webSocket;
    }

    @Override
    public boolean isOpen() {
        return this.webSocket.isOpen();
    }

    @Override
    public void disconnect() {
        if (this.webSocket.isOpen()) {
            this.webSocket.close(1000, "done");
        }
    }

    @Override
    public void sendText(String message) {
        this.webSocket.send(message);
    }

    @Override
    public void sendText(byte[] message) {
        TextFrame frame = new TextFrame();
        frame.setFin(true);
        frame.setPayload(ByteBuffer.wrap(message));
        this.webSocket.sendFrame((Framedata)frame);
    }

    @Override
    public void connect() {
        try {
            this.webSocket.connectBlocking(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new CdpException(e);
        }
    }
}

