/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.channel;

import com.cdp4j.channel.ByteBufferBackedInputStream;
import com.cdp4j.channel.ListInputStream;
import com.cdp4j.session.MessageHandler;
import com.cdp4j.session.SessionFactory;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.xnio.Pooled;

public class UndertowWebSocketListener
extends AbstractReceiveListener {
    private final SessionFactory factory;
    private final MessageHandler handler;

    public UndertowWebSocketListener(SessionFactory factory, MessageHandler handler) {
        this.factory = factory;
        this.handler = handler;
    }

    protected void onText(WebSocketChannel webSocketChannel, StreamSourceFrameChannel messageChannel) throws IOException {
        BufferedBinaryMessage buffer = new BufferedBinaryMessage(this.getMaxTextBufferSize(), true);
        buffer.read(messageChannel, (WebSocketCallback)new CdpWebSocketCallback(this));
    }

    protected void onFullCloseMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
        this.factory.close();
    }

    private static class CdpWebSocketCallback
    implements WebSocketCallback<BufferedBinaryMessage> {
        private final UndertowWebSocketListener listener;

        CdpWebSocketCallback(UndertowWebSocketListener listener) {
            this.listener = listener;
        }

        public void complete(WebSocketChannel channel, BufferedBinaryMessage message) {
            try {
                Pooled pooled = message.getData();
                ByteBuffer[] resources = (ByteBuffer[])pooled.getResource();
                if (resources.length == 1) {
                    this.listener.handler.process(new ByteBufferBackedInputStream((AutoCloseable)pooled, resources[0], true));
                } else {
                    ArrayList<InputStream> streams = new ArrayList<InputStream>(resources.length);
                    for (ByteBuffer next : resources) {
                        streams.add(new ByteBufferBackedInputStream((AutoCloseable)pooled, next, false));
                    }
                    this.listener.handler.process(new ListInputStream((AutoCloseable)pooled, streams));
                }
            }
            catch (Throwable e) {
                this.listener.onError(channel, e);
            }
        }

        public void onError(WebSocketChannel channel, BufferedBinaryMessage context, Throwable throwable) {
            context.getData().close();
            this.listener.onError(channel, throwable);
        }
    }
}

