/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.command;

import com.cdp4j.command.BluetoothEmulation;
import com.cdp4j.session.CommandReturnType;
import com.cdp4j.session.DomainCommand;
import com.cdp4j.session.ParameterizedCommandImpl;
import com.cdp4j.session.SessionInvocationHandler;
import com.cdp4j.type.bluetoothemulation.CentralState;
import com.cdp4j.type.bluetoothemulation.CharacteristicOperationType;
import com.cdp4j.type.bluetoothemulation.CharacteristicProperties;
import com.cdp4j.type.bluetoothemulation.DescriptorOperationType;
import com.cdp4j.type.bluetoothemulation.GATTOperationType;
import com.cdp4j.type.bluetoothemulation.ManufacturerData;
import com.cdp4j.type.bluetoothemulation.ScanEntry;
import java.lang.reflect.Type;
import java.util.List;

class BluetoothEmulationImpl
extends ParameterizedCommandImpl<BluetoothEmulation>
implements BluetoothEmulation {
    private static final CommandReturnType CRT_ADD_CHARACTERISTIC = new CommandReturnType("characteristicId", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_ADD_DESCRIPTOR = new CommandReturnType("descriptorId", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_ADD_SERVICE = new CommandReturnType("serviceId", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_DISABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_ENABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_REMOVE_CHARACTERISTIC = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_REMOVE_DESCRIPTOR = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_REMOVE_SERVICE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_SIMULATED_CENTRAL_STATE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SIMULATE_ADVERTISEMENT = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SIMULATE_CHARACTERISTIC_OPERATION_RESPONSE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SIMULATE_DESCRIPTOR_OPERATION_RESPONSE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SIMULATE_GA_TT_DISCONNECTION = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SIMULATE_GA_TT_OPERATION_RESPONSE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SIMULATE_PRECONNECTED_PERIPHERAL = new CommandReturnType(null, Void.TYPE, null);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final String[] PARAMS_ADD_CHARACTERISTIC_1 = new String[]{"serviceId", "characteristicUuid", "properties"};
    private static final String[] PARAMS_ADD_DESCRIPTOR_1 = new String[]{"characteristicId", "descriptorUuid"};
    private static final String[] PARAMS_ADD_SERVICE_1 = new String[]{"address", "serviceUuid"};
    private static final String[] PARAMS_ENABLE_1 = new String[]{"state", "leSupported"};
    private static final String[] PARAMS_REMOVE_CHARACTERISTIC_1 = new String[]{"characteristicId"};
    private static final String[] PARAMS_REMOVE_DESCRIPTOR_1 = new String[]{"descriptorId"};
    private static final String[] PARAMS_REMOVE_SERVICE_1 = new String[]{"serviceId"};
    private static final String[] PARAMS_SET_SIMULATED_CENTRAL_STATE_1 = new String[]{"state"};
    private static final String[] PARAMS_SIMULATE_ADVERTISEMENT_1 = new String[]{"entry"};
    private static final String[] PARAMS_SIMULATE_CHARACTERISTIC_OPERATION_RESPONSE_1 = new String[]{"characteristicId", "type", "code"};
    private static final String[] PARAMS_SIMULATE_CHARACTERISTIC_OPERATION_RESPONSE_2 = new String[]{"characteristicId", "type", "code", "data"};
    private static final String[] PARAMS_SIMULATE_DESCRIPTOR_OPERATION_RESPONSE_1 = new String[]{"descriptorId", "type", "code"};
    private static final String[] PARAMS_SIMULATE_DESCRIPTOR_OPERATION_RESPONSE_2 = new String[]{"descriptorId", "type", "code", "data"};
    private static final String[] PARAMS_SIMULATE_GA_TT_DISCONNECTION_1 = new String[]{"address"};
    private static final String[] PARAMS_SIMULATE_GA_TT_OPERATION_RESPONSE_1 = new String[]{"address", "type", "code"};
    private static final String[] PARAMS_SIMULATE_PRECONNECTED_PERIPHERAL_1 = new String[]{"address", "name", "manufacturerData", "knownServiceUuids"};
    private final SessionInvocationHandler handler;

    public BluetoothEmulationImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public String addCharacteristic(String serviceId, String characteristicUuid, CharacteristicProperties properties) {
        return (String)this.handler.invoke(this, DomainCommand.BluetoothEmulation_addCharacteristic, CRT_ADD_CHARACTERISTIC, PARAMS_ADD_CHARACTERISTIC_1, new Object[]{serviceId, characteristicUuid, properties}, true);
    }

    @Override
    public String addDescriptor(String characteristicId, String descriptorUuid) {
        return (String)this.handler.invoke(this, DomainCommand.BluetoothEmulation_addDescriptor, CRT_ADD_DESCRIPTOR, PARAMS_ADD_DESCRIPTOR_1, new Object[]{characteristicId, descriptorUuid}, true);
    }

    @Override
    public String addService(String address, String serviceUuid) {
        return (String)this.handler.invoke(this, DomainCommand.BluetoothEmulation_addService, CRT_ADD_SERVICE, PARAMS_ADD_SERVICE_1, new Object[]{address, serviceUuid}, true);
    }

    @Override
    public void disable() {
        this.handler.invoke(this, DomainCommand.BluetoothEmulation_disable, CRT_DISABLE, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void enable(CentralState state, Boolean leSupported) {
        this.handler.invoke(this, DomainCommand.BluetoothEmulation_enable, CRT_ENABLE, PARAMS_ENABLE_1, new Object[]{state, leSupported}, true);
    }

    @Override
    public void removeCharacteristic(String characteristicId) {
        this.handler.invoke(this, DomainCommand.BluetoothEmulation_removeCharacteristic, CRT_REMOVE_CHARACTERISTIC, PARAMS_REMOVE_CHARACTERISTIC_1, new Object[]{characteristicId}, true);
    }

    @Override
    public void removeDescriptor(String descriptorId) {
        this.handler.invoke(this, DomainCommand.BluetoothEmulation_removeDescriptor, CRT_REMOVE_DESCRIPTOR, PARAMS_REMOVE_DESCRIPTOR_1, new Object[]{descriptorId}, true);
    }

    @Override
    public void removeService(String serviceId) {
        this.handler.invoke(this, DomainCommand.BluetoothEmulation_removeService, CRT_REMOVE_SERVICE, PARAMS_REMOVE_SERVICE_1, new Object[]{serviceId}, true);
    }

    @Override
    public void setSimulatedCentralState(CentralState state) {
        this.handler.invoke(this, DomainCommand.BluetoothEmulation_setSimulatedCentralState, CRT_SET_SIMULATED_CENTRAL_STATE, PARAMS_SET_SIMULATED_CENTRAL_STATE_1, new Object[]{state}, true);
    }

    @Override
    public void simulateAdvertisement(ScanEntry entry) {
        this.handler.invoke(this, DomainCommand.BluetoothEmulation_simulateAdvertisement, CRT_SIMULATE_ADVERTISEMENT, PARAMS_SIMULATE_ADVERTISEMENT_1, new Object[]{entry}, true);
    }

    @Override
    public void simulateCharacteristicOperationResponse(String characteristicId, CharacteristicOperationType type, Integer code) {
        this.handler.invoke(this, DomainCommand.BluetoothEmulation_simulateCharacteristicOperationResponse, CRT_SIMULATE_CHARACTERISTIC_OPERATION_RESPONSE, PARAMS_SIMULATE_CHARACTERISTIC_OPERATION_RESPONSE_1, new Object[]{characteristicId, type, code}, true);
    }

    @Override
    public void simulateCharacteristicOperationResponse(String characteristicId, CharacteristicOperationType type, Integer code, String data) {
        this.handler.invoke(this, DomainCommand.BluetoothEmulation_simulateCharacteristicOperationResponse, CRT_SIMULATE_CHARACTERISTIC_OPERATION_RESPONSE, PARAMS_SIMULATE_CHARACTERISTIC_OPERATION_RESPONSE_2, new Object[]{characteristicId, type, code, data}, true);
    }

    @Override
    public void simulateDescriptorOperationResponse(String descriptorId, DescriptorOperationType type, Integer code) {
        this.handler.invoke(this, DomainCommand.BluetoothEmulation_simulateDescriptorOperationResponse, CRT_SIMULATE_DESCRIPTOR_OPERATION_RESPONSE, PARAMS_SIMULATE_DESCRIPTOR_OPERATION_RESPONSE_1, new Object[]{descriptorId, type, code}, true);
    }

    @Override
    public void simulateDescriptorOperationResponse(String descriptorId, DescriptorOperationType type, Integer code, String data) {
        this.handler.invoke(this, DomainCommand.BluetoothEmulation_simulateDescriptorOperationResponse, CRT_SIMULATE_DESCRIPTOR_OPERATION_RESPONSE, PARAMS_SIMULATE_DESCRIPTOR_OPERATION_RESPONSE_2, new Object[]{descriptorId, type, code, data}, true);
    }

    @Override
    public void simulateGATTDisconnection(String address) {
        this.handler.invoke(this, DomainCommand.BluetoothEmulation_simulateGATTDisconnection, CRT_SIMULATE_GA_TT_DISCONNECTION, PARAMS_SIMULATE_GA_TT_DISCONNECTION_1, new Object[]{address}, true);
    }

    @Override
    public void simulateGATTOperationResponse(String address, GATTOperationType type, Integer code) {
        this.handler.invoke(this, DomainCommand.BluetoothEmulation_simulateGATTOperationResponse, CRT_SIMULATE_GA_TT_OPERATION_RESPONSE, PARAMS_SIMULATE_GA_TT_OPERATION_RESPONSE_1, new Object[]{address, type, code}, true);
    }

    @Override
    public void simulatePreconnectedPeripheral(String address, String name, List<ManufacturerData> manufacturerData, List<String> knownServiceUuids) {
        this.handler.invoke(this, DomainCommand.BluetoothEmulation_simulatePreconnectedPeripheral, CRT_SIMULATE_PRECONNECTED_PERIPHERAL, PARAMS_SIMULATE_PRECONNECTED_PERIPHERAL_1, new Object[]{address, name, manufacturerData, knownServiceUuids}, true);
    }
}

