/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.command;

import com.cdp4j.TypeReference;
import com.cdp4j.command.CacheStorageAsync;
import com.cdp4j.session.CommandReturnType;
import com.cdp4j.session.DomainCommand;
import com.cdp4j.session.ParameterizedCommandImpl;
import com.cdp4j.session.SessionInvocationHandler;
import com.cdp4j.type.cachestorage.Cache;
import com.cdp4j.type.cachestorage.CachedResponse;
import com.cdp4j.type.cachestorage.Header;
import com.cdp4j.type.cachestorage.RequestEntriesResult;
import com.cdp4j.type.storage.StorageBucket;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class CacheStorageAsyncImpl
extends ParameterizedCommandImpl<CacheStorageAsync>
implements CacheStorageAsync {
    private static final TypeReference<List<Cache>> LIST_CACHE = new TypeReference<List<Cache>>(){};
    private static final CommandReturnType CRT_DELETE_CACHE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_DELETE_ENTRY = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_REQUEST_CACHED_RESPONSE = new CommandReturnType("response", (Type)((Object)CachedResponse.class), null);
    private static final CommandReturnType CRT_REQUEST_CACHE_NAMES = new CommandReturnType("caches", (Type)((Object)List.class), LIST_CACHE);
    private static final CommandReturnType CRT_REQUEST_ENTRIES = new CommandReturnType(null, (Type)((Object)RequestEntriesResult.class), null);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final String[] PARAMS_DELETE_CACHE_1 = new String[]{"cacheId"};
    private static final String[] PARAMS_DELETE_ENTRY_1 = new String[]{"cacheId", "request"};
    private static final String[] PARAMS_REQUEST_CACHED_RESPONSE_1 = new String[]{"cacheId", "requestURL", "requestHeaders"};
    private static final String[] PARAMS_REQUEST_CACHE_NAMES_2 = new String[]{"securityOrigin", "storageKey", "storageBucket"};
    private static final String[] PARAMS_REQUEST_ENTRIES_1 = new String[]{"cacheId"};
    private static final String[] PARAMS_REQUEST_ENTRIES_2 = new String[]{"cacheId", "skipCount", "pageSize", "pathFilter"};
    private final SessionInvocationHandler handler;

    public CacheStorageAsyncImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public CompletableFuture<Void> deleteCache(String cacheId) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.CacheStorage_deleteCache, CRT_DELETE_CACHE, PARAMS_DELETE_CACHE_1, new Object[]{cacheId}, false);
    }

    @Override
    public CompletableFuture<Void> deleteEntry(String cacheId, String request) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.CacheStorage_deleteEntry, CRT_DELETE_ENTRY, PARAMS_DELETE_ENTRY_1, new Object[]{cacheId, request}, false);
    }

    @Override
    public CompletableFuture<List<Cache>> requestCacheNames() {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.CacheStorage_requestCacheNames, CRT_REQUEST_CACHE_NAMES, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<List<Cache>> requestCacheNames(String securityOrigin, String storageKey, StorageBucket storageBucket) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.CacheStorage_requestCacheNames, CRT_REQUEST_CACHE_NAMES, PARAMS_REQUEST_CACHE_NAMES_2, new Object[]{securityOrigin, storageKey, storageBucket}, false);
    }

    @Override
    public CompletableFuture<CachedResponse> requestCachedResponse(String cacheId, String requestURL, List<Header> requestHeaders) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.CacheStorage_requestCachedResponse, CRT_REQUEST_CACHED_RESPONSE, PARAMS_REQUEST_CACHED_RESPONSE_1, new Object[]{cacheId, requestURL, requestHeaders}, false);
    }

    @Override
    public CompletableFuture<RequestEntriesResult> requestEntries(String cacheId) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.CacheStorage_requestEntries, CRT_REQUEST_ENTRIES, PARAMS_REQUEST_ENTRIES_1, new Object[]{cacheId}, false);
    }

    @Override
    public CompletableFuture<RequestEntriesResult> requestEntries(String cacheId, Integer skipCount, Integer pageSize, String pathFilter) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.CacheStorage_requestEntries, CRT_REQUEST_ENTRIES, PARAMS_REQUEST_ENTRIES_2, new Object[]{cacheId, skipCount, pageSize, pathFilter}, false);
    }
}

