/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.command;

import com.cdp4j.TypeReference;
import com.cdp4j.command.CacheStorage;
import com.cdp4j.session.CommandReturnType;
import com.cdp4j.session.DomainCommand;
import com.cdp4j.session.ParameterizedCommandImpl;
import com.cdp4j.session.SessionInvocationHandler;
import com.cdp4j.type.cachestorage.Cache;
import com.cdp4j.type.cachestorage.CachedResponse;
import com.cdp4j.type.cachestorage.Header;
import com.cdp4j.type.cachestorage.RequestEntriesResult;
import com.cdp4j.type.storage.StorageBucket;
import java.lang.reflect.Type;
import java.util.List;

class CacheStorageImpl
extends ParameterizedCommandImpl<CacheStorage>
implements CacheStorage {
    private static final TypeReference<List<Cache>> LIST_CACHE = new TypeReference<List<Cache>>(){};
    private static final CommandReturnType CRT_DELETE_CACHE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_DELETE_ENTRY = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_REQUEST_CACHED_RESPONSE = new CommandReturnType("response", (Type)((Object)CachedResponse.class), null);
    private static final CommandReturnType CRT_REQUEST_CACHE_NAMES = new CommandReturnType("caches", (Type)((Object)List.class), LIST_CACHE);
    private static final CommandReturnType CRT_REQUEST_ENTRIES = new CommandReturnType(null, (Type)((Object)RequestEntriesResult.class), null);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final String[] PARAMS_DELETE_CACHE_1 = new String[]{"cacheId"};
    private static final String[] PARAMS_DELETE_ENTRY_1 = new String[]{"cacheId", "request"};
    private static final String[] PARAMS_REQUEST_CACHED_RESPONSE_1 = new String[]{"cacheId", "requestURL", "requestHeaders"};
    private static final String[] PARAMS_REQUEST_CACHE_NAMES_2 = new String[]{"securityOrigin", "storageKey", "storageBucket"};
    private static final String[] PARAMS_REQUEST_ENTRIES_1 = new String[]{"cacheId"};
    private static final String[] PARAMS_REQUEST_ENTRIES_2 = new String[]{"cacheId", "skipCount", "pageSize", "pathFilter"};
    private final SessionInvocationHandler handler;

    public CacheStorageImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public void deleteCache(String cacheId) {
        this.handler.invoke(this, DomainCommand.CacheStorage_deleteCache, CRT_DELETE_CACHE, PARAMS_DELETE_CACHE_1, new Object[]{cacheId}, true);
    }

    @Override
    public void deleteEntry(String cacheId, String request) {
        this.handler.invoke(this, DomainCommand.CacheStorage_deleteEntry, CRT_DELETE_ENTRY, PARAMS_DELETE_ENTRY_1, new Object[]{cacheId, request}, true);
    }

    @Override
    public List<Cache> requestCacheNames() {
        return (List)this.handler.invoke(this, DomainCommand.CacheStorage_requestCacheNames, CRT_REQUEST_CACHE_NAMES, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public List<Cache> requestCacheNames(String securityOrigin, String storageKey, StorageBucket storageBucket) {
        return (List)this.handler.invoke(this, DomainCommand.CacheStorage_requestCacheNames, CRT_REQUEST_CACHE_NAMES, PARAMS_REQUEST_CACHE_NAMES_2, new Object[]{securityOrigin, storageKey, storageBucket}, true);
    }

    @Override
    public CachedResponse requestCachedResponse(String cacheId, String requestURL, List<Header> requestHeaders) {
        return (CachedResponse)this.handler.invoke(this, DomainCommand.CacheStorage_requestCachedResponse, CRT_REQUEST_CACHED_RESPONSE, PARAMS_REQUEST_CACHED_RESPONSE_1, new Object[]{cacheId, requestURL, requestHeaders}, true);
    }

    @Override
    public RequestEntriesResult requestEntries(String cacheId) {
        return (RequestEntriesResult)this.handler.invoke(this, DomainCommand.CacheStorage_requestEntries, CRT_REQUEST_ENTRIES, PARAMS_REQUEST_ENTRIES_1, new Object[]{cacheId}, true);
    }

    @Override
    public RequestEntriesResult requestEntries(String cacheId, Integer skipCount, Integer pageSize, String pathFilter) {
        return (RequestEntriesResult)this.handler.invoke(this, DomainCommand.CacheStorage_requestEntries, CRT_REQUEST_ENTRIES, PARAMS_REQUEST_ENTRIES_2, new Object[]{cacheId, skipCount, pageSize, pathFilter}, true);
    }
}

