/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.logger;

import com.cdp4j.logger.CdpLogger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class CdpLog4j2Logger
implements CdpLogger {
    private final Logger log;
    private final boolean debugEnabled;

    public CdpLog4j2Logger(String name) {
        this.log = LogManager.getLogger((String)name);
        this.debugEnabled = this.log.isDebugEnabled();
    }

    @Override
    public void info(String message, Object ... args) {
        if (this.log.isInfoEnabled()) {
            this.log.info(message, args);
        }
    }

    @Override
    public void debug(String message, Object ... args) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(message, args);
        }
    }

    @Override
    public void warn(String message, Object ... args) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(message, args);
        }
    }

    @Override
    public void error(String message, Object ... args) {
        if (this.log.isErrorEnabled()) {
            this.log.error(message, args);
        }
    }

    @Override
    public void error(String message, Throwable t) {
        if (this.log.isErrorEnabled()) {
            this.log.error(message, t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }
}

