/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.logger;

import com.cdp4j.logger.CdpLogger;
import com.cdp4j.logger.FormattingTuple;
import com.cdp4j.logger.MessageFormatter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class CdpLog4jLogger
implements CdpLogger {
    private final Logger log;
    private final boolean isDebugEnabled;

    public CdpLog4jLogger(String name) {
        this.log = Logger.getLogger((String)name);
        this.isDebugEnabled = this.log.isDebugEnabled();
    }

    @Override
    public void info(String message, Object ... args) {
        if (this.log.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            this.log.info((Object)tuple.getMessage());
        }
    }

    @Override
    public void debug(String message, Object ... args) {
        if (this.log.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            this.log.debug((Object)tuple.getMessage());
        }
    }

    @Override
    public void warn(String message, Object ... args) {
        if (this.log.isEnabledFor((Priority)Level.WARN)) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            this.log.log((Priority)Level.WARN, (Object)tuple.getMessage());
        }
    }

    @Override
    public void error(String message, Object ... args) {
        if (this.log.isEnabledFor((Priority)Level.ERROR)) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            this.log.error((Object)tuple.getMessage());
        }
    }

    @Override
    public void error(String message, Throwable t) {
        if (this.log.isEnabledFor((Priority)Level.ERROR)) {
            this.log.error((Object)message, t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }
}

