/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.serialization;

import com.cdp4j.logger.CdpLogger;
import com.cdp4j.serialization.GsonEnumTypeAdapter;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

class GsonEnumTypeAdapterFactory
implements TypeAdapterFactory {
    private final CdpLogger log;
    private static final String CDP_ENUM_PACKAGE_PREFIX = "com.cdp4j.type";

    GsonEnumTypeAdapterFactory(CdpLogger log) {
        this.log = log;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Class rawType = typeToken.getRawType();
        if (!Enum.class.isAssignableFrom(rawType) || rawType == Enum.class || !rawType.getName().startsWith(CDP_ENUM_PACKAGE_PREFIX)) {
            return null;
        }
        if (!rawType.isEnum()) {
            rawType = rawType.getSuperclass();
        }
        return new GsonEnumTypeAdapter(rawType, this.log);
    }
}

