/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.serialization;

import com.cdp4j.JsonLibrary;
import com.cdp4j.exception.CdpException;
import com.cdp4j.logger.CdpLogger;
import com.cdp4j.serialization.GsonEnumTypeAdapterFactory;
import com.cdp4j.serialization.JsonMapper;
import com.cdp4j.session.Option;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;

public class GsonMapper
implements JsonMapper {
    private final Gson gson;
    private static TypeToken<List<Option>> LIST_OPTION = new TypeToken<List<Option>>(){};
    private static TypeToken<List<List<Object>>> LIST_LIST_OBJECT = new TypeToken<List<List<Object>>>(){};
    private static final GsonByteArrayTypeAdapter GSON_TYPE_ARRAY_ADAPTER = new GsonByteArrayTypeAdapter();

    public GsonMapper() {
        this(null);
    }

    public GsonMapper(CdpLogger log) {
        GsonBuilder builder = new GsonBuilder().registerTypeHierarchyAdapter(byte[].class, (Object)GSON_TYPE_ARRAY_ADAPTER).registerTypeAdapterFactory((TypeAdapterFactory)new GsonEnumTypeAdapterFactory(log)).disableHtmlEscaping();
        this.gson = builder.create();
    }

    @Override
    public List<Option> jsonToOptions(String json) {
        return (List)this.gson.fromJson(json, LIST_OPTION.getType());
    }

    @Override
    public Object fromJsonResult(String json, Class<?> returnType) {
        JsonObject object = (JsonObject)this.gson.fromJson(json, JsonObject.class);
        JsonElement result = object.get("result");
        Object value = this.gson.fromJson(result, returnType);
        return value;
    }

    @Override
    public String toJson(Object argument) {
        return this.gson.toJson(argument);
    }

    @Override
    public List<List<Object>> jsonToListOfList(String json) {
        return (List)this.gson.fromJson(json, LIST_LIST_OBJECT.getType());
    }

    @Override
    public Object getMapper() {
        return this.gson;
    }

    @Override
    public Object getReader() {
        throw new CdpException("not supported");
    }

    @Override
    public Object getWriter() {
        throw new CdpException("not supported");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T fromJson(InputStream is, Class<T> klass) {
        try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            Object object = this.gson.fromJson((Reader)reader, klass);
            return (T)object;
        }
        catch (IOException e) {
            throw new CdpException(e);
        }
    }

    @Override
    public JsonLibrary getType() {
        return JsonLibrary.Gson;
    }

    @Override
    public <T> T fromObject(Object value, Class<T> returnType) {
        throw new CdpException("not supported");
    }

    private static class GsonByteArrayTypeAdapter
    implements JsonDeserializer<byte[]>,
    JsonSerializer<byte[]> {
        private GsonByteArrayTypeAdapter() {
        }

        public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(Base64.getEncoder().encodeToString(src));
        }

        public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Base64.getDecoder().decode(json.getAsString());
        }
    }
}

