/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.session;

import com.cdp4j.JsonLibrary;
import com.cdp4j.SelectorEngine;
import com.cdp4j.command.DOM;
import com.cdp4j.exception.ElementNotFoundException;
import com.cdp4j.serialization.JsonMapper;
import com.cdp4j.session.Constant;
import com.cdp4j.session.DocumentSnapshot;
import com.cdp4j.session.DomSnapshotIterator;
import com.cdp4j.session.Option;
import com.cdp4j.session.Session;
import com.cdp4j.session.TreeNode;
import com.cdp4j.type.dom.BoxModel;
import com.cdp4j.type.dom.Node;
import com.cdp4j.type.domsnapshot.DOMNode;
import com.cdp4j.type.domsnapshot.GetSnapshotResult;
import com.cdp4j.type.runtime.CallArgument;
import com.cdp4j.type.runtime.CallFunctionOnResult;
import com.cdp4j.type.runtime.ExceptionDetails;
import com.cdp4j.type.runtime.PropertyDescriptor;
import com.cdp4j.type.runtime.RemoteObject;
import com.cdp4j.type.util.Point;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface Dom {
    default public String getText(String selector) {
        return this.getText(selector, Constant.EMPTY_ARGS);
    }

    default public String getText(String selector, Object ... args) {
        return (String)this.getThis().getProperty(selector, "textContent", args);
    }

    default public Session selectInputText(String selector) {
        return this.selectInputText(selector, Constant.EMPTY_ARGS);
    }

    default public Session selectInputText(String selector, Object ... args) {
        this.getThis().logEntry("selectInputText", String.format(selector, args));
        String objectId = this.getThis().getObjectId(selector, args);
        if (objectId == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        CallFunctionOnResult functionResult = this.getThis().getCommand().getRuntime().callFunctionOn("function() { this.select(); }", objectId, null, null, null, null, null, null, null, null, null, null, null);
        if (functionResult != null) {
            RemoteObject exception;
            ExceptionDetails exceptionDetails;
            RemoteObject result = functionResult.getResult();
            if (result != null) {
                this.getThis().releaseObject(result.getObjectId());
            }
            if ((exceptionDetails = functionResult.getExceptionDetails()) != null && (exception = exceptionDetails.getException()) != null) {
                this.getThis().error(exception.getDescription(), new Object[0]);
            }
        }
        this.getThis().releaseObject(objectId);
        return this.getThis();
    }

    default public Session focus(String selector) {
        return this.focus(null, selector);
    }

    default public Session focus(String selector, Object ... args) {
        return this.focus(null, selector, args);
    }

    default public Session focus(Integer contextId, String selector) {
        return this.focus(contextId, selector, Constant.EMPTY_ARGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Session focus(Integer contextId, String selector, Object ... args) {
        this.getThis().logEntry("focus", String.format(selector, args));
        String objectId = this.getThis().getObjectIdWithContext(contextId, selector, args);
        if (objectId == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        try {
            DOM dom = this.getThis().getCommand().getDOM();
            dom.focus(null, null, objectId);
        }
        finally {
            this.getThis().releaseObject(objectId);
        }
        return this.getThis();
    }

    default public int getSelectedIndex(String selector) {
        return this.getSelectedIndex(selector, Constant.EMPTY_ARGS);
    }

    default public int getSelectedIndex(String selector, Object ... args) {
        String objectId = this.getThis().getObjectId(selector, args);
        if (objectId == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        Number selectedIndex = (Number)this.getThis().getPropertyByObjectId(objectId, "selectedIndex");
        this.getThis().releaseObject(objectId);
        if (selectedIndex == null) {
            selectedIndex = -1;
        }
        this.getThis().logExit("getSelectedIndex", String.format(selector, args), selectedIndex.intValue());
        return selectedIndex.intValue();
    }

    default public Session setSelectedIndex(String selector, int index) {
        return this.setSelectedIndex(selector, index, Constant.EMPTY_ARGS);
    }

    default public Session setSelectedIndex(String selector, int index, Object ... args) {
        String objectId;
        if (index < -1) {
            return this.getThis();
        }
        if (index != -1) {
            this.getThis().logEntry("setSelectedIndex", String.format(selector, args) + "\", \"" + index);
        }
        if ((objectId = this.getThis().getObjectId(selector, args)) == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        CallFunctionOnResult result = this.getThis().getCommand().getRuntime().callFunctionOn(String.format("function() { this.selectedIndex = %d }", index), objectId, null, null, null, null, null, null, null, null, null, null, null);
        if (result != null && result.getResult() != null) {
            this.getThis().releaseObject(result.getResult().getObjectId());
        }
        this.getThis().releaseObject(objectId);
        return this.getThis();
    }

    default public List<Option> getOptions(String selector) {
        return this.getOptions(selector, Constant.EMPTY_ARGS);
    }

    default public List<Option> getOptions(String selector, Object ... args) {
        String objectId = this.getThis().getObjectId(selector, args);
        if (objectId == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        PropertyDescriptor pd = this.getThis().getPropertyDescriptor(objectId, "options");
        if (pd != null && pd.getValue() != null) {
            Number length = (Number)this.getThis().getPropertyByObjectId(pd.getValue().getObjectId(), "length");
            List<Option> list = Collections.emptyList();
            if (length != null) {
                if (length.intValue() <= 0) {
                    this.getThis().releaseObject(objectId);
                } else {
                    CallFunctionOnResult result = this.getThis().getCommand().getRuntime().callFunctionOn("function() { let options = []; for (let i = 0; i < this.length; i++) { options.push({ index : this[i].index, selected: this[i].selected, value: this[i].value, text: this[i].textContent, group: this[i].parentElement.tagName=== 'OPTGROUP' ? this[i].parentElement.getAttribute('label') : null }); } return JSON.stringify(options); }", pd.getValue().getObjectId(), null, null, null, null, null, null, null, null, null, null, null);
                    if (result != null && result.getResult() != null) {
                        String json = (String)result.getResult().getValue();
                        this.getThis().releaseObject(result.getResult().getObjectId());
                        JsonMapper mapper = this.getThis().getJsonMapper();
                        list = mapper.jsonToOptions(json);
                    }
                }
            }
            this.getThis().releaseObject(pd.getValue().getObjectId());
            this.getThis().releaseObject(objectId);
            return list;
        }
        this.getThis().releaseObject(objectId);
        return Collections.emptyList();
    }

    default public Session clearOptions(String selector) {
        return this.clearOptions(selector, -1, Constant.EMPTY_ARGS);
    }

    default public Session clearOptions(String selector, Object ... args) {
        this.getThis().logEntry("clearOptions", String.format(selector, args));
        return this.setSelectedIndex(selector, -1, args);
    }

    default public Session setSelectedOptions(String selector, List<Integer> indexes) {
        return this.setSelectedOptions(selector, indexes, Constant.EMPTY_ARGS);
    }

    default public Session setSelectedOptions(String selector, List<Integer> indexes, Object ... args) {
        if (indexes == null) {
            return this.getThis();
        }
        String objectId = this.getThis().getObjectId(selector, args);
        if (objectId == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        this.getThis().logEntry("setSelectOptions", String.format(selector, args) + "\", \"" + Arrays.toString((Object[])indexes.toArray(new Integer[0])));
        PropertyDescriptor pd = this.getThis().getPropertyDescriptor(objectId, "options");
        if (pd != null && pd.getValue() != null) {
            Number length = (Number)this.getThis().getPropertyByObjectId(pd.getValue().getObjectId(), "length");
            if (length != null) {
                if (length.intValue() <= 0) {
                    this.getThis().releaseObject(objectId);
                } else {
                    for (Integer index : indexes) {
                        if (index > length.intValue() || index < 0) {
                            this.getThis().error("invalid index value [{}]", (int)index);
                            continue;
                        }
                        CallFunctionOnResult result = this.getThis().getCommand().getRuntime().callFunctionOn(String.format("function() { this[%d].selected = true }", index), pd.getValue().getObjectId(), null, null, null, null, null, null, null, null, null, null, null);
                        if (result == null || result.getResult() == null) continue;
                        this.getThis().releaseObject(result.getResult().getObjectId());
                    }
                }
            }
            this.getThis().releaseObject(pd.getValue().getObjectId());
            this.getThis().releaseObject(objectId);
            return this.getThis();
        }
        this.getThis().releaseObject(objectId);
        return this.getThis();
    }

    default public Session setFiles(String selector, Path ... files) {
        if (files == null || files.length == 0) {
            return this.getThis();
        }
        ArrayList<String> list = new ArrayList<String>(files.length);
        for (Path file : files) {
            list.add(file.toString());
        }
        return this.setFiles(selector, list.toArray(new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Session setFiles(String selector, String ... files) {
        if (files == null || files.length == 0) {
            return this.getThis();
        }
        String objectId = this.getThis().getObjectIdWithContext(null, selector, Constant.EMPTY_ARGS);
        if (objectId == null) {
            throw new ElementNotFoundException(String.format(selector, new Object[0]));
        }
        try {
            this.getThis().logEntry("setFiles", String.format(selector, new Object[0]) + "\", \"" + Arrays.toString(files));
            DOM dom = this.getThis().getCommand().getDOM();
            dom.setFileInputFiles(Arrays.asList(files), null, null, objectId);
            Session session = this.getThis();
            return session;
        }
        finally {
            this.getThis().releaseObject(objectId);
        }
    }

    default public boolean isDisabled(String selector) {
        return this.isDisabled(selector, Constant.EMPTY_ARGS);
    }

    default public boolean isDisabled(String selector, Object ... args) {
        Boolean property = Boolean.TRUE.equals(this.getThis().getProperty(selector, "disabled", args));
        this.getThis().logExit("isDisabled", String.format(selector, args), (boolean)property);
        return property;
    }

    default public boolean isChecked(String selector) {
        return this.isChecked(selector, Constant.EMPTY_ARGS);
    }

    default public boolean isChecked(String selector, Object ... args) {
        Boolean property = Boolean.TRUE.equals(this.getThis().getProperty(selector, "checked", args));
        this.getThis().logExit("isChecked", String.format(selector, args), (boolean)property);
        return property;
    }

    default public Session setChecked(String selector, boolean checked) {
        return this.setChecked(selector, checked, Constant.EMPTY_ARGS);
    }

    default public Session setChecked(String selector, boolean checked, Object ... args) {
        this.getThis().logEntry("setChecked", String.format(selector, new Object[0]) + "\", \"" + checked);
        this.getThis().setProperty(selector, "checked", checked, args);
        return this.getThis();
    }

    default public Session setDisabled(String selector, boolean disabled) {
        return this.setDisabled(selector, disabled, Constant.EMPTY_ARGS);
    }

    default public Session setDisabled(String selector, boolean disabled, Object ... args) {
        this.getThis().logEntry("setDisabled", String.format(selector, new Object[0]) + "\", \"" + disabled);
        this.getThis().setProperty(selector, "disabled", disabled, args);
        return this.getThis();
    }

    default public Session setValue(String selector, Object value) {
        return this.setValue(selector, value, Constant.EMPTY_ARGS);
    }

    default public Session setValue(String selector, Object value, Object ... args) {
        return this.setAttribute(selector, "value", value, args);
    }

    default public String getValue(String selector) {
        return this.getValue(selector, Constant.EMPTY_ARGS);
    }

    default public String getValue(String selector, Object ... args) {
        String objectId = this.getThis().getObjectId(selector, args);
        if (objectId == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        String value = (String)this.getThis().getPropertyByObjectId(objectId, "value");
        this.getThis().releaseObject(objectId);
        if (value == null) {
            return null;
        }
        this.getThis().logExit("getValue", String.format(selector, args), value);
        return value;
    }

    default public Map<String, String> getAttributes(String selector) {
        return this.getAttributes(selector, Constant.EMPTY_ARGS);
    }

    default public Map<String, String> getAttributes(String selector, Object ... args) {
        return this.getAttributes(null, selector, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Map<String, String> getAttributes(Integer contextId, String selector, Object ... args) {
        Session that = this.getThis();
        String objectId = that.getObjectIdWithContext(contextId, selector, args);
        if (objectId == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        Node node = null;
        try {
            node = that.getCommand().getDOM().describeNode(null, null, objectId, null, Boolean.FALSE);
        }
        finally {
            that.releaseObject(objectId);
        }
        if (node != null) {
            List<String> attributes = node.getAttributes();
            if (attributes.isEmpty()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(attributes.size() / 2);
            for (int i = 0; i < attributes.size(); i += 2) {
                String attrName = attributes.get(i);
                String attrValue = attributes.get(i + 1);
                map.put(attrName, attrValue);
            }
            return map;
        }
        return Collections.emptyMap();
    }

    default public String getAttribute(String selector, String name) {
        return this.getAttribute(selector, name, Constant.EMPTY_ARGS);
    }

    default public String getAttribute(String selector, String name, Object ... args) {
        return this.getAttribute(null, selector, name, args);
    }

    default public String getAttribute(Integer contextId, String selector, String name, Object ... args) {
        if (name == null || name.trim().isEmpty()) {
            return null;
        }
        String value = this.getAttributes(contextId, String.format(selector, args), new Object[0]).get(name);
        this.getThis().logExit("getAttribute", String.format(selector, args) + "\", \"" + name, value);
        return value;
    }

    default public Session setAttribute(String selector, String name, Object value, Object ... args) {
        return this.setAttribute(null, selector, name, value, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Session setAttribute(Integer contextId, String selector, String name, Object value, Object ... args) {
        if (this.getThis().isRootFrame() && this.getThis().getSelectorEngine() != SelectorEngine.Playwright) {
            Integer nodeId = this.getThis().getNodeId(contextId, selector, args);
            if (nodeId == null || Constant.EMPTY_NODE_ID.equals(nodeId)) {
                throw new ElementNotFoundException(String.format(selector, args));
            }
            this.getThis().logEntry("setAttribute", String.format(selector, new Object[0]) + "\", \"" + name + "\", \"" + value);
            this.getThis().getCommand().getDOM().setAttributeValue(nodeId, name, value == null ? null : String.valueOf(value));
            return this.getThis();
        }
        String objectId = this.getThis().getObjectIdWithContext(contextId, selector, args);
        if (objectId == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        try {
            ArrayList<CallArgument> arguments = new ArrayList<CallArgument>(3);
            CallArgument argObj = new CallArgument();
            argObj.setObjectId(objectId);
            arguments.add(argObj);
            CallArgument argName = new CallArgument();
            argName.setValue(name);
            arguments.add(argName);
            CallArgument argValue = new CallArgument();
            argValue.setValue(String.valueOf(value));
            arguments.add(argValue);
            String func = "(obj, name, value) => { obj.setAttribute(name, value); }";
            this.getThis().getCommand().getRuntime().callFunctionOn(func, objectId, arguments, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null);
            Session session = this.getThis();
            return session;
        }
        finally {
            this.getThis().releaseObject(objectId);
        }
    }

    default public Session setAttribute(String selector, String name, Object value) {
        return this.setAttribute(selector, name, value, Constant.EMPTY_ARGS);
    }

    default public BoxModel getBoxModel(String selector, Object ... args) {
        return this.getBoxModel(null, selector, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public BoxModel getBoxModel(Integer contextId, String selector, Object ... args) {
        String objectId = this.getThis().getObjectIdWithContext(contextId, selector, args);
        if (objectId == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        try {
            BoxModel boxModel = this.getThis().getCommand().getDOM().getBoxModel(null, null, objectId);
            return boxModel;
        }
        finally {
            this.getThis().releaseObject(objectId);
        }
    }

    default public String getOuterHtml(String selector) {
        return this.getOuterHtml(selector, Constant.EMPTY_ARGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public String getOuterHtml(String selector, Object ... args) {
        String objectId = this.getThis().getObjectId(null, selector, args);
        if (objectId == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        try {
            String string = this.getThis().getCommand().getDOM().getOuterHTML(null, null, objectId, null);
            return string;
        }
        finally {
            this.getThis().releaseObject(objectId);
        }
    }

    default public String getInnerHtml(String selector) {
        return this.getInnerHtml(selector, Constant.EMPTY_ARGS);
    }

    default public String getInnerHtml(String selector, Object ... args) {
        return (String)this.getThis().getProperty(selector, "innerHTML", args);
    }

    default public void scrollIntoViewIfNeeded(String selector) {
        this.scrollIntoViewIfNeeded(selector, Constant.EMPTY_ARGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void scrollIntoViewIfNeeded(String selector, Object ... args) {
        String objectId = this.getThis().getObjectId(selector, args);
        if (objectId == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        try {
            this.scrollIntoViewIfNeededWithObjectId(selector, objectId, args);
        }
        finally {
            this.getThis().releaseObject(objectId);
        }
    }

    default public void scrollIntoViewIfNeededWithObjectId(String selector, String objectId, Object ... args) {
        this.getThis().getCommand().getDOM().scrollIntoViewIfNeeded(null, null, objectId, null);
    }

    default public Point getClickablePoint(String selector) {
        return this.getClickablePoint(selector, Constant.EMPTY_ARGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Point getClickablePoint(String selector, Object ... args) {
        String objectId = this.getThis().getObjectId(selector, args);
        if (objectId == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        try {
            Point point = this.getClickablePointWithObjectId(selector, objectId, args);
            return point;
        }
        finally {
            this.getThis().releaseObject(objectId);
        }
    }

    default public Point getClickablePointWithObjectId(String selector, String objectId, Object ... args) {
        Function<List, Double> computeQuadArea = quad -> {
            Double area = 0.0;
            for (int i = 0; i < quad.size(); ++i) {
                Point p1 = (Point)quad.get(i);
                Point p2 = (Point)quad.get((i + 1) % quad.size());
                area = area + (p1.x * p2.y - p2.x * p1.y) / 2.0;
            }
            return area;
        };
        List<List<Double>> quads = this.getThis().getCommand().getDOM().getContentQuads(null, null, objectId);
        List clickableQuads = quads.stream().map(quad -> {
            ArrayList<Point> list = new ArrayList<Point>(4);
            list.add(new Point((Double)quad.get(0), (Double)quad.get(1)));
            list.add(new Point((Double)quad.get(2), (Double)quad.get(3)));
            list.add(new Point((Double)quad.get(4), (Double)quad.get(5)));
            list.add(new Point((Double)quad.get(6), (Double)quad.get(7)));
            return list;
        }).filter(t -> (Double)computeQuadArea.apply((List)t) > 1.0).collect(Collectors.toList());
        List quad2 = (List)clickableQuads.get(0);
        Double x = 0.0;
        Double y = 0.0;
        for (Point next : quad2) {
            x = x + next.x;
            y = y + next.y;
        }
        x = x / 4.0;
        y = y / 4.0;
        return new Point(x, y);
    }

    default public List<DocumentSnapshot> getDocumentSnapshot() {
        if (JsonLibrary.Jackson == this.getThis().getJsonMapper().getType()) {
            GetSnapshotResult result = this.getThis().getCommand().getCustomCommand().getSnapshot(Collections.emptyList());
            List<DOMNode> nodes = result.getDomNodes();
            return DomSnapshotIterator.toHtml(nodes);
        }
        GetSnapshotResult result = this.getThis().getCommand().getDOMSnapshot().getSnapshot(Collections.emptyList());
        List<DOMNode> nodes = result.getDomNodes();
        return DomSnapshotIterator.toHtml(nodes);
    }

    default public String getDOMSnapshot() {
        GetSnapshotResult result = this.getThis().getCommand().getDOMSnapshot().getSnapshot(Collections.emptyList());
        List<DOMNode> nodes = result.getDomNodes();
        int size = nodes.size();
        int[] childParentIndexes = new int[size];
        for (int parentIndex = 0; parentIndex < size; ++parentIndex) {
            DOMNode node = nodes.get(parentIndex);
            for (Integer childIndex : node.getChildNodeIndexes()) {
                childParentIndexes[childIndex.intValue()] = parentIndex;
            }
        }
        DOMNode root = nodes.get(0);
        int rootLength = root.getChildNodeIndexes().size();
        TreeNode tree = new TreeNode(root, rootLength);
        for (int i = 1; i < size; ++i) {
            int parentIndex = childParentIndexes[i];
            DOMNode node = nodes.get(i);
            List<Integer> childNodeIndexes = node.getChildNodeIndexes();
            int childLength = childNodeIndexes.size();
            if (parentIndex > 0) {
                TreeNode parentNode;
                DOMNode parent = nodes.get(parentIndex);
                if (parent == null || (parentNode = tree.find(parent)) == null) continue;
                parentNode.add(new TreeNode(node, childLength));
                continue;
            }
            tree.add(new TreeNode(node, childLength));
        }
        return tree.toString();
    }

    public Session getThis();
}

