/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.session;

import com.cdp4j.exception.CdpReadTimeoutException;
import com.cdp4j.logger.CdpLogger;
import com.cdp4j.session.DomainCommand;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;

class FutureUtils {
    FutureUtils() {
    }

    public static <T> CompletableFuture<T> orTimeout(CompletableFuture<T> future, long timeout, TimeUnit timeUnit, Function<Long, CdpReadTimeoutException> readTimeoutSupplier, Executor timeoutFailExecutor, Runnable cleaner, CdpLogger logger, DomainCommand command) {
        if (!future.isDone()) {
            ScheduledFuture timeoutFuture = Delayer.delay(() -> timeoutFailExecutor.execute(new Timeout(future, timeout, readTimeoutSupplier, cleaner, logger, command)), timeout, timeUnit);
            future.whenComplete((value, throwable) -> {
                if (!timeoutFuture.isDone()) {
                    timeoutFuture.cancel(false);
                }
            });
        }
        return future;
    }

    public static <R extends RuntimeException, T extends R> R handleOrReturnException(T exception, Consumer<T> exceptionHandler, Class<R> returnTypeClass) {
        if (exceptionHandler != null) {
            try {
                exceptionHandler.accept(exception);
                return null;
            }
            catch (RuntimeException handlerException) {
                if (returnTypeClass.isAssignableFrom(handlerException.getClass())) {
                    return (R)handlerException;
                }
                throw handlerException;
            }
        }
        return exception;
    }

    private static enum Delayer {

        static final ScheduledThreadPoolExecutor DELAYER = new ScheduledThreadPoolExecutor(0, new CdpThreadFactory("CdpCompletableFutureDelayScheduler"));

        private static ScheduledFuture<?> delay(Runnable runnable, long delay, TimeUnit timeUnit) {
            return DELAYER.schedule(runnable, delay, timeUnit);
        }

        static {
            DELAYER.setKeepAliveTime(60L, TimeUnit.SECONDS);
            DELAYER.setRemoveOnCancelPolicy(true);
        }
    }

    private static final class Timeout
    implements Runnable {
        private final CompletableFuture<?> future;
        private final long timeout;
        private final Function<Long, CdpReadTimeoutException> readTimeoutSupplier;
        private final Runnable cleaner;
        private final CdpLogger log;
        private final DomainCommand command;

        private Timeout(CompletableFuture<?> future, long timeout, Function<Long, CdpReadTimeoutException> readTimeoutSupplier, Runnable cleaner, CdpLogger log, DomainCommand command) {
            this.future = future;
            this.timeout = timeout;
            this.readTimeoutSupplier = readTimeoutSupplier;
            this.cleaner = cleaner;
            this.log = log;
            this.command = command;
        }

        @Override
        public void run() {
            this.log.error("TimeoutError [{}] ({} ms)", this.command.method, this.timeout);
            CdpReadTimeoutException timeoutException = this.readTimeoutSupplier.apply(this.timeout);
            if (timeoutException != null) {
                this.future.completeExceptionally(timeoutException);
            }
            this.cleaner.run();
        }
    }

    private static class CdpThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger THREAD_SEQUENCE_NUMBER = new AtomicInteger(1);
        private final String name;

        public CdpThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, this.name + "-" + THREAD_SEQUENCE_NUMBER.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    }
}

