/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.session;

import com.cdp4j.channel.Channel;
import com.cdp4j.exception.CdpException;
import com.cdp4j.exception.CdpReadTimeoutException;
import com.cdp4j.exception.CdpReadTimeoutExceptionHandler;
import com.cdp4j.logger.CdpLogger;
import com.cdp4j.serialization.JsonMapper;
import com.cdp4j.serialization.ResponseParser;
import com.cdp4j.session.CommandReturnType;
import com.cdp4j.session.Context;
import com.cdp4j.session.DomainCommand;
import com.cdp4j.session.FutureUtils;
import com.cdp4j.session.HandlerConstants;
import com.cdp4j.session.ParameterizedCommand;
import com.cdp4j.session.PromiseContext;
import com.cdp4j.session.SemaphoreContext;
import com.cdp4j.session.Session;
import com.cdp4j.session.SessionInvocationHandler;
import com.cdp4j.session.ThreadContext;
import com.cdp4j.session.WaitingStrategy;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class GsonSessionInvocationHandler
implements SessionInvocationHandler,
HandlerConstants {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Gson gson;
    private final Channel channel;
    private final Map<Integer, Context> contexts;
    private final CdpLogger log;
    private final Session session;
    private final String sessionId;
    private int readTimeout;
    private final CdpReadTimeoutExceptionHandler readTimeoutExceptionHandler;
    private final WaitingStrategy waitingStrategy;
    private final Executor workerThreadPool;

    GsonSessionInvocationHandler(JsonMapper mapper, Channel channel, Map<Integer, Context> contexts, Session session, CdpLogger log, String sessionId, int readTimeOut, CdpReadTimeoutExceptionHandler readTimeoutExceptionHandler, WaitingStrategy waitingStrategy, Executor workerThreadPool) {
        this.gson = (Gson)mapper.getMapper();
        this.channel = channel;
        this.contexts = contexts;
        this.session = session;
        this.log = log;
        this.sessionId = sessionId;
        this.readTimeout = readTimeOut;
        this.readTimeoutExceptionHandler = readTimeoutExceptionHandler;
        this.waitingStrategy = waitingStrategy;
        this.workerThreadPool = workerThreadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(ParameterizedCommand<?> parameterizedCommand, DomainCommand command, CommandReturnType crt, String[] argNames, Object[] args, boolean sync) {
        Context context;
        CdpReadTimeoutExceptionHandler readTimeoutExceptionHandler;
        int readTimeout;
        if (!this.session.isConnected() || this.session.isDisposed()) {
            throw new CdpException(this.session.isDisposed() ? "Session was disposed." : "WebSocket connection is not alive.");
        }
        Integer id = this.counter.incrementAndGet();
        if (parameterizedCommand == null) {
            readTimeout = this.readTimeout;
            readTimeoutExceptionHandler = this.readTimeoutExceptionHandler;
        } else {
            int commandReadTimeout = parameterizedCommand.getReadTimeout();
            commandReadTimeout = commandReadTimeout < 0 ? this.readTimeout : commandReadTimeout;
            readTimeout = (int)Math.round((double)commandReadTimeout * parameterizedCommand.getReadTimeoutFactor());
            CdpReadTimeoutExceptionHandler commandReadTimeoutExceptionHandler = parameterizedCommand.getReadTimeoutExceptionHandler();
            readTimeoutExceptionHandler = commandReadTimeoutExceptionHandler == null ? this.readTimeoutExceptionHandler : commandReadTimeoutExceptionHandler;
        }
        String json = this.toJson(command.method, id, argNames, args);
        if (this.log.isDebugEnabled()) {
            this.log.debug("--> {}", json);
        }
        CompletableFuture<Object> promise = null;
        if (sync) {
            context = WaitingStrategy.Semaphore == this.waitingStrategy ? new SemaphoreContext(command, crt, null) : new ThreadContext(command, crt, null);
        } else {
            promise = FutureUtils.orTimeout(new CompletableFuture(), readTimeout, TimeUnit.MILLISECONDS, timeout -> {
                CdpReadTimeoutException timeoutException = new CdpReadTimeoutException((long)timeout);
                timeoutException.setContextualData(command, crt, argNames, args, json);
                return FutureUtils.handleOrReturnException(timeoutException, readTimeoutExceptionHandler, CdpReadTimeoutException.class);
            }, this.workerThreadPool, () -> {
                Context c;
                if (this.session != null && (c = this.session.pullContext(id)) != null) {
                    c.release();
                }
            }, this.log, command);
            PromiseContext promiseContext = new PromiseContext(command, crt, promise, null);
            context = promiseContext;
        }
        Context context2 = context;
        this.contexts.put(id, context2);
        if (sync) {
            try {
                this.channel.sendText(json);
                context2.await(readTimeout);
            }
            catch (CdpReadTimeoutException ex) {
                ex.setContextualData(command, crt, argNames, args, json);
                if (readTimeoutExceptionHandler != null) {
                    readTimeoutExceptionHandler.accept(ex);
                }
                throw ex;
            }
            finally {
                this.session.pullContext(id);
            }
        } else {
            this.channel.sendText(json);
            return promise;
        }
        if (context2.getError() != null) {
            throw context2.getError();
        }
        return context2.getData();
    }

    String toJson(String method, Integer id, String[] argNames, Object[] argValues) {
        JsonObject argsJson = new JsonObject();
        if (argValues.length > 0) {
            for (int i = 0; i < argValues.length; ++i) {
                argsJson.add(argNames[i], this.gson.toJsonTree(argValues[i]));
            }
        }
        JsonObject payload = new JsonObject();
        payload.add("id", (JsonElement)new JsonPrimitive((Number)id));
        if (this.sessionId != null) {
            payload.add("sessionId", (JsonElement)new JsonPrimitive(this.sessionId));
        }
        payload.add("method", (JsonElement)new JsonPrimitive(method));
        if (argValues.length > 0) {
            payload.add("params", (JsonElement)argsJson);
        }
        return this.gson.toJson((JsonElement)payload);
    }

    @Override
    public void dispose() {
        for (Context context : this.contexts.values()) {
            try {
                context.release();
            }
            catch (Throwable throwable) {}
        }
        this.contexts.clear();
    }

    @Override
    public Object invokeWithCustomParser(ParameterizedCommand<?> parameterizedCommand, DomainCommand command, CommandReturnType crt, String[] argNames, Object[] args, boolean sync, ResponseParser parser) {
        throw new CdpException("not supported");
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        if (readTimeout < 0) {
            throw new IllegalArgumentException("Read timeout must be >= 0");
        }
        this.readTimeout = readTimeout;
    }
}

