/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.session;

import com.cdp4j.channel.Channel;
import com.cdp4j.exception.CdpException;
import com.cdp4j.exception.CdpReadTimeoutException;
import com.cdp4j.exception.CdpReadTimeoutExceptionHandler;
import com.cdp4j.logger.CdpLogger;
import com.cdp4j.serialization.JsonMapper;
import com.cdp4j.serialization.ResponseParser;
import com.cdp4j.session.CommandReturnType;
import com.cdp4j.session.Context;
import com.cdp4j.session.DomainCommand;
import com.cdp4j.session.FutureUtils;
import com.cdp4j.session.HandlerConstants;
import com.cdp4j.session.ParameterizedCommand;
import com.cdp4j.session.PromiseContext;
import com.cdp4j.session.SemaphoreContext;
import com.cdp4j.session.Session;
import com.cdp4j.session.SessionInvocationHandler;
import com.cdp4j.session.ThreadContext;
import com.cdp4j.session.WaitingStrategy;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class JacksonSessionInvocationHandler
implements SessionInvocationHandler,
HandlerConstants {
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Channel channel;
    private final Map<Integer, Context> contexts;
    private final CdpLogger log;
    private final Session session;
    private final String sessionId;
    private int readTimeout;
    private final CdpReadTimeoutExceptionHandler readTimeoutExceptionHandler;
    private final WaitingStrategy waitingStrategy;
    private final ObjectWriter writer;
    private final Executor workerThreadPool;

    JacksonSessionInvocationHandler(JsonMapper mapper, Channel channel, Map<Integer, Context> contexts, Session session, CdpLogger log, String sessionId, int readTimeOut, CdpReadTimeoutExceptionHandler readTimeoutExceptionHandler, WaitingStrategy waitingStrategy, Executor workerThreadPool) {
        this.writer = (ObjectWriter)mapper.getWriter();
        this.channel = channel;
        this.contexts = contexts;
        this.session = session;
        this.log = log;
        this.sessionId = sessionId;
        this.readTimeout = readTimeOut;
        this.readTimeoutExceptionHandler = readTimeoutExceptionHandler;
        this.waitingStrategy = waitingStrategy;
        this.workerThreadPool = workerThreadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invokeWithCustomParser(ParameterizedCommand<?> parameterizedCommand, DomainCommand command, CommandReturnType crt, String[] argNames, Object[] args, boolean sync, ResponseParser responseParser) {
        Context context;
        byte[] json;
        CdpReadTimeoutExceptionHandler readTimeoutExceptionHandler;
        int readTimeout;
        if (!this.session.isConnected() || this.session.isDisposed()) {
            throw new CdpException(this.session.isDisposed() ? "Session was disposed." : "WebSocket connection is not alive.");
        }
        Integer id = this.counter.incrementAndGet();
        if (parameterizedCommand == null) {
            readTimeout = this.readTimeout;
            readTimeoutExceptionHandler = this.readTimeoutExceptionHandler;
        } else {
            int commandReadTimeout = parameterizedCommand.getReadTimeout();
            commandReadTimeout = commandReadTimeout < 0 ? this.readTimeout : commandReadTimeout;
            readTimeout = (int)Math.round((double)commandReadTimeout * parameterizedCommand.getReadTimeoutFactor());
            CdpReadTimeoutExceptionHandler commandReadTimeoutExceptionHandler = parameterizedCommand.getReadTimeoutExceptionHandler();
            readTimeoutExceptionHandler = commandReadTimeoutExceptionHandler == null ? this.readTimeoutExceptionHandler : commandReadTimeoutExceptionHandler;
        }
        try {
            json = this.toJson(command.method, id, argNames, args);
        }
        catch (IOException e) {
            throw new CdpException(e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("--> {}", new String(json, StandardCharsets.UTF_8));
        }
        CompletableFuture<Object> promise = null;
        if (sync) {
            context = WaitingStrategy.Semaphore == this.waitingStrategy ? new SemaphoreContext(command, crt, responseParser) : new ThreadContext(command, crt, responseParser);
        } else {
            promise = FutureUtils.orTimeout(new CompletableFuture(), readTimeout, TimeUnit.MILLISECONDS, timeout -> {
                CdpReadTimeoutException timeoutException = new CdpReadTimeoutException((long)timeout);
                timeoutException.setContextualData(command, crt, argNames, args, new String(json, StandardCharsets.UTF_8));
                return FutureUtils.handleOrReturnException(timeoutException, readTimeoutExceptionHandler, CdpReadTimeoutException.class);
            }, this.workerThreadPool, () -> {
                Context c;
                if (this.session != null && (c = this.session.pullContext(id)) != null) {
                    c.release();
                }
            }, this.log, command);
            PromiseContext promiseContext = new PromiseContext(command, crt, promise, responseParser);
            context = promiseContext;
        }
        Context context2 = context;
        this.contexts.put(id, context2);
        if (sync) {
            try {
                this.channel.sendText(json);
                context2.await(readTimeout);
            }
            catch (CdpReadTimeoutException ex) {
                ex.setContextualData(command, crt, argNames, args, new String(json, StandardCharsets.UTF_8));
                if (readTimeoutExceptionHandler != null) {
                    readTimeoutExceptionHandler.accept(ex);
                }
                throw ex;
            }
            finally {
                this.session.pullContext(id);
            }
        } else {
            this.channel.sendText(json);
            return promise;
        }
        if (context2.getError() != null) {
            throw context2.getError();
        }
        return context2.getData();
    }

    byte[] toJson(String method, Integer id, String[] parameters, Object[] args) throws IOException {
        try (ByteArrayOutputStream bs = new ByteArrayOutputStream(256);){
            byte[] byArray;
            block14: {
                JsonGenerator generator = this.writer.createGenerator((OutputStream)bs);
                try {
                    generator.writeStartObject();
                    generator.writeNumberField("id", id.intValue());
                    if (this.sessionId != null) {
                        generator.writeStringField("sessionId", this.sessionId);
                    }
                    generator.writeStringField("method", method);
                    if (args.length > 0) {
                        generator.writeFieldName("params");
                        generator.writeStartObject();
                        for (int i = 0; i < args.length; ++i) {
                            Object value = args[i];
                            if (value == null) continue;
                            generator.writeObjectField(parameters[i], value);
                        }
                        generator.writeEndObject();
                    }
                    generator.writeEndObject();
                    generator.close();
                    byArray = bs.toByteArray();
                    if (generator == null) break block14;
                }
                catch (Throwable throwable) {
                    if (generator != null) {
                        try {
                            generator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                generator.close();
            }
            return byArray;
        }
    }

    @Override
    public void dispose() {
        for (Context context : this.contexts.values()) {
            try {
                context.release();
            }
            catch (Throwable throwable) {}
        }
        this.contexts.clear();
    }

    @Override
    public Object invoke(ParameterizedCommand<?> parameterizedCommand, DomainCommand command, CommandReturnType crt, String[] argNames, Object[] args, boolean sync) {
        return this.invokeWithCustomParser(parameterizedCommand, command, crt, argNames, args, sync, null);
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        if (readTimeout < 0) {
            throw new IllegalArgumentException("Read timeout must be >= 0");
        }
        this.readTimeout = readTimeout;
    }
}

