/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.session;

import com.cdp4j.command.Input;
import com.cdp4j.event.Events;
import com.cdp4j.event.input.DragIntercepted;
import com.cdp4j.exception.CdpException;
import com.cdp4j.listener.EventListener;
import com.cdp4j.session.Constant;
import com.cdp4j.session.Session;
import com.cdp4j.type.constant.DragEvent;
import com.cdp4j.type.constant.MouseEventType;
import com.cdp4j.type.constant.PointerType;
import com.cdp4j.type.input.DragData;
import com.cdp4j.type.input.MouseButton;
import com.cdp4j.type.util.Point;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public interface Mouse {
    default public Session click(String selector) {
        return this.click(selector, Constant.EMPTY_ARGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Session click(String selector, Object ... args) {
        this.getThis().logEntry("click", String.format(selector, args));
        String objectId = this.getThis().getObjectId(selector, args);
        Point point = null;
        try {
            this.getThis().scrollIntoViewIfNeededWithObjectId(selector, objectId, args);
            point = this.getThis().getClickablePointWithObjectId(selector, objectId, args);
        }
        finally {
            if (objectId != null) {
                this.getThis().releaseObject(objectId);
            }
        }
        this.move(point.x, point.y);
        this.down(point.x, point.y);
        this.up(point.x, point.y);
        return this.getThis();
    }

    default public Session move(double x, double y) {
        Input input = this.getThis().getCommand().getInput();
        input.dispatchMouseEvent(MouseEventType.MouseMoved, x, y, null, null, MouseButton.Left, null, null, null, null, null, null, null, null, null, PointerType.Mouse);
        return this.getThis();
    }

    default public Session down(double x, double y) {
        Input input = this.getThis().getCommand().getInput();
        Integer clickCount = 1;
        input.dispatchMouseEvent(MouseEventType.MousePressed, x, y, null, null, MouseButton.Left, null, clickCount, null, null, null, null, null, null, null, PointerType.Mouse);
        return this.getThis();
    }

    default public Session up(double x, double y) {
        Input input = this.getThis().getCommand().getInput();
        Integer clickCount = 1;
        input.dispatchMouseEvent(MouseEventType.MouseReleased, x, y, null, null, MouseButton.Left, null, clickCount, null, null, null, null, null, null, null, PointerType.Mouse);
        return this.getThis();
    }

    default public DragData drag(Point start, Point target) {
        Input input = this.getThis().getCommand().getInput();
        input.setInterceptDrags(Boolean.TRUE);
        DragData[] data = new DragData[1];
        CountDownLatch latch = new CountDownLatch(1);
        EventListener[] listener = new EventListener[1];
        try {
            listener[0] = (event, value) -> {
                if (Events.InputDragIntercepted == event) {
                    data[0] = ((DragIntercepted)value).getData();
                    latch.countDown();
                }
            };
            this.getThis().addEventListener(listener[0]);
            this.move(start.x, start.y);
            this.down(start.x, start.y);
            this.move(target.x, target.y);
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            latch.countDown();
            throw new CdpException(e);
        }
        finally {
            this.getThis().removeEventEventListener(listener[0]);
        }
        return data[0];
    }

    default public Session dragEnter(Point target, DragData data) {
        this.getThis().getCommand().getInput().dispatchDragEvent(DragEvent.DragEnter, target.x, target.y, data);
        return this.getThis();
    }

    default public Session dragOver(Point target, DragData data) {
        this.getThis().getCommand().getInput().dispatchDragEvent(DragEvent.DragOver, target.x, target.y, data);
        return this.getThis();
    }

    default public Session drop(Point target, DragData data) {
        this.getThis().getCommand().getInput().dispatchDragEvent(DragEvent.Drop, target.x, target.y, data);
        return this.getThis();
    }

    default public Session dragAndDrop(Point start, Point target) {
        DragData data = this.drag(start, target);
        this.dragEnter(target, data);
        this.dragOver(target, data);
        this.drop(target, data);
        this.up(target.x, target.y);
        return this.getThis();
    }

    default public Session dragAndDrop(String draggable, String droppable) {
        Point start = this.getThis().getClickablePoint(draggable);
        Point target = this.getThis().getClickablePoint(droppable);
        return this.dragAndDrop(start, target);
    }

    public Session getThis();
}

