/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.session;

import com.cdp4j.command.DOM;
import com.cdp4j.command.Network;
import com.cdp4j.command.Page;
import com.cdp4j.session.Session;
import com.cdp4j.type.page.GetNavigationHistoryResult;
import com.cdp4j.type.page.NavigationEntry;
import com.cdp4j.type.runtime.RemoteObject;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface Navigator {
    default public Session stop() {
        this.getThis().logEntry("stop");
        this.getThis().getCommand().getPage().stopLoading();
        return this.getThis();
    }

    default public Session back() {
        this.getThis().logEntry("back");
        Page page = this.getThis().getCommand().getPage();
        GetNavigationHistoryResult history = page.getNavigationHistory();
        int index = history.getCurrentIndex() - 1;
        if (index < 0 || index >= history.getEntries().size()) {
            return this.getThis();
        }
        NavigationEntry entry = history.getEntries().get(index);
        if (entry != null) {
            page.navigateToHistoryEntry(entry.getId());
        }
        return this.getThis();
    }

    default public Session forward() {
        this.getThis().logEntry("forward");
        Page page = this.getThis().getCommand().getPage();
        GetNavigationHistoryResult history = page.getNavigationHistory();
        int index = history.getCurrentIndex() + 1;
        if (index >= history.getEntries().size()) {
            return this.getThis();
        }
        NavigationEntry entry = history.getEntries().get(index);
        if (entry != null) {
            page.navigateToHistoryEntry(entry.getId());
        }
        return this.getThis();
    }

    default public Session reload() {
        this.getThis().logEntry("reload");
        this.getThis().getCommand().getPage().reload();
        return this.getThis();
    }

    default public Session setUserAgent(String userAgent) {
        this.getThis().logEntry("userAgent", userAgent);
        Network network = this.getThis().getCommand().getNetwork();
        network.enable();
        network.setUserAgentOverride(userAgent);
        return this.getThis();
    }

    default public String getLocation() {
        return this.getThis().getCommand().getDOM().getDocument().getDocumentURL();
    }

    default public String getPathname() {
        DOM dom = this.getThis().getCommand().getDOM();
        Integer nodeId = dom.getDocument().getNodeId();
        RemoteObject remoteObject = dom.resolveNode(nodeId, null, null, this.getThis().getExecutionContextId());
        String pathname = (String)this.getThis().getPropertyByObjectId(remoteObject.getObjectId(), "location.pathname");
        this.getThis().releaseObject(remoteObject.getObjectId());
        return pathname;
    }

    default public Map<String, Object> getQueryString() {
        this.getThis().disableFlowLog();
        String json = (String)this.getThis().evaluate("JSON.stringify(Array.from(new URLSearchParams(document.location.search)))");
        this.getThis().enableFlowLog();
        if (json == null || json.trim().isEmpty()) {
            return Collections.emptyMap();
        }
        List<List<Object>> params = this.getThis().getJsonMapper().jsonToListOfList(json);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(params.size());
        for (List<Object> param : params) {
            if (param.size() == 0) continue;
            String key = String.valueOf(param.get(0));
            List<Object> value = null;
            if (param.size() > 1) {
                value = param.size() == 2 ? param.get(1) : param.subList(1, param.size());
            }
            map.put(key, value);
        }
        return map;
    }

    default public String getContent() {
        this.getThis().disableFlowLog();
        DOM dom = this.getThis().getCommand().getDOM();
        Integer nodeId = dom.getDocument().getNodeId();
        RemoteObject remoteObject = dom.resolveNode(nodeId, null, null, this.getThis().getExecutionContextId());
        String title = (String)this.getThis().getPropertyByObjectId(remoteObject.getObjectId(), "documentElement.outerHTML");
        this.getThis().logExit("getContent", title);
        this.getThis().releaseObject(remoteObject.getObjectId());
        return title;
    }

    default public String getTitle() {
        DOM dom = this.getThis().getCommand().getDOM();
        Integer nodeId = dom.getDocument().getNodeId();
        RemoteObject remoteObject = dom.resolveNode(nodeId, null, null, this.getThis().getExecutionContextId());
        String title = (String)this.getThis().getPropertyByObjectId(remoteObject.getObjectId(), "title");
        this.getThis().logExit("getTitle", title);
        this.getThis().releaseObject(remoteObject.getObjectId());
        return title;
    }

    default public boolean isDomReady() {
        try {
            this.getThis().disableFlowLog();
            boolean bl = "true".equals(String.valueOf(this.getThis().evaluate("document.readyState == 'complete'")));
            return bl;
        }
        catch (Throwable t) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.getThis().enableFlowLog();
        }
    }

    default public boolean clearCache() {
        this.getThis().logEntry("clearCache");
        Network network = this.getThis().getCommand().getNetwork();
        network.enable();
        this.getThis().getCommand().getNetwork().clearBrowserCache();
        return true;
    }

    default public boolean clearCookies() {
        this.getThis().logEntry("clearCookies");
        Network network = this.getThis().getCommand().getNetwork();
        network.enable();
        this.getThis().getCommand().getNetwork().clearBrowserCookies();
        return true;
    }

    public Session getThis();
}

