/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.session;

import com.cdp4j.exception.CdpReadTimeoutExceptionHandler;
import com.cdp4j.session.ParameterizedCommand;

public class ParameterizedCommandImpl<T extends ParameterizedCommand<?>>
implements ParameterizedCommand<T> {
    protected int readTimeout = -1;
    protected double readTimeoutFactor = 1.0;
    protected CdpReadTimeoutExceptionHandler readTimeoutExceptionHandler = null;

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public double getReadTimeoutFactor() {
        return this.readTimeoutFactor;
    }

    @Override
    public CdpReadTimeoutExceptionHandler getReadTimeoutExceptionHandler() {
        return this.readTimeoutExceptionHandler;
    }

    @Override
    public T withReadTimeout(int readTimeout) {
        Object clonedCommand = this.clone();
        ((ParameterizedCommandImpl)clonedCommand).readTimeout = readTimeout;
        return (T)clonedCommand;
    }

    @Override
    public T withReadTimeoutFactor(double readTimeoutFactor) {
        if (readTimeoutFactor <= 0.0) {
            throw new IllegalArgumentException("read timeout factor must be >= 0");
        }
        Object clonedCommand = this.clone();
        ((ParameterizedCommandImpl)clonedCommand).readTimeoutFactor = readTimeoutFactor;
        return (T)clonedCommand;
    }

    @Override
    public T withReadTimeoutExceptionHandler(CdpReadTimeoutExceptionHandler readTimeoutExceptionHandler) {
        Object clonedCommand = this.clone();
        ((ParameterizedCommandImpl)clonedCommand).readTimeoutExceptionHandler = readTimeoutExceptionHandler;
        return (T)clonedCommand;
    }

    protected T clone() {
        try {
            return (T)((ParameterizedCommand)super.clone());
        }
        catch (CloneNotSupportedException e) {
            assert (false) : "Never happens";
            throw new RuntimeException(e);
        }
    }
}

